/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.kapi;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.Nullable;

public class ResourceLocator {
    private static final Map<String, File> loadedResources = new HashMap<String, File>();
    private static final String CORE_DEPS_PLUGIN = "com.arm.mgd.core.deps";

    public static File loadExecutable(String path) throws IOException, URISyntaxException {
        return ResourceLocator.loadExecutable(path, ResourceLocator.class, null);
    }

    public static File loadExecutable(String path, Class<?> context, @Nullable InputStream inputStream) throws IOException, URISyntaxException {
        File exeFile = ResourceLocator.loadResource(path, context, inputStream);
        if (!exeFile.canExecute()) {
            exeFile.setExecutable(true);
        }
        return exeFile;
    }

    public static void loadResource(String path) throws IOException, URISyntaxException {
        ResourceLocator.loadResource(path, ResourceLocator.class, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File loadResource(String source, Class<?> context, @Nullable InputStream inputStream) throws IOException, URISyntaxException {
        Long targetLength;
        File tempFile;
        Long sourceLength;
        File resource;
        block25: {
            resource = loadedResources.get(source);
            if (resource != null) return resource;
            sourceLength = null;
            if (inputStream == null && (inputStream = context.getResourceAsStream("/" + source)) == null) {
                File sourceFile = new File(ResourceLocator.getResourceRootPath(context), source);
                sourceLength = sourceFile.length();
                inputStream = new FileInputStream(sourceFile);
            }
            String sourceBaseName = new File(source).getName();
            tempFile = FileUtils.getFileInTempDir(sourceBaseName);
            tempFile.createNewFile();
            targetLength = null;
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try {
                    ReadableByteChannel inputChannel = Channels.newChannel(inputStream);
                    try {
                        block24: {
                            FileOutputStream fos = new FileOutputStream(tempFile);
                            try {
                                try (FileChannel outputChannel = fos.getChannel();){
                                    targetLength = outputChannel.transferFrom(inputChannel, 0L, Long.MAX_VALUE);
                                }
                                if (fos == null) break block24;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (fos == null) throw throwable;
                                fos.close();
                                throw throwable;
                            }
                            fos.close();
                        }
                        if (inputChannel == null) break block25;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (inputChannel == null) throw throwable;
                        inputChannel.close();
                        throw throwable;
                    }
                    inputChannel.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            finally {
                inputStream.close();
            }
        }
        resource = tempFile;
        if (!resource.exists()) {
            CoreLogging.userMessageReportOnce(null, Level.SEVERE, "Unable to locate resource '" + resource + "'");
            return resource;
        }
        if (sourceLength != null && !sourceLength.equals(targetLength)) {
            CoreLogging.userMessageReportOnce(null, Level.SEVERE, "Unable to perform a complete copy of '" + source + "' to '" + tempFile + "'");
            return resource;
        }
        loadedResources.put(source, resource);
        return resource;
    }

    public static File getResourceRootPath(Class<?> context) throws URISyntaxException {
        URL classesUrl = context.getResource(String.valueOf(context.getSimpleName()) + ".class");
        String className = context.getName();
        className = String.valueOf(className.replace('.', '/')) + ".class";
        className = classesUrl.toURI().toString().replace(className, "");
        try {
            return ((File)NullUtils.neverNull((Object)new File(new URI(className)).getParentFile())).getParentFile();
        }
        catch (IllegalArgumentException x) {
            return null;
        }
    }

    public static File loadResourceFromCoreDeps(String source) throws IOException, URISyntaxException {
        URL resource = Platform.getBundle((String)CORE_DEPS_PLUGIN).getResource(source);
        return ResourceLocator.loadResource(source, null, resource.openStream());
    }

    public static File loadExecutableFromCoreDeps(String source) throws IOException, URISyntaxException {
        URL resource = Platform.getBundle((String)CORE_DEPS_PLUGIN).getResource(source);
        return ResourceLocator.loadExecutable(source, null, resource.openStream());
    }
}

