/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.kapi;

import com.arm.mgd.core.asset.objects.gen.AllAssetClasses;
import com.arm.mgd.core.kapi.IConstantOrAliasSpecContainer;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.ISerializationProxy;
import com.arm.mgd.core.kapi.SerializableDependency;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.state.StateId;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.ApiXmlLoaderHelper;
import com.arm.mgd.kapi.IFunctionOrAliasSpec;
import com.arm.mgd.kapi.UnresolvedSpecItemException;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AnonymousConstantSpec;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.kapi.extended.BasicTypeSpec;
import com.arm.mgd.kapi.extended.ConstantGroupSpec;
import com.arm.mgd.kapi.extended.FunctionSpec;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.Api;
import com.arm.mgd.lightweight.asset.IAssetItem;
import com.arm.mgd.utils.NullUtils;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

public abstract class KapiSpec
implements SerializableDependency,
IConstantOrAliasSpecContainer {
    private static final long serialVersionUID = -5342721302272516244L;
    private static @NonNull List<@NonNull KapiSpec> availableApiSpecs = new ArrayList<KapiSpec>();
    private final @NonNull String name;
    private final @NonNull Api api;
    protected ResolvedMaps resolvedMaps;
    private AbstractConstantOrAliasSpecExtended successConstant;
    public static final @NonNull GLES GLES = new GLES("gl");
    public static final @NonNull EGL EGL = new EGL("egl");
    public static final @NonNull CL CL = new CL("cl");
    public static final @NonNull VULKAN VULKAN = new VULKAN("vulkan");
    private static final String API_DIR = "/api_specs/";
    private static final String SCHEMA_FILE = "../schema/kapi.xsd";
    private static Map<String, FunctionSpec> unknownFunctions = new HashMap<String, FunctionSpec>();

    @Override
    public Object writeReplace() {
        return new SerializationProxy(this);
    }

    protected KapiSpec(String apiName) {
        assert (apiName != null && !apiName.isEmpty());
        this.name = apiName;
        String filename = API_DIR + apiName + ".xml";
        Api loadedApi = ApiXmlLoaderHelper.loadApi(filename);
        if (loadedApi == null) {
            loadedApi = ApiXmlLoaderHelper.loadApi("/" + apiName + ".xml");
        }
        if (loadedApi == null) {
            throw new RuntimeException("Unable to load API model for " + apiName);
        }
        this.api = loadedApi;
        CoreLogging.info(null, "Loaded API model for " + apiName);
        this.resolvedMaps = new ResolvedMaps(this.api);
        this.evaluateLoadedModel();
        if (KapiSpec.findApiByName(apiName) != null) {
            throw new RuntimeException("API model '" + apiName + "' already registered!");
        }
        availableApiSpecs.add(this);
    }

    public AbstractConstantOrAliasSpecExtended getSuccessConstant() {
        return this.successConstant;
    }

    protected static @Nullable KapiSpec findApiByName(@NonNull String apiName) {
        for (KapiSpec existingApiSpec : availableApiSpecs) {
            if (!existingApiSpec.getName().equals(apiName)) continue;
            return existingApiSpec;
        }
        return null;
    }

    public static @NonNull List<@NonNull KapiSpec> getAvailableKapiSpecs() {
        return availableApiSpecs;
    }

    public @NonNull Api getApi() {
        return this.api;
    }

    public @NonNull String getName() {
        return this.name;
    }

    private void evaluateLoadedModel() {
        for (AbstractConstantOrAliasSpecExtended c : this.resolvedMaps.constantMap.values()) {
            try {
                c.resolve(this, this.resolvedMaps);
            }
            catch (UnresolvedSpecItemException e) {
                CoreLogging.severe(null, e, c + " value='" + c.getValue() + "' not resolved: " + e.getMessage());
            }
        }
        for (ConstantGroupSpec cg : this.resolvedMaps.constantGroupMap.values()) {
            cg.resolve(this);
        }
        for (AbstractConstantOrAliasSpecExtended c : this.resolvedMaps.constantMap.values()) {
            try {
                c.resolveConstantRefs(this);
            }
            catch (Exception e) {
                CoreLogging.severe(null, e, "Cannot resolve constant refs for constant " + c);
            }
        }
        for (StateSpec s : this.resolvedMaps.stateSpecMap.values()) {
            try {
                s.resolve(this, this.resolvedMaps);
            }
            catch (Exception e) {
                CoreLogging.severe(null, e, "Cannot resolve state " + s);
            }
        }
        for (FunctionSpec function : this.getApi().getFunctions().getFunctions()) {
            try {
                function.resolve(this);
            }
            catch (Exception e) {
                CoreLogging.severe(null, e, "Cannot resolve function " + function);
            }
        }
        for (BasicTypeSpec basicType : this.getApi().getBasicTypes().getBasicType()) {
            try {
                basicType.resolve(this);
            }
            catch (Exception e) {
                CoreLogging.severe(null, e, "Cannot resolve basic type " + basicType);
            }
        }
        for (AssetTableSpec ats : this.resolvedMaps.assetTableMap.values()) {
            ats.resolve(this);
        }
        this.successConstant = this.api.getApiInfo().getSuccessConstant();
        if (this.successConstant == null) {
            CoreLogging.severe(null, "Cannot resolve success error code for " + (Object)((Object)this.api.getApiInfo().getName()));
        }
    }

    public static void save(Api apiToSave, OutputStream sOut) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Api.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)SCHEMA_FILE);
            m.marshal((Object)apiToSave, sOut);
        }
        catch (JAXBException e) {
            CoreLogging.severe(null, e, "Unable to save API spec " + apiToSave);
        }
    }

    public static @NonNull FunctionSpec getDefaultFunction(String name) {
        assert (name != null && !name.isEmpty());
        FunctionSpec f = unknownFunctions.get(name);
        if (f == null) {
            f = FunctionSpec.createDefault(name);
            unknownFunctions.put(name, f);
        }
        return f;
    }

    public static IFunctionOrAliasSpecExtended getFunctionSpecByName(String nameToFind) {
        assert (nameToFind != null && !nameToFind.isEmpty());
        for (KapiSpec kapi : availableApiSpecs) {
            IFunctionOrAliasSpecExtended functionSpec = kapi.resolvedMaps.functionMap.get(nameToFind);
            if (functionSpec == null) continue;
            return functionSpec;
        }
        return null;
    }

    public StateSpec getStateSpecByName(@NonNull StateId nameToLocate) {
        assert (nameToLocate != null);
        return this.resolvedMaps.stateSpecMap.get(nameToLocate.id);
    }

    public AbstractConstantOrAliasSpecExtended getConstantSpecByName(String nameToLocate) {
        assert (nameToLocate != null && !nameToLocate.isEmpty());
        return this.resolvedMaps.constantMap.get(nameToLocate);
    }

    @Override
    public @NonNull AbstractConstantOrAliasSpecExtended getConstantSpecByValue(@NonNull Long v) {
        AbstractConstantOrAliasSpecExtended result = null;
        for (AbstractConstantOrAliasSpecExtended constantSpec : this.resolvedMaps.constantMap.values()) {
            if (!v.equals(constantSpec.getResolvedValue())) continue;
            if (!constantSpec.isExtension()) {
                return constantSpec;
            }
            result = constantSpec;
        }
        if (result == null) {
            result = AnonymousConstantSpec.newConstant(v);
        }
        return result;
    }

    public AssetTableSpec getAssetTableSpecById(String assetTableId) {
        AssetTableSpec table = this.resolvedMaps.assetTableMap.get(assetTableId);
        assert (table != null);
        return table;
    }

    public String toString() {
        return "KapiSpec '" + this.name + "'";
    }

    public boolean isError(int errorCode) {
        int successCodeValue = this.getSuccessConstant().getResolvedValue().intValue();
        return errorCode != successCodeValue;
    }

    public Collection<StateSpec> getAllStateSpecs() {
        return this.resolvedMaps.stateSpecMap.values();
    }

    public static int getTotalNumberOfStateSpecs() {
        int result = 0;
        for (KapiSpec kapiSpec : KapiSpec.getAvailableKapiSpecs()) {
            result += kapiSpec.getAllStateSpecs().size();
        }
        return result;
    }

    public static AbstractConstantOrAliasSpecExtended findConstantByName(String nameToLocate) {
        for (KapiSpec spec : KapiSpec.getAvailableKapiSpecs()) {
            AbstractConstantOrAliasSpecExtended constant = spec.getConstantSpecByName(nameToLocate);
            if (constant == null) continue;
            return constant;
        }
        return null;
    }

    public abstract @NonNull IAssetClassLookup<?> getAssetClassLookup();

    @NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
    public class AssetTraits<TSS_ASSET_TYPE extends com.arm.mgd.core.asset.IAssetItem, LW_ASSET_TYPE extends IAssetItem<?, ? extends LW_VALUE_TYPE>, LW_VALUE_TYPE extends IAssetItem.Value<? extends LW_ASSET_TYPE>> {
        public final AssetTableSpec SPEC;
        public final Class<TSS_ASSET_TYPE> ASSET_CLASS;
        public final Class<LW_ASSET_TYPE> LIGHTWEIGHT_ASSET_CLASS;
        public final Class<LW_VALUE_TYPE> LIGHTWEIGHT_VALUE_CLASS;
        public final @Nullable AllAssetClasses ENUM;

        public AssetTraits(@Nullable AssetTableSpec spec, AllAssetClasses classEnum, Class<? super TSS_ASSET_TYPE> tssClass, Class<? super LW_ASSET_TYPE> lwClass, Class<? super LW_VALUE_TYPE> lwValueClass) {
            this.SPEC = (AssetTableSpec)NullUtils.neverNull((Object)spec);
            this.ENUM = classEnum;
            this.ASSET_CLASS = (Class)NullUtils.neverNull(tssClass);
            this.LIGHTWEIGHT_ASSET_CLASS = (Class)NullUtils.neverNull(lwClass);
            this.LIGHTWEIGHT_VALUE_CLASS = (Class)NullUtils.neverNull(lwValueClass);
        }

        public KapiSpec getKapiSpec() {
            return KapiSpec.this;
        }
    }

    public static interface IAssetClassLookup<API_MODEL> {
        public @Nullable AssetTraits<?, ? extends IAssetItem<API_MODEL, ?>, ?> getAssetTraitsByName(@NonNull String var1);

        public @Nullable String getAssetNameByClass(@NonNull Class<? extends com.arm.mgd.core.asset.IAssetItem> var1);

        public @Nullable String getLightweightAssetNameByClass(@NonNull Class<? extends IAssetItem<?, ?>> var1);
    }

    public class ResolvedMaps {
        public final Map<String, IFunctionOrAliasSpecExtended> functionMap = new HashMap<String, IFunctionOrAliasSpecExtended>();
        public final Map<String, AbstractConstantOrAliasSpecExtended> constantMap = new HashMap<String, AbstractConstantOrAliasSpecExtended>();
        public final Map<String, ConstantGroupSpec> constantGroupMap = new HashMap<String, ConstantGroupSpec>();
        public final Map<String, StateSpec> stateSpecMap = new HashMap<String, StateSpec>();
        public final Map<String, AssetTableSpec> assetTableMap = new HashMap<String, AssetTableSpec>();
        public final Map<String, BasicTypeSpec> basicTypeMap = new HashMap<String, BasicTypeSpec>();

        ResolvedMaps(Api api) {
            for (AssetTableSpec assetTableSpec : api.getAssetTables().getAssetTable()) {
                this.assetTableMap.put(assetTableSpec.getId(), assetTableSpec);
            }
            for (IFunctionOrAliasSpec function : api.getFunctions().getFunctionsAndAliases()) {
                this.functionMap.put(function.getName(), (IFunctionOrAliasSpecExtended)function);
            }
            for (AbstractConstantOrAliasSpecExtended c : api.getConstants().getConstantsAndAliases()) {
                this.constantMap.put(c.getName(), c);
            }
            for (ConstantGroupSpec cg : api.getConstantGroups().getConstantGroup()) {
                this.constantGroupMap.put(cg.getName(), cg);
            }
            for (StateSpec s : api.getStates().getState()) {
                this.stateSpecMap.put(s.getId(), s);
            }
            for (BasicTypeSpec t : api.getBasicTypes().getBasicType()) {
                this.basicTypeMap.put(t.getId(), t);
            }
        }
    }

    private static class SerializationProxy
    implements ISerializationProxy {
        private static final long serialVersionUID = -9172525672552008266L;
        private final @NonNull String nameToLocate;

        SerializationProxy(KapiSpec kapiSpec) {
            this.nameToLocate = kapiSpec.getName();
        }

        @Override
        public Object readResolve() {
            return KapiSpec.findApiByName(this.nameToLocate);
        }
    }
}

