/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.help;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.gen.DocumentationUrlSpec;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

public class ApiDocProvider {
    public static URL getApiDocLocation(Object apiSpecObject) {
        try {
            if (apiSpecObject instanceof IFunctionOrAliasSpecExtended) {
                IFunctionOrAliasSpecExtended functionSpec = (IFunctionOrAliasSpecExtended)apiSpecObject;
                String functionName = functionSpec.getName();
                if (functionSpec.getDocumentationRef() != null) {
                    List<DocumentationUrlSpec> listDocSpec = functionSpec.getKapiSpec().getApi().getDocumentationUrls().getDocumentationUrl();
                    for (DocumentationUrlSpec documentationUrlSpec : listDocSpec) {
                        if (!documentationUrlSpec.getName().equals(functionSpec.getDocumentationRef())) continue;
                        return new URL(documentationUrlSpec.getUrl());
                    }
                }
                if (functionSpec.getKapiSpec() == KapiSpec.VULKAN && functionSpec.getHighestApiVersionSupportedIn().equals("1.0")) {
                    return new URL("https://www.khronos.org/registry/vulkan/specs/1.0/man/html/" + functionName + ".html");
                }
                if (functionSpec.getKapiSpec() == KapiSpec.GLES) {
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("3.2")) {
                        return new URL("https://www.khronos.org/opengles/sdk/docs/man32/html/" + functionName + ".xhtml");
                    }
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("3.1")) {
                        return new URL("https://www.khronos.org/opengles/sdk/docs/man31/html/" + functionName + ".xhtml");
                    }
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("3.0")) {
                        return new URL("https://www.khronos.org/opengles/sdk/docs/man3/html/" + functionName + ".xhtml");
                    }
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("2.0")) {
                        return new URL("https://www.khronos.org/opengles/sdk/docs/man/xhtml/" + functionName + ".xml");
                    }
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("1.1")) {
                        return new URL("https://www.khronos.org/opengles/sdk/1.1/docs/man/" + functionName + ".xml");
                    }
                }
                if (functionSpec.getKapiSpec() == KapiSpec.EGL) {
                    return new URL("https://www.khronos.org/registry/egl/sdk/docs/man/html/" + functionName + ".xhtml");
                }
                if (functionSpec.getKapiSpec() == KapiSpec.CL) {
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("1.0")) {
                        return new URL("https://www.khronos.org/registry/cl/sdk/1.0/docs/man/xhtml/" + functionName + ".html");
                    }
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("1.1")) {
                        return new URL("https://www.khronos.org/registry/cl/sdk/1.1/docs/man/xhtml/" + functionName + ".html");
                    }
                    if (functionSpec.getHighestApiVersionSupportedIn().equals("1.2")) {
                        return new URL("https://www.khronos.org/registry/cl/sdk/1.2/docs/man/xhtml/" + functionName + ".html");
                    }
                }
            }
        }
        catch (MalformedURLException e) {
            CoreLogging.severe(null, e, "Unable to open help page");
        }
        return null;
    }

    public static void checkURLValid(URL url) throws Exception {
        if (url == null) {
            throw new Exception("Unknown URL.");
        }
        HttpURLConnection huc = (HttpURLConnection)url.openConnection();
        huc.setRequestMethod("HEAD");
        huc.setDoOutput(true);
        try {
            huc.connect();
        }
        catch (IOException ioe) {
            throw new Exception("Cannot connect to website: " + ioe.getMessage());
        }
        int code = huc.getResponseCode();
        if (code >= 400) {
            throw new Exception("The requested URL returned an invalid code (" + code + ").");
        }
    }
}

