/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.export;

import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.asset.texture.RGBAImageWriter;
import com.arm.mgd.core.export.AbstractAssetExporter;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;

public final class VkImageAssetExporter
extends AbstractAssetExporter<VkImageAsset> {
    private static final @NonNull String IMAGE_FILE_PREFIX = "vulkan_image_";
    private static final @NonNull String IMAGE_FILE_EXTENSION = ".png";
    private static final @NonNull VkImageAssetExporter SINGLETON = new VkImageAssetExporter();

    private VkImageAssetExporter() {
    }

    public static boolean export(@NonNull Collection<@NonNull VkImageAsset> images, @NonNull File directory) {
        return SINGLETON.exportAssets(images, directory);
    }

    public static boolean export(@NonNull Collection<@NonNull VkImageAsset> images, @NonNull File directory, @NonNull ICoreProgressMonitor progressMonitor) {
        return SINGLETON.exportAssets(images, directory, progressMonitor);
    }

    @Override
    protected @NonNull String getTaskNameForMonitor() {
        return "Exporting Vulkan images";
    }

    @Override
    protected void raiseUserWarningAtEndOfExporting() {
        CoreLogging.userMessage(null, Level.WARNING, "There were some problems exporting textures. See the console for more information.");
    }

    @Override
    protected boolean exportIndividualAsset(@NonNull VkImageAsset imageAsset, @NonNull File directory) {
        RGBAImageData imageData;
        String fileName = VkImageAssetExporter.makeFileNameFromImage(imageAsset);
        try {
            imageData = imageAsset.getImageData();
        }
        catch (IImageProvider.ImageConversionException | IImageProvider.ImageDataUnavailableException | IOException e) {
            CoreLogging.warning(null, "Unable to get image data for " + fileName + ": " + e.getLocalizedMessage());
            return false;
        }
        File outputFile = new File(directory, fileName);
        try {
            RGBAImageWriter.writeAsPng(imageData, outputFile);
        }
        catch (IOException e) {
            CoreLogging.warning(null, "Unable to write out image data for " + fileName + ": " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private static @NonNull String makeFileNameFromImage(@NonNull VkImageAsset imageAsset) {
        return IMAGE_FILE_PREFIX + imageAsset.getHandle() + IMAGE_FILE_EXTENSION;
    }

    @Override
    protected @NonNull String getSubTaskNameFromAsset(@NonNull VkImageAsset asset) {
        return "Exporting " + VkImageAssetExporter.makeFileNameFromImage(asset);
    }
}

