/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.export;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.texture.GlTextureCompositor;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.asset.texture.RGBAImageWriter;
import com.arm.mgd.core.export.AbstractAssetExporter;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;

public final class GlTextureAssetExporter
extends AbstractAssetExporter<GlTextureAsset> {
    private static final @NonNull GlTextureAssetExporter SINGLETON = new GlTextureAssetExporter();

    private GlTextureAssetExporter() {
    }

    public static boolean export(@NonNull Collection<@NonNull GlTextureAsset> textureAssets, @NonNull File outputDirectory) {
        return SINGLETON.exportAssets(textureAssets, outputDirectory, ICoreProgressMonitor.NULL_MONITOR);
    }

    public static boolean export(@NonNull Collection<@NonNull GlTextureAsset> textureAssets, @NonNull File outputDirectory, @NonNull ICoreProgressMonitor progressMonitor) {
        return SINGLETON.exportAssets(textureAssets, outputDirectory, progressMonitor);
    }

    @Override
    protected @NonNull String getTaskNameForMonitor() {
        return "Exporting textures";
    }

    @Override
    protected void raiseUserWarningAtEndOfExporting() {
        CoreLogging.userMessage(null, Level.WARNING, "There were some problems exporting textures. See the console for more information.");
    }

    @Override
    protected boolean exportIndividualAsset(@NonNull GlTextureAsset textureAsset, @NonNull File directory) {
        for (GlTextureSurfaceAsset surfaceAsset : textureAsset.getSurfaces()) {
            for (GlTextureImageAsset imageAsset : surfaceAsset.getMipmapImages()) {
                String fileName = "Texture_" + textureAsset.getId() + surfaceAsset.getExportLabel() + "_Mip_" + imageAsset.getId() + ".png";
                GlTextureCompositor imageProvider = imageAsset.getGlTextureCompositor();
                if (imageProvider.isDataInvalid()) continue;
                try {
                    RGBAImageData imageData = imageProvider.getImageData();
                    RGBAImageWriter.writeAsPng(imageData, new File(directory, fileName));
                }
                catch (IImageProvider.ImageDataUnavailableException e) {
                    CoreLogging.warning(null, "Unable to get texture data for " + fileName + ": " + e.getLocalizedMessage());
                    return false;
                }
                catch (IImageProvider.ImageConversionException e) {
                    CoreLogging.warning(null, "Unable to convert texture data for " + fileName + ": " + e.getLocalizedMessage());
                    return false;
                }
                catch (IOException e) {
                    CoreLogging.warning(null, "Unable to write out file " + fileName + ": " + e.getLocalizedMessage());
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected @NonNull String getSubTaskNameFromAsset(@NonNull GlTextureAsset asset) {
        return "Exporting Texture_" + asset.getId();
    }
}

