/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.export;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.export.AbstractAssetExporter;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;

public final class GlShaderAssetExporter
extends AbstractAssetExporter<GlShaderAsset> {
    private static final GlShaderAssetExporter SINGLETON = new GlShaderAssetExporter();

    private GlShaderAssetExporter() {
    }

    public static boolean export(@NonNull Collection<@NonNull GlShaderAsset> shaders, @NonNull File directory) {
        return SINGLETON.exportAssets(shaders, directory);
    }

    public static boolean export(@NonNull Collection<@NonNull GlShaderAsset> shaders, @NonNull File directory, @NonNull ICoreProgressMonitor progressMonitor) {
        return SINGLETON.exportAssets(shaders, directory, progressMonitor);
    }

    @Override
    protected @NonNull String getTaskNameForMonitor() {
        return "Exporting Shaders";
    }

    @Override
    protected void raiseUserWarningAtEndOfExporting() {
        CoreLogging.userMessage(null, Level.WARNING, "There were some problems exporting shaders. See the console for more information.");
    }

    @Override
    protected boolean exportIndividualAsset(@NonNull GlShaderAsset shader, @NonNull File directory) {
        File outFile = new File(directory, GlShaderAssetExporter.buildFileNameFromShader(shader));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintWriter writer = new PrintWriter(outFile);){
                String source = shader.getSource();
                if (source != null) {
                    writer.write(source);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            CoreLogging.warning(null, "Unable to create " + outFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private static @NonNull String buildFileNameFromShader(@NonNull GlShaderAsset shader) {
        StringBuilder fileNameBuilder = new StringBuilder();
        if (KapiSpec.GLES.constants.GL_FRAGMENT_SHADER.equals(shader.getType())) {
            fileNameBuilder.append("Fragment");
        } else if (KapiSpec.GLES.constants.GL_VERTEX_SHADER.equals(shader.getType())) {
            fileNameBuilder.append("Vertex");
        } else if (KapiSpec.GLES.constants.GL_COMPUTE_SHADER.equals(shader.getType())) {
            fileNameBuilder.append("Compute");
        } else if (KapiSpec.GLES.constants.GL_GEOMETRY_SHADER.equals(shader.getType())) {
            fileNameBuilder.append("Geometry");
        } else if (KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER.equals(shader.getType())) {
            fileNameBuilder.append("TessControl");
        } else if (KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER.equals(shader.getType())) {
            fileNameBuilder.append("TessEvaluation");
        }
        fileNameBuilder.append("_").append(shader.getId());
        fileNameBuilder.append("_Programs");
        List<GlProgramAsset> linkedProgramList = shader.getLinkedToProgramList();
        if (!linkedProgramList.isEmpty()) {
            for (GlProgramAsset program : linkedProgramList) {
                fileNameBuilder.append("_" + program.getId());
            }
        } else {
            fileNameBuilder.append("_None");
        }
        if (shader.isDeleted()) {
            fileNameBuilder.append("_Deleted");
        } else if (shader.isFlaggedForDeletion()) {
            fileNameBuilder.append("_FlaggedForDeletion");
        }
        fileNameBuilder.append(".glsl");
        return NullUtils.buildString((StringBuilder)fileNameBuilder);
    }

    @Override
    protected @NonNull String getSubTaskNameFromAsset(@NonNull GlShaderAsset asset) {
        return "Exporting " + GlShaderAssetExporter.buildFileNameFromShader(asset);
    }
}

