/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.export;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.texture.GlFramebufferCompositor;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.asset.texture.RGBAImageWriter;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GlFramebufferAssetExporter {
    private static final @NonNull ApplicationFeatureAuthoriser FEATURE_AUTHORISER = ApplicationFeatureAuthoriser.RESOURCES_EXPORT;

    private GlFramebufferAssetExporter() {
    }

    public static boolean export(@NonNull HashMap<@NonNull TraceDataModel, Set<Integer>> modelToSelectedDrawCallsMap, @NonNull File directory, @NonNull ICoreProgressMonitor progressMonitor) {
        if (!FEATURE_AUTHORISER.isAuthorisationReceivedAndApproved()) {
            CoreLogging.userMessage(null, Level.WARNING, FEATURE_AUTHORISER.getFeature().getLicenceMissingMessage());
            return false;
        }
        int numFramebuffersToExport = GlFramebufferAssetExporter.getNumFramebuffersToExport(modelToSelectedDrawCallsMap);
        if (numFramebuffersToExport == 0) {
            CoreLogging.userMessage(null, Level.WARNING, "No captured framebuffers in selection.");
            return true;
        }
        progressMonitor.setTask("Exporting Framebuffers", numFramebuffersToExport);
        boolean wasProblem = false;
        for (Map.Entry<TraceDataModel, Set<Integer>> entry : modelToSelectedDrawCallsMap.entrySet()) {
            @NonNull TraceDataModel model = entry.getKey();
            @Nullable Set<Integer> functionCallIndices = entry.getValue();
            SynchronousTraceStateSnapshot tss = new SynchronousTraceStateSnapshot(model);
            @NonNull List<@NonNull Frame> frames = model.getFrames().getFrames();
            File modelDir = null;
            int i = 0;
            while (i < frames.size()) {
                Frame frame = frames.get(i);
                if (frame.isCaptured()) {
                    File frameDir = null;
                    int drawCallCounter = 0;
                    for (FrameRenderPass renderpass : frame.getRenderPassList()) {
                        for (DrawFunctionCall dfc : renderpass.getDrawCalls()) {
                            if (progressMonitor.isCancelled()) {
                                return true;
                            }
                            progressMonitor.setSubTask("Draw Call " + drawCallCounter);
                            try {
                                int index = dfc.getIndex();
                                if (functionCallIndices != null && !functionCallIndices.contains(index)) continue;
                                if (modelDir == null) {
                                    modelDir = GlFramebufferAssetExporter.createNavDir(directory, model);
                                }
                                if (!modelDir.exists()) {
                                    wasProblem = true;
                                    continue;
                                }
                                if (frameDir == null) {
                                    frameDir = GlFramebufferAssetExporter.createNavDir(modelDir, frame);
                                }
                                if (!frameDir.exists()) {
                                    wasProblem = true;
                                    continue;
                                }
                                long boundFramebuffer = tss.getStateItemBySpec(KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING).getValue()[0].getValueAsLong();
                                StringBuilder outFileNameBuilder = new StringBuilder();
                                outFileNameBuilder.append("Draw_").append(drawCallCounter).append("_FB_").append(boundFramebuffer).append(".png");
                                String outFileName = outFileNameBuilder.toString();
                                try {
                                    try {
                                        tss.setSelectedFunction(index);
                                        GlFramebufferAsset asset = GlFramebufferAsset.getBoundFramebufferAsset(tss, KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING);
                                        GlFramebufferAssetExporter.writeFramebufferToDisk(asset, frameDir, outFileName);
                                    }
                                    catch (Exception e) {
                                        CoreLogging.warning(null, "Error exporting " + outFileName + ": " + e.getLocalizedMessage());
                                        wasProblem = true;
                                        progressMonitor.incProgress(1);
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    progressMonitor.incProgress(1);
                                    throw throwable;
                                }
                                progressMonitor.incProgress(1);
                            }
                            finally {
                                ++drawCallCounter;
                            }
                        }
                    }
                }
                ++i;
            }
        }
        progressMonitor.finished();
        if (wasProblem) {
            CoreLogging.userMessage(null, Level.WARNING, "There were some problems exporting captured framebuffers. See the console for more information.");
        }
        return !wasProblem;
    }

    private static @NonNull File createNavDir(@NonNull File parentDir, @NonNull INavigationElement<?> element) {
        return GlFramebufferAssetExporter.createDir(parentDir, element.getLongLabelText());
    }

    private static @NonNull File createDir(@NonNull File parentDir, @NonNull String dirName) {
        File dir = new File(parentDir, dirName);
        dir.mkdir();
        if (!dir.exists()) {
            CoreLogging.warning(null, "Unable to create directory " + dir.getAbsolutePath());
        }
        return dir;
    }

    private static void writeFramebufferToDisk(GlFramebufferAsset asset, File frameDir, String outFileName) {
        if (asset == null) {
            return;
        }
        Collection<@NonNull GlFramebufferCompositor> captureItems = asset.getAllCaptureItems();
        for (GlFramebufferCompositor captureItem : captureItems) {
            try {
                if (captureItem.isDataInvalid()) continue;
                RGBAImageData imageData = captureItem.getImageData();
                File file = new File(frameDir, outFileName.replaceAll("\\.png$", String.format("_%s.png", captureItem.getAttachment().getName())));
                RGBAImageWriter.writeAsPng(imageData, file);
            }
            catch (IImageProvider.ImageConversionException | IImageProvider.ImageDataUnavailableException | IOException e) {
                CoreLogging.severe(null, "Could not export framebuffer to disk, compositing operation cancelled: " + e.getMessage());
            }
        }
    }

    private static int getNumFramebuffersToExport(@NonNull HashMap<@NonNull TraceDataModel, Set<Integer>> modelToSelectedDrawCallsMap) {
        int totalWork = 0;
        for (Map.Entry<TraceDataModel, Set<Integer>> entry : modelToSelectedDrawCallsMap.entrySet()) {
            @NonNull TraceDataModel model = entry.getKey();
            @Nullable Set<Integer> functionCallIndices = entry.getValue();
            if (functionCallIndices == null) {
                totalWork += model.getFrames().getFrames().stream().filter(Frame::isCaptured).filter(frame -> frame.hasDataForStatisticType(CommonStatistics.NUMBER_OF_DRAW_CALLS)).mapToInt(frame -> frame.getStatistic(CommonStatistics.NUMBER_OF_DRAW_CALLS).getValue().intValue()).sum();
                continue;
            }
            totalWork = (int)((long)totalWork + functionCallIndices.stream().mapToInt(Integer::intValue).filter(i -> i < model.count()).mapToObj(model::getCallItem).filter(fc -> fc instanceof DrawFunctionCall).filter(fc -> ((Frame)NullUtils.neverNull((Object)fc.getParentFrame())).isCaptured()).count());
        }
        return totalWork;
    }
}

