/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.export;

import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.export.AbstractAssetExporter;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.logging.Level;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.jdt.annotation.NonNull;

public final class BufferItemAssetExporter
extends AbstractAssetExporter<IBufferItem> {
    private static final BufferItemAssetExporter SINGLETON = new BufferItemAssetExporter();

    private BufferItemAssetExporter() {
    }

    public static boolean export(@NonNull Collection<@NonNull IBufferItem> buffers, @NonNull File directory) {
        return SINGLETON.exportAssets(buffers, directory);
    }

    public static boolean export(@NonNull Collection<@NonNull IBufferItem> buffers, @NonNull File directory, @NonNull ICoreProgressMonitor progressMonitor) {
        return SINGLETON.exportAssets(buffers, directory, progressMonitor);
    }

    @Override
    protected @NonNull String getTaskNameForMonitor() {
        return "Exporting Buffers";
    }

    @Override
    protected boolean exportIndividualAsset(@NonNull IBufferItem buffer, @NonNull File directory) {
        File outFile = new File(directory, BufferItemAssetExporter.makeFileNameFromBuffer(buffer));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintWriter writer = new PrintWriter(outFile);){
                byte[] data = buffer.getDataForBuffer();
                if (data != null) {
                    writer.write(DatatypeConverter.printHexBinary((byte[])data));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            CoreLogging.warning(null, "Unable to create " + outFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private static @NonNull String makeFileNameFromBuffer(@NonNull IBufferItem buffer) {
        return "Buffer_" + buffer.getId() + ".txt";
    }

    @Override
    protected void raiseUserWarningAtEndOfExporting() {
        CoreLogging.userMessage(null, Level.WARNING, "There were some problems exporting buffers. See the console for more information.");
    }

    @Override
    protected @NonNull String getSubTaskNameFromAsset(@NonNull IBufferItem buffer) {
        return "Exporting " + BufferItemAssetExporter.makeFileNameFromBuffer(buffer);
    }
}

