/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.export;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractAssetExporter<T extends IAssetItem> {
    private static final @NonNull ApplicationFeatureAuthoriser FEATURE_AUTHORISER = ApplicationFeatureAuthoriser.RESOURCES_EXPORT;

    protected abstract @NonNull String getTaskNameForMonitor();

    protected abstract boolean exportIndividualAsset(@NonNull T var1, @NonNull File var2);

    protected abstract void raiseUserWarningAtEndOfExporting();

    protected abstract @NonNull String getSubTaskNameFromAsset(@NonNull T var1);

    protected boolean exportAssets(@NonNull Collection<@NonNull T> assets, @NonNull File directory, @NonNull ICoreProgressMonitor progressMonitor) {
        if (!FEATURE_AUTHORISER.isAuthorisationReceivedAndApproved()) {
            CoreLogging.userMessage(null, Level.WARNING, FEATURE_AUTHORISER.getFeature().getLicenceMissingMessage());
            return false;
        }
        if (assets.isEmpty()) {
            CoreLogging.userMessage(null, Level.WARNING, "Nothing to export.");
            return true;
        }
        boolean wasProblem = false;
        progressMonitor.setTask(this.getTaskNameForMonitor(), assets.size());
        for (IAssetItem asset : assets) {
            progressMonitor.setSubTask(this.getSubTaskNameFromAsset(asset));
            if (progressMonitor.isCancelled()) break;
            if (!this.exportIndividualAsset(asset, directory)) {
                wasProblem = true;
            }
            progressMonitor.incProgress(1);
        }
        if (wasProblem) {
            this.raiseUserWarningAtEndOfExporting();
        }
        progressMonitor.finished();
        return !wasProblem;
    }

    protected boolean exportAssets(@NonNull Collection<@NonNull T> assets, @NonNull File directory) {
        return this.exportAssets(assets, directory, ICoreProgressMonitor.NULL_MONITOR);
    }
}

