/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.diff;

import com.arm.mgd.core.diff.ContainerDiffItem;
import com.arm.mgd.core.diff.DiffClassification;
import com.arm.mgd.core.diff.DiffItem;
import com.arm.mgd.core.diff.IDiffable;
import com.arm.mgd.core.diff.MultiValueDiffItem;
import com.arm.mgd.core.diff.NotDiffableException;
import com.arm.mgd.core.diff.SingleValueDiffItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.state.StateValue;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.ComparatorUtils;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.SortedSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DiffService {
    public static DiffItem generate(@NonNull IDiffable<?> o1, @NonNull IDiffable<?> o2) throws NotDiffableException {
        return DiffService.generate(o1, o2, null);
    }

    public static DiffItem generate(@NonNull IDiffable<?> o1, @NonNull IDiffable<?> o2, @Nullable ICoreProgressMonitor monitor) throws NotDiffableException {
        block6: {
            try {
                Method targetMethod = DiffService.getGenerateMethod(o1, o2);
                if (targetMethod != null) {
                    return (DiffItem)targetMethod.invoke(null, o1, o2, monitor != null ? monitor : ICoreProgressMonitor.NULL_MONITOR);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof NotDiffableException) {
                    throw (NotDiffableException)cause;
                }
                e.printStackTrace();
                assert (false);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        throw new NotDiffableException(o1, o2);
    }

    public static boolean isDiffable(@NonNull IDiffable<?> o1, @NonNull IDiffable<?> o2) {
        Method targetMethod = DiffService.getGenerateMethod(o1, o2);
        if (targetMethod == null) {
            return false;
        }
        try {
            Method helper = DiffService.class.getDeclaredMethod("isDiffableHelper", o1.getIDiffableTClass(), o2.getIDiffableTClass());
            assert (helper.getReturnType() == Boolean.TYPE);
            return (Boolean)helper.invoke(null, o1, o2);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return true;
        }
    }

    private static DiffItem generate(@NonNull FunctionCall f1, @NonNull FunctionCall f2, @NonNull ICoreProgressMonitor monitor) throws NotDiffableException {
        if (!DiffService.isDiffableHelper(f1, f2)) {
            throw new NotDiffableException(f1, f2);
        }
        if (f1.getIndex() > f2.getIndex()) {
            FunctionCall temp = f1;
            f1 = f2;
            f2 = temp;
        }
        SynchronousTraceStateSnapshot f1Snapshot = new SynchronousTraceStateSnapshot(f1.getModel());
        SynchronousTraceStateSnapshot f2Snapshot = new SynchronousTraceStateSnapshot(f2.getModel());
        monitor.setTask("Generating state diff", 1);
        f1Snapshot.setSelectedFunction(f1.getIndex());
        f2Snapshot.setSelectedFunction(f2.getIndex());
        return DiffService.generate(f1Snapshot, f2Snapshot, monitor);
    }

    private static DiffItem generate(@NonNull StateItem s1, @NonNull StateItem s2, @NonNull ICoreProgressMonitor monitor) throws NotDiffableException {
        if (!DiffService.isDiffableHelper(s1, s2)) {
            throw new NotDiffableException(s1, s2);
        }
        StateValue[] values1 = s1.getValue();
        StateValue[] values2 = s2.getValue();
        int length1 = values1.length;
        int length2 = values2.length;
        int maxLength = Math.max(length1, length2);
        ArrayList<@NonNull SingleValueDiffItem<T>> resultValues = new ArrayList();
        int i = 0;
        while (i < maxLength) {
            StateValue v1 = i < length1 ? values1[i] : null;
            StateValue v2 = i < length2 ? values2[i] : null;
            boolean changed = !ComparatorUtils.equalNullables(v1, v2);
            resultValues.add(new SingleValueDiffItem<StateValue>((String)NullUtils.neverNull((Object)s1.getStateSpec().getName()), s1, s2, v1, v2, changed ? DiffClassification.DIFFERENT : DiffClassification.NEVER_CHANGED));
            ++i;
        }
        if (resultValues.size() != 1) {
            return new MultiValueDiffItem((String)NullUtils.neverNull((Object)s1.getStateSpec().getName()), s1, s2, resultValues);
        }
        return (DiffItem)resultValues.get(0);
    }

    private static DiffItem generate(@NonNull TraceStateSnapshot s1, @NonNull TraceStateSnapshot s2, @NonNull ICoreProgressMonitor monitor) throws NotDiffableException {
        if (!DiffService.isDiffableHelper(s1, s2)) {
            throw new NotDiffableException(s1, s2);
        }
        if (s1.getCurrentSelection() > s2.getCurrentSelection()) {
            TraceStateSnapshot temp = s1;
            s1 = s2;
            s2 = temp;
        }
        ArrayList<@NonNull DiffItem> diffItems = new ArrayList<DiffItem>();
        int totalTasks = KapiSpec.getTotalNumberOfStateSpecs();
        int taskProgress = 0;
        for (KapiSpec kapiSpec : KapiSpec.getAvailableKapiSpecs()) {
            for (StateSpec stateSpec : kapiSpec.getAllStateSpecs()) {
                if (monitor.isCancelled()) {
                    return null;
                }
                monitor.setTask("Comparing state", totalTasks);
                monitor.incProgress(taskProgress++);
                if (stateSpec.getStateType().getIndexCount() != null || stateSpec.getStateType().getIndexCountRef() != null) continue;
                StateItem stateItem1 = s1.getStateItemBySpec(stateSpec);
                StateItem stateItem2 = s2.getStateItemBySpec(stateSpec);
                assert (stateItem1 != null);
                assert (stateItem2 != null);
                DiffItem diff = DiffService.generate(stateItem1, stateItem2, monitor);
                SortedSet<FunctionCall> modifyingFunctions = stateItem2.getAllModifyingFunctions(s1.getCurrentSelection(), s2.getCurrentSelection() + 1);
                diff.setRelatedFunctions(modifyingFunctions);
                if (diff.getClassification() == DiffClassification.NEVER_CHANGED && !modifyingFunctions.isEmpty()) {
                    diff.setClassification(DiffClassification.PREVIOUSLY_CHANGED);
                }
                if (diff.getClassification() == DiffClassification.NEVER_CHANGED) continue;
                diffItems.add(diff);
            }
        }
        monitor.setTask("Complete", 1);
        monitor.incProgress(1);
        FunctionCall f1 = s1.getModel().getCallItem(s1.getCurrentSelection());
        FunctionCall f2 = s2.getModel().getCallItem(s2.getCurrentSelection());
        String description = "Comparing " + f1.getFunctionSpec().getName() + " at " + s1.getCurrentSelection() + " with " + f2.getFunctionSpec().getName() + " at " + s2.getCurrentSelection();
        return new ContainerDiffItem(description, ContainerDiffItem.Type.GROUP, f1, f2, diffItems);
    }

    private static Method getGenerateMethod(@NonNull IDiffable<?> o1, @NonNull IDiffable<?> o2) {
        try {
            Method thisMethod = DiffService.class.getDeclaredMethod("generate", IDiffable.class, IDiffable.class, ICoreProgressMonitor.class);
            Method targetMethod = DiffService.class.getDeclaredMethod("generate", o1.getIDiffableTClass(), o2.getIDiffableTClass(), ICoreProgressMonitor.class);
            if (thisMethod != targetMethod) {
                return targetMethod;
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean isDiffableHelper(@NonNull FunctionCall f1, @NonNull FunctionCall f2) {
        if (f1.equals(f2)) {
            return false;
        }
        if (f1.getModel() != f2.getModel()) {
            return false;
        }
        return f1.getPid() == f2.getPid();
    }

    private static boolean isDiffableHelper(@NonNull StateItem s1, @NonNull StateItem s2) {
        return s1.getStateSpec().equals(s2.getStateSpec());
    }

    private static boolean isDiffableHelper(@NonNull TraceStateSnapshot s1, @NonNull TraceStateSnapshot s2) {
        FunctionCall f1 = s1.getModel().getCallItem(s1.getCurrentSelection());
        FunctionCall f2 = s2.getModel().getCallItem(s2.getCurrentSelection());
        return DiffService.isDiffableHelper(f1, f2);
    }
}

