/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.diagnostics;

import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.IFunctionOrAliasSpec;
import java.util.ArrayList;
import java.util.List;

public class ListReplayableFunctions {
    public static void main(String[] args) throws IllegalArgumentException {
        ArrayList<IFunctionOrAliasSpecExtended> replayableFunctions = new ArrayList<IFunctionOrAliasSpecExtended>();
        ArrayList<IFunctionOrAliasSpecExtended> nonReplayableFunctions = new ArrayList<IFunctionOrAliasSpecExtended>();
        for (IFunctionOrAliasSpecExtended function : ListReplayableFunctions.getAllFunctionSpecs()) {
            if (function.isFrameReplayable()) {
                replayableFunctions.add(function);
                continue;
            }
            nonReplayableFunctions.add(function);
        }
        System.out.println("Replayable Functions:\n");
        for (IFunctionOrAliasSpecExtended functionSpec : replayableFunctions) {
            ListReplayableFunctions.printFunctionInformation(functionSpec);
        }
        System.out.println("\nNon-Replayable Functions:\n");
        for (IFunctionOrAliasSpecExtended functionSpec : nonReplayableFunctions) {
            ListReplayableFunctions.printFunctionInformation(functionSpec);
        }
    }

    private static void printFunctionInformation(IFunctionOrAliasSpecExtended functionSpec) {
        System.out.println(String.valueOf(functionSpec.getName()) + "\t" + (Object)((Object)functionSpec.getKapiSpec().getApi().getApiInfo().getName()) + " " + functionSpec.getHighestApiVersionSupportedIn());
    }

    public static List<IFunctionOrAliasSpecExtended> getAllFunctionSpecs() {
        ArrayList<IFunctionOrAliasSpecExtended> allFunctionSpecs = new ArrayList<IFunctionOrAliasSpecExtended>();
        for (KapiSpec kapiSpec : KapiSpec.getAvailableKapiSpecs()) {
            for (IFunctionOrAliasSpec fs : kapiSpec.getApi().getFunctions().getFunctionsAndAliases()) {
                allFunctionSpecs.add((IFunctionOrAliasSpecExtended)fs);
            }
        }
        return allFunctionSpecs;
    }
}

