/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.diagnostics;

import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.Frames;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.FileTarget;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.IReplayableListener;
import java.io.File;
import java.io.IOException;

public class FrameReplayCoverage
implements IReplayableListener {
    private int numberOfFrames = 0;
    private int framesProcessed = 0;
    private int replayFrameCount = 0;

    public static void main(String[] args) throws IOException, ProtocolVersionException {
        File testFile = args.length > 0 ? new File(args[0]) : new File("trace.mgd");
        FileTarget testFileTarget = new FileTarget(testFile);
        try {
            testFileTarget.syncRead();
            FrameReplayCoverage coverageChecker = new FrameReplayCoverage();
            testFileTarget.forEachProcessTarget(target -> coverageChecker.process(target.getModel()));
        }
        finally {
            testFileTarget.close(ICoreProgressMonitor.NULL_MONITOR);
        }
    }

    public void process(TraceDataModel model) {
        Frames modelFrames = model.getFrames();
        FrameReplayCoverage frameReplayCoverageTest = new FrameReplayCoverage();
        this.numberOfFrames = modelFrames.count();
        int i = 0;
        while (i < modelFrames.count()) {
            modelFrames.getFrameAt(i).isFrameReplayable(frameReplayCoverageTest);
            ++i;
        }
    }

    @Override
    public void onReplayStateUpdated(TraceDataModel model, Frame updatedFrame) {
        if (updatedFrame.isFrameReplayable(null)) {
            ++this.replayFrameCount;
        }
        ++this.framesProcessed;
        System.out.println("Frame: " + this.framesProcessed + " out of " + (this.numberOfFrames - 1) + " processed");
        if (this.framesProcessed >= this.numberOfFrames) {
            System.out.println("Processing completed: " + this.replayFrameCount + " out of " + (this.numberOfFrames - 1) + " frames are replayable");
        }
    }
}

