/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.devicediscovery;

import com.arm.mgd.core.devicediscovery.DeviceDiscoveryManager;
import com.arm.mgd.core.devicediscovery.IDeviceDiscoveryListener;
import com.arm.mgd.core.devicediscovery.LanDevice;
import com.arm.mgd.utils.NullUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleDeviceTracker {
    private final @NonNull IDeviceDiscoveryListener listener = new IDeviceDiscoveryListener(){

        @Override
        public void onStatusChanged(@NonNull DeviceDiscoveryManager.Status s, @Nullable Throwable e) {
        }

        @Override
        public void onDeviceUpdated(@NonNull LanDevice device) {
            SimpleDeviceTracker.this.connectedDevices.add(device);
        }

        @Override
        public void onDeviceRemoved(@NonNull String ipAddress) {
            Iterator<LanDevice> it = SimpleDeviceTracker.this.connectedDevices.iterator();
            while (it.hasNext()) {
                LanDevice device = it.next();
                if (!device.getIp().contentEquals(ipAddress)) continue;
                it.remove();
            }
        }
    };
    private final @NonNull Set<@NonNull LanDevice> connectedDevices = (Set)NullUtils.neverNull(Collections.synchronizedSet(new HashSet()));

    public SimpleDeviceTracker() {
        DeviceDiscoveryManager.getInstance().addListener(this.listener);
    }

    public @NonNull Set<@NonNull LanDevice> getConnectedDevices() {
        return new HashSet<LanDevice>(this.connectedDevices);
    }
}

