/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.devicediscovery;

import com.arm.mgd.core.devicediscovery.IDeviceDiscoveryListener;
import com.arm.mgd.core.devicediscovery.LanDevice;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DeviceDiscoveryManager {
    private static final @NonNull DeviceDiscoveryManager INSTANCE = new DeviceDiscoveryManager();
    private static final short PORT = 5003;
    private static final byte[] SIGNATURE = new byte[]{77, 71, 68, 68};
    private static final int SIGNATURE_LEN = 4;
    private static final int PROTOCOL_VERSION_LEN = 4;
    private static final int CONNECTED_STATUS_LEN = 1;
    private static final int GL_VENDOR_LEN = 32;
    private static final int GL_RENDERER_LEN = 32;
    private static final int GL_VERSION_LEN = 96;
    private static final int DATA_LEN = 512;
    private static final long PING_FREQUENCY_MILLISECONDS = 2000L;
    private static final long ALIVE_TIMEOUT_MILLISECONDS = 4000L;
    private static final long CLEANUP_SLEEP_MILLISECONDS = 500L;
    private static final long RETRY_INTERVAL_MILLISECONDS = 3000L;
    private static final long MAX_RETRY_COUNT = 30L;
    private final @NonNull AtomicBoolean isListening = new AtomicBoolean(false);
    private final @NonNull List<@NonNull IDeviceDiscoveryListener> listeners = new ArrayList<IDeviceDiscoveryListener>();
    private @Nullable DatagramSocket socket = null;
    private final @NonNull ReentrantLock lastUpdatedDevicesLock = new ReentrantLock();
    private final @NonNull Map<@NonNull String, Long> lastUpdatedDevices = new HashMap<String, Long>();

    private DeviceDiscoveryManager() {
    }

    public static @NonNull DeviceDiscoveryManager getInstance() {
        return INSTANCE;
    }

    private void start() {
        if (!this.isListening.compareAndSet(false, true)) {
            return;
        }
        new Thread(() -> {
            int retryCount = 0;
            while (this.isListening.get() && (long)retryCount++ < 30L) {
                try {
                    this.startListening();
                }
                catch (SocketException | UnknownHostException e) {
                    this.notifyAll(l -> l.onStatusChanged(Status.RETRYING, e));
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        this.stop();
                        break;
                    }
                }
            }
            this.stop();
            if ((long)retryCount >= 30L) {
                this.notifyAll(l -> l.onStatusChanged(Status.GIVENUP, null));
            }
        }).start();
        new Thread(() -> {
            try {
                try {
                    this.cleanup();
                }
                catch (InterruptedException e) {
                    this.notifyAll(l -> l.onStatusChanged(Status.GIVENUP, e));
                    this.stop();
                }
            }
            finally {
                this.stop();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        DeviceDiscoveryManager deviceDiscoveryManager = this;
        synchronized (deviceDiscoveryManager) {
            this.isListening.set(false);
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
    }

    private void cleanup() throws InterruptedException {
        ArrayList<String> purgeList = new ArrayList<String>();
        while (this.isListening.get()) {
            this.lastUpdatedDevicesLock.lock();
            for (Map.Entry<String, Long> kvp : this.lastUpdatedDevices.entrySet()) {
                if (System.currentTimeMillis() - kvp.getValue() <= 4000L) continue;
                purgeList.add(kvp.getKey());
                this.notifyAll(l -> l.onDeviceRemoved((String)kvp.getKey()));
            }
            this.lastUpdatedDevices.entrySet().removeIf(e -> purgeList.contains(e.getKey()));
            purgeList.clear();
            this.lastUpdatedDevicesLock.unlock();
            Thread.sleep(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startListening() throws SocketException, UnknownHostException {
        DatagramSocket localSocket;
        block16: {
            localSocket = null;
            try {
                localSocket = new DatagramSocket(5003, InetAddress.getByAddress(new byte[4]));
                localSocket.setReuseAddress(true);
                localSocket.setBroadcast(true);
            }
            catch (SocketException | UnknownHostException e) {
                CoreLogging.warning(null, e, "Failed to initialise listener socket for device discovery.");
                if (localSocket != null) {
                    localSocket.close();
                }
                throw e;
            }
            DeviceDiscoveryManager e = this;
            synchronized (e) {
                if (!this.isListening.get()) {
                    localSocket.close();
                    return;
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = localSocket;
            }
            this.notifyAll(l -> l.onStatusChanged(Status.RUNNING, null));
            ExecutorService executor = NamedExecutors.cachedFiniteThreadPool(1, 60L, TimeUnit.SECONDS, new NamedThreadFactory("DeviceDiscoveryManager Executor"));
            while (this.isListening.get()) {
                byte[] data = new byte[512];
                DatagramPacket receivedPacket = new DatagramPacket(data, data.length);
                try {
                    localSocket.receive(receivedPacket);
                }
                catch (IOException e2) {
                    if (localSocket.isClosed()) break;
                    CoreLogging.warning(null, e2, "Listener socket failed to receive device discovery announcements.");
                    break;
                }
                executor.execute(() -> this.processData(receivedPacket.getAddress().getHostAddress(), receivedPacket.getAddress().getHostName(), data));
            }
            try {
                try {
                    executor.shutdown();
                    executor.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e3) {
                    CoreLogging.warning(null, e3, "Interrupted while closing child threads of device discovery manager. Will force shut them down.");
                    executor.shutdownNow();
                    break block16;
                }
            }
            catch (Throwable throwable) {
                executor.shutdownNow();
                throw throwable;
            }
            executor.shutdownNow();
        }
        localSocket.close();
    }

    private void processData(@Nullable String ip, @Nullable String hostname, byte[] data) {
        assert (data.length == 512);
        if (data[0] != SIGNATURE[0] || data[1] != SIGNATURE[1] || data[2] != SIGNATURE[2] || data[3] != SIGNATURE[3]) {
            return;
        }
        if (ip == null) {
            return;
        }
        String realHostname = hostname == null || hostname.equals(ip) ? "" : hostname;
        int idx = 4;
        String protocolVersion = DeviceDiscoveryManager.getStringFromByteArray(data, idx, 4);
        boolean isConnected = data[idx += 4] != 0;
        String glVendor = DeviceDiscoveryManager.getStringFromByteArray(data, ++idx, 32);
        String glRenderer = DeviceDiscoveryManager.getStringFromByteArray(data, idx += 32, 32);
        String glVersion = DeviceDiscoveryManager.getStringFromByteArray(data, idx += 32, 96);
        this.lastUpdatedDevicesLock.lock();
        this.lastUpdatedDevices.put(ip, System.currentTimeMillis());
        this.lastUpdatedDevicesLock.unlock();
        this.notifyAll(l -> l.onDeviceUpdated(new LanDevice(ip, realHostname, protocolVersion, isConnected, glVendor, glRenderer, glVersion)));
    }

    private synchronized void notifyAll(@NonNull Consumer<@NonNull IDeviceDiscoveryListener> func) {
        for (IDeviceDiscoveryListener l : this.listeners) {
            try {
                func.accept(l);
            }
            catch (Throwable everything) {
                everything.printStackTrace();
            }
        }
    }

    public synchronized void addListener(@NonNull IDeviceDiscoveryListener listener) {
        this.start();
        this.listeners.add(listener);
    }

    public synchronized void removeListener(@NonNull IDeviceDiscoveryListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.stop();
        }
    }

    public void forceStop() {
        this.stop();
    }

    private static @NonNull String getStringFromByteArray(byte @NonNull [] data, int startIndex, int maxLength) {
        assert (data.length >= startIndex + maxLength);
        int i = startIndex;
        while (i < startIndex + maxLength) {
            byte c = data[i];
            if (c == 0) {
                return new String(data, startIndex, i - startIndex);
            }
            ++i;
        }
        return new String(data, startIndex, maxLength);
    }

    public static enum Status {
        RUNNING,
        RETRYING,
        GIVENUP;

    }
}

