/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.counters;

import com.arm.mgd.core.counters.Counters;
import com.arm.mgd.core.target.data.TraceDataModel;

public class PerFrameStatistics {
    private float verticesPerFrame;
    private float instancedVerticesPerFrame;
    private float drawCallsPerFrame;
    private float memoryAllocatedPerFrame;
    private final TraceDataModel parentModel;

    public PerFrameStatistics(TraceDataModel functionCallModel) {
        this.parentModel = functionCallModel;
    }

    public float getVerticesPerFrame() {
        return this.verticesPerFrame;
    }

    public float getInstancedVerticesPerFrame() {
        return this.instancedVerticesPerFrame;
    }

    public float getDrawCallsPerFrame() {
        return this.drawCallsPerFrame;
    }

    public float getMemoryAllocatedPerFrame() {
        return this.memoryAllocatedPerFrame;
    }

    public void updateStatistics() {
        Counters counters = this.parentModel.getCounters();
        float numberOfFrames = this.parentModel.getFrames().count();
        if (numberOfFrames == 0.0f) {
            numberOfFrames = 1.0f;
        }
        this.verticesPerFrame = (float)counters.totalVertices / numberOfFrames;
        this.instancedVerticesPerFrame = (float)counters.totalInstancedVertices / numberOfFrames;
        this.drawCallsPerFrame = (float)counters.totalDrawCalls / numberOfFrames;
        this.memoryAllocatedPerFrame = (float)counters.totalMemoryAllocated / numberOfFrames;
    }
}

