/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.counters;

import com.arm.mgd.core.asset.InterestingCallData;
import com.arm.mgd.core.counters.Counters;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.CommonStatistics;
import com.arm.mgd.core.util.FunctionCallProcessor;
import java.lang.reflect.Method;

public class CountersProcessor
extends FunctionCallProcessor {
    public static final CountersProcessor INSTANCE = new CountersProcessor();

    @Override
    public Method getMethodForFunctionCall(String functionName) throws SecurityException, NoSuchMethodException {
        try {
            return CountersProcessor.class.getMethod(functionName, FunctionCall.class, Counters.class);
        }
        catch (NoSuchMethodException e) {
            return CountersProcessor.class.getMethod(functionName, DrawFunctionCall.class, Counters.class);
        }
    }

    private static void processDraw(DrawFunctionCall functionCall, Counters counters) {
        ++counters.totalDrawCalls;
        InterestingCallData data = functionCall.getInterestingCallData();
        if (data.hasDataForStatisticType(CommonStatistics.NUMBER_OF_INSTANCED_VERTICES)) {
            counters.totalInstancedVertices += data.getStatistic(CommonStatistics.NUMBER_OF_INSTANCED_VERTICES).getValue().longValue();
        }
        if (data.hasDataForStatisticType(CommonStatistics.NUMBER_OF_INDICES)) {
            counters.totalVertices += data.getStatistic(CommonStatistics.NUMBER_OF_INDICES).getValue().longValue();
        }
    }

    public static void glClear(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glClearBufferfi(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glClearBufferfv(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glClearBufferiv(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glClearBufferuiv(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawArrays(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawArraysIndirect(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawArraysInstanced(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawElements(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawElementsBaseVertex(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawElementsIndirect(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawElementsInstanced(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawElementsInstancedBaseVertex(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawRangeElements(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }

    public static void glDrawRangeElementsBaseVertex(DrawFunctionCall functionCall, Counters counters) {
        CountersProcessor.processDraw(functionCall, counters);
    }
}

