/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.authorisation;

import com.arm.mgd.core.pb.v2.MgdProtosV2;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public enum Feature {
    FULL_TRACE_REPLAY("Full Trace Replay", "gd_full_trace_replay"),
    USER_SCRIPTING("User Scripting", "gd_user_scripting"),
    NON_MALI_DEVICE("Non-Mali Device", "gd_non_mali_device"),
    HARDWARE_COUNTERS("Hardware Counters", "gd_hardware_counters"),
    HEADLESS_MODE("Headless Mode", "gd_headless_mode"),
    LINUX_DEV_SUPPORT("Linux support", "gd_linux_support"),
    RESOURCES_EXPORT("Resources Export", "gd_resources_export"),
    AUTOMATED_TRACE("Automated Trace", "gd_automated_trace"),
    ROOTED_ANDROID_SUPPORT("Rooted Android Support", "gd_rooted_android_support"),
    UNROOTED_ANDROID_SUPPORT("Unrooted Android Support", null),
    GRAPHICS_ANALYZER_PRODUCT("Graphics Analyzer Product", "graphics.analyser.product");

    private static final String FEATURE_NOT_AVAILABLE_MESSAGE = "No corresponding product feature is available for: ";
    private final @NonNull String label;
    private final @Nullable String licensingName;

    private Feature(String label, String licensingName) {
        this.label = label;
        this.licensingName = licensingName;
    }

    public @NonNull String getLabel() {
        return this.label;
    }

    public @Nullable String getLicensingName() {
        return this.licensingName;
    }

    public static @NonNull Feature getCoreFeature( @NonNull MgdProtosV2.ProductFeatures feature) {
        switch (feature) {
            case FULL_TRACE_REPLAY: {
                return FULL_TRACE_REPLAY;
            }
            case HEADLESS_MODE: {
                return HEADLESS_MODE;
            }
            case LINUX_DEV_SUPPORT: {
                return LINUX_DEV_SUPPORT;
            }
            case ROOTED_ANDROID_SUPPORT: {
                return ROOTED_ANDROID_SUPPORT;
            }
            case UNROOTED_ANDROID_SUPPORT: {
                return UNROOTED_ANDROID_SUPPORT;
            }
        }
        throw new AssertionError((Object)("Unknown feature: " + (Object)((Object)feature)));
    }

    public  @NonNull MgdProtosV2.ProductFeatures getAsProductFeatures() {
        switch (this) {
            case FULL_TRACE_REPLAY: {
                return MgdProtosV2.ProductFeatures.FULL_TRACE_REPLAY;
            }
            case HEADLESS_MODE: {
                return MgdProtosV2.ProductFeatures.HEADLESS_MODE;
            }
            case LINUX_DEV_SUPPORT: {
                return MgdProtosV2.ProductFeatures.LINUX_DEV_SUPPORT;
            }
            case ROOTED_ANDROID_SUPPORT: {
                return MgdProtosV2.ProductFeatures.ROOTED_ANDROID_SUPPORT;
            }
            case UNROOTED_ANDROID_SUPPORT: {
                return MgdProtosV2.ProductFeatures.UNROOTED_ANDROID_SUPPORT;
            }
        }
        throw new AssertionError((Object)(FEATURE_NOT_AVAILABLE_MESSAGE + (Object)((Object)this)));
    }

    private @NonNull String getAsVerbPhrase() {
        switch (this) {
            case AUTOMATED_TRACE: {
                return "use automated trace";
            }
            case FULL_TRACE_REPLAY: {
                return "use full trace replay";
            }
            case HARDWARE_COUNTERS: {
                return "use hardware counters";
            }
            case HEADLESS_MODE: {
                return "operate in headless mode (that is, entirely from the command-line)";
            }
            case LINUX_DEV_SUPPORT: {
                return "trace Linux targets";
            }
            case NON_MALI_DEVICE: {
                return "trace a non-Mali device";
            }
            case RESOURCES_EXPORT: {
                return "export resources";
            }
            case ROOTED_ANDROID_SUPPORT: {
                return "connect to a rooted Android device";
            }
            case UNROOTED_ANDROID_SUPPORT: {
                return "connect to an unrooted Android device";
            }
            case USER_SCRIPTING: {
                return "allow user scripting";
            }
            case GRAPHICS_ANALYZER_PRODUCT: {
                return "use this product";
            }
        }
        return "perform this operation";
    }

    public @NonNull String getLicenceMissingMessage() {
        String checkUserGuideMessage = "If you have an appropriate license, make sure that you have followed the instructions in the User Guide.";
        StringBuilder sb = new StringBuilder();
        switch (this) {
            case NON_MALI_DEVICE: {
                sb.append("You are either trying to debug a non-Mali GPU, or ").append(VersionProperties.FULL_PRODUCT_NAME).append(" can't tell which GPU is in your device. ").append(System.lineSeparator()).append(System.lineSeparator()).append("This error will not occur if you install a \"").append((Object)this).append("\" license allowing the tracing of non-Mali GPUs. ").append("If you have an appropriate license, make sure that you have followed the instructions in the User Guide.").append(" If you are tracing a Linux target, ensure that the EGL and OpenGL ES libraries are present in the ").append("LD_LIBRARY_PATH environment variable or in the directories /lib, /usr/lib, /lib64 or /usr/lib64.");
                break;
            }
            case FULL_TRACE_REPLAY: 
            case USER_SCRIPTING: 
            case HARDWARE_COUNTERS: 
            case HEADLESS_MODE: 
            case LINUX_DEV_SUPPORT: 
            case RESOURCES_EXPORT: 
            case AUTOMATED_TRACE: 
            case ROOTED_ANDROID_SUPPORT: 
            case UNROOTED_ANDROID_SUPPORT: 
            case GRAPHICS_ANALYZER_PRODUCT: {
                sb.append("Cannot ").append(this.getAsVerbPhrase()).append(" without a license covering feature \"").append((Object)this).append("\". ").append("If you have an appropriate license, make sure that you have followed the instructions in the User Guide.");
                break;
            }
            default: {
                sb.append("A license covering feature \"").append((Object)this).append("\" is unavailable. ").append("If you have an appropriate license, make sure that you have followed the instructions in the User Guide.");
            }
        }
        return (String)NullUtils.neverNull((Object)sb.toString());
    }
}

