/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.authorisation;

import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.authorisation.IArmAuthorisationProvider;
import com.arm.mgd.core.authorisation.ILicenseFeatureGrant;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AuthorisationManager {
    private static final @NonNull String AUTHORISATION_GRANTED_SUCCESS = "Authorisation granted from license file.";
    private final @NonNull Map<Feature, FeatureAuthorisationLicense> featuresAuthorisationLicenses = new HashMap<Feature, FeatureAuthorisationLicense>();
    private final @NonNull IArmAuthorisationProvider authorisationProvider;
    private final @NonNull NamedSingleThreadExecutor executor = new NamedSingleThreadExecutor("License Checkout Thread", true);

    public AuthorisationManager(@NonNull IArmAuthorisationProvider authorisationProvider) {
        this.authorisationProvider = authorisationProvider;
    }

    public @NonNull IArmAuthorisationProvider getAuthorisationProvider() {
        return this.authorisationProvider;
    }

    public boolean canProvideAuthorisation() {
        return this.authorisationProvider.canProvideAuthorisation();
    }

    public boolean willCompleteImmediately() {
        return this.authorisationProvider.willCompleteImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllAuthorisations() {
        Map<Feature, FeatureAuthorisationLicense> map = this.featuresAuthorisationLicenses;
        synchronized (map) {
            for (FeatureAuthorisationLicense license : this.featuresAuthorisationLicenses.values()) {
                if (license.licenseGrant == null) continue;
                license.licenseGrant.close();
            }
            this.featuresAuthorisationLicenses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull CompletableFuture<@NonNull FeatureAuthorisation> getAuthorisation(@NonNull Feature feature) {
        Map<Feature, FeatureAuthorisationLicense> map = this.featuresAuthorisationLicenses;
        synchronized (map) {
            CompletableFuture<@NonNull FeatureAuthorisation> future = new CompletableFuture<FeatureAuthorisation>();
            FeatureAuthorisationLicense featureAuthorisationLicense = this.featuresAuthorisationLicenses.get((Object)feature);
            if (featureAuthorisationLicense != null) {
                featureAuthorisationLicense.incrementCount();
                future.complete(featureAuthorisationLicense.featureAuthorisation);
            } else {
                this.executor.runLater(() -> future.complete(this.checkoutLicense((Feature)feature).featureAuthorisation));
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAuthorisation(@NonNull Feature feature) {
        Map<Feature, FeatureAuthorisationLicense> map = this.featuresAuthorisationLicenses;
        synchronized (map) {
            FeatureAuthorisationLicense featureAuthorisationLicense = this.featuresAuthorisationLicenses.get((Object)feature);
            assert (featureAuthorisationLicense != null);
            featureAuthorisationLicense.decrementCount();
            if (featureAuthorisationLicense.count == 0) {
                this.featuresAuthorisationLicenses.remove((Object)feature);
                AuthorisationManager.releaseFeatureAuthorisationLicense(featureAuthorisationLicense);
            }
        }
    }

    private static void releaseFeatureAuthorisationLicense(@Nullable FeatureAuthorisationLicense featureAuthorisationLicense) {
        if (featureAuthorisationLicense != null && featureAuthorisationLicense.licenseGrant != null) {
            featureAuthorisationLicense.licenseGrant.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FeatureAuthorisationLicense checkoutLicense(@NonNull Feature feature) {
        Map<Feature, FeatureAuthorisationLicense> map = this.featuresAuthorisationLicenses;
        synchronized (map) {
            FeatureAuthorisationLicense featureAuthorisationLicense;
            try {
                @NonNull ILicenseFeatureGrant license = this.authorisationProvider.checkoutLicense(feature);
                featureAuthorisationLicense = new FeatureAuthorisationLicense(new FeatureAuthorisation(true, AUTHORISATION_GRANTED_SUCCESS, feature), license);
            }
            catch (IArmAuthorisationProvider.CheckoutException | IArmAuthorisationProvider.NoLicenseFoundException e) {
                featureAuthorisationLicense = new FeatureAuthorisationLicense(new FeatureAuthorisation(false, (String)NullUtils.neverNull((Object)e.getMessage()), feature), null);
            }
            FeatureAuthorisationLicense oldFeatureAuthorisationLicense = this.featuresAuthorisationLicenses.put(feature, featureAuthorisationLicense);
            AuthorisationManager.releaseFeatureAuthorisationLicense(oldFeatureAuthorisationLicense);
            return featureAuthorisationLicense;
        }
    }

    private class FeatureAuthorisationLicense {
        private final @NonNull FeatureAuthorisation featureAuthorisation;
        private final @Nullable ILicenseFeatureGrant licenseGrant;
        private int count;

        private FeatureAuthorisationLicense(@Nullable FeatureAuthorisation featureAuthorisation, ILicenseFeatureGrant licenseGrant) {
            this.featureAuthorisation = featureAuthorisation;
            this.licenseGrant = licenseGrant;
            this.count = 1;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void decrementCount() {
            assert (this.count > 0);
            --this.count;
        }
    }
}

