/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.authorisation;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.authorisation.AuthorisationManager;
import com.arm.mgd.core.authorisation.Feature;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.utils.NullUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ApplicationFeatureAuthoriser {
    public static final @NonNull ApplicationFeatureAuthoriser HARDWARE_COUNTERS = new ApplicationFeatureAuthoriser(Feature.HARDWARE_COUNTERS);
    public static final @NonNull ApplicationFeatureAuthoriser FULL_TRACE_REPLAY = new ApplicationFeatureAuthoriser(Feature.FULL_TRACE_REPLAY);
    public static final @NonNull ApplicationFeatureAuthoriser HEADLESS_MODE = new ApplicationFeatureAuthoriser(Feature.HEADLESS_MODE);
    public static final @NonNull ApplicationFeatureAuthoriser RESOURCES_EXPORT = new ApplicationFeatureAuthoriser(Feature.RESOURCES_EXPORT);
    public static final @NonNull ApplicationFeatureAuthoriser AUTOMATED_TRACE = new ApplicationFeatureAuthoriser(Feature.AUTOMATED_TRACE);
    public static final @NonNull ApplicationFeatureAuthoriser USER_SCRIPTING = new ApplicationFeatureAuthoriser(Feature.USER_SCRIPTING);
    private final @NonNull Feature feature;
    private @Nullable FeatureAuthorisation authorisationOutcome = null;
    private final @NonNull Set<Consumer<? super FeatureAuthorisation>> authorisationConsumers = (Set)NullUtils.neverNull(ConcurrentHashMap.newKeySet());
    private static final @NonNull Executor consumerExecutor = (Executor)NullUtils.neverNull((Object)Executors.newSingleThreadExecutor());
    private static final @NonNull Set<@NonNull Feature> CURRENT_AUTHORISED_FEATURES = (Set)NullUtils.neverNull(ConcurrentHashMap.newKeySet());
    private static final @NonNull Executor featureChangedExecutor = (Executor)NullUtils.neverNull((Object)Executors.newSingleThreadExecutor());
    private static final @NonNull Set<Consumer<@NonNull Set<Feature>>> featureListChangedListeners = (Set)NullUtils.neverNull(ConcurrentHashMap.newKeySet());

    private ApplicationFeatureAuthoriser(@NonNull Feature feature) {
        this.feature = feature;
    }

    public @NonNull Feature getFeature() {
        return this.feature;
    }

    public void claimFeature() {
        @Nullable AuthorisationManager authManager = CoreInstance.getAuthorisationManager();
        assert (authManager != null);
        if (authManager.willCompleteImmediately()) {
            this.setAuthorisation(authManager.getAuthorisation(this.feature).join());
        } else {
            authManager.getAuthorisation(this.feature).thenAccept(auth -> this.setAuthorisation((FeatureAuthorisation)auth));
        }
    }

    private static @NonNull Set<Feature> getImmutableCopyOfCurrentFeaturesSet() {
        return NullUtils.unmodifiableSet(new HashSet<Feature>(CURRENT_AUTHORISED_FEATURES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAuthorisation(@NonNull FeatureAuthorisation auth) {
        ApplicationFeatureAuthoriser applicationFeatureAuthoriser = this;
        synchronized (applicationFeatureAuthoriser) {
            this.authorisationOutcome = auth;
        }
        boolean featureListChanged = false;
        featureListChanged = auth.isAuthorised() ? CURRENT_AUTHORISED_FEATURES.add(auth.getFeature()) : CURRENT_AUTHORISED_FEATURES.remove((Object)auth.getFeature());
        if (featureListChanged) {
            featureChangedExecutor.execute(() -> featureListChangedListeners.forEach(consumer -> consumer.accept(ApplicationFeatureAuthoriser.getImmutableCopyOfCurrentFeaturesSet())));
        }
        this.authorisationConsumers.forEach(consumer -> consumerExecutor.execute(() -> consumer.accept(auth)));
    }

    public synchronized void registerAuthorisationConsumer(@NonNull Consumer<@NonNull ? super FeatureAuthorisation> consumer) {
        if (this.authorisationOutcome != null) {
            consumerExecutor.execute(() -> consumer.accept(this.authorisationOutcome));
        }
        this.authorisationConsumers.add(consumer);
    }

    public static void registerAnyAuthorisationConsumer(@NonNull Consumer<@NonNull Set<Feature>> consumer) {
        featureListChangedListeners.add(consumer);
        consumer.accept(NullUtils.unmodifiableSet(ApplicationFeatureAuthoriser.getImmutableCopyOfCurrentFeaturesSet()));
    }

    public static @NonNull List<@NonNull ApplicationFeatureAuthoriser> getListOfLifetimeFeatureAuthorisers() {
        return NullUtils.asList((Object[])new ApplicationFeatureAuthoriser[]{HARDWARE_COUNTERS, FULL_TRACE_REPLAY, HEADLESS_MODE, RESOURCES_EXPORT, AUTOMATED_TRACE, USER_SCRIPTING});
    }

    public synchronized boolean isAuthorisationReceivedAndApproved() {
        return this.authorisationOutcome != null && this.authorisationOutcome.isAuthorised();
    }
}

