/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.texture.ConvertExe;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class RGBAImageWriter {
    public static void writeAsPng(@NonNull RGBAImageData imageData, @NonNull File pngFile) throws IOException {
        File rgba = null;
        try {
            rgba = FileUtils.makeFileFromBuffers(pngFile.getName(), ".rgba", imageData.getData().getData());
            int bitDepth = 8;
            @NonNull Dimension size = imageData.getSize();
            boolean isFlipped = imageData.getCoordinateOrigin() == RGBAImageData.CoordinateOrigin.TOP_LEFT;
            ConvertExe.convertRawRGBAtoPng(rgba, size.getWidth(), size.getHeight(), isFlipped, 8, pngFile);
        }
        finally {
            if (rgba != null) {
                rgba.delete();
            }
        }
    }
}

