/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import org.eclipse.jdt.annotation.NonNull;

public class RGBAImageData {
    private final @NonNull Dimension size;
    private final @NonNull IByteDataProvider data;
    private final @NonNull CoordinateOrigin coordinateOrigin;

    public RGBAImageData(@NonNull Dimension size, @NonNull IByteDataProvider data, @NonNull CoordinateOrigin coordinateOrigin) throws IImageProvider.ImageConversionException {
        this.size = size;
        this.data = data;
        this.coordinateOrigin = coordinateOrigin;
        if (!size.isValid() || !size.is2D()) {
            throw new IImageProvider.ImageConversionException("Invalid image dimensions " + size);
        }
        int expectedLength = 4 * size.getArea();
        if (data.getLength() != expectedLength) {
            throw new IImageProvider.ImageConversionException("Image size is " + size + " but data was " + data.getLength() + " bytes. Expected " + expectedLength + " bytes.");
        }
    }

    public @NonNull Dimension getSize() {
        return this.size;
    }

    public @NonNull IByteDataProvider getData() {
        return this.data;
    }

    public @NonNull CoordinateOrigin getCoordinateOrigin() {
        return this.coordinateOrigin;
    }

    public static enum CoordinateOrigin {
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

