/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.GlImageOffset;
import com.arm.mgd.core.asset.texture.ASTCHeader;
import com.arm.mgd.core.asset.texture.AstcExe;
import com.arm.mgd.core.asset.texture.ConvertExe;
import com.arm.mgd.core.asset.texture.EtcPackExe;
import com.arm.mgd.core.asset.texture.IGlTextureLayerData;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.Dimension3D;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.core.util.HashUtils;
import com.arm.mgd.core.util.image.IntegerTextureConverter;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlTextureLayer
implements Serializable,
IImageProvider {
    private static final @NonNull ConvertExe CONVERT_EXE = new ConvertExe();
    private static final @NonNull EtcPackExe ETC_PACK = new EtcPackExe();
    private static final @NonNull AstcExe ASTC_EXE = new AstcExe();
    private static final long serialVersionUID = 5770869199709271576L;
    private final @NonNull Dimension dimension;
    private final @NonNull AbstractConstantOrAliasSpecExtended internalFormat;
    private File pngFile;
    private final @Nullable IGlTextureLayerData textureData;
    private final @NonNull GlImageOffset offset;
    private final @Nullable AbstractConstantOrAliasSpecExtended type;
    private @Nullable String dataHash;

    public GlTextureLayer(@Nullable IGlTextureLayerData textureData, @NonNull GlImageOffset glImageOffset, @NonNull Dimension size, @NonNull AbstractConstantOrAliasSpecExtended internalFormat, @Nullable AbstractConstantOrAliasSpecExtended type) {
        this.textureData = textureData;
        this.offset = glImageOffset;
        this.dimension = size;
        this.internalFormat = internalFormat;
        this.type = type;
    }

    @Nullable String getDataHash() {
        if (this.dataHash == null) {
            IByteDataProvider provider = this.getData();
            this.dataHash = provider != null ? HashUtils.getBytesAsString(HashUtils.getMD5Hash(provider)) : null;
        }
        return this.dataHash;
    }

    public @Nullable IByteDataProvider getData() {
        return this.textureData != null ? this.textureData.getData() : null;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getInternalFormat() {
        return this.internalFormat;
    }

    public @Nullable AbstractConstantOrAliasSpecExtended getType() {
        return this.type;
    }

    public @NonNull Dimension getSize() {
        return this.dimension;
    }

    public @NonNull GlImageOffset getOffset() {
        return this.offset;
    }

    synchronized @NonNull File getPngFile() throws IOException, UnsupportedGlTextureFormatException, IImageProvider.ImageDataUnavailableException {
        if (this.pngFile == null || !this.pngFile.exists()) {
            File potentialPngFile = FileUtils.getFileInTempDir("GlTextureLayer_" + this.getDataHash() + "_" + this.getSize() + ".png");
            if (potentialPngFile.exists()) {
                this.pngFile = potentialPngFile;
            } else {
                try {
                    this.getPngFileForTexture(potentialPngFile);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                if (potentialPngFile.exists()) {
                    this.pngFile = potentialPngFile;
                }
            }
        }
        if (this.pngFile != null) {
            return this.pngFile;
        }
        throw new GlImageUnavailableRawData(this);
    }

    @Override
    public @NonNull RGBAImageData getImageData() throws IOException, IImageProvider.ImageDataUnavailableException, IImageProvider.ImageConversionException {
        File png = this.getPngFile();
        File rgba = null;
        byte @Nullable [] data = null;
        try {
            rgba = ConvertExe.convertPngToRawRGBA(png);
            data = Files.readAllBytes(rgba.toPath());
            assert (data != null);
        }
        finally {
            if (rgba != null) {
                rgba.delete();
            }
        }
        return new RGBAImageData(this.getSize(), IByteDataProvider.createMemoryProvider(data), RGBAImageData.CoordinateOrigin.BOTTOM_LEFT);
    }

    public void getPngFileForTexture(@NonNull File outputPngFile) throws IOException, UnsupportedGlTextureFormatException, InterruptedException, GlImageUnavailableRawData {
        AbstractConstantOrAliasSpecExtended localType = this.type;
        if (!CONVERT_EXE.isAvailable() || !ETC_PACK.isAvailable()) {
            throw new IOException("Texture tools not available.");
        }
        if (this.dimension.getDepth() > 1) {
            throw new UnsupportedGlTextureFormatException("Cannot convert 3D textures for visualization.");
        }
        IByteDataProvider provider = this.getData();
        if (provider == null || provider.isEmpty()) {
            throw new GlImageUnavailableRawData(this);
        }
        ByteBuffer data = provider.getData();
        if (KapiSpec.GLES.constants.GL_COMPRESSED_RGBA8_ETC2_EAC.equals(this.internalFormat)) {
            ETC_PACK.getPngFileForCompressedTexture(outputPngFile, data, this.dimension, EtcPackExe.EtcDescriptor.ETC2PACKAGE_RGBA_NO_MIPMAPS);
        } else if (KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC.equals(this.internalFormat)) {
            ETC_PACK.getPngFileForCompressedTexture(outputPngFile, data, this.dimension, EtcPackExe.EtcDescriptor.ETC2PACKAGE_RGBA_NO_MIPMAPS);
        } else if (KapiSpec.GLES.constants.GL_COMPRESSED_RGB8_ETC2.equals(this.internalFormat)) {
            ETC_PACK.getPngFileForCompressedTexture(outputPngFile, data, this.dimension, EtcPackExe.EtcDescriptor.ETC2PACKAGE_RGB_NO_MIPMAPS);
        } else if (KapiSpec.GLES.constants.GL_ETC1_RGB8_OES.equals(this.internalFormat)) {
            ETC_PACK.getPngFileForCompressedTexture(outputPngFile, data, this.dimension, EtcPackExe.EtcDescriptor.ETC1_RGB_NO_MIPMAPS);
        } else if (KapiSpec.GLES.constantGroups.ASTCFORMATS.contains(this.internalFormat)) {
            ASTCHeader header = new ASTCHeader(this.internalFormat, new Dimension3D(this.dimension.getWidth(), this.dimension.getHeight()));
            ASTC_EXE.getPngFileForCompressedTexture(header, outputPngFile, provider.getData());
        } else if (Arrays.asList(KapiSpec.GLES.constants.GL_LUMINANCE, KapiSpec.GLES.constants.GL_ALPHA).contains(this.internalFormat)) {
            CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, this, ConvertExe.RawImageDescriptor.GRAYSCALE);
        } else if (KapiSpec.GLES.constants.GL_RGBA4.equals(this.internalFormat)) {
            CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, this, ConvertExe.RawImageDescriptor.RGBA4444);
        } else if (KapiSpec.GLES.constants.GL_RGBA8.equals(this.internalFormat)) {
            CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, this, ConvertExe.RawImageDescriptor.RGBA8888);
        } else if (localType != null) {
            if (KapiSpec.GLES.constants.GL_RGBA.equals(this.internalFormat) && KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.equals(localType)) {
                CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, this, ConvertExe.RawImageDescriptor.RGBA8888);
            } else if (KapiSpec.GLES.constants.GL_BGRA_EXT.equals(this.internalFormat) && KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.equals(localType)) {
                CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, this, ConvertExe.RawImageDescriptor.BGRA8888);
            } else if (KapiSpec.GLES.constants.GL_RGBA.equals(this.internalFormat) && KapiSpec.GLES.constants.GL_UNSIGNED_SHORT_4_4_4_4.equals(localType)) {
                CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, this, ConvertExe.RawImageDescriptor.RGBA4444);
            } else if (KapiSpec.GLES.constants.GL_RGB.equals(this.internalFormat) && KapiSpec.GLES.constants.GL_UNSIGNED_BYTE.equals(localType)) {
                CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, this, ConvertExe.RawImageDescriptor.RGB888);
            } else if (KapiSpec.GLES.constants.GL_RGB.equals(this.internalFormat) && KapiSpec.GLES.constants.GL_UNSIGNED_SHORT_5_6_5.equals(localType)) {
                IntegerTextureConverter.Result convertedData = IntegerTextureConverter.convertOpenGLESTextureData(data, this.getSize(), this.internalFormat, localType, null, IntegerTextureConverter.AlphaChannel.NO_ALPHA);
                CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, ConvertExe.RawImageDescriptor.RGB888, NullUtils.asReadOnlyByteBuffer((byte[])convertedData.getData()), convertedData.getWidth(), convertedData.getHeight());
            } else if (KapiSpec.GLES.constants.GL_RED_INTEGER.equals(this.internalFormat) && KapiSpec.GLES.constants.GL_INT.equals(localType)) {
                IntegerTextureConverter.Result convertedData = IntegerTextureConverter.convertOpenGLESTextureData(data, this.getSize(), this.internalFormat, localType, null, IntegerTextureConverter.AlphaChannel.NO_ALPHA);
                CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, ConvertExe.RawImageDescriptor.RGB888, NullUtils.asReadOnlyByteBuffer((byte[])convertedData.getData()), convertedData.getWidth(), convertedData.getHeight());
            } else {
                IntegerTextureConverter.Result convertedData = IntegerTextureConverter.convertOpenGLESTextureData(data, this.getSize(), this.internalFormat, localType, null, IntegerTextureConverter.AlphaChannel.NO_ALPHA);
                if (convertedData == null) {
                    throw new UnsupportedGlTextureFormatException(this);
                }
                CONVERT_EXE.getPngFileForUncompressedTexture(outputPngFile, ConvertExe.RawImageDescriptor.RGB888, NullUtils.asReadOnlyByteBuffer((byte[])convertedData.getData()), convertedData.getWidth(), convertedData.getHeight());
            }
        } else {
            throw new UnsupportedGlTextureFormatException(this);
        }
    }

    public static class GlImageUnavailableRawData
    extends IImageProvider.ImageDataUnavailableException {
        private GlImageUnavailableRawData(@NonNull GlTextureLayer layer) {
            super(GlImageUnavailableRawData.getMessageFromLayer(layer));
        }

        private static String getMessageFromLayer(@NonNull GlTextureLayer layer) {
            AbstractConstantOrAliasSpecExtended internalFormat = layer.getInternalFormat();
            return "Texture with internal format " + internalFormat.getName() + " (" + internalFormat.getValue() + ") has not been captured and no image data is available.";
        }
    }

    public static class UnsupportedGlTextureFormatException
    extends IImageProvider.ImageConversionException {
        private UnsupportedGlTextureFormatException(@NonNull GlTextureLayer layer) {
            super(UnsupportedGlTextureFormatException.getMessageFromLayer(layer));
        }

        private static String getMessageFromLayer(@NonNull GlTextureLayer layer) {
            AbstractConstantOrAliasSpecExtended internalFormat = layer.getInternalFormat();
            return "Texture internal format " + internalFormat.getName() + " (" + internalFormat.getValue() + ") not supported.";
        }

        private UnsupportedGlTextureFormatException(@NonNull String reason) {
            super(reason);
        }
    }
}

