/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.GlImageOffset;
import com.arm.mgd.core.asset.texture.ConvertExe;
import com.arm.mgd.core.asset.texture.GlTextureLayer;
import com.arm.mgd.core.asset.texture.IGlImageProvider;
import com.arm.mgd.core.asset.texture.IImageCompositor;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.Pair;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlTextureCompositor
implements IGlImageProvider,
IImageCompositor<GlTextureLayer>,
Serializable {
    private static final long serialVersionUID = -984491783858240565L;
    private final @NonNull List<@NonNull GlTextureLayer> textureLayers = new ArrayList<GlTextureLayer>();
    private static final int MAX_FORMAT_TYPE_PAIRS_TO_SHOW = 5;

    @Override
    public @NonNull Dimension getSize() {
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        int minDepth = Integer.MAX_VALUE;
        int maxWidth = 0;
        int maxHeight = 0;
        int maxDepth = 0;
        boolean is2D = false;
        for (GlTextureLayer layer : this.textureLayers) {
            GlImageOffset offset = layer.getOffset();
            Dimension size = layer.getSize();
            is2D |= size.is2D();
            maxWidth = Math.max(maxWidth, offset.x + size.getWidth());
            maxHeight = Math.max(maxHeight, offset.y + size.getHeight());
            maxDepth = Math.max(maxDepth, offset.z + size.getDepth());
            minWidth = Math.min(minWidth, offset.x);
            minHeight = Math.min(minHeight, offset.y);
            minDepth = Math.min(minDepth, offset.z);
        }
        if (is2D) {
            return new Dimension(maxWidth - minWidth, maxHeight - minHeight);
        }
        return new Dimension(maxWidth - minWidth, maxHeight - minHeight, maxDepth - minDepth);
    }

    @Override
    public String getGlFormatDescription() {
        HashSet<String> typeStrings = new HashSet<String>();
        for (GlTextureLayer layer : this.textureLayers) {
            typeStrings.add(layer.getInternalFormat().getName());
        }
        return StringUtils.arrayToString(typeStrings.toArray(), 5);
    }

    @Override
    public String getGlTypeDescription() {
        HashSet<String> typeStrings = new HashSet<String>();
        for (GlTextureLayer layer : this.textureLayers) {
            AbstractConstantOrAliasSpecExtended type = layer.getType();
            if (type == null) continue;
            typeStrings.add(type.getName());
        }
        return StringUtils.arrayToString(typeStrings.toArray(), 6);
    }

    public @NonNull String getGlFormatTypeDescription() {
        TreeSet<Pair<String, String>> formatTypePairs = new TreeSet<Pair<String, String>>(new Comparator<Pair<String, String>>(){

            @Override
            public int compare(Pair<String, String> a, Pair<String, String> b) {
                int formatResult = a.getFirstValue().compareTo(b.getFirstValue());
                if (formatResult != 0) {
                    return formatResult;
                }
                return a.getSecondValue().compareTo(b.getSecondValue());
            }
        });
        for (GlTextureLayer layer : this.textureLayers) {
            @NonNull AbstractConstantOrAliasSpecExtended abstractConstantOrAliasSpecExtended = layer.getInternalFormat();
            AbstractConstantOrAliasSpecExtended type = layer.getType();
            if (type == null) continue;
            formatTypePairs.add(new Pair<String, String>(abstractConstantOrAliasSpecExtended.getName(), type.getName()));
        }
        StringBuilder result = new StringBuilder();
        int limit = 0;
        for (Pair pair : formatTypePairs) {
            if (limit > 0) {
                result.append(", ");
            }
            result.append((String)pair.getFirstValue()).append(":").append((String)pair.getSecondValue());
            if (++limit >= 5) break;
        }
        return (String)NullUtils.neverNull((Object)result.toString());
    }

    public @Nullable GlTextureLayer getLayer(int key) {
        try {
            return this.textureLayers.get(key);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public @NonNull RGBAImageData getImageData() throws IImageProvider.ImageDataUnavailableException, IOException, IImageProvider.ImageConversionException {
        if (this.isDataInvalid()) {
            throw new IImageProvider.ImageDataUnavailableException("No data available");
        }
        if (this.textureLayers.size() == 1 && this.textureLayers.get(0).getOffset().equals(GlImageOffset.ZERO)) {
            return this.textureLayers.get(0).getImageData();
        }
        File png = null;
        File rgba = null;
        byte @Nullable [] data = null;
        try {
            png = ConvertExe.combineImages(this.textureLayers);
            rgba = ConvertExe.convertPngToRawRGBA(png);
            data = Files.readAllBytes(rgba.toPath());
            assert (data != null);
        }
        finally {
            if (png != null) {
                png.delete();
            }
            if (rgba != null) {
                rgba.delete();
            }
        }
        return new RGBAImageData(this.getSize(), IByteDataProvider.createMemoryProvider(data), RGBAImageData.CoordinateOrigin.BOTTOM_LEFT);
    }

    @Override
    public void addElement(@NonNull GlTextureLayer element) {
        this.textureLayers.add(element);
    }

    @Override
    public void removeElementsIf(@NonNull Predicate<GlTextureLayer> deletionPredicate) {
        this.textureLayers.removeIf(deletionPredicate);
    }

    public void resetImageDataAndClearTextureLayers() {
        this.textureLayers.clear();
    }

    @Override
    public boolean isDataInvalid() {
        return this.textureLayers.isEmpty();
    }
}

