/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.texture.IGlImageProvider;
import com.arm.mgd.core.asset.texture.IImageCompositor;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.target.data.FramebufferAttachment;
import com.arm.mgd.core.target.data.FramebufferDiffAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.marshaller.TraceParseException;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.image.IntegerTextureConverter;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlFramebufferCompositor
implements IGlImageProvider,
IImageCompositor<FramebufferDiffAttachment>,
Serializable {
    private static final long serialVersionUID = 9067552101844448572L;
    private final AbstractConstantOrAliasSpecExtended attachment;
    private final @Nullable AbstractConstantOrAliasSpecExtended internalFormat;
    private boolean treatAsInternalFormat;
    private final List<FramebufferDiffAttachment> framebufferDiffs;
    private FramebufferAttachment fullBuffer;
    private @Nullable FunctionCall invalidatesFramebufferFunctionCall;

    public GlFramebufferCompositor(AbstractConstantOrAliasSpecExtended attachment, AbstractConstantOrAliasSpecExtended internalFormat) {
        this.attachment = attachment;
        this.internalFormat = internalFormat;
        this.treatAsInternalFormat = false;
        this.framebufferDiffs = new CopyOnWriteArrayList<FramebufferDiffAttachment>();
        this.fullBuffer = null;
    }

    private void resetImageData() {
        this.invalidatesFramebufferFunctionCall = null;
    }

    public AbstractConstantOrAliasSpecExtended getAttachment() {
        return this.attachment;
    }

    @Override
    public String getGlFormatDescription() {
        return this.fullBuffer != null ? this.fullBuffer.format.getName() : "";
    }

    @Override
    public String getGlTypeDescription() {
        return this.fullBuffer != null ? this.fullBuffer.type.getName() : "";
    }

    @Override
    public void addElement(FramebufferDiffAttachment element) {
        try {
            this.addFramebufferDiffAttachment(element);
        }
        catch (TraceParseException e) {
            CoreLogging.severe(e);
        }
    }

    private void addFramebufferDiffAttachment(FramebufferDiffAttachment element) throws TraceParseException {
        assert (this.fullBuffer != null);
        if (!element.getFormat().equals(this.fullBuffer.format) || !element.getType().equals(this.fullBuffer.type)) {
            throw new TraceParseException("Unsupported framebuffer diff. format and type are not the same as original image: (" + element.getFormat() + "/" + element.getType() + ") vs (" + this.fullBuffer.format + "/" + this.fullBuffer.type + ").");
        }
        this.resetImageData();
        this.framebufferDiffs.add(element);
    }

    @Override
    public void removeElementsIf(@NonNull Predicate<FramebufferDiffAttachment> deletionPredicate) {
        this.resetImageData();
        this.framebufferDiffs.removeIf(deletionPredicate);
    }

    public void setFullBuffer(@NonNull FramebufferAttachment framebufferAttachment, boolean treatAsInternalFormat) {
        this.resetImageData();
        if (!this.framebufferDiffs.isEmpty()) {
            this.framebufferDiffs.clear();
        }
        this.fullBuffer = framebufferAttachment;
        this.treatAsInternalFormat = treatAsInternalFormat;
    }

    @Override
    public @NonNull RGBAImageData getImageData() throws IImageProvider.ImageDataUnavailableException, IImageProvider.ImageConversionException {
        IByteDataProvider provider;
        IByteDataProvider iByteDataProvider = provider = this.fullBuffer != null ? this.fullBuffer.getData() : null;
        if (this.fullBuffer == null || provider == null || this.isDataInvalid()) {
            throw new IImageProvider.ImageDataUnavailableException("No data available");
        }
        Dimension size = this.fullBuffer.size;
        byte[] data = provider.cloneData();
        int i = 0;
        while (i < this.framebufferDiffs.size()) {
            FramebufferDiffAttachment framebufferDiffAttachment = this.framebufferDiffs.get(i);
            assert (framebufferDiffAttachment.size.equals(size));
            framebufferDiffAttachment.copyImageDataTo(data);
            ++i;
        }
        IntegerTextureConverter.Result result = IntegerTextureConverter.convertOpenGLESTextureData(NullUtils.asReadOnlyByteBuffer((byte[])data), this.fullBuffer.size, this.fullBuffer.format, this.fullBuffer.type, this.treatAsInternalFormat ? this.internalFormat : null, IntegerTextureConverter.AlphaChannel.INLINE_ALPHA);
        if (result == null) {
            throw new IImageProvider.ImageConversionException("Failed to convert framebuffer capture image composition to RGBA8 for " + this.attachment.getName() + " (" + this.fullBuffer.format.getName() + ", " + this.fullBuffer.type.getName() + ").");
        }
        return new RGBAImageData(new Dimension(result.getWidth(), result.getHeight()), IByteDataProvider.createMemoryProvider(result.getData()), RGBAImageData.CoordinateOrigin.TOP_LEFT);
    }

    @Override
    public @NonNull Dimension getSize() {
        return this.fullBuffer != null ? this.fullBuffer.size : Dimension.ZERO;
    }

    public void setFullBufferInvalid(FunctionCall parentFunctionCall) {
        this.invalidatesFramebufferFunctionCall = parentFunctionCall;
    }

    @Override
    public boolean isDataInvalid() {
        return this.invalidatesFramebufferFunctionCall != null;
    }
}

