/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.texture.ConvertExe;
import com.arm.mgd.core.asset.texture.ImagemagickRunner;
import com.arm.mgd.core.kapi.ResourceLocator;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.OSUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jdt.annotation.NonNull;

public class EtcPackExe {
    private static File etcPackExe;
    private static boolean isAvailable;

    static {
        isAvailable = false;
        try {
            switch (OSUtils.OS) {
                case LINUX: {
                    etcPackExe = ResourceLocator.loadExecutableFromCoreDeps(OSUtils.is64bit() ? "external/tct/linux64/etcpack" : "external/tct/linux32/etcpack");
                    isAvailable = true;
                    break;
                }
                case WINDOWS: {
                    etcPackExe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/win32/etcpack.exe");
                    isAvailable = true;
                    break;
                }
                case MAC: {
                    etcPackExe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/macosx64/etcpack");
                    isAvailable = true;
                    break;
                }
            }
            isAvailable &= ConvertExe.loadResources();
        }
        catch (IOException e) {
            CoreLogging.severe(null, e, "IOException");
        }
        catch (URISyntaxException e) {
            CoreLogging.severe(null, e, "URISyntaxException");
        }
    }

    public boolean isAvailable() {
        return isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPngFileForCompressedTexture(@NonNull File outputPngFile, @NonNull ByteBuffer data, @NonNull Dimension size, @NonNull EtcDescriptor etcDescriptor) throws IOException, InterruptedException {
        File pkmFile = EtcPackExe.makePkm(data, size, etcDescriptor);
        String[] commands = new String[]{etcPackExe.getAbsolutePath(), pkmFile.getAbsolutePath(), FileUtils.getTemporaryDirectory().getAbsolutePath()};
        Object object = ConvertExe.convertExeSync;
        synchronized (object) {
            ImagemagickRunner.run(commands, null, etcPackExe.getParentFile());
            File ppmFile = FileUtils.getFileInTempDir(String.valueOf(FilenameUtils.removeExtension((String)pkmFile.getName())) + ".ppm");
            if (!ppmFile.exists()) {
                throw new IOException("A problem occurred while converting " + pkmFile.getAbsolutePath() + " to " + ppmFile.getAbsolutePath());
            }
            File expectedPngFile = FileUtils.getFileInTempDir(String.valueOf(FilenameUtils.removeExtension((String)pkmFile.getName())) + ".png");
            ConvertExe.convertImage(ppmFile, expectedPngFile, new String[0]);
            if (!expectedPngFile.exists()) {
                throw new IOException("Uncompressed file doesn't exist: " + expectedPngFile);
            }
            FileUtils.deleteFileInBackground(ppmFile);
            expectedPngFile.renameTo(outputPngFile);
            if (!outputPngFile.exists()) {
                throw new IOException("A problem occurred while renaming " + expectedPngFile + " to " + outputPngFile);
            }
        }
        FileUtils.deleteFileInBackground(pkmFile);
    }

    private static @NonNull File makePkm(@NonNull ByteBuffer data, @NonNull Dimension size, @NonNull EtcDescriptor etcDescriptor) throws IOException {
        int extendedWidth = (int)(Math.ceil((float)size.getWidth() / 4.0f) * 4.0);
        int extendedHeight = (int)(Math.ceil((float)size.getHeight() / 4.0f) * 4.0);
        ByteArrayOutputStream headerByteStream = new ByteArrayOutputStream();
        DataOutputStream headerStream = new DataOutputStream(headerByteStream);
        headerStream.write(etcDescriptor.etcMagicString);
        headerStream.writeShort(etcDescriptor.etcPackMagicNumber);
        headerStream.writeShort(extendedWidth);
        headerStream.writeShort(extendedHeight);
        headerStream.writeShort(size.getWidth());
        headerStream.writeShort(size.getHeight());
        assert (headerStream.size() == 16);
        return FileUtils.makeFileFromBuffers("texture", ".pkm", NullUtils.asReadOnlyByteBuffer((byte[])NullUtils.neverNull((byte[])headerByteStream.toByteArray())), data);
    }

    static enum EtcDescriptor {
        ETC1_RGB_NO_MIPMAPS(0, new byte[]{80, 75, 77, 32, 49, 48}),
        ETC2PACKAGE_RGB_NO_MIPMAPS(1, new byte[]{80, 75, 77, 32, 50, 48}),
        ETC2PACKAGE_RGBA_NO_MIPMAPS(3, new byte[]{80, 75, 77, 32, 50, 48});

        final int etcPackMagicNumber;
        final byte[] etcMagicString;

        private EtcDescriptor(int etcPackMagicNumber, byte[] etcMagicString) {
            this.etcPackMagicNumber = etcPackMagicNumber;
            this.etcMagicString = etcMagicString;
        }
    }
}

