/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.GlImageOffset;
import com.arm.mgd.core.asset.texture.GlTextureLayer;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.ImagemagickRunner;
import com.arm.mgd.core.kapi.ResourceLocator;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.OSUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ConvertExe {
    static Object convertExeSync = new Object();
    private static File convertExe;
    private static boolean isAvailable;

    static {
        isAvailable = false;
        try {
            isAvailable = ConvertExe.loadResources();
        }
        catch (IOException | URISyntaxException e) {
            CoreLogging.severe(e);
        }
    }

    static boolean loadResources() throws IOException, URISyntaxException {
        switch (OSUtils.OS) {
            case LINUX: {
                if (OSUtils.is64bit()) {
                    convertExe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/linux64/convert");
                    ResourceLocator.loadExecutableFromCoreDeps("external/tct/linux64/composite");
                    ResourceLocator.loadResourceFromCoreDeps("external/tct/linux64/colors.xml");
                    ResourceLocator.loadResourceFromCoreDeps("external/tct/linux64/delegates.xml");
                    ResourceLocator.loadResourceFromCoreDeps("external/tct/linux64/magic.xml");
                } else {
                    convertExe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/linux32/convert");
                    ResourceLocator.loadExecutableFromCoreDeps("external/tct/linux32/composite");
                    ResourceLocator.loadResourceFromCoreDeps("external/tct/linux32/colors.xml");
                    ResourceLocator.loadResourceFromCoreDeps("external/tct/linux32/delegates.xml");
                    ResourceLocator.loadResourceFromCoreDeps("external/tct/linux32/magic.xml");
                }
                return true;
            }
            case WINDOWS: {
                convertExe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/win32/convert.exe");
                ResourceLocator.loadExecutableFromCoreDeps("external/tct/win32/composite.exe");
                ResourceLocator.loadResourceFromCoreDeps("external/tct/win32/colors.xml");
                ResourceLocator.loadResourceFromCoreDeps("external/tct/win32/delegates.xml");
                ResourceLocator.loadResourceFromCoreDeps("external/tct/win32/vcomp100.dll");
                return true;
            }
            case MAC: {
                convertExe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/macosx64/convert");
                ResourceLocator.loadExecutableFromCoreDeps("external/tct/macosx64/composite");
                ResourceLocator.loadResourceFromCoreDeps("external/tct/macosx64/coder.xml");
                ResourceLocator.loadResourceFromCoreDeps("external/tct/macosx64/colors.xml");
                ResourceLocator.loadResourceFromCoreDeps("external/tct/macosx64/delegates.xml");
                ResourceLocator.loadResourceFromCoreDeps("external/tct/macosx64/magic.xml");
                return true;
            }
        }
        return false;
    }

    public boolean isAvailable() {
        return isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertImage(File inputFile, File outputFile, String ... additionalOptions) throws IOException {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(convertExe.getAbsolutePath());
        commandList.addAll(Arrays.asList(additionalOptions));
        commandList.add(inputFile.getAbsolutePath());
        commandList.add(outputFile.getAbsolutePath());
        Object object = convertExeSync;
        synchronized (object) {
            try {
                ImagemagickRunner.run(commandList.toArray(new String[commandList.size()]), null, convertExe.getParentFile());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    public static void convertTgaToPng(File tgaFile, File pngFile) throws IOException {
        assert (tgaFile.getName().endsWith(".tga"));
        assert (pngFile.getName().endsWith(".png"));
        ConvertExe.convertImage(tgaFile, pngFile, new String[0]);
    }

    public static void convertTgaToRgba(File tgaFile, File rgbaFile) throws IOException {
        assert (tgaFile.getName().endsWith(".tga"));
        assert (rgbaFile.getName().endsWith(".rgba"));
        ConvertExe.convertImage(tgaFile, rgbaFile, new String[0]);
    }

    public static @NonNull File convertPngToRawRGBA(@NonNull File pngFile) throws IOException {
        assert (pngFile.getName().endsWith(".png"));
        File tmpRgbaFile = FileUtils.createTempFile("ConvertExe_PngToRGBA_", ".rgba");
        ConvertExe.convertImage(pngFile, tmpRgbaFile, new String[0]);
        return tmpRgbaFile;
    }

    public static void convertRawRGBAtoPng(File rgbaFile, int width, int height, boolean isFlipped, int bitdepth, File pngFile) throws IOException {
        assert (pngFile.getName().endsWith(".png"));
        assert (rgbaFile.getName().endsWith(".rgba"));
        ArrayList<@NonNull String> options = new ArrayList<String>();
        options.add("-size");
        options.add(String.valueOf(NullUtils.stringValueOf((long)width)) + "x" + NullUtils.stringValueOf((long)height));
        options.add("-depth");
        options.add(NullUtils.stringValueOf((long)bitdepth));
        if (isFlipped) {
            options.add("-flip");
        }
        ConvertExe.convertImage(rgbaFile, pngFile, options.toArray(new String[options.size()]));
    }

    void getPngFileForUncompressedTexture(@NonNull File outputPngFile, @NonNull GlTextureLayer imageLayer, @NonNull RawImageDescriptor rawImageDescriptor) throws IOException, InterruptedException {
        IByteDataProvider data = imageLayer.getData();
        if (data == null) {
            return;
        }
        Dimension size = imageLayer.getSize();
        this.getPngFileForUncompressedTexture(outputPngFile, rawImageDescriptor, data.getData(), size.getWidth(), size.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getPngFileForUncompressedTexture(@NonNull File outputPngFile, @NonNull RawImageDescriptor rawImageDescriptor, @NonNull ByteBuffer data, int imgWidth, int imgHeight) throws IOException, InterruptedException {
        File rawFile = ConvertExe.makeRaw(rawImageDescriptor, data, imgWidth, imgHeight);
        File tmpPngFile = FileUtils.createTempFile("ConvertExe_Uncompressed_", ".png");
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(convertExe.getAbsolutePath());
        commandList.add("-size");
        commandList.add(imgWidth + "x" + imgHeight);
        commandList.add("-depth");
        commandList.add("" + rawImageDescriptor.depth);
        commandList.add(String.valueOf(rawImageDescriptor.format) + ":" + rawFile.getAbsolutePath());
        String[] stringArray = rawImageDescriptor.extraCommands;
        int n = rawImageDescriptor.extraCommands.length;
        int n2 = 0;
        while (n2 < n) {
            String extraCommand = stringArray[n2];
            commandList.add(extraCommand);
            ++n2;
        }
        commandList.add(tmpPngFile.getAbsolutePath());
        String[] commands = commandList.toArray(new String[0]);
        Object object = convertExeSync;
        synchronized (object) {
            ImagemagickRunner.run(commands, null, convertExe.getParentFile());
            try {
                Files.move(tmpPngFile.toPath(), outputPngFile.toPath(), new CopyOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!outputPngFile.exists()) {
                throw new IOException("A problem occurred while renaming " + tmpPngFile + " to " + outputPngFile + ".\nThe original file was: " + rawFile);
            }
        }
        FileUtils.deleteFileInBackground(rawFile);
    }

    private static File makeRaw(@NonNull RawImageDescriptor rawImageDescriptor, @NonNull ByteBuffer data, int imgWidth, int imgHeight) throws IOException {
        assert (data.remaining() * 8 == rawImageDescriptor.depth * rawImageDescriptor.channels * imgWidth * imgHeight);
        return FileUtils.makeFileFromBuffers("texture", ".raw", data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull File combineImages(@NonNull List<@NonNull GlTextureLayer> imagelayers) throws IImageProvider.ImageDataUnavailableException, IOException, GlTextureLayer.UnsupportedGlTextureFormatException {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(convertExe.getAbsolutePath());
        boolean imageFound = false;
        File tmpOutput = FileUtils.createTempFile("ConvertExe_CombinedImage_", ".png");
        IImageProvider.ImageDataUnavailableException caughtUnavailableException = null;
        for (GlTextureLayer layer : imagelayers) {
            try {
                File pngFile = layer.getPngFile();
                GlImageOffset offset = layer.getOffset();
                commandList.add("-page");
                commandList.add("+" + offset.x + "+" + offset.y);
                commandList.add(pngFile.getAbsolutePath());
                imageFound = true;
            }
            catch (IImageProvider.ImageDataUnavailableException e) {
                if (caughtUnavailableException != null) continue;
                caughtUnavailableException = e;
            }
        }
        if (!imageFound) {
            if (caughtUnavailableException != null) {
                throw caughtUnavailableException;
            }
            throw new IImageProvider.ImageDataUnavailableException("No image data available.");
        }
        commandList.add("-background");
        commandList.add("none");
        commandList.add("-layers");
        commandList.add("merge");
        commandList.add(tmpOutput.getAbsolutePath());
        String[] commands = commandList.toArray(new String[commandList.size()]);
        Object object = convertExeSync;
        synchronized (object) {
            try {
                ImagemagickRunner.run(commands, null, convertExe.getParentFile());
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
        return tmpOutput;
    }

    static enum RawImageDescriptor {
        GRAYSCALE(8, 1, "gray"),
        RGBA8888(8, 4, "rgba"),
        BGRA8888(8, 4, "rgba", new String[]{"-channel", "RGBA", "-separate", "-swap", "0,2", "-combine"}),
        RGBA4444(4, 4, "rgba"),
        RGB888(8, 3, "rgb");

        final int depth;
        final int channels;
        final String format;
        final String[] extraCommands;

        private RawImageDescriptor(int depth, int channels, String format) {
            this(depth, channels, format, new String[0]);
        }

        private RawImageDescriptor(int depth, int channels, String format, String[] extraCommands) {
            this.depth = depth;
            this.channels = channels;
            this.format = format;
            this.extraCommands = extraCommands;
        }
    }
}

