/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.texture.ASTCHeader;
import com.arm.mgd.core.asset.texture.ASTCValidator;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CompressedTextureValidator {
    private static final @NonNull String ASTC_DATA_INVALID_LENGTH_ERROR = "ASTC data length was not as expected for given dimensions and block size.";
    private static final @NonNull String ASTC_DATA_INVALID_LENGTH_ERROR_DESCRIPTION = "This could mean the 16 byte header has been included as part of the ASTC data, or an incorrect ASTC format has been used for the data.";
    private static final @NonNull String ASTC_DATA_HEADER_DETECTED_ERROR = "ASTC data was the correct length, but an ASTC header was detected at the start.";
    private static final @NonNull String ASTC_DATA_POSSIBLE_HEADER_DETECTED_ERROR = "ASTC data was the correct length, but a possible ASTC header was detected at the start.";
    private static final @NonNull String ASTC_DATA_HEADER_DETECTED_DESCRIPTION = "The 16 byte header should not be included when uploading texture data.";

    public static boolean validateCompressedTextureData(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, int width, int height, int depth, @NonNull AbstractConstantOrAliasSpecExtended internalFormat, @Nullable TextureArgAttachment attachment) {
        IByteDataProvider data;
        IByteDataProvider iByteDataProvider = data = attachment != null ? attachment.getData() : null;
        if (data == null) {
            return false;
        }
        if (ASTCHeader.ASTC_BLOCK_SIZE_LOOKUP.containsKey(internalFormat)) {
            ASTCValidator.ASTCValidity validity = ASTCValidator.isASTCDataValid(width, height, depth, internalFormat, data.getData());
            switch (validity) {
                case INVALID_LENGTH: {
                    TraceAnalysisLogger.warning(currentState, functionCall, ASTC_DATA_INVALID_LENGTH_ERROR, ASTC_DATA_INVALID_LENGTH_ERROR_DESCRIPTION);
                    return false;
                }
                case CORRECT_LENGTH_BUT_DEFINITE_HEADER_DETECTED: {
                    TraceAnalysisLogger.warning(currentState, functionCall, ASTC_DATA_HEADER_DETECTED_ERROR, ASTC_DATA_HEADER_DETECTED_DESCRIPTION);
                    return true;
                }
                case CORRECT_LENGTH_BUT_POSSIBLE_HEADER_DETECTED: {
                    TraceAnalysisLogger.warning(currentState, functionCall, ASTC_DATA_POSSIBLE_HEADER_DETECTED_ERROR, ASTC_DATA_HEADER_DETECTED_DESCRIPTION);
                    return true;
                }
                case VALID: {
                    return true;
                }
            }
            throw new AssertionError((Object)validity);
        }
        return true;
    }
}

