/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.texture.ASTCHeader;
import com.arm.mgd.core.asset.texture.ConvertExe;
import com.arm.mgd.core.kapi.ResourceLocator;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Dimension3D;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.core.util.ProcessRunner;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.OSUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AstcExe {
    private static File exe;
    private static boolean isAvailable;

    static {
        isAvailable = false;
        try {
            switch (OSUtils.OS) {
                case LINUX: {
                    exe = OSUtils.is64bit() ? ResourceLocator.loadExecutableFromCoreDeps("external/tct/linux64/astcenc") : ResourceLocator.loadExecutableFromCoreDeps("external/tct/linux32/astcenc");
                    isAvailable = true;
                    break;
                }
                case WINDOWS: {
                    exe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/win32/astcenc.exe");
                    isAvailable = true;
                    break;
                }
                case MAC: {
                    exe = ResourceLocator.loadExecutableFromCoreDeps("external/tct/macosx64/astcenc");
                    isAvailable = true;
                    break;
                }
            }
            isAvailable &= ConvertExe.loadResources();
        }
        catch (IOException | URISyntaxException e) {
            CoreLogging.severe(e);
        }
    }

    public boolean isAvailable() {
        return isAvailable;
    }

    public void getPngFileForCompressedTexture(@NonNull ASTCHeader header, @NonNull File outputPngFile, @NonNull ByteBuffer compressedData) throws IOException {
        File tmpTgaFile = AstcExe.getTgaFileFromAstcCompressedTexture(header, compressedData);
        try {
            ConvertExe.convertTgaToPng(tmpTgaFile, outputPngFile);
        }
        finally {
            FileUtils.deleteFileInBackground(tmpTgaFile);
        }
    }

    public static byte @NonNull [] getUncompressedData(@NonNull ASTCHeader header, @NonNull ByteBuffer compressedData) throws IOException {
        File tmpTgaFile = AstcExe.getTgaFileFromAstcCompressedTexture(header, compressedData);
        File tmpRGBAFile = FileUtils.createTempFile("image_", ".rgba");
        byte[] uncompressedData = null;
        try {
            ConvertExe.convertTgaToRgba(tmpTgaFile, tmpRGBAFile);
            uncompressedData = Files.readAllBytes(tmpRGBAFile.toPath());
            assert (uncompressedData != null);
        }
        finally {
            FileUtils.deleteFileInBackground(tmpTgaFile);
            FileUtils.deleteFileInBackground(tmpRGBAFile);
        }
        return uncompressedData;
    }

    private static @Nullable File getTgaFileFromAstcCompressedTexture(@NonNull ASTCHeader header, @NonNull ByteBuffer compressedData) throws IOException {
        byte[] fileHeader = header.generateHeader();
        if (fileHeader == null) {
            return null;
        }
        File tmpCompressedFile = FileUtils.makeFileFromBuffers("compressed_image_", ".astc", NullUtils.asReadOnlyByteBuffer((byte[])fileHeader), compressedData);
        File outputFile = FileUtils.createTempFile("image_", ".tga");
        try {
            String[] commands = new String[]{exe.getAbsolutePath(), "-d", tmpCompressedFile.getAbsolutePath(), outputFile.getAbsolutePath()};
            ProcessRunner processRunner = new ProcessRunner(commands, null, exe.getParentFile());
            if (processRunner.getExitCode() != 0) {
                return null;
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            FileUtils.deleteFileInBackground(tmpCompressedFile);
        }
        return outputFile;
    }

    public static byte @NonNull [] getCompressedDataWithoutRowPitch(byte @NonNull [] compressedData, @NonNull Dimension3D blockSize, @NonNull Dimension3D imageSize, int rowPitch) {
        assert (rowPitch > 0);
        int numOfBlocksPerRow = (imageSize.x + blockSize.x - 1) / blockSize.x;
        int numOfBlocksPerCol = (imageSize.y + blockSize.y - 1) / blockSize.y;
        int astcBlockSizeInBytes = 16;
        int rowInBytes = 16 * numOfBlocksPerRow;
        byte[] outputData = new byte[16 * numOfBlocksPerRow * numOfBlocksPerCol];
        int y = 0;
        int dy = 0;
        while (dy < outputData.length) {
            System.arraycopy(compressedData, y, outputData, dy, rowInBytes);
            y += rowPitch;
            dy += rowInBytes;
        }
        return outputData;
    }
}

