/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.asset.texture.ASTCHeader;
import com.arm.mgd.core.util.Dimension3D;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class ASTCValidator {
    public static ASTCValidity isASTCDataValid(int width, int height, int depth, @NonNull AbstractConstantOrAliasSpecExtended internalFormat, @NonNull ByteBuffer astcData) {
        assert (ASTCHeader.ASTC_BLOCK_SIZE_LOOKUP.containsKey(internalFormat));
        Dimension3D blockSizes = ASTCHeader.ASTC_BLOCK_SIZE_LOOKUP.get(internalFormat);
        assert (blockSizes != null);
        Dimension3D imageSize = new Dimension3D(width, height, depth);
        int xBlocks = (imageSize.x + blockSizes.x - 1) / blockSizes.x;
        int yBlocks = (imageSize.y + blockSizes.y - 1) / blockSizes.y;
        int zBlocks = (imageSize.z + blockSizes.z - 1) / blockSizes.z;
        int expectedSize = xBlocks * yBlocks * zBlocks * 16;
        if (astcData.remaining() != expectedSize) {
            return ASTCValidity.INVALID_LENGTH;
        }
        ASTCHeader header = new ASTCHeader(astcData);
        if (header.isMagicValid()) {
            if (header.isBlockSizeValid() && header.isImageSizeValid() && blockSizes.equals(header.getBlockSize()) && imageSize.equals(header.getImageSize())) {
                return ASTCValidity.CORRECT_LENGTH_BUT_DEFINITE_HEADER_DETECTED;
            }
            return ASTCValidity.CORRECT_LENGTH_BUT_POSSIBLE_HEADER_DETECTED;
        }
        return ASTCValidity.VALID;
    }

    public static enum ASTCValidity {
        VALID,
        CORRECT_LENGTH_BUT_DEFINITE_HEADER_DETECTED,
        CORRECT_LENGTH_BUT_POSSIBLE_HEADER_DETECTED,
        INVALID_LENGTH;

    }
}

