/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.texture;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.Dimension3D;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ASTCHeader {
    public static final Map<AbstractConstantOrAliasSpecExtended, Dimension3D> ASTC_BLOCK_SIZE_LOOKUP = new HashMap<AbstractConstantOrAliasSpecExtended, Dimension3D>(){
        {
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_4X4, new Dimension3D(4, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_5X4, new Dimension3D(5, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_5X5, new Dimension3D(5, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_6X5, new Dimension3D(6, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_6X6, new Dimension3D(6, 6));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_8X5, new Dimension3D(8, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_8X6, new Dimension3D(8, 6));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_8X8, new Dimension3D(8, 8));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_10X5, new Dimension3D(10, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_10X6, new Dimension3D(10, 6));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_10X8, new Dimension3D(10, 8));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_10X10, new Dimension3D(10, 10));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_12X10, new Dimension3D(12, 10));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_12X12, new Dimension3D(12, 12));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4X4, new Dimension3D(4, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5X4, new Dimension3D(5, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5X5, new Dimension3D(5, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6X5, new Dimension3D(6, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6X6, new Dimension3D(6, 6));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8X5, new Dimension3D(8, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8X6, new Dimension3D(8, 6));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8X8, new Dimension3D(8, 8));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10X5, new Dimension3D(10, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10X6, new Dimension3D(10, 6));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10X8, new Dimension3D(10, 8));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10X10, new Dimension3D(10, 10));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12X10, new Dimension3D(12, 10));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12X12, new Dimension3D(12, 12));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_3X3X3_OES, new Dimension3D(3, 3, 3));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_4X3X3_OES, new Dimension3D(4, 3, 3));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_4X4X3_OES, new Dimension3D(4, 4, 3));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_4X4X4_OES, new Dimension3D(4, 4, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_5X4X4_OES, new Dimension3D(5, 4, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_5X5X4_OES, new Dimension3D(5, 5, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_5X5X5_OES, new Dimension3D(5, 5, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_6X5X5_OES, new Dimension3D(6, 5, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_6X6X5_OES, new Dimension3D(6, 6, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_RGBA_ASTC_6X6X6_OES, new Dimension3D(6, 6, 6));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3X3X3_OES, new Dimension3D(3, 3, 3));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4X3X3_OES, new Dimension3D(4, 3, 3));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4X4X3_OES, new Dimension3D(4, 4, 3));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4X4X4_OES, new Dimension3D(4, 4, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5X4X4_OES, new Dimension3D(5, 4, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5X5X4_OES, new Dimension3D(5, 5, 4));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5X5X5_OES, new Dimension3D(5, 5, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6X5X5_OES, new Dimension3D(6, 5, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6X6X5_OES, new Dimension3D(6, 6, 5));
            this.put(KapiSpec.GLES.constants.GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6X6X6_OES, new Dimension3D(6, 6, 6));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_4X4_UNORM_BLOCK, new Dimension3D(4, 4));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_4X4_SRGB_BLOCK, new Dimension3D(4, 4));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_5X4_UNORM_BLOCK, new Dimension3D(5, 4));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_5X4_SRGB_BLOCK, new Dimension3D(5, 4));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_5X5_UNORM_BLOCK, new Dimension3D(5, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_5X5_SRGB_BLOCK, new Dimension3D(5, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_6X5_UNORM_BLOCK, new Dimension3D(6, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_6X5_SRGB_BLOCK, new Dimension3D(6, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_6X6_UNORM_BLOCK, new Dimension3D(6, 6));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_6X6_SRGB_BLOCK, new Dimension3D(6, 6));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_8X5_UNORM_BLOCK, new Dimension3D(8, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_8X5_SRGB_BLOCK, new Dimension3D(8, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_8X6_UNORM_BLOCK, new Dimension3D(8, 6));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_8X6_SRGB_BLOCK, new Dimension3D(8, 6));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_8X8_UNORM_BLOCK, new Dimension3D(8, 8));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_8X8_SRGB_BLOCK, new Dimension3D(8, 8));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X5_UNORM_BLOCK, new Dimension3D(10, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X5_SRGB_BLOCK, new Dimension3D(10, 5));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X6_UNORM_BLOCK, new Dimension3D(10, 6));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X6_SRGB_BLOCK, new Dimension3D(10, 6));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X8_UNORM_BLOCK, new Dimension3D(10, 8));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X8_SRGB_BLOCK, new Dimension3D(10, 8));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X10_UNORM_BLOCK, new Dimension3D(10, 10));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_10X10_SRGB_BLOCK, new Dimension3D(10, 10));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_12X10_UNORM_BLOCK, new Dimension3D(12, 10));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_12X10_SRGB_BLOCK, new Dimension3D(12, 10));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_12X12_UNORM_BLOCK, new Dimension3D(12, 12));
            this.put(KapiSpec.VULKAN.constants.VK_FORMAT_ASTC_12X12_SRGB_BLOCK, new Dimension3D(12, 12));
        }
    };
    public static final byte[] ASTC_MAGIC = new byte[]{19, -85, -95, 92};
    private final Dimension3D blockSize;
    private final Dimension3D imageSize;
    private final boolean magicValid;

    private static Dimension3D validBlockSize(Dimension3D blockSize) {
        if (blockSize != null && ASTC_BLOCK_SIZE_LOOKUP.containsValue(blockSize)) {
            return blockSize;
        }
        return null;
    }

    private static Dimension3D validImageSize(Dimension3D imageSize) {
        if (imageSize != null && imageSize.x > 0 && imageSize.x < 0x1000000 && imageSize.y > 0 && imageSize.y < 0x1000000 && imageSize.z > 0 && imageSize.z < 0x1000000) {
            return imageSize;
        }
        return null;
    }

    public ASTCHeader(@NonNull ByteBuffer data) {
        if (data.remaining() >= 16 && data.get() == ASTC_MAGIC[0] && data.get() == ASTC_MAGIC[1] && data.get() == ASTC_MAGIC[2] && data.get() == ASTC_MAGIC[3]) {
            this.blockSize = ASTCHeader.validBlockSize(new Dimension3D(data.get() & 0xFF, data.get() & 0xFF, data.get() & 0xFF));
            int xSize = (data.get() & 0xFF) + (data.get() & 0xFF) * 256 + (data.get() & 0xFF) * 65536;
            int ySize = (data.get() & 0xFF) + (data.get() & 0xFF) * 256 + (data.get() & 0xFF) * 65536;
            int zSize = (data.get() & 0xFF) + (data.get() & 0xFF) * 256 + (data.get() & 0xFF) * 65536;
            this.magicValid = true;
            this.imageSize = ASTCHeader.validImageSize(new Dimension3D(xSize, ySize, zSize));
        } else {
            this.magicValid = false;
            this.blockSize = null;
            this.imageSize = null;
        }
    }

    public ASTCHeader(@Nullable AbstractConstantOrAliasSpecExtended format, @Nullable Dimension3D imageSize) {
        this(ASTC_BLOCK_SIZE_LOOKUP.get(format), imageSize);
    }

    public ASTCHeader(@Nullable Dimension3D blockSize, @Nullable Dimension3D imageSize) {
        this.magicValid = true;
        this.blockSize = ASTCHeader.validBlockSize(blockSize);
        this.imageSize = ASTCHeader.validImageSize(imageSize);
    }

    public byte @Nullable [] generateHeader() {
        if (this.isBlockSizeValid() && this.isImageSizeValid()) {
            byte[] result = new byte[]{ASTC_MAGIC[0], ASTC_MAGIC[1], ASTC_MAGIC[2], ASTC_MAGIC[3], (byte)this.blockSize.x, (byte)this.blockSize.y, (byte)this.blockSize.z, (byte)(this.imageSize.x & 0xFF), (byte)(this.imageSize.x >>> 8 & 0xFF), (byte)(this.imageSize.x >>> 16 & 0xFF), (byte)(this.imageSize.y & 0xFF), (byte)(this.imageSize.y >>> 8 & 0xFF), (byte)(this.imageSize.y >>> 16 & 0xFF), (byte)(this.imageSize.z & 0xFF), (byte)(this.imageSize.z >>> 8 & 0xFF), (byte)(this.imageSize.z >>> 16 & 0xFF)};
            return result;
        }
        return null;
    }

    public @Nullable Dimension3D getBlockSize() {
        return this.blockSize;
    }

    public @Nullable Dimension3D getImageSize() {
        return this.imageSize;
    }

    public boolean isBlockSizeValid() {
        return this.blockSize != null;
    }

    public boolean isImageSizeValid() {
        return this.imageSize != null;
    }

    public boolean isMagicValid() {
        return this.magicValid;
    }
}

