/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.properties;

import com.arm.mgd.core.asset.properties.IAssetProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ValueAssetProperty
implements IAssetProperty {
    private static final @NonNull Map<@NonNull String, IAssetProperty> cachedProperties = new HashMap<String, IAssetProperty>();
    private static final @NonNull ArrayList<@NonNull ValueAssetProperty> negativeProperties = new ArrayList();
    private final @NonNull String value;
    public static final @NonNull ValueAssetProperty NULL = ValueAssetProperty.cache("NULL", false);
    public static final @NonNull ValueAssetProperty NONE = ValueAssetProperty.cache("None", false);
    public static final @NonNull ValueAssetProperty ZERO = ValueAssetProperty.cache("0", false);
    private static final @NonNull ValueAssetProperty TRUE = ValueAssetProperty.cache("True", true);
    private static final @NonNull ValueAssetProperty FALSE = ValueAssetProperty.cache("False", false);

    static {
        ValueAssetProperty.cache("GL_TRUE", true);
        ValueAssetProperty.cache("GL_FALSE", false);
        ValueAssetProperty.cache("GL_NONE", false);
        ValueAssetProperty.cache("EGL_TRUE", true);
        ValueAssetProperty.cache("EGL_FALSE", false);
        ValueAssetProperty.cache("EGL_NONE", false);
        ValueAssetProperty.cache("CL_TRUE", true);
        ValueAssetProperty.cache("CL_FALSE", false);
        ValueAssetProperty.cache("CL_NONE", false);
        ValueAssetProperty.cache("VK_TRUE", true);
        ValueAssetProperty.cache("VK_FALSE", false);
    }

    ValueAssetProperty(@NonNull String value) {
        this.value = value;
    }

    private static @NonNull ValueAssetProperty cache(@NonNull String newValue, boolean asBoolean) {
        ValueAssetProperty property = new ValueAssetProperty(newValue);
        cachedProperties.put(newValue, property);
        if (!asBoolean) {
            negativeProperties.add(property);
        }
        return property;
    }

    @Override
    public @NonNull String getSimpleValue() {
        return this.value;
    }

    public static @NonNull IAssetProperty create(@NonNull String value) {
        assert (!value.isEmpty());
        IAssetProperty cached = cachedProperties.get(value);
        if (cached != null) {
            return cached;
        }
        return new ValueAssetProperty(value);
    }

    public static @NonNull IAssetProperty fromBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public boolean isFalsy() {
        return negativeProperties.contains(this);
    }
}

