/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.properties;

import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.IAssetPropertyProvider;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.utils.NullUtils;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;

public class ListAssetProperty
implements IAssetPropertyProvider {
    private final @NonNull AssetPropertyContainer properties = new AssetPropertyContainer();

    public ListAssetProperty(@NonNull Collection<? extends IAssetProperty> children) {
        int i = 0;
        for (IAssetProperty iAssetProperty : children) {
            if (iAssetProperty == null) continue;
            this.properties.put(NullUtils.stringValueOf((long)i), iAssetProperty);
            ++i;
        }
    }

    @Override
    public @NonNull String getSimpleValue() {
        return String.valueOf(this.properties.size()) + " " + StringUtils.formatQuantity(this.properties.size(), "item", "items");
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        return this.properties;
    }

    @Override
    public boolean hasProperties() {
        return this.properties.size() != 0;
    }
}

