/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.properties;

import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.IAssetPropertyProvider;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.utils.NullUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetPropertyContainer
implements IAssetPropertyProvider {
    public static final @NonNull AssetPropertyContainer EMPTY_CONTAINER = new AssetPropertyContainer(){

        @Override
        public void put(@NonNull String key, @NonNull IAssetProperty value) {
            throw new AssertionError((Object)"Attempted to put key-value pair into AssetPropertyContainer.EMPTY_CONTAINER");
        }
    };
    private final LinkedHashMap<@NonNull String, @Nullable IAssetProperty> properties = new LinkedHashMap();

    public void put(@NonNull String key, @NonNull IAssetProperty value) {
        assert (!key.isEmpty());
        this.properties.put(key, value);
    }

    @Override
    public @NonNull String getSimpleValue() {
        return String.valueOf(this.properties.size()) + " " + StringUtils.formatQuantity(this.properties.size(), "property", "properties");
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        return this;
    }

    @Override
    public boolean hasProperties() {
        return this.properties.size() != 0;
    }

    public int size() {
        return this.properties.size();
    }

    public @Nullable IAssetProperty get(@NonNull String key) {
        return this.properties.get(key);
    }

    public boolean containsKey(@NonNull String key) {
        return this.properties.containsKey(key);
    }

    public @NonNull Set<@NonNull String> keySet() {
        return (Set)NullUtils.neverNull(Collections.unmodifiableSet(this.properties.keySet()));
    }

    public @NonNull Set<Map.Entry<@NonNull String, @NonNull IAssetProperty>> entrySet() {
        return (Set)NullUtils.neverNull(Collections.unmodifiableSet(this.properties.entrySet()));
    }
}

