/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.programvariable;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.programvariable.GlProgramVariableContainer;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.target.data.ProgramResourceDescriptorMap;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.core.util.UnsupportedTypeException;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class ShaderUniformContainer
extends GlProgramVariableContainer<ShaderUniform> {
    private static final long serialVersionUID = -936952002248983848L;
    private final @NonNull GlProgramAsset parentAsset;

    public ShaderUniformContainer(@NonNull GlProgramAsset parentAsset) {
        super(ShaderUniform.class);
        this.parentAsset = parentAsset;
    }

    public void resetContents(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall createdByFunction, @NonNull ProgramResourceDescriptorMap programResourceDescriptor) {
        Map<Long, ProgramResourceDescriptor> uniformsMap = programResourceDescriptor.getResourcesMap(KapiSpec.GLES.constants.GL_UNIFORM);
        Map<Long, ProgramResourceDescriptor> uniformBlocksMap = programResourceDescriptor.getResourcesMap(KapiSpec.GLES.constants.GL_UNIFORM_BLOCK);
        this.clear();
        for (ProgramResourceDescriptor uniform : uniformsMap.values()) {
            ProgramResourceDescriptor block = uniformBlocksMap.get(uniform.resolveBlockIndex());
            try {
                ShaderUniform uniformAsset = new ShaderUniform(createdByFunction, this.parentAsset, uniform, block);
                this.addVariable(uniformAsset);
            }
            catch (UnsupportedTypeException e) {
                TraceAnalysisLogger.error(currentState, createdByFunction, e, "Unable to process program uniform");
            }
        }
    }
}

