/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.programvariable;

import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractShaderUniform;
import com.arm.mgd.core.asset.programvariable.GlProgramVariableOffset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.core.util.NumberValueConverter;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.BasicTypeSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ShaderUniform
extends AbstractShaderUniform {
    private static final long serialVersionUID = 6203565972464081070L;
    private final NumberValueConverter<?> valueConverter;

    private static Number[] getElementBytes(byte @NonNull [] data, @NonNull BasicTypeSpec cType) throws UnsupportedTypeException {
        if (cType.equals(KapiSpec.GLES.basicTypes.GLFLOAT)) {
            return NumberUtils.getFloatObjectsFromBytes(data);
        }
        if (cType.equals(KapiSpec.GLES.basicTypes.GLHALF)) {
            return NumberUtils.getHalfFloatObjectsFromBytes(data);
        }
        if (cType.equals(KapiSpec.GLES.basicTypes.GLINT)) {
            return NumberUtils.getIntegerObjectsForIntegersFromBytes(data);
        }
        if (cType.equals(KapiSpec.GLES.basicTypes.GLUINT)) {
            return NumberUtils.getLongObjectsForUnsignedIntsFromBytes(data);
        }
        if (cType.equals(KapiSpec.GLES.basicTypes.GLBOOLEAN)) {
            return NumberUtils.getByteObjectsForBytesFromBytes(data);
        }
        throw new UnsupportedTypeException("Uniform type '" + cType.getCtype() + "' unsupported.");
    }

    public ShaderUniform(@NonNull FunctionCall createdByFunction, @NonNull GlProgramAsset parentAsset, @NonNull ProgramResourceDescriptor uniform, ProgramResourceDescriptor block) throws UnsupportedTypeException {
        super(createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, uniform, block, parentAsset);
        AbstractConstantOrAliasSpecExtended type = this.getType();
        if (type.getCtype() == null) {
            throw new UnsupportedTypeException("Uniform type '" + type + "' unsupported.");
        }
        this.valueConverter = type.getCtype().getValueConverter();
        if (this.valueConverter == null) {
            throw new UnsupportedTypeException("Uniform type '" + type + "' unsupported.");
        }
        this.clearValue(createdByFunction);
    }

    public static @NonNull ShaderUniform createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlProgramAsset parentAsset) {
        ShaderUniform result = (ShaderUniform)parentAsset.getUniformsContainer().getByIndex(assetAttachment.getId());
        if (result != null) {
            assert (result.getBlockResourceDescriptor() == null);
            return result;
        }
        throw new AssertionError((Object)("Unexpected missing ShaderUniform asset: " + assetAttachment.getId()));
    }

    public void clearValue(@NonNull FunctionCall functionCall) {
        this.setPreviousModificationFunction(functionCall);
        AbstractConstantOrAliasSpecExtended type = this.getType();
        int arrayLength = Math.max(1, this.getArrayLength());
        int index = 0;
        while (index < arrayLength) {
            this.setValue(index, type.createZeroNumberArray(1));
            ++index;
        }
    }

    @Override
    public String getLabelText() {
        return this.getName();
    }

    public @NonNull String getValuesString() {
        int mElementCount;
        int mLoopCount;
        boolean isMatrix;
        StringBuilder result = new StringBuilder();
        boolean isArray = this.isArrayVariable();
        AbstractConstantOrAliasSpecExtended type = this.getType();
        int mColumns = type.getNumberOfColumnsAsInt();
        int mRows = type.getNumberOfRowsAsInt();
        boolean rowMajor = this.getResourceDescriptor().resolveIsRowMajor();
        boolean bl = isMatrix = mColumns > 1 && mRows > 1;
        int n = isMatrix ? (rowMajor ? mColumns : mRows) : (mLoopCount = 1);
        int n2 = isMatrix ? (rowMajor ? mRows : mColumns) : (mElementCount = Math.max(mRows, mColumns));
        if (isArray) {
            result.append("[");
        }
        int arrayLength = Math.max(1, this.getArrayLength());
        int i = 0;
        while (i < arrayLength) {
            Number[] value = this.getValue(i);
            if (isMatrix) {
                result.append("[");
            }
            int r = 0;
            while (r < mLoopCount) {
                if (r > 0) {
                    result.append(",\n ");
                    if (isArray) {
                        result.append(" ");
                    }
                }
                result.append("[");
                int c = 0;
                while (c < mElementCount) {
                    int pos;
                    int n3 = pos = isMatrix ? c * mLoopCount + r : c;
                    if (c > 0) {
                        result.append(", ");
                    }
                    result.append(value[pos]);
                    ++c;
                }
                result.append("]");
                ++r;
            }
            if (isMatrix) {
                result.append("]");
            }
            if (isArray) {
                if (i + 1 < arrayLength) {
                    result.append(",\n ");
                } else {
                    result.append("]");
                }
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    public int mapLocationToIndex(int location, int offset) {
        if (location < 0) {
            return -1;
        }
        GlProgramVariableOffset vOffset = this.getParentAsset().getUniformsContainer().getByLocation(location + offset);
        if (vOffset == null) {
            return -1;
        }
        return vOffset.getArrayIndex();
    }

    public void setValue(int arrayIndex, @NonNull Number[] elementValues, @NonNull FunctionCall functionCall) {
        this.setValue(arrayIndex, elementValues);
        this.setPreviousModificationFunction(functionCall);
    }

    public void setValueFromBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlBufferAsset bufferAsset, long offset, long length) throws UnsupportedTypeException {
        int mElementCount;
        int mLoopCount;
        boolean isMatrix;
        this.clearValue(functionCall);
        byte[] data = bufferAsset.getData();
        if (data == null) {
            if (bufferAsset.getSize() == 0L) {
                TraceAnalysisLogger.warning(currentState, functionCall, "Uniform Buffer bound to empty buffer");
            } else {
                TraceAnalysisLogger.warning(currentState, functionCall, "Buffer data not available for Uniform Buffer. Uniform information will not be available for blocks bound to this buffer.");
            }
            return;
        }
        if (offset < 0L || offset >= (long)data.length || offset + length > (long)data.length) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Uniform Buffer binding offset or length out of range");
            return;
        }
        long bufferDataSize = this.getBlockResourceDescriptor().resolveBufferDataSize();
        if (bufferDataSize > length) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Uniform Buffer binding length smaller than necessary");
            return;
        }
        AbstractConstantOrAliasSpecExtended type = this.getType();
        BasicTypeSpec basicType = type.getCtype();
        int arraySize = this.getResourceDescriptor().resolveArraySize();
        int arrayStride = this.getResourceDescriptor().resolveArrayStride();
        int matrixStride = this.getResourceDescriptor().resolveMatrixStride();
        int mColumns = type.getNumberOfColumnsAsInt();
        int mRows = type.getNumberOfRowsAsInt();
        boolean rowMajor = this.getResourceDescriptor().resolveIsRowMajor();
        Integer elementSize = basicType.getByteSize();
        long uOffset = this.getResourceDescriptor().resolveOffset();
        boolean bl = isMatrix = mColumns > 1 && mRows > 1;
        int n = isMatrix ? (rowMajor ? mRows : mColumns) : (mLoopCount = 1);
        int n2 = isMatrix ? (rowMajor ? mColumns : mRows) : (mElementCount = Math.max(mRows, mColumns));
        assert (uOffset + offset < (long)data.length);
        if (elementSize == null || elementSize == 0) {
            return;
        }
        int base = (int)(offset + uOffset);
        int dPos = 0;
        int arrayLength = Math.max(1, this.getArrayLength());
        int i = 0;
        while (i < arrayLength) {
            @NonNull Number[] element = this.getValue(i);
            int mPos = 0;
            assert (mLoopCount * mElementCount == element.length);
            int mLoop = 0;
            while (mLoop < mLoopCount) {
                byte @NonNull [] slice = new byte[mElementCount * elementSize];
                System.arraycopy(data, base + dPos + mPos, slice, 0, slice.length);
                Number[] newValues = ShaderUniform.getElementBytes(slice, basicType);
                assert (newValues.length == mElementCount);
                System.arraycopy(newValues, 0, element, mLoop * mElementCount, newValues.length);
                if (isMatrix && matrixStride > 0) {
                    assert (mElementCount * elementSize <= matrixStride);
                    mPos += matrixStride;
                } else {
                    mPos += mElementCount * elementSize;
                }
                ++mLoop;
            }
            if (arraySize > 0 && arrayStride > 0) {
                assert (mPos <= arrayStride);
                dPos += arrayStride;
            } else {
                dPos += mPos;
            }
            this.setValue(i, element);
            ++i;
        }
    }

    @Override
    protected @NonNull Number[] mapAndValidateValue(@NonNull Number[] value) {
        int expectedLength = Math.max(1, this.getElementLength());
        int count = Math.min(value.length, expectedLength);
        assert (value.length <= expectedLength);
        @NonNull Number[] result = new Number[expectedLength];
        int i = 0;
        while (i < count) {
            result[i] = this.valueConverter.convert(value[i]);
            ++i;
        }
        return result;
    }

    public @Nullable Long getUniformBlockBinding() {
        ProgramResourceDescriptor blockDescriptor = this.getBlockResourceDescriptor();
        if (blockDescriptor == null) {
            return null;
        }
        Map<Long, Long> map = this.getParentAsset().getUniformBlockBindings();
        return map.get(blockDescriptor.getIndex());
    }

    public void setValue(Number[] value) {
        int elementLength = Math.max(1, this.getElementLength());
        int arrayLength = Math.max(1, this.getArrayLength());
        if (value == null || value.length != elementLength * arrayLength) {
            assert (value == null || value.length == 0) : "Invalid data sent for uniform value (received " + value.length + ", expected " + elementLength * arrayLength + ")";
            return;
        }
        Number[] slice = new Number[elementLength];
        int i = 0;
        while (i < arrayLength) {
            System.arraycopy(value, i * elementLength, slice, 0, elementLength);
            this.setValue(i, slice);
            ++i;
        }
    }

    @Override
    public @Nullable String getTextForm() {
        return this.getValuesString();
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        @NonNull String blockName = this.getBlockName();
        if (!blockName.isEmpty()) {
            properties.put("Block Name", ValueAssetProperty.create(blockName));
        }
        properties.put("Type", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getType().getName())));
        int arrayLength = this.getArrayLength();
        if (arrayLength != 0) {
            properties.put("Array Length", ValueAssetProperty.create(NullUtils.stringValueOf((long)arrayLength)));
        }
        return properties;
    }
}

