/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.programvariable;

import com.arm.mgd.core.asset.programvariable.GlProgramVariableAsset;
import com.arm.mgd.core.asset.programvariable.GlProgramVariableOffset;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public abstract class GlProgramVariableContainer<T extends GlProgramVariableAsset>
implements Serializable {
    private static final long serialVersionUID = 7634858592520479480L;
    public static final @NonNull String DEFAULT_BLOCK_NAME = "";
    private final Map<String, Map<Long, T>> blockMap = new HashMap<String, Map<Long, T>>();
    private final Class<T> clazz;
    private final Map<Long, T> indexMap = new HashMap<Long, T>();
    private final Map<Integer, GlProgramVariableOffset<T>> locationMap = new HashMap<Integer, GlProgramVariableOffset<T>>();

    protected GlProgramVariableContainer(@NonNull Class<T> clazz) {
        this.clazz = clazz;
    }

    public Set<String> getAllBlockNames() {
        return Collections.unmodifiableSet(this.blockMap.keySet());
    }

    public Collection<T> getAllVariables() {
        return Collections.unmodifiableCollection(this.indexMap.values());
    }

    public Map<Long, T> getBlock(@NonNull String blockName) {
        Map<Long, T> result = this.blockMap.get(blockName);
        return result != null ? Collections.unmodifiableMap(result) : null;
    }

    public T getByIndex(long index) {
        return (T)((GlProgramVariableAsset)this.indexMap.get(index));
    }

    public GlProgramVariableOffset<T> getByLocation(int location) {
        return this.locationMap.get(location);
    }

    public void clear() {
        this.blockMap.clear();
        this.indexMap.clear();
        this.locationMap.clear();
    }

    protected void addVariable(@NonNull T variable) {
        Long index = ((GlProgramVariableAsset)variable).getIndex();
        String blockName = ((GlProgramVariableAsset)variable).getBlockName();
        assert (!this.indexMap.containsKey(index));
        this.indexMap.put(index, variable);
        Map<Long, T> perBlockMap = this.blockMap.get(blockName);
        if (perBlockMap == null) {
            perBlockMap = new HashMap<Long, T>();
            this.blockMap.put(blockName, perBlockMap);
        }
        perBlockMap.put(index, variable);
        if (((GlProgramVariableAsset)variable).isArrayVariable()) {
            assert (((GlProgramVariableAsset)variable).getArrayLength() == ((GlProgramVariableAsset)variable).getResourceDescriptor().getAdditionalLocations().size());
            List<ProgramResourceDescriptor.ProgramResourceAdditionalLocation> locations = ((GlProgramVariableAsset)variable).getResourceDescriptor().getAdditionalLocations();
            int arrayIndex = 0;
            while (arrayIndex < locations.size()) {
                ProgramResourceDescriptor.ProgramResourceAdditionalLocation arrayLocation = locations.get(arrayIndex);
                Integer location = arrayLocation.getLocation();
                if (location >= 0) {
                    assert (!this.locationMap.containsKey(location));
                    this.locationMap.put(location, new GlProgramVariableOffset<T>(variable, arrayIndex, location));
                }
                ++arrayIndex;
            }
        } else {
            Integer location = ((GlProgramVariableAsset)variable).getLocation();
            if (location >= 0) {
                assert (!this.locationMap.containsKey(location));
                this.locationMap.put(location, new GlProgramVariableOffset<T>(variable, location));
            }
        }
    }
}

