/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.programvariable;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import org.eclipse.jdt.annotation.NonNull;

public abstract class GlProgramVariableAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = 4805419463974797869L;
    private final ProgramResourceDescriptor blockDescriptor;
    private final @NonNull ProgramResourceDescriptor descriptor;
    private final @NonNull String name;

    protected GlProgramVariableAsset(@NonNull AssetTableSpec assetSpec, @NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, @NonNull ProgramResourceDescriptor descriptor, ProgramResourceDescriptor blockDescriptor) {
        super(assetSpec, snapshotAssetParent, createdByFunction, uniqueInstanceId, descriptor.getIndex());
        this.descriptor = descriptor;
        this.blockDescriptor = blockDescriptor;
        this.name = descriptor.getNameWithoutSuffix();
    }

    public int getArrayLength() {
        return this.descriptor.resolveArraySize();
    }

    public @NonNull String getBlockName() {
        return this.blockDescriptor != null ? this.blockDescriptor.getName() : "";
    }

    public ProgramResourceDescriptor getBlockResourceDescriptor() {
        return this.blockDescriptor;
    }

    public int getElementLength() {
        return this.descriptor.resolveElementLength();
    }

    public long getIndex() {
        return this.descriptor.getIndex();
    }

    public int getLocation() {
        return this.descriptor.resolveLocation();
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull ProgramResourceDescriptor getResourceDescriptor() {
        return this.descriptor;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getType() {
        return this.descriptor.resolveType();
    }

    public boolean isArrayVariable() {
        return this.descriptor.resolveArraySize() > 1;
    }

    public boolean isInDefaultBlock() {
        return this.getBlockName().isEmpty();
    }
}

