/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors.gen;

import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.VkBufferViewAsset;
import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkComputePipelineAsset;
import com.arm.mgd.core.asset.VkDescriptorPoolAsset;
import com.arm.mgd.core.asset.VkDescriptorSetAsset;
import com.arm.mgd.core.asset.VkDescriptorSetLayoutAsset;
import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.asset.VkFramebufferAsset;
import com.arm.mgd.core.asset.VkGraphicsPipelineAsset;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.VkImageViewAsset;
import com.arm.mgd.core.asset.VkPipelineAsset;
import com.arm.mgd.core.asset.VkPipelineLayoutAsset;
import com.arm.mgd.core.asset.VkRenderPassAsset;
import com.arm.mgd.core.asset.VkShaderModuleAsset;
import com.arm.mgd.core.asset.VkSwapchainKHRAsset;
import com.arm.mgd.core.asset.objects.IVkAttachmentDescription;
import com.arm.mgd.core.asset.objects.IVkSubpassDependency;
import com.arm.mgd.core.asset.objects.IVkSubpassDescription;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.processors.ProvidedAssetProcessors;
import com.arm.mgd.core.asset.processors.ValueTransformHelper;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.lang.handle.HandleAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public final class VulkanAssetProcessor {
    private static final Map<String, AssetProcessorBase> ASSET_PROCESSORS = new HashMap<String, AssetProcessorBase>(){
        {
            this.put("vkAllocateCommandBuffers", new VkAllocateCommandBuffers());
            this.put("vkAllocateDescriptorSets", new VkAllocateDescriptorSets());
            this.put("vkAllocateMemory", new VkAllocateMemory());
            this.put("vkBeginCommandBuffer", new VkBeginCommandBuffer());
            this.put("vkBindBufferMemory", new VkBindBufferMemory());
            this.put("vkBindImageMemory", new VkBindImageMemory());
            this.put("vkCreateBuffer", new VkCreateBuffer());
            this.put("vkCreateBufferView", new VkCreateBufferView());
            this.put("vkCreateComputePipelines", new VkCreateComputePipelines());
            this.put("vkCreateDescriptorPool", new VkCreateDescriptorPool());
            this.put("vkCreateDescriptorSetLayout", new VkCreateDescriptorSetLayout());
            this.put("vkCreateFramebuffer", new VkCreateFramebuffer());
            this.put("vkCreateGraphicsPipelines", new VkCreateGraphicsPipelines());
            this.put("vkCreateImage", new VkCreateImage());
            this.put("vkCreateImageView", new VkCreateImageView());
            this.put("vkCreatePipelineLayout", new VkCreatePipelineLayout());
            this.put("vkCreateRenderPass", new VkCreateRenderPass());
            this.put("vkCreateRenderPass2", new VkCreateRenderPass2());
            this.put("vkCreateShaderModule", new VkCreateShaderModule());
            this.put("vkCreateSwapchainKHR", new VkCreateSwapchainKhr());
            this.put("vkDestroyBuffer", new VkDestroyBuffer());
            this.put("vkDestroyBufferView", new VkDestroyBufferView());
            this.put("vkDestroyDescriptorPool", new VkDestroyDescriptorPool());
            this.put("vkDestroyDescriptorSetLayout", new VkDestroyDescriptorSetLayout());
            this.put("vkDestroyFramebuffer", new VkDestroyFramebuffer());
            this.put("vkDestroyImage", new VkDestroyImage());
            this.put("vkDestroyImageView", new VkDestroyImageView());
            this.put("vkDestroyPipeline", new VkDestroyPipeline());
            this.put("vkDestroyPipelineLayout", new VkDestroyPipelineLayout());
            this.put("vkDestroyRenderPass", new VkDestroyRenderPass());
            this.put("vkDestroyShaderModule", new VkDestroyShaderModule());
            this.put("vkDestroySwapchainKHR", new VkDestroySwapchainKhr());
            this.put("vkEndCommandBuffer", new VkEndCommandBuffer());
            this.put("vkFreeCommandBuffers", new VkFreeCommandBuffers());
            this.put("vkFreeDescriptorSets", new VkFreeDescriptorSets());
            this.put("vkFreeMemory", new VkFreeMemory());
            this.put("vkGetSwapchainImagesKHR", new VkGetSwapchainImagesKhr());
            this.put("vkResetCommandBuffer", new VkResetCommandBuffer());
            this.put("vkResetDescriptorPool", new VkResetDescriptorPool());
        }
    };

    public static final AssetProcessorBase getAssetProcessor(String functionName) {
        return ASSET_PROCESSORS.get(functionName);
    }

    private static class Constants {
        private Constants() {
        }
    }

    private static final class VkAllocateCommandBuffers
    extends AssetProcessorBase {
        private VkAllocateCommandBuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKALLOCATECOMMANDBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkCommandBufferAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPAllocateInfo(functionCall);
                LongsArgAttachment arg_pCommandBuffers = VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPCommandBuffers(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateCommandBuffersDecorator.getReturnValue(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_pCommandBuffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, allocatedCommandBuffer_id_value -> {
                    Handle temp_getCommandPool_return_value_1 = arg_pAllocateInfo.getCommandPool();
                    AbstractConstantOrAliasSpecExtended temp_getLevel_return_value_2 = arg_pAllocateInfo.getLevel();
                    VkCommandBufferAsset vkCommandBufferAsset = AssetProcessorBase.createNewVkCommandBufferAsset(currentState, functionCall, allocatedCommandBuffer_id_value, temp_getCommandPool_return_value_1, arg_device, temp_getLevel_return_value_2);
                });
            }
        }
    }

    private static final class VkAllocateDescriptorSets
    extends AssetProcessorBase {
        private VkAllocateDescriptorSets() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKALLOCATEDESCRIPTORSETS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkDescriptorSetAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPAllocateInfo(functionCall);
                HandleArrayAttachment arg_pDescriptorSets = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPDescriptorSets(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateDescriptorSetsDecorator.getReturnValue(functionCall);
                Handle temp_getDescriptorPool_return_value_0 = arg_pAllocateInfo.getDescriptorPool();
                long descriptorPool_id_value = AssetProcessorBase.asAssetID(temp_getDescriptorPool_return_value_0);
                VkDescriptorPoolAsset descriptorPool = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDescriptorPoolAsset(currentState, functionCall, descriptorPool_id_value), descriptorPool_id_value);
                List<Long> temp_asAssetIDs_return_value_1 = AssetProcessorBase.asAssetIDs(arg_pDescriptorSets);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_1, allocatedDescriptorSet_id_value -> {
                    VkDescriptorSetAsset vkDescriptorSetAsset = AssetProcessorBase.createNewVkDescriptorSetAsset(currentState, functionCall, allocatedDescriptorSet_id_value, descriptorPool, null);
                });
            }
        }
    }

    private static final class VkAllocateMemory
    extends AssetProcessorBase {
        private VkAllocateMemory() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKALLOCATEMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkAllocateMemoryDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkMemoryAllocateInfo arg_pAllocateInfo = VULKAN.VkAllocateMemoryDecorator.getArgumentPAllocateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkAllocateMemoryDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pMemory = VULKAN.VkAllocateMemoryDecorator.getArgumentPMemory(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkAllocateMemoryDecorator.getReturnValue(functionCall);
                long deviceMemoryAsset_id_value = AssetProcessorBase.asAssetID(arg_pMemory);
                Long temp_getAllocationSize_return_value_0 = arg_pAllocateInfo.getAllocationSize();
                long temp_longValue_return_value_1 = temp_getAllocationSize_return_value_0;
                Long temp_getMemoryTypeIndex_return_value_2 = arg_pAllocateInfo.getMemoryTypeIndex();
                long temp_longValue_return_value_3 = temp_getMemoryTypeIndex_return_value_2;
                VkDeviceMemoryAsset vkDeviceMemoryAsset = AssetProcessorBase.createNewVkDeviceMemoryAsset(currentState, functionCall, deviceMemoryAsset_id_value, temp_longValue_return_value_1, temp_longValue_return_value_3);
            }
        }
    }

    private static final class VkBeginCommandBuffer
    extends AssetProcessorBase {
        private VkBeginCommandBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKBEGINCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_commandBuffer = VULKAN.VkBeginCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                VULKAN.Structs.VkCommandBufferBeginInfo arg_pBeginInfo = VULKAN.VkBeginCommandBufferDecorator.getArgumentPBeginInfo(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBeginCommandBufferDecorator.getReturnValue(functionCall);
                long commandBufferAsset_id_value = AssetProcessorBase.asAssetID(arg_commandBuffer);
                VkCommandBufferAsset commandBufferAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkCommandBufferAsset(currentState, functionCall, commandBufferAsset_id_value), commandBufferAsset_id_value);
                commandBufferAsset.setPreviousModificationFunction(functionCall);
                VULKAN.Structs.VkCommandBufferInheritanceInfo temp_getPInheritanceInfo_return_value_0 = arg_pBeginInfo.getPInheritanceInfo();
                commandBufferAsset.setInheritanceInfo(temp_getPInheritanceInfo_return_value_0);
                ProvidedAssetProcessors.processProvidedActionForVkCommandBufferAssetOnVkBeginCommandBuffer(currentState, functionCall, commandBufferAsset, arg_commandBuffer, arg_pBeginInfo, returnValue_);
            }
        }
    }

    private static final class VkBindBufferMemory
    extends AssetProcessorBase {
        private VkBindBufferMemory() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKBINDBUFFERMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkBindBufferMemoryDecorator.getArgumentDevice(functionCall);
                Handle arg_buffer = VULKAN.VkBindBufferMemoryDecorator.getArgumentBuffer(functionCall);
                Handle arg_memory = VULKAN.VkBindBufferMemoryDecorator.getArgumentMemory(functionCall);
                Long arg_memoryOffset = VULKAN.VkBindBufferMemoryDecorator.getArgumentMemoryOffset(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBindBufferMemoryDecorator.getReturnValue(functionCall);
                long bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                VkBufferAsset bufferAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value);
                bufferAsset.setPreviousModificationFunction(functionCall);
                long memoryAsset_id_value = AssetProcessorBase.asAssetID(arg_memory);
                VkDeviceMemoryAsset memoryAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDeviceMemoryAsset(currentState, functionCall, memoryAsset_id_value), memoryAsset_id_value);
                ProvidedAssetProcessors.processProvidedActionForVkBufferAssetOnVkBindBufferMemory(currentState, functionCall, bufferAsset, arg_device, arg_buffer, arg_memory, arg_memoryOffset, returnValue_, memoryAsset);
            }
        }
    }

    private static final class VkBindImageMemory
    extends AssetProcessorBase {
        private VkBindImageMemory() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKBINDIMAGEMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkBindImageMemoryDecorator.getArgumentDevice(functionCall);
                Handle arg_image = VULKAN.VkBindImageMemoryDecorator.getArgumentImage(functionCall);
                Handle arg_memory = VULKAN.VkBindImageMemoryDecorator.getArgumentMemory(functionCall);
                Long arg_memoryOffset = VULKAN.VkBindImageMemoryDecorator.getArgumentMemoryOffset(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkBindImageMemoryDecorator.getReturnValue(functionCall);
                long imageAsset_id_value = AssetProcessorBase.asAssetID(arg_image);
                VkImageAsset imageAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkImageAsset(currentState, functionCall, imageAsset_id_value), imageAsset_id_value);
                imageAsset.setPreviousModificationFunction(functionCall);
                long memoryAsset_id_value = AssetProcessorBase.asAssetID(arg_memory);
                VkDeviceMemoryAsset memoryAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDeviceMemoryAsset(currentState, functionCall, memoryAsset_id_value), memoryAsset_id_value);
                ProvidedAssetProcessors.processProvidedActionForVkImageAssetOnVkBindImageMemory(currentState, functionCall, imageAsset, arg_device, arg_image, arg_memory, arg_memoryOffset, returnValue_, memoryAsset);
            }
        }
    }

    private static final class VkCreateBuffer
    extends AssetProcessorBase {
        private VkCreateBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateBufferDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkBufferCreateInfo arg_pCreateInfo = VULKAN.VkCreateBufferDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateBufferDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pBuffer = VULKAN.VkCreateBufferDecorator.getArgumentPBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateBufferDecorator.getReturnValue(functionCall);
                long bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_pBuffer);
                Bitfield temp_getFlags_return_value_0 = arg_pCreateInfo.getFlags();
                LongsArgAttachment temp_getPQueueFamilyIndices_return_value_1 = arg_pCreateInfo.getPQueueFamilyIndices();
                AbstractConstantOrAliasSpecExtended temp_getSharingMode_return_value_2 = arg_pCreateInfo.getSharingMode();
                Long temp_getSize_return_value_3 = arg_pCreateInfo.getSize();
                long temp_longValue_return_value_4 = temp_getSize_return_value_3;
                Bitfield temp_getUsage_return_value_5 = arg_pCreateInfo.getUsage();
                VkBufferAsset vkBufferAsset = AssetProcessorBase.createNewVkBufferAsset(currentState, functionCall, bufferAsset_id_value, temp_getFlags_return_value_0, temp_getPQueueFamilyIndices_return_value_1, temp_getSharingMode_return_value_2, temp_longValue_return_value_4, temp_getUsage_return_value_5);
            }
        }
    }

    private static final class VkCreateBufferView
    extends AssetProcessorBase {
        private VkCreateBufferView() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEBUFFERVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateBufferViewDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkBufferViewCreateInfo arg_pCreateInfo = VULKAN.VkCreateBufferViewDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateBufferViewDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pView = VULKAN.VkCreateBufferViewDecorator.getArgumentPView(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateBufferViewDecorator.getReturnValue(functionCall);
                Handle temp_getBuffer_return_value_0 = arg_pCreateInfo.getBuffer();
                long parentBuffer_id_value = AssetProcessorBase.asAssetID(temp_getBuffer_return_value_0);
                VkBufferAsset parentBuffer = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkBufferAsset(currentState, functionCall, parentBuffer_id_value), parentBuffer_id_value);
                long bufferView_id_value = AssetProcessorBase.asAssetID(arg_pView);
                Bitfield temp_getFlags_return_value_1 = arg_pCreateInfo.getFlags();
                AbstractConstantOrAliasSpecExtended temp_getFormat_return_value_2 = arg_pCreateInfo.getFormat();
                Long temp_getOffset_return_value_3 = arg_pCreateInfo.getOffset();
                long temp_longValue_return_value_4 = temp_getOffset_return_value_3;
                Long temp_getRange_return_value_5 = arg_pCreateInfo.getRange();
                long temp_longValue_return_value_6 = temp_getRange_return_value_5;
                VkBufferViewAsset vkBufferViewAsset = AssetProcessorBase.createNewVkBufferViewAsset(currentState, functionCall, bufferView_id_value, parentBuffer, temp_getFlags_return_value_1, temp_getFormat_return_value_2, temp_longValue_return_value_4, temp_longValue_return_value_6);
            }
        }
    }

    private static final class VkCreateComputePipelines
    extends AssetProcessorBase {
        private VkCreateComputePipelines() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATECOMPUTEPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateComputePipelinesDecorator.getArgumentDevice(functionCall);
                Handle arg_pipelineCache = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPipelineCache(functionCall);
                Long arg_createInfoCount = VULKAN.VkCreateComputePipelinesDecorator.getArgumentCreateInfoCount(functionCall);
                List< @NonNull VULKAN.Structs.VkComputePipelineCreateInfo> arg_pCreateInfos = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPCreateInfos(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPAllocator(functionCall);
                HandleArrayAttachment arg_pPipelines = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPPipelines(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateComputePipelinesDecorator.getReturnValue(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_pPipelines);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, pipelineAsset_id_value -> {
                    VkComputePipelineAsset vkComputePipelineAsset = AssetProcessorBase.createNewVkComputePipelineAsset(currentState, functionCall, pipelineAsset_id_value);
                });
            }
        }
    }

    private static final class VkCreateDescriptorPool
    extends AssetProcessorBase {
        private VkCreateDescriptorPool() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORPOOL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkDescriptorPoolCreateInfo arg_pCreateInfo = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pDescriptorPool = VULKAN.VkCreateDescriptorPoolDecorator.getArgumentPDescriptorPool(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateDescriptorPoolDecorator.getReturnValue(functionCall);
                long descriptorPoolAsset_id_value = AssetProcessorBase.asAssetID(arg_pDescriptorPool);
                VkDescriptorPoolAsset vkDescriptorPoolAsset = AssetProcessorBase.createNewVkDescriptorPoolAsset(currentState, functionCall, descriptorPoolAsset_id_value);
            }
        }
    }

    private static final class VkCreateDescriptorSetLayout
    extends AssetProcessorBase {
        private VkCreateDescriptorSetLayout() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEDESCRIPTORSETLAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkDescriptorSetLayoutCreateInfo arg_pCreateInfo = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pSetLayout = VULKAN.VkCreateDescriptorSetLayoutDecorator.getArgumentPSetLayout(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateDescriptorSetLayoutDecorator.getReturnValue(functionCall);
                long descriptorSetLayoutAsset_id_value = AssetProcessorBase.asAssetID(arg_pSetLayout);
                List<VULKAN.Structs.VkDescriptorSetLayoutBinding> temp_getPBindings_return_value_0 = arg_pCreateInfo.getPBindings();
                VkDescriptorSetLayoutAsset vkDescriptorSetLayoutAsset = AssetProcessorBase.createNewVkDescriptorSetLayoutAsset(currentState, functionCall, descriptorSetLayoutAsset_id_value, temp_getPBindings_return_value_0);
            }
        }
    }

    private static final class VkCreateFramebuffer
    extends AssetProcessorBase {
        private VkCreateFramebuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateFramebufferDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkFramebufferCreateInfo arg_pCreateInfo = VULKAN.VkCreateFramebufferDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateFramebufferDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pFramebuffer = VULKAN.VkCreateFramebufferDecorator.getArgumentPFramebuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateFramebufferDecorator.getReturnValue(functionCall);
                Handle temp_getRenderPass_return_value_0 = arg_pCreateInfo.getRenderPass();
                long renderPass_id_value = AssetProcessorBase.asAssetID(temp_getRenderPass_return_value_0);
                VkRenderPassAsset renderPass = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, currentState, functionCall, AssetProcessorBase.getVkRenderPassAsset(currentState, functionCall, renderPass_id_value), renderPass_id_value);
                long framebufferAsset_id_value = AssetProcessorBase.asAssetID(arg_pFramebuffer);
                ArrayList<VkImageViewAsset> temp_new_list_1 = new ArrayList<VkImageViewAsset>();
                Bitfield temp_getFlags_return_value_2 = arg_pCreateInfo.getFlags();
                Long temp_getHeight_return_value_3 = arg_pCreateInfo.getHeight();
                long temp_longValue_return_value_4 = temp_getHeight_return_value_3;
                Long temp_getLayers_return_value_5 = arg_pCreateInfo.getLayers();
                long temp_longValue_return_value_6 = temp_getLayers_return_value_5;
                Long temp_getWidth_return_value_7 = arg_pCreateInfo.getWidth();
                long temp_longValue_return_value_8 = temp_getWidth_return_value_7;
                VkFramebufferAsset vkFramebufferAsset = AssetProcessorBase.createNewVkFramebufferAsset(currentState, functionCall, framebufferAsset_id_value, temp_new_list_1, temp_getFlags_return_value_2, temp_longValue_return_value_4, temp_longValue_return_value_6, renderPass, temp_longValue_return_value_8);
            }
        }
    }

    private static final class VkCreateGraphicsPipelines
    extends AssetProcessorBase {
        private VkCreateGraphicsPipelines() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEGRAPHICSPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentDevice(functionCall);
                Handle arg_pipelineCache = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPipelineCache(functionCall);
                Long arg_createInfoCount = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentCreateInfoCount(functionCall);
                List< @NonNull VULKAN.Structs.VkGraphicsPipelineCreateInfo> arg_pCreateInfos = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPCreateInfos(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPAllocator(functionCall);
                HandleArrayAttachment arg_pPipelines = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPPipelines(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateGraphicsPipelinesDecorator.getReturnValue(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_pPipelines);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, pipelineAsset_id_value -> {
                    VkGraphicsPipelineAsset vkGraphicsPipelineAsset = AssetProcessorBase.createNewVkGraphicsPipelineAsset(currentState, functionCall, pipelineAsset_id_value);
                });
            }
        }
    }

    private static final class VkCreateImage
    extends AssetProcessorBase {
        private VkCreateImage() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateImageDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkImageCreateInfo arg_pCreateInfo = VULKAN.VkCreateImageDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateImageDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pImage = VULKAN.VkCreateImageDecorator.getArgumentPImage(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateImageDecorator.getReturnValue(functionCall);
                long imageAsset_id_value = AssetProcessorBase.asAssetID(arg_pImage);
                Long temp_getArrayLayers_return_value_0 = arg_pCreateInfo.getArrayLayers();
                long temp_longValue_return_value_1 = temp_getArrayLayers_return_value_0;
                VULKAN.Structs.VkExtent3D temp_getExtent_return_value_2 = arg_pCreateInfo.getExtent();
                Bitfield temp_getFlags_return_value_3 = arg_pCreateInfo.getFlags();
                AbstractConstantOrAliasSpecExtended temp_getFormat_return_value_4 = arg_pCreateInfo.getFormat();
                AbstractConstantOrAliasSpecExtended temp_getImageType_return_value_5 = arg_pCreateInfo.getImageType();
                AbstractConstantOrAliasSpecExtended temp_getInitialLayout_return_value_6 = arg_pCreateInfo.getInitialLayout();
                Long temp_getMipLevels_return_value_7 = arg_pCreateInfo.getMipLevels();
                long temp_longValue_return_value_8 = temp_getMipLevels_return_value_7;
                LongsArgAttachment temp_getPQueueFamilyIndices_return_value_9 = arg_pCreateInfo.getPQueueFamilyIndices();
                Bitfield temp_valueOf_return_value_10 = Bitfield.valueOf(arg_pCreateInfo.getSamples());
                AbstractConstantOrAliasSpecExtended temp_getSharingMode_return_value_11 = arg_pCreateInfo.getSharingMode();
                AbstractConstantOrAliasSpecExtended temp_getTiling_return_value_12 = arg_pCreateInfo.getTiling();
                Bitfield temp_getUsage_return_value_13 = arg_pCreateInfo.getUsage();
                VkImageAsset imageAsset = AssetProcessorBase.createNewVkImageAsset(currentState, functionCall, imageAsset_id_value, temp_longValue_return_value_1, temp_getExtent_return_value_2, temp_getFlags_return_value_3, temp_getFormat_return_value_4, temp_getImageType_return_value_5, temp_getInitialLayout_return_value_6, temp_longValue_return_value_8, temp_getPQueueFamilyIndices_return_value_9, temp_valueOf_return_value_10, temp_getSharingMode_return_value_11, temp_getTiling_return_value_12, temp_getUsage_return_value_13);
                ProvidedAssetProcessors.processProvidedActionForVkImageAssetOnVkCreateImage(currentState, functionCall, imageAsset, arg_device, arg_pCreateInfo, arg_pAllocator, arg_pImage, returnValue_);
            }
        }
    }

    private static final class VkCreateImageView
    extends AssetProcessorBase {
        private VkCreateImageView() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEIMAGEVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateImageViewDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkImageViewCreateInfo arg_pCreateInfo = VULKAN.VkCreateImageViewDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateImageViewDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pView = VULKAN.VkCreateImageViewDecorator.getArgumentPView(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateImageViewDecorator.getReturnValue(functionCall);
                Handle temp_getImage_return_value_0 = arg_pCreateInfo.getImage();
                long imageAsset_id_value = AssetProcessorBase.asAssetID(temp_getImage_return_value_0);
                VkImageAsset imageAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkImageAsset(currentState, functionCall, imageAsset_id_value), imageAsset_id_value);
                long imageViewAsset_id_value = AssetProcessorBase.asAssetID(arg_pView);
                VULKAN.Structs.VkComponentMapping temp_getComponents_return_value_1 = arg_pCreateInfo.getComponents();
                Bitfield temp_getFlags_return_value_2 = arg_pCreateInfo.getFlags();
                AbstractConstantOrAliasSpecExtended temp_getFormat_return_value_3 = arg_pCreateInfo.getFormat();
                VULKAN.Structs.VkImageSubresourceRange temp_getSubresourceRange_return_value_4 = arg_pCreateInfo.getSubresourceRange();
                AbstractConstantOrAliasSpecExtended temp_getViewType_return_value_5 = arg_pCreateInfo.getViewType();
                VkImageViewAsset vkImageViewAsset = AssetProcessorBase.createNewVkImageViewAsset(currentState, functionCall, imageViewAsset_id_value, temp_getComponents_return_value_1, temp_getFlags_return_value_2, temp_getFormat_return_value_3, imageAsset, temp_getSubresourceRange_return_value_4, temp_getViewType_return_value_5);
            }
        }
    }

    private static final class VkCreatePipelineLayout
    extends AssetProcessorBase {
        private VkCreatePipelineLayout() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATEPIPELINELAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkPipelineLayoutCreateInfo arg_pCreateInfo = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pPipelineLayout = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPPipelineLayout(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreatePipelineLayoutDecorator.getReturnValue(functionCall);
                long pipelineLayout_id_value = AssetProcessorBase.asAssetID(arg_pPipelineLayout);
                Bitfield temp_getFlags_return_value_0 = arg_pCreateInfo.getFlags();
                List<VULKAN.Structs.VkPushConstantRange> temp_getPPushConstantRanges_return_value_1 = arg_pCreateInfo.getPPushConstantRanges();
                ArrayList<VkDescriptorSetLayoutAsset> temp_new_list_2 = new ArrayList<VkDescriptorSetLayoutAsset>();
                VkPipelineLayoutAsset vkPipelineLayoutAsset = AssetProcessorBase.createNewVkPipelineLayoutAsset(currentState, functionCall, pipelineLayout_id_value, temp_getFlags_return_value_0, temp_getPPushConstantRanges_return_value_1, temp_new_list_2);
            }
        }
    }

    private static final class VkCreateRenderPass
    extends AssetProcessorBase {
        private VkCreateRenderPass() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATERENDERPASS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateRenderPassDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkRenderPassCreateInfo arg_pCreateInfo = VULKAN.VkCreateRenderPassDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateRenderPassDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pRenderPass = VULKAN.VkCreateRenderPassDecorator.getArgumentPRenderPass(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateRenderPassDecorator.getReturnValue(functionCall);
                long renderPassAsset_id_value = AssetProcessorBase.asAssetID(arg_pRenderPass);
                List<IVkAttachmentDescription> temp_map_return_value_1 = ValueTransformHelper.map(arg_pCreateInfo.getPAttachments(), temp_list_xform_value_0 -> ValueTransformHelper.toIvKAttachmentDescription(temp_list_xform_value_0));
                List<IVkSubpassDependency> temp_map_return_value_3 = ValueTransformHelper.map(arg_pCreateInfo.getPDependencies(), temp_list_xform_value_2 -> ValueTransformHelper.toIvKSubpassDependency(temp_list_xform_value_2));
                Bitfield temp_getFlags_return_value_4 = arg_pCreateInfo.getFlags();
                List<IVkSubpassDescription> temp_map_return_value_6 = ValueTransformHelper.map(arg_pCreateInfo.getPSubpasses(), temp_list_xform_value_5 -> ValueTransformHelper.toIvKSubpassDescription(temp_list_xform_value_5));
                VkRenderPassAsset vkRenderPassAsset = AssetProcessorBase.createNewVkRenderPassAsset(currentState, functionCall, renderPassAsset_id_value, temp_map_return_value_1, temp_map_return_value_3, temp_getFlags_return_value_4, temp_map_return_value_6);
            }
        }
    }

    private static final class VkCreateRenderPass2
    extends AssetProcessorBase {
        private VkCreateRenderPass2() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATERENDERPASS2.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateRenderPass2Decorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkRenderPassCreateInfo2 arg_pCreateInfo = VULKAN.VkCreateRenderPass2Decorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateRenderPass2Decorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pRenderPass = VULKAN.VkCreateRenderPass2Decorator.getArgumentPRenderPass(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateRenderPass2Decorator.getReturnValue(functionCall);
                long renderPassAsset_id_value = AssetProcessorBase.asAssetID(arg_pRenderPass);
                List<IVkAttachmentDescription> temp_map_return_value_1 = ValueTransformHelper.map(arg_pCreateInfo.getPAttachments(), temp_list_xform_value_0 -> ValueTransformHelper.toIvKAttachmentDescription(temp_list_xform_value_0));
                List<IVkSubpassDependency> temp_map_return_value_3 = ValueTransformHelper.map(arg_pCreateInfo.getPDependencies(), temp_list_xform_value_2 -> ValueTransformHelper.toIvKSubpassDependency(temp_list_xform_value_2));
                Bitfield temp_getFlags_return_value_4 = arg_pCreateInfo.getFlags();
                List<IVkSubpassDescription> temp_map_return_value_6 = ValueTransformHelper.map(arg_pCreateInfo.getPSubpasses(), temp_list_xform_value_5 -> ValueTransformHelper.toIvKSubpassDescription(temp_list_xform_value_5));
                VkRenderPassAsset vkRenderPassAsset = AssetProcessorBase.createNewVkRenderPassAsset(currentState, functionCall, renderPassAsset_id_value, temp_map_return_value_1, temp_map_return_value_3, temp_getFlags_return_value_4, temp_map_return_value_6);
            }
        }
    }

    private static final class VkCreateShaderModule
    extends AssetProcessorBase {
        private VkCreateShaderModule() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATESHADERMODULE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateShaderModuleDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkShaderModuleCreateInfo arg_pCreateInfo = VULKAN.VkCreateShaderModuleDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateShaderModuleDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pShaderModule = VULKAN.VkCreateShaderModuleDecorator.getArgumentPShaderModule(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateShaderModuleDecorator.getReturnValue(functionCall);
                long shaderModuleAsset_id_value = AssetProcessorBase.asAssetID(arg_pShaderModule);
                VkShaderModuleAsset vkShaderModuleAsset = AssetProcessorBase.createNewVkShaderModuleAsset(currentState, functionCall, shaderModuleAsset_id_value);
            }
        }
    }

    private static final class VkCreateSwapchainKhr
    extends AssetProcessorBase {
        private VkCreateSwapchainKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKCREATESWAPCHAINKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentDevice(functionCall);
                VULKAN.Structs.VkSwapchainCreateInfoKHR arg_pCreateInfo = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPCreateInfo(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPAllocator(functionCall);
                HandleAttachment arg_pSwapchain = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPSwapchain(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkCreateSwapchainKHRDecorator.getReturnValue(functionCall);
                long swapchainAsset_id_value = AssetProcessorBase.asAssetID(arg_pSwapchain);
                AbstractConstantOrAliasSpecExtended temp_getClipped_return_value_0 = arg_pCreateInfo.getClipped();
                Bitfield temp_valueOf_return_value_1 = Bitfield.valueOf(arg_pCreateInfo.getCompositeAlpha());
                Long temp_getImageArrayLayers_return_value_2 = arg_pCreateInfo.getImageArrayLayers();
                long temp_longValue_return_value_3 = temp_getImageArrayLayers_return_value_2;
                AbstractConstantOrAliasSpecExtended temp_getImageColorSpace_return_value_4 = arg_pCreateInfo.getImageColorSpace();
                VULKAN.Structs.VkExtent2D temp_getImageExtent_return_value_5 = arg_pCreateInfo.getImageExtent();
                AbstractConstantOrAliasSpecExtended temp_getImageFormat_return_value_6 = arg_pCreateInfo.getImageFormat();
                AbstractConstantOrAliasSpecExtended temp_getImageSharingMode_return_value_7 = arg_pCreateInfo.getImageSharingMode();
                Bitfield temp_getImageUsage_return_value_8 = arg_pCreateInfo.getImageUsage();
                Bitfield temp_valueOf_return_value_9 = Bitfield.valueOf(arg_pCreateInfo.getPreTransform());
                AbstractConstantOrAliasSpecExtended temp_getPresentMode_return_value_10 = arg_pCreateInfo.getPresentMode();
                LongsArgAttachment temp_getPQueueFamilyIndices_return_value_11 = arg_pCreateInfo.getPQueueFamilyIndices();
                Handle temp_getSurface_return_value_12 = arg_pCreateInfo.getSurface();
                VkSwapchainKHRAsset vkSwapchainKHRAsset = AssetProcessorBase.createNewVkSwapchainKHRAsset(currentState, functionCall, swapchainAsset_id_value, temp_getClipped_return_value_0, temp_valueOf_return_value_1, temp_longValue_return_value_3, temp_getImageColorSpace_return_value_4, temp_getImageExtent_return_value_5, temp_getImageFormat_return_value_6, temp_getImageSharingMode_return_value_7, temp_getImageUsage_return_value_8, temp_valueOf_return_value_9, temp_getPresentMode_return_value_10, temp_getPQueueFamilyIndices_return_value_11, temp_getSurface_return_value_12);
            }
        }
    }

    private static final class VkDestroyBuffer
    extends AssetProcessorBase {
        private VkDestroyBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyBufferDecorator.getArgumentDevice(functionCall);
                Handle arg_buffer = VULKAN.VkDestroyBufferDecorator.getArgumentBuffer(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyBufferDecorator.getArgumentPAllocator(functionCall);
                long deletedBufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                VkBufferAsset deletedBufferAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkBufferAsset(currentState, functionCall, deletedBufferAsset_id_value), deletedBufferAsset_id_value);
                deletedBufferAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForVkBufferAssetOnVkDestroyBuffer(currentState, functionCall, deletedBufferAsset, arg_device, arg_buffer, arg_pAllocator);
                long bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                VkBufferAsset bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (bufferAsset != null) {
                    AssetProcessorBase.deleteVkBufferAsset(currentState, functionCall, bufferAsset);
                }
            }
        }
    }

    private static final class VkDestroyBufferView
    extends AssetProcessorBase {
        private VkDestroyBufferView() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYBUFFERVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyBufferViewDecorator.getArgumentDevice(functionCall);
                Handle arg_bufferView = VULKAN.VkDestroyBufferViewDecorator.getArgumentBufferView(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyBufferViewDecorator.getArgumentPAllocator(functionCall);
                long bufferView_id_value = AssetProcessorBase.asAssetID(arg_bufferView);
                VkBufferViewAsset bufferView = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS, currentState, functionCall, AssetProcessorBase.getVkBufferViewAsset(currentState, functionCall, bufferView_id_value), bufferView_id_value, AssetProcessorBase.asAssetID(0L));
                if (bufferView != null) {
                    AssetProcessorBase.deleteVkBufferViewAsset(currentState, functionCall, bufferView);
                }
            }
        }
    }

    private static final class VkDestroyDescriptorPool
    extends AssetProcessorBase {
        private VkDestroyDescriptorPool() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYDESCRIPTORPOOL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyDescriptorPoolDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorPool = VULKAN.VkDestroyDescriptorPoolDecorator.getArgumentDescriptorPool(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyDescriptorPoolDecorator.getArgumentPAllocator(functionCall);
                long descriptorPoolAsset_id_value = AssetProcessorBase.asAssetID(arg_descriptorPool);
                VkDescriptorPoolAsset descriptorPoolAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDescriptorPoolAsset(currentState, functionCall, descriptorPoolAsset_id_value), descriptorPoolAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (descriptorPoolAsset != null) {
                    AssetProcessorBase.deleteVkDescriptorPoolAsset(currentState, functionCall, descriptorPoolAsset);
                }
            }
        }
    }

    private static final class VkDestroyDescriptorSetLayout
    extends AssetProcessorBase {
        private VkDestroyDescriptorSetLayout() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYDESCRIPTORSETLAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyDescriptorSetLayoutDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorSetLayout = VULKAN.VkDestroyDescriptorSetLayoutDecorator.getArgumentDescriptorSetLayout(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyDescriptorSetLayoutDecorator.getArgumentPAllocator(functionCall);
                long descriptorSetLayoutAsset_id_value = AssetProcessorBase.asAssetID(arg_descriptorSetLayout);
                VkDescriptorSetLayoutAsset descriptorSetLayoutAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDescriptorSetLayoutAsset(currentState, functionCall, descriptorSetLayoutAsset_id_value), descriptorSetLayoutAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (descriptorSetLayoutAsset != null) {
                    AssetProcessorBase.deleteVkDescriptorSetLayoutAsset(currentState, functionCall, descriptorSetLayoutAsset);
                }
            }
        }
    }

    private static final class VkDestroyFramebuffer
    extends AssetProcessorBase {
        private VkDestroyFramebuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyFramebufferDecorator.getArgumentDevice(functionCall);
                Handle arg_framebuffer = VULKAN.VkDestroyFramebufferDecorator.getArgumentFramebuffer(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyFramebufferDecorator.getArgumentPAllocator(functionCall);
                long framebufferAsset_id_value = AssetProcessorBase.asAssetID(arg_framebuffer);
                VkFramebufferAsset framebufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkFramebufferAsset(currentState, functionCall, framebufferAsset_id_value), framebufferAsset_id_value);
                if (framebufferAsset != null) {
                    AssetProcessorBase.deleteVkFramebufferAsset(currentState, functionCall, framebufferAsset);
                }
            }
        }
    }

    private static final class VkDestroyImage
    extends AssetProcessorBase {
        private VkDestroyImage() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyImageDecorator.getArgumentDevice(functionCall);
                Handle arg_image = VULKAN.VkDestroyImageDecorator.getArgumentImage(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyImageDecorator.getArgumentPAllocator(functionCall);
                long deletedImageAsset_id_value = AssetProcessorBase.asAssetID(arg_image);
                VkImageAsset deletedImageAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkImageAsset(currentState, functionCall, deletedImageAsset_id_value), deletedImageAsset_id_value);
                deletedImageAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForVkImageAssetOnVkDestroyImage(currentState, functionCall, deletedImageAsset, arg_device, arg_image, arg_pAllocator);
                long imageAsset_id_value = AssetProcessorBase.asAssetID(arg_image);
                VkImageAsset imageAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkImageAsset(currentState, functionCall, imageAsset_id_value), imageAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (imageAsset != null) {
                    AssetProcessorBase.deleteVkImageAsset(currentState, functionCall, imageAsset);
                }
            }
        }
    }

    private static final class VkDestroyImageView
    extends AssetProcessorBase {
        private VkDestroyImageView() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYIMAGEVIEW.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyImageViewDecorator.getArgumentDevice(functionCall);
                Handle arg_imageView = VULKAN.VkDestroyImageViewDecorator.getArgumentImageView(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyImageViewDecorator.getArgumentPAllocator(functionCall);
                long imageViewAsset_id_value = AssetProcessorBase.asAssetID(arg_imageView);
                VkImageViewAsset imageViewAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS, currentState, functionCall, AssetProcessorBase.getVkImageViewAsset(currentState, functionCall, imageViewAsset_id_value), imageViewAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (imageViewAsset != null) {
                    AssetProcessorBase.deleteVkImageViewAsset(currentState, functionCall, imageViewAsset);
                }
            }
        }
    }

    private static final class VkDestroyPipeline
    extends AssetProcessorBase {
        private VkDestroyPipeline() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYPIPELINE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyPipelineDecorator.getArgumentDevice(functionCall);
                Handle arg_pipeline = VULKAN.VkDestroyPipelineDecorator.getArgumentPipeline(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyPipelineDecorator.getArgumentPAllocator(functionCall);
                long pipelineAsset_id_value = AssetProcessorBase.asAssetID(arg_pipeline);
                VkPipelineAsset pipelineAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkPipelineAsset(currentState, functionCall, pipelineAsset_id_value), pipelineAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (pipelineAsset != null) {
                    AssetProcessorBase.deleteVkPipelineAsset(currentState, functionCall, pipelineAsset);
                }
            }
        }
    }

    private static final class VkDestroyPipelineLayout
    extends AssetProcessorBase {
        private VkDestroyPipelineLayout() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYPIPELINELAYOUT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyPipelineLayoutDecorator.getArgumentDevice(functionCall);
                Handle arg_pipelineLayout = VULKAN.VkDestroyPipelineLayoutDecorator.getArgumentPipelineLayout(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyPipelineLayoutDecorator.getArgumentPAllocator(functionCall);
                long pipelineLayoutAsset_id_value = AssetProcessorBase.asAssetID(arg_pipelineLayout);
                VkPipelineLayoutAsset pipelineLayoutAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS, currentState, functionCall, AssetProcessorBase.getVkPipelineLayoutAsset(currentState, functionCall, pipelineLayoutAsset_id_value), pipelineLayoutAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (pipelineLayoutAsset != null) {
                    AssetProcessorBase.deleteVkPipelineLayoutAsset(currentState, functionCall, pipelineLayoutAsset);
                }
            }
        }
    }

    private static final class VkDestroyRenderPass
    extends AssetProcessorBase {
        private VkDestroyRenderPass() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYRENDERPASS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyRenderPassDecorator.getArgumentDevice(functionCall);
                Handle arg_renderPass = VULKAN.VkDestroyRenderPassDecorator.getArgumentRenderPass(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyRenderPassDecorator.getArgumentPAllocator(functionCall);
                long renderPassAsset_id_value = AssetProcessorBase.asAssetID(arg_renderPass);
                VkRenderPassAsset renderPassAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, currentState, functionCall, AssetProcessorBase.getVkRenderPassAsset(currentState, functionCall, renderPassAsset_id_value), renderPassAsset_id_value);
                if (renderPassAsset != null) {
                    AssetProcessorBase.deleteVkRenderPassAsset(currentState, functionCall, renderPassAsset);
                }
            }
        }
    }

    private static final class VkDestroyShaderModule
    extends AssetProcessorBase {
        private VkDestroyShaderModule() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYSHADERMODULE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroyShaderModuleDecorator.getArgumentDevice(functionCall);
                Handle arg_shaderModule = VULKAN.VkDestroyShaderModuleDecorator.getArgumentShaderModule(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroyShaderModuleDecorator.getArgumentPAllocator(functionCall);
                long shaderModuleAsset_id_value = AssetProcessorBase.asAssetID(arg_shaderModule);
                VkShaderModuleAsset shaderModuleAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkShaderModuleAsset(currentState, functionCall, shaderModuleAsset_id_value), shaderModuleAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (shaderModuleAsset != null) {
                    AssetProcessorBase.deleteVkShaderModuleAsset(currentState, functionCall, shaderModuleAsset);
                }
            }
        }
    }

    private static final class VkDestroySwapchainKhr
    extends AssetProcessorBase {
        private VkDestroySwapchainKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKDESTROYSWAPCHAINKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkDestroySwapchainKHRDecorator.getArgumentDevice(functionCall);
                Handle arg_swapchain = VULKAN.VkDestroySwapchainKHRDecorator.getArgumentSwapchain(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkDestroySwapchainKHRDecorator.getArgumentPAllocator(functionCall);
                long swapchainAsset_id_value = AssetProcessorBase.asAssetID(arg_swapchain);
                VkSwapchainKHRAsset swapchainAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS, currentState, functionCall, AssetProcessorBase.getVkSwapchainKHRAsset(currentState, functionCall, swapchainAsset_id_value), swapchainAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (swapchainAsset != null) {
                    AssetProcessorBase.deleteVkSwapchainKHRAsset(currentState, functionCall, swapchainAsset);
                }
            }
        }
    }

    private static final class VkEndCommandBuffer
    extends AssetProcessorBase {
        private VkEndCommandBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKENDCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_commandBuffer = VULKAN.VkEndCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkEndCommandBufferDecorator.getReturnValue(functionCall);
                long commandBufferAsset_id_value = AssetProcessorBase.asAssetID(arg_commandBuffer);
                VkCommandBufferAsset commandBufferAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkCommandBufferAsset(currentState, functionCall, commandBufferAsset_id_value), commandBufferAsset_id_value);
                commandBufferAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForVkCommandBufferAssetOnVkEndCommandBuffer(currentState, functionCall, commandBufferAsset, arg_commandBuffer, returnValue_);
            }
        }
    }

    private static final class VkFreeCommandBuffers
    extends AssetProcessorBase {
        private VkFreeCommandBuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKFREECOMMANDBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkFreeCommandBuffersDecorator.getArgumentDevice(functionCall);
                Handle arg_commandPool = VULKAN.VkFreeCommandBuffersDecorator.getArgumentCommandPool(functionCall);
                Long arg_commandBufferCount = VULKAN.VkFreeCommandBuffersDecorator.getArgumentCommandBufferCount(functionCall);
                LongsArgAttachment arg_pCommandBuffers = VULKAN.VkFreeCommandBuffersDecorator.getArgumentPCommandBuffers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_pCommandBuffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, allocatedCommandBuffer_id_value -> {
                    VkCommandBufferAsset allocatedCommandBuffer = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkCommandBufferAsset(currentState, functionCall, allocatedCommandBuffer_id_value), allocatedCommandBuffer_id_value);
                    if (allocatedCommandBuffer != null) {
                        AssetProcessorBase.deleteVkCommandBufferAsset(currentState, functionCall, allocatedCommandBuffer);
                    }
                });
            }
        }
    }

    private static final class VkFreeDescriptorSets
    extends AssetProcessorBase {
        private VkFreeDescriptorSets() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKFREEDESCRIPTORSETS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorPool = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentDescriptorPool(functionCall);
                Long arg_descriptorSetCount = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentDescriptorSetCount(functionCall);
                HandleArrayAttachment arg_pDescriptorSets = VULKAN.VkFreeDescriptorSetsDecorator.getArgumentPDescriptorSets(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkFreeDescriptorSetsDecorator.getReturnValue(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_pDescriptorSets);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, allocatedDescriptorSet_id_value -> {
                    VkDescriptorSetAsset allocatedDescriptorSet = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDescriptorSetAsset(currentState, functionCall, allocatedDescriptorSet_id_value), allocatedDescriptorSet_id_value, AssetProcessorBase.asAssetID(0L));
                    if (allocatedDescriptorSet != null) {
                        AssetProcessorBase.deleteVkDescriptorSetAsset(currentState, functionCall, allocatedDescriptorSet);
                    }
                });
            }
        }
    }

    private static final class VkFreeMemory
    extends AssetProcessorBase {
        private VkFreeMemory() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKFREEMEMORY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkFreeMemoryDecorator.getArgumentDevice(functionCall);
                Handle arg_memory = VULKAN.VkFreeMemoryDecorator.getArgumentMemory(functionCall);
                VULKAN.Structs.VkAllocationCallbacks arg_pAllocator = VULKAN.VkFreeMemoryDecorator.getArgumentPAllocator(functionCall);
                long memoryAsset_id_value = AssetProcessorBase.asAssetID(arg_memory);
                VkDeviceMemoryAsset memoryAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDeviceMemoryAsset(currentState, functionCall, memoryAsset_id_value), memoryAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (memoryAsset != null) {
                    AssetProcessorBase.deleteVkDeviceMemoryAsset(currentState, functionCall, memoryAsset);
                }
            }
        }
    }

    private static final class VkGetSwapchainImagesKhr
    extends AssetProcessorBase {
        private VkGetSwapchainImagesKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKGETSWAPCHAINIMAGESKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentDevice(functionCall);
                Handle arg_swapchain = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentSwapchain(functionCall);
                LongPtrArgAttachment arg_pSwapchainImageCount = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentPSwapchainImageCount(functionCall);
                HandleArrayAttachment arg_pSwapchainImages = VULKAN.VkGetSwapchainImagesKHRDecorator.getArgumentPSwapchainImages(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkGetSwapchainImagesKHRDecorator.getReturnValue(functionCall);
                long swapchainAsset_id_value = AssetProcessorBase.asAssetID(arg_swapchain);
                VkSwapchainKHRAsset swapchainAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS, currentState, functionCall, AssetProcessorBase.getVkSwapchainKHRAsset(currentState, functionCall, swapchainAsset_id_value), swapchainAsset_id_value);
                swapchainAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForVkSwapchainKhraSsetOnVkGetSwapchainImagesKhr(currentState, functionCall, swapchainAsset, arg_device, arg_swapchain, arg_pSwapchainImageCount, arg_pSwapchainImages, returnValue_);
            }
        }
    }

    private static final class VkResetCommandBuffer
    extends AssetProcessorBase {
        private VkResetCommandBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKRESETCOMMANDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_commandBuffer = VULKAN.VkResetCommandBufferDecorator.getArgumentCommandBuffer(functionCall);
                Bitfield arg_flags = VULKAN.VkResetCommandBufferDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkResetCommandBufferDecorator.getReturnValue(functionCall);
                long commandBufferAsset_id_value = AssetProcessorBase.asAssetID(arg_commandBuffer);
                VkCommandBufferAsset commandBufferAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkCommandBufferAsset(currentState, functionCall, commandBufferAsset_id_value), commandBufferAsset_id_value);
                commandBufferAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForVkCommandBufferAssetOnVkResetCommandBuffer(currentState, functionCall, commandBufferAsset, arg_commandBuffer, arg_flags, returnValue_);
            }
        }
    }

    private static final class VkResetDescriptorPool
    extends AssetProcessorBase {
        private VkResetDescriptorPool() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.VULKAN.functions.VKRESETDESCRIPTORPOOL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_device = VULKAN.VkResetDescriptorPoolDecorator.getArgumentDevice(functionCall);
                Handle arg_descriptorPool = VULKAN.VkResetDescriptorPoolDecorator.getArgumentDescriptorPool(functionCall);
                Bitfield arg_flags = VULKAN.VkResetDescriptorPoolDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = VULKAN.VkResetDescriptorPoolDecorator.getReturnValue(functionCall);
                long descriptorPoolAsset_id_value = AssetProcessorBase.asAssetID(arg_descriptorPool);
                VkDescriptorPoolAsset descriptorPoolAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDescriptorPoolAsset(currentState, functionCall, descriptorPoolAsset_id_value), descriptorPoolAsset_id_value);
                descriptorPoolAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForVkDescriptorPoolAssetOnVkResetDescriptorPool(currentState, functionCall, descriptorPoolAsset, arg_device, arg_descriptorPool, arg_flags, returnValue_);
            }
        }
    }
}

