/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlImageUnitAsset;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramPipelineAsset;
import com.arm.mgd.core.asset.GlQueryObjectAsset;
import com.arm.mgd.core.asset.GlRenderbufferAsset;
import com.arm.mgd.core.asset.GlSamplerAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlSyncObjectAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.GlTransformFeedbackAsset;
import com.arm.mgd.core.asset.GlUniformBindingPointAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.core.asset.GlVertexBufferBindingAsset;
import com.arm.mgd.core.asset.objects.OneShotPropertyFailureException;
import com.arm.mgd.core.asset.objects.gen.AbstractGlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlUniformBindingPointAsset;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.processors.ProvidedAssetProcessors;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public final class GlesAssetProcessor {
    private static final Map<String, AssetProcessorBase> ASSET_PROCESSORS = new HashMap<String, AssetProcessorBase>(){
        {
            this.put("glActiveShaderProgram", new GlActiveShaderProgram());
            this.put("glActiveTexture", new GlActiveTexture());
            this.put("glAttachShader", new GlAttachShader());
            this.put("glBeginQuery", new GlBeginQuery());
            this.put("glBeginTransformFeedback", new GlBeginTransformFeedback());
            this.put("glBindBuffer", new GlBindBuffer());
            this.put("glBindBufferBase", new GlBindBufferBase());
            this.put("glBindBufferRange", new GlBindBufferRange());
            this.put("glBindFramebuffer", new GlBindFramebuffer());
            this.put("glBindImageTexture", new GlBindImageTexture());
            this.put("glBindProgramPipeline", new GlBindProgramPipeline());
            this.put("glBindRenderbuffer", new GlBindRenderbuffer());
            this.put("glBindSampler", new GlBindSampler());
            this.put("glBindTexture", new GlBindTexture());
            this.put("glBindTransformFeedback", new GlBindTransformFeedback());
            this.put("glBindVertexBuffer", new GlBindVertexBuffer());
            this.put("glClientWaitSync", new GlClientWaitSync());
            this.put("glCompileShader", new GlCompileShader());
            this.put("glCompressedTexImage2D", new GlCompressedTexImage2D());
            this.put("glCompressedTexImage3D", new GlCompressedTexImage3D());
            this.put("glCreateProgram", new GlCreateProgram());
            this.put("glCreateShader", new GlCreateShader());
            this.put("glCreateShaderProgramv", new GlCreateShaderProgramv());
            this.put("glCreateShaderProgramvEXT", new GlCreateShaderProgramvExt());
            this.put("glDeleteBuffers", new GlDeleteBuffers());
            this.put("glDeleteFramebuffers", new GlDeleteFramebuffers());
            this.put("glDeleteProgram", new GlDeleteProgram());
            this.put("glDeleteProgramPipelines", new GlDeleteProgramPipelines());
            this.put("glDeleteQueries", new GlDeleteQueries());
            this.put("glDeleteRenderbuffers", new GlDeleteRenderbuffers());
            this.put("glDeleteSamplers", new GlDeleteSamplers());
            this.put("glDeleteShader", new GlDeleteShader());
            this.put("glDeleteSync", new GlDeleteSync());
            this.put("glDeleteTextures", new GlDeleteTextures());
            this.put("glDeleteTransformFeedbacks", new GlDeleteTransformFeedbacks());
            this.put("glDeleteVertexArrays", new GlDeleteVertexArrays());
            this.put("glDetachShader", new GlDetachShader());
            this.put("glDiscardFramebufferEXT", new GlDiscardFramebufferExt());
            this.put("glEGLImageTargetTexStorageEXT", new GlEgliMageTargetTexStorageExt());
            this.put("glEGLImageTargetTexture2DOES", new GlEgliMageTargetTexture2Does());
            this.put("glEGLImageTargetTextureStorageEXT", new GlEgliMageTargetTextureStorageExt());
            this.put("glEndQuery", new GlEndQuery());
            this.put("glEndTransformFeedback", new GlEndTransformFeedback());
            this.put("glFenceSync", new GlFenceSync());
            this.put("glFramebufferParameteri", new GlFramebufferParameteri());
            this.put("glFramebufferTextureMultisampleMultiviewOVR", new GlFramebufferTextureMultisampleMultiviewOvr());
            this.put("glFramebufferTextureMultiviewOVR", new GlFramebufferTextureMultiviewOvr());
            this.put("glGenBuffers", new GlGenBuffers());
            this.put("glGenFramebuffers", new GlGenFramebuffers());
            this.put("glGenProgramPipelines", new GlGenProgramPipelines());
            this.put("glGenQueries", new GlGenQueries());
            this.put("glGenRenderbuffers", new GlGenRenderbuffers());
            this.put("glGenSamplers", new GlGenSamplers());
            this.put("glGenTextures", new GlGenTextures());
            this.put("glGenTransformFeedbacks", new GlGenTransformFeedbacks());
            this.put("glGenVertexArrays", new GlGenVertexArrays());
            this.put("glGenerateMipmap", new GlGenerateMipmap());
            this.put("glGetQueryObjectuiv", new GlGetQueryObjectuiv());
            this.put("glInvalidateFramebuffer", new GlInvalidateFramebuffer());
            this.put("glInvalidateSubFramebuffer", new GlInvalidateSubFramebuffer());
            this.put("glLinkProgram", new GlLinkProgram());
            this.put("glPauseTransformFeedback", new GlPauseTransformFeedback());
            this.put("glProgramParameteri", new GlProgramParameteri());
            this.put("glRenderbufferStorage", new GlRenderbufferStorage());
            this.put("glRenderbufferStorageMultisample", new GlRenderbufferStorageMultisample());
            this.put("glResumeTransformFeedback", new GlResumeTransformFeedback());
            this.put("glSamplerParameterIiv", new GlSamplerParameterIiv());
            this.put("glSamplerParameterIuiv", new GlSamplerParameterIuiv());
            this.put("glSamplerParameterf", new GlSamplerParameterf());
            this.put("glSamplerParameterfv", new GlSamplerParameterfv());
            this.put("glSamplerParameteri", new GlSamplerParameteri());
            this.put("glSamplerParameteriv", new GlSamplerParameteriv());
            this.put("glShaderBinary", new GlShaderBinary());
            this.put("glTexImage2D", new GlTexImage2D());
            this.put("glTexImage3D", new GlTexImage3D());
            this.put("glTexImage3DOES", new GlTexImage3Does());
            this.put("glTexParameterIiv", new GlTexParameterIiv());
            this.put("glTexParameterIuiv", new GlTexParameterIuiv());
            this.put("glTexParameterf", new GlTexParameterf());
            this.put("glTexParameterfv", new GlTexParameterfv());
            this.put("glTexParameteri", new GlTexParameteri());
            this.put("glTexParameteriv", new GlTexParameteriv());
            this.put("glTexStorage2D", new GlTexStorage2D());
            this.put("glTexStorage2DMultisample", new GlTexStorage2DmUltisample());
            this.put("glTexStorage3D", new GlTexStorage3D());
            this.put("glTexStorage3DMultisample", new GlTexStorage3DmUltisample());
            this.put("glUniform1f", new GlUniform1F());
            this.put("glUniform1fv", new GlUniform1Fv());
            this.put("glUniform1i", new GlUniform1I());
            this.put("glUniform1iv", new GlUniform1Iv());
            this.put("glUniform1ui", new GlUniform1Ui());
            this.put("glUniform1uiv", new GlUniform1Uiv());
            this.put("glUniform2f", new GlUniform2F());
            this.put("glUniform2fv", new GlUniform2Fv());
            this.put("glUniform2i", new GlUniform2I());
            this.put("glUniform2iv", new GlUniform2Iv());
            this.put("glUniform2ui", new GlUniform2Ui());
            this.put("glUniform2uiv", new GlUniform2Uiv());
            this.put("glUniform3f", new GlUniform3F());
            this.put("glUniform3fv", new GlUniform3Fv());
            this.put("glUniform3i", new GlUniform3I());
            this.put("glUniform3iv", new GlUniform3Iv());
            this.put("glUniform3ui", new GlUniform3Ui());
            this.put("glUniform3uiv", new GlUniform3Uiv());
            this.put("glUniform4f", new GlUniform4F());
            this.put("glUniform4fv", new GlUniform4Fv());
            this.put("glUniform4i", new GlUniform4I());
            this.put("glUniform4iv", new GlUniform4Iv());
            this.put("glUniform4ui", new GlUniform4Ui());
            this.put("glUniform4uiv", new GlUniform4Uiv());
            this.put("glUniformMatrix2fv", new GlUniformMatrix2Fv());
            this.put("glUniformMatrix2x3fv", new GlUniformMatrix2X3Fv());
            this.put("glUniformMatrix2x4fv", new GlUniformMatrix2X4Fv());
            this.put("glUniformMatrix3fv", new GlUniformMatrix3Fv());
            this.put("glUniformMatrix3x2fv", new GlUniformMatrix3X2Fv());
            this.put("glUniformMatrix3x4fv", new GlUniformMatrix3X4Fv());
            this.put("glUniformMatrix4fv", new GlUniformMatrix4Fv());
            this.put("glUniformMatrix4x2fv", new GlUniformMatrix4X2Fv());
            this.put("glUniformMatrix4x3fv", new GlUniformMatrix4X3Fv());
            this.put("glUseProgram", new GlUseProgram());
            this.put("glUseProgramStages", new GlUseProgramStages());
            this.put("glVertexAttribBinding", new GlVertexAttribBinding());
            this.put("glVertexAttribDivisor", new GlVertexAttribDivisor());
            this.put("glVertexAttribFormat", new GlVertexAttribFormat());
            this.put("glVertexAttribIFormat", new GlVertexAttribIfOrmat());
            this.put("glVertexBindingDivisor", new GlVertexBindingDivisor());
            this.put("glWaitSync", new GlWaitSync());
        }
    };

    public static final AssetProcessorBase getAssetProcessor(String functionName) {
        return ASSET_PROCESSORS.get(functionName);
    }

    private static class Constants {
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED, KapiSpec.GLES.constants.GL_TIME_ELAPSED_EXT, KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED_CONSERVATIVE, KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, KapiSpec.GLES.constants.GL_TIMESTAMP_EXT, KapiSpec.GLES.constants.GL_PRIMITIVES_GENERATED));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_READ_WRITE, KapiSpec.GLES.constants.GL_READ_ONLY, KapiSpec.GLES.constants.GL_WRITE_ONLY));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_2 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_RGBA32I, KapiSpec.GLES.constants.GL_RGBA8I, KapiSpec.GLES.constants.GL_R32F, KapiSpec.GLES.constants.GL_RGBA8UI, KapiSpec.GLES.constants.GL_R32I, KapiSpec.GLES.constants.GL_RGBA8, KapiSpec.GLES.constants.GL_R32UI, KapiSpec.GLES.constants.GL_RGBA32UI, KapiSpec.GLES.constants.GL_RGBA16F, KapiSpec.GLES.constants.GL_RGBA8_SNORM, KapiSpec.GLES.constants.GL_RGBA16I, KapiSpec.GLES.constants.GL_RGBA16UI, KapiSpec.GLES.constants.GL_RGBA32F));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_3 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY, KapiSpec.GLES.constants.GL_TEXTURE_2D, KapiSpec.GLES.constants.GL_TEXTURE_BUFFER, KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE, KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP, KapiSpec.GLES.constants.GL_TEXTURE_3D, KapiSpec.GLES.constants.GL_TEXTURE_EXTERNAL_OES, KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE_ARRAY, KapiSpec.GLES.constants.GL_TEXTURE_2D_ARRAY));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_4 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER, KapiSpec.GLES.constants.GL_COMPUTE_SHADER, KapiSpec.GLES.constants.GL_GEOMETRY_SHADER, KapiSpec.GLES.constants.GL_FRAGMENT_SHADER, KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER, KapiSpec.GLES.constants.GL_VERTEX_SHADER));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_5 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_GPU_COMMANDS_COMPLETE));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_6 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_FENCE));

        private Constants() {
        }
    }

    private static final class GlActiveShaderProgram
    extends AssetProcessorBase {
        private GlActiveShaderProgram() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLACTIVESHADERPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_pipeline = GLES.GlActiveShaderProgramDecorator.getArgumentPipeline(functionCall);
                Long arg_program = GLES.GlActiveShaderProgramDecorator.getArgumentProgram(functionCall);
                long programPipelineAsset_id_value = AssetProcessorBase.asAssetID(arg_pipeline);
                GlProgramPipelineAsset programPipelineAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramPipelineAsset(currentState, functionCall, programPipelineAsset_id_value), programPipelineAsset_id_value);
                programPipelineAsset.setPreviousModificationFunction(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                GlProgramAsset programAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value, AssetProcessorBase.asAssetID(0L));
                programPipelineAsset.setActiveProgram(programAsset);
            }
        }
    }

    private static final class GlActiveTexture
    extends AssetProcessorBase {
        private GlActiveTexture() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLACTIVETEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_texture = GLES.GlActiveTextureDecorator.getArgumentTexture(functionCall);
                GlTextureUnitAsset textureUnitAsset = ProvidedAssetProcessors.provideGlTextureUnitAssetForGlActiveTexture(currentState, functionCall, arg_texture);
                textureUnitAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlAttachShader
    extends AssetProcessorBase {
        private GlAttachShader() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLATTACHSHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlAttachShaderDecorator.getArgumentProgram(functionCall);
                Long arg_shader = GLES.GlAttachShaderDecorator.getArgumentShader(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                GlProgramAsset programAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value);
                programAsset.setPreviousModificationFunction(functionCall);
                long shaderAsset_id_value = AssetProcessorBase.asAssetID(arg_shader);
                GlShaderAsset shaderAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlShaderAsset(currentState, functionCall, shaderAsset_id_value), shaderAsset_id_value);
                shaderAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlAttachShader(currentState, functionCall, programAsset, arg_program, arg_shader, shaderAsset);
            }
        }
    }

    private static final class GlBeginQuery
    extends AssetProcessorBase {
        private GlBeginQuery() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBEGINQUERY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBeginQueryDecorator.getArgumentTarget(functionCall);
                Long arg_id = GLES.GlBeginQueryDecorator.getArgumentId(functionCall);
                long queryAsset_id_value = AssetProcessorBase.asAssetID(arg_id);
                GlQueryObjectAsset queryAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, currentState, functionCall, AssetProcessorBase.getGlQueryObjectAsset(currentState, functionCall, queryAsset_id_value), queryAsset_id_value);
                queryAsset.setPreviousModificationFunction(functionCall);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_target, Constants.CONSTANT_SET_0);
                queryAsset.setQueryTarget(temp_validateConstantIsInSetLogError_return_value_0);
            }
        }
    }

    private static final class GlBeginTransformFeedback
    extends AssetProcessorBase {
        private GlBeginTransformFeedback() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBEGINTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_primitiveMode = GLES.GlBeginTransformFeedbackDecorator.getArgumentPrimitiveMode(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
                targetAsset.setActive(KapiSpec.GLES.constants.GL_TRUE.equals(KapiSpec.GLES.constants.GL_TRUE));
            }
        }
    }

    private static final class GlBindBuffer
    extends AssetProcessorBase {
        private GlBindBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                GlBufferAsset targetAsset;
                long targetAsset_id_value;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferDecorator.getArgumentTarget(functionCall);
                Long arg_buffer = GLES.GlBindBufferDecorator.getArgumentBuffer(functionCall);
                if (!arg_buffer.equals(0L)) {
                    targetAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, targetAsset_id_value), targetAsset_id_value);
                    targetAsset.setPreviousModificationFunction(functionCall);
                    targetAsset.setLastBoundTarget(arg_target);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_ELEMENT_ARRAY_BUFFER)) {
                    targetAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    targetAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, targetAsset_id_value), targetAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                    GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                    long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                    GlVertexArrayObjectAsset currentVAOAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                    currentVAOAsset.setPreviousModificationFunction(functionCall);
                    currentVAOAsset.setElementArrayBufferBinding(targetAsset);
                }
            }
        }
    }

    private static final class GlBindBufferBase
    extends AssetProcessorBase {
        private GlBindBufferBase() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDBUFFERBASE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractAssetItem bindingAsset;
                long bindingAsset_id_value;
                GlBufferAsset bufferAsset;
                long bufferAsset_id_value;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferBaseDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlBindBufferBaseDecorator.getArgumentIndex(functionCall);
                Long arg_buffer = GLES.GlBindBufferBaseDecorator.getArgumentBuffer(functionCall);
                if (!arg_buffer.equals(0L)) {
                    long targetAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    GlBufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, targetAsset_id_value), targetAsset_id_value);
                    targetAsset.setPreviousModificationFunction(functionCall);
                    targetAsset.setLastBoundTarget(arg_target);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlAtomicCounterBufferBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    ((AbstractGlAtomicCounterBufferBindingPointAsset)bindingAsset).setOffset(0L);
                    long temp_temp_0 = bufferAsset != null ? bufferAsset.getSize() : 0L;
                    ((AbstractGlAtomicCounterBufferBindingPointAsset)bindingAsset).setLength(temp_temp_0);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlShaderStorageBufferBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlShaderStorageBufferBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    ((AbstractGlShaderStorageBufferBindingPointAsset)bindingAsset).setOffset(0L);
                    long temp_temp_1 = bufferAsset != null ? bufferAsset.getSize() : 0L;
                    ((AbstractGlShaderStorageBufferBindingPointAsset)bindingAsset).setLength(temp_temp_1);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlTransformFeedbackBufferBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    ((AbstractGlTransformFeedbackBufferBindingPointAsset)bindingAsset).setOffset(0L);
                    long temp_temp_2 = bufferAsset != null ? bufferAsset.getSize() : 0L;
                    ((AbstractGlTransformFeedbackBufferBindingPointAsset)bindingAsset).setLength(temp_temp_2);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlUniformBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlUniformBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    ((AbstractGlUniformBindingPointAsset)bindingAsset).setOffset(0L);
                    long temp_temp_3 = bufferAsset != null ? bufferAsset.getSize() : 0L;
                    ((AbstractGlUniformBindingPointAsset)bindingAsset).setLength(temp_temp_3);
                    ProvidedAssetProcessors.processProvidedActionForGlUniformBindingPointAssetOnGlBindBufferBase(currentState, functionCall, (GlUniformBindingPointAsset)bindingAsset, arg_target, arg_index, arg_buffer, bufferAsset);
                }
            }
        }
    }

    private static final class GlBindBufferRange
    extends AssetProcessorBase {
        private GlBindBufferRange() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDBUFFERRANGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractAssetItem bindingAsset;
                long bindingAsset_id_value;
                GlBufferAsset bufferAsset;
                long bufferAsset_id_value;
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindBufferRangeDecorator.getArgumentTarget(functionCall);
                Long arg_index = GLES.GlBindBufferRangeDecorator.getArgumentIndex(functionCall);
                Long arg_buffer = GLES.GlBindBufferRangeDecorator.getArgumentBuffer(functionCall);
                Long arg_offset = GLES.GlBindBufferRangeDecorator.getArgumentOffset(functionCall);
                Long arg_size = GLES.GlBindBufferRangeDecorator.getArgumentSize(functionCall);
                if (!arg_buffer.equals(0L)) {
                    long targetAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    GlBufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, targetAsset_id_value), targetAsset_id_value);
                    targetAsset.setPreviousModificationFunction(functionCall);
                    targetAsset.setLastBoundTarget(arg_target);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_ATOMIC_COUNTER_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlAtomicCounterBufferBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    long temp_longValue_return_value_0 = arg_offset;
                    ((AbstractGlAtomicCounterBufferBindingPointAsset)bindingAsset).setOffset(temp_longValue_return_value_0);
                    long temp_longValue_return_value_1 = arg_size;
                    ((AbstractGlAtomicCounterBufferBindingPointAsset)bindingAsset).setLength(temp_longValue_return_value_1);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_SHADER_STORAGE_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlShaderStorageBufferBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlShaderStorageBufferBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    long temp_longValue_return_value_2 = arg_offset;
                    ((AbstractGlShaderStorageBufferBindingPointAsset)bindingAsset).setOffset(temp_longValue_return_value_2);
                    long temp_longValue_return_value_3 = arg_size;
                    ((AbstractGlShaderStorageBufferBindingPointAsset)bindingAsset).setLength(temp_longValue_return_value_3);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlTransformFeedbackBufferBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    long temp_longValue_return_value_4 = arg_offset;
                    ((AbstractGlTransformFeedbackBufferBindingPointAsset)bindingAsset).setOffset(temp_longValue_return_value_4);
                    long temp_longValue_return_value_5 = arg_size;
                    ((AbstractGlTransformFeedbackBufferBindingPointAsset)bindingAsset).setLength(temp_longValue_return_value_5);
                }
                if (arg_target.equals(KapiSpec.GLES.constants.GL_UNIFORM_BUFFER)) {
                    bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                    bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    bindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                    bindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlUniformBindingPointAsset(currentState, functionCall, bindingAsset_id_value), bindingAsset_id_value);
                    bindingAsset.setPreviousModificationFunction(functionCall);
                    ((AbstractGlUniformBindingPointAsset)bindingAsset).setBuffer(bufferAsset);
                    long temp_longValue_return_value_6 = arg_offset;
                    ((AbstractGlUniformBindingPointAsset)bindingAsset).setOffset(temp_longValue_return_value_6);
                    long temp_longValue_return_value_7 = arg_size;
                    ((AbstractGlUniformBindingPointAsset)bindingAsset).setLength(temp_longValue_return_value_7);
                    ProvidedAssetProcessors.processProvidedActionForGlUniformBindingPointAssetOnGlBindBufferRange(currentState, functionCall, (GlUniformBindingPointAsset)bindingAsset, arg_target, arg_index, arg_buffer, arg_offset, arg_size, bufferAsset);
                }
            }
        }
    }

    private static final class GlBindFramebuffer
    extends AssetProcessorBase {
        private GlBindFramebuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindFramebufferDecorator.getArgumentTarget(functionCall);
                Long arg_framebuffer = GLES.GlBindFramebufferDecorator.getArgumentFramebuffer(functionCall);
                long framebufferAsset_id_value = AssetProcessorBase.asAssetID(arg_framebuffer);
                GlFramebufferAsset glFramebufferAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlFramebufferAsset(currentState, functionCall, framebufferAsset_id_value, AssetProcessorBase.asAssetID(0L)), framebufferAsset_id_value);
            }
        }
    }

    private static final class GlBindImageTexture
    extends AssetProcessorBase {
        private GlBindImageTexture() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDIMAGETEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_unit = GLES.GlBindImageTextureDecorator.getArgumentUnit(functionCall);
                Long arg_texture = GLES.GlBindImageTextureDecorator.getArgumentTexture(functionCall);
                Integer arg_level = GLES.GlBindImageTextureDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_layered = GLES.GlBindImageTextureDecorator.getArgumentLayered(functionCall);
                Integer arg_layer = GLES.GlBindImageTextureDecorator.getArgumentLayer(functionCall);
                AbstractConstantOrAliasSpecExtended arg_access = GLES.GlBindImageTextureDecorator.getArgumentAccess(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlBindImageTextureDecorator.getArgumentFormat(functionCall);
                long imageUnitAsset_id_value = AssetProcessorBase.asAssetID(arg_unit);
                GlImageUnitAsset imageUnitAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlImageUnitAsset(currentState, functionCall, imageUnitAsset_id_value), imageUnitAsset_id_value);
                imageUnitAsset.setPreviousModificationFunction(functionCall);
                long textureAsset_id_value = AssetProcessorBase.asAssetID(arg_texture);
                GlTextureAsset textureAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureAsset(currentState, functionCall, textureAsset_id_value, AssetProcessorBase.asAssetID(0L)), textureAsset_id_value);
                imageUnitAsset.setTexture(textureAsset);
                long temp_longValue_return_value_0 = arg_level.longValue();
                imageUnitAsset.setLevel(temp_longValue_return_value_0);
                imageUnitAsset.setLayered(arg_layered.equals(KapiSpec.GLES.constants.GL_TRUE));
                long temp_longValue_return_value_1 = arg_layer.longValue();
                imageUnitAsset.setLayer(temp_longValue_return_value_1);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_access, Constants.CONSTANT_SET_1);
                assert (temp_validateConstantIsInSetLogError_return_value_2 != null);
                imageUnitAsset.setAccess(temp_validateConstantIsInSetLogError_return_value_2);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_3 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_format, Constants.CONSTANT_SET_2);
                assert (temp_validateConstantIsInSetLogError_return_value_3 != null);
                imageUnitAsset.setFormat(temp_validateConstantIsInSetLogError_return_value_3);
            }
        }
    }

    private static final class GlBindProgramPipeline
    extends AssetProcessorBase {
        private GlBindProgramPipeline() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_pipeline;
            assert (KapiSpec.GLES.functions.GLBINDPROGRAMPIPELINE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && !(arg_pipeline = GLES.GlBindProgramPipelineDecorator.getArgumentPipeline(functionCall)).equals(0L)) {
                long programPipelineAsset_id_value = AssetProcessorBase.asAssetID(arg_pipeline);
                GlProgramPipelineAsset programPipelineAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramPipelineAsset(currentState, functionCall, programPipelineAsset_id_value), programPipelineAsset_id_value);
                programPipelineAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlBindRenderbuffer
    extends AssetProcessorBase {
        private GlBindRenderbuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDRENDERBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindRenderbufferDecorator.getArgumentTarget(functionCall);
                Long arg_renderbuffer = GLES.GlBindRenderbufferDecorator.getArgumentRenderbuffer(functionCall);
                if (!arg_renderbuffer.equals(0L)) {
                    long renderbufferAsset_id_value = AssetProcessorBase.asAssetID(arg_renderbuffer);
                    GlRenderbufferAsset glRenderbufferAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlRenderbufferAsset(currentState, functionCall, renderbufferAsset_id_value), renderbufferAsset_id_value);
                }
            }
        }
    }

    private static final class GlBindSampler
    extends AssetProcessorBase {
        private GlBindSampler() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDSAMPLER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_unit = GLES.GlBindSamplerDecorator.getArgumentUnit(functionCall);
                Long arg_sampler = GLES.GlBindSamplerDecorator.getArgumentSampler(functionCall);
                long unitAsset_id_value = AssetProcessorBase.asAssetID(arg_unit);
                GlTextureUnitAsset unitAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlTextureUnitAsset(currentState, functionCall, unitAsset_id_value), unitAsset_id_value);
                unitAsset.setPreviousModificationFunction(functionCall);
                long samplerAsset_id_value = AssetProcessorBase.asAssetID(arg_sampler);
                GlSamplerAsset samplerAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value, AssetProcessorBase.asAssetID(0L));
                unitAsset.setSampler(samplerAsset);
            }
        }
    }

    private static final class GlBindTexture
    extends AssetProcessorBase {
        private GlBindTexture() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDTEXTURE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTextureDecorator.getArgumentTarget(functionCall);
                Long arg_texture = GLES.GlBindTextureDecorator.getArgumentTexture(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_ACTIVE_TEXTURE);
                GlTextureUnitAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlTextureUnitAsset textureUnitAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureUnitAsset.setPreviousModificationFunction(functionCall);
                long textureAsset_id_value = AssetProcessorBase.asAssetID(arg_texture);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureAsset(currentState, functionCall, textureAsset_id_value, AssetProcessorBase.asAssetID(0L)), textureAsset_id_value);
                textureAsset.setPreviousModificationFunction(functionCall);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_3 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_target, Constants.CONSTANT_SET_3);
                assert (temp_validateConstantIsInSet_return_value_3 != null);
                textureUnitAsset.setTextureTargets(temp_validateConstantIsInSet_return_value_3, textureAsset);
                try {
                    textureAsset.setTextureTarget(arg_target);
                }
                catch (OneShotPropertyFailureException oneShotException) {
                    AssetProcessorBase.handleOneShotPropertyFailure(currentState, functionCall, oneShotException);
                }
            }
        }
    }

    private static final class GlBindTransformFeedback
    extends AssetProcessorBase {
        private GlBindTransformFeedback() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlBindTransformFeedbackDecorator.getArgumentTarget(functionCall);
                Long arg_id = GLES.GlBindTransformFeedbackDecorator.getArgumentId(functionCall);
                long targetAsset_id_value = AssetProcessorBase.asAssetID(arg_id);
                GlTransformFeedbackAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTransformFeedbackAsset(currentState, functionCall, targetAsset_id_value, AssetProcessorBase.asAssetID(0L)), targetAsset_id_value);
                targetAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlBindVertexBuffer
    extends AssetProcessorBase {
        private GlBindVertexBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLBINDVERTEXBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_bindingindex = GLES.GlBindVertexBufferDecorator.getArgumentBindingindex(functionCall);
                Long arg_buffer = GLES.GlBindVertexBufferDecorator.getArgumentBuffer(functionCall);
                Long arg_offset = GLES.GlBindVertexBufferDecorator.getArgumentOffset(functionCall);
                Integer arg_stride = GLES.GlBindVertexBufferDecorator.getArgumentStride(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                long vertexBindingAsset_id_value = AssetProcessorBase.asAssetID(arg_bindingindex);
                GlVertexBufferBindingAsset vertexBindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlVertexBufferBindingAsset(currentState, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                vertexBindingAsset.setPreviousModificationFunction(functionCall);
                long bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                GlBufferAsset bufferAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value);
                vertexBindingAsset.setBuffer(bufferAsset);
                long temp_longValue_return_value_3 = arg_offset;
                vertexBindingAsset.setOffset(temp_longValue_return_value_3);
                long temp_longValue_return_value_4 = arg_stride.longValue();
                vertexBindingAsset.setStride(temp_longValue_return_value_4);
            }
        }
    }

    private static final class GlClientWaitSync
    extends AssetProcessorBase {
        private GlClientWaitSync() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCLIENTWAITSYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_sync = GLES.GlClientWaitSyncDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended arg_flags = GLES.GlClientWaitSyncDecorator.getArgumentFlags(functionCall);
                Long arg_timeout = GLES.GlClientWaitSyncDecorator.getArgumentTimeout(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = GLES.GlClientWaitSyncDecorator.getReturnValue(functionCall);
                long syncObjectAsset_id_value = AssetProcessorBase.asAssetID(arg_sync);
                GlSyncObjectAsset syncObjectAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSyncObjectAsset(currentState, functionCall, syncObjectAsset_id_value), syncObjectAsset_id_value);
                syncObjectAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlCompileShader
    extends AssetProcessorBase {
        private GlCompileShader() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCOMPILESHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_shader = GLES.GlCompileShaderDecorator.getArgumentShader(functionCall);
                long shaderAsset_id_value = AssetProcessorBase.asAssetID(arg_shader);
                GlShaderAsset shaderAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlShaderAsset(currentState, functionCall, shaderAsset_id_value), shaderAsset_id_value);
                shaderAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlCompressedTexImage2D
    extends AssetProcessorBase {
        private GlCompressedTexImage2D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlCompressedTexImage2DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlCompressedTexImage2DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlCompressedTexImage2DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlCompressedTexImage2DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlCompressedTexImage2DDecorator.getArgumentHeight(functionCall);
                Integer arg_border = GLES.GlCompressedTexImage2DDecorator.getArgumentBorder(functionCall);
                Integer arg_imageSize = GLES.GlCompressedTexImage2DDecorator.getArgumentImageSize(functionCall);
                TextureArgAttachment arg_data = GLES.GlCompressedTexImage2DDecorator.getArgumentData(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlCompressedTexImage2D(currentState, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_border, arg_imageSize, arg_data);
                long textureImageAsset_id_value = AssetProcessorBase.asAssetID(arg_level.intValue());
                GlTextureImageAsset textureImageAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureImageAsset(currentState, functionCall, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_3 = arg_width.longValue();
                textureImageAsset.setWidth(temp_longValue_return_value_3);
                long temp_longValue_return_value_4 = arg_height.longValue();
                textureImageAsset.setHeight(temp_longValue_return_value_4);
                textureImageAsset.setDepth(1L);
                textureImageAsset.setInternalFormat(arg_internalformat);
            }
        }
    }

    private static final class GlCompressedTexImage3D
    extends AssetProcessorBase {
        private GlCompressedTexImage3D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCOMPRESSEDTEXIMAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlCompressedTexImage3DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlCompressedTexImage3DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlCompressedTexImage3DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlCompressedTexImage3DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlCompressedTexImage3DDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlCompressedTexImage3DDecorator.getArgumentDepth(functionCall);
                Integer arg_border = GLES.GlCompressedTexImage3DDecorator.getArgumentBorder(functionCall);
                Integer arg_imageSize = GLES.GlCompressedTexImage3DDecorator.getArgumentImageSize(functionCall);
                TextureArgAttachment arg_data = GLES.GlCompressedTexImage3DDecorator.getArgumentData(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlCompressedTexImage3D(currentState, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_imageSize, arg_data);
                long textureImageAsset_id_value = AssetProcessorBase.asAssetID(arg_level.intValue());
                GlTextureImageAsset textureImageAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureImageAsset(currentState, functionCall, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_3 = arg_width.longValue();
                textureImageAsset.setWidth(temp_longValue_return_value_3);
                long temp_longValue_return_value_4 = arg_height.longValue();
                textureImageAsset.setHeight(temp_longValue_return_value_4);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                    long temp_longValue_return_value_5 = arg_depth.longValue();
                    textureImageAsset.setDepth(temp_longValue_return_value_5);
                }
                if (!arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                    textureImageAsset.setDepth(1L);
                }
                textureImageAsset.setDepth(1L);
                textureImageAsset.setInternalFormat(arg_internalformat);
            }
        }
    }

    private static final class GlCreateProgram
    extends AssetProcessorBase {
        private GlCreateProgram() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long returnValue_ = GLES.GlCreateProgramDecorator.getReturnValue(functionCall);
                long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                GlProgramAsset returnedAsset = AssetProcessorBase.createNewGlProgramAsset(currentState, functionCall, returnedAsset_id_value);
                AssetProcessorBase.processPossibleReplayOverrideAsset(currentState, functionCall, returnedAsset);
            }
        }
    }

    private static final class GlCreateShader
    extends AssetProcessorBase {
        private GlCreateShader() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATESHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderDecorator.getArgumentType(functionCall);
                Long returnValue_ = GLES.GlCreateShaderDecorator.getReturnValue(functionCall);
                long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_type, Constants.CONSTANT_SET_4);
                GlShaderAsset returnedAsset = AssetProcessorBase.createNewGlShaderAsset(currentState, functionCall, returnedAsset_id_value, temp_validateConstantIsInSet_return_value_0);
                AssetProcessorBase.processPossibleReplayOverrideAsset(currentState, functionCall, returnedAsset);
            }
        }
    }

    private static final class GlCreateShaderProgramv
    extends AssetProcessorBase {
        private GlCreateShaderProgramv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATESHADERPROGRAMV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderProgramvDecorator.getArgumentType(functionCall);
                Integer arg_count = GLES.GlCreateShaderProgramvDecorator.getArgumentCount(functionCall);
                StringsArgAttachment arg_strings = GLES.GlCreateShaderProgramvDecorator.getArgumentStrings(functionCall);
                Long returnValue_ = GLES.GlCreateShaderProgramvDecorator.getReturnValue(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                GlProgramAsset programAsset = AssetProcessorBase.createNewGlProgramAsset(currentState, functionCall, programAsset_id_value);
                ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlCreateShaderProgramv(currentState, functionCall, programAsset, arg_type, arg_count, arg_strings, returnValue_);
            }
        }
    }

    private static final class GlCreateShaderProgramvExt
    extends AssetProcessorBase {
        private GlCreateShaderProgramvExt() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLCREATESHADERPROGRAMVEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentType(functionCall);
                Integer arg_count = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentCount(functionCall);
                StringsArgAttachment arg_strings = GLES.GlCreateShaderProgramvEXTDecorator.getArgumentStrings(functionCall);
                Long returnValue_ = GLES.GlCreateShaderProgramvEXTDecorator.getReturnValue(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                GlProgramAsset programAsset = AssetProcessorBase.createNewGlProgramAsset(currentState, functionCall, programAsset_id_value);
                ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlCreateShaderProgramvExt(currentState, functionCall, programAsset, arg_type, arg_count, arg_strings, returnValue_);
            }
        }
    }

    private static final class GlDeleteBuffers
    extends AssetProcessorBase {
        private GlDeleteBuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteBuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_buffers = GLES.GlDeleteBuffersDecorator.getArgumentBuffers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_buffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, bufferAsset_id_value -> {
                    GlBufferAsset bufferAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.BUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlBufferAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (bufferAsset != null) {
                        AssetProcessorBase.deleteGlBufferAsset(currentState, functionCall, bufferAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteFramebuffers
    extends AssetProcessorBase {
        private GlDeleteFramebuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEFRAMEBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteFramebuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_framebuffers = GLES.GlDeleteFramebuffersDecorator.getArgumentFramebuffers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_framebuffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, framebuffersAsset_id_value -> {
                    GlFramebufferAsset framebuffersAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlFramebufferAsset(currentState, functionCall, framebuffersAsset_id_value, AssetProcessorBase.asAssetID(0L)), framebuffersAsset_id_value);
                    if (framebuffersAsset != null && framebuffersAsset.getId() != AssetProcessorBase.asAssetID(0L)) {
                        AssetProcessorBase.deleteGlFramebufferAsset(currentState, functionCall, framebuffersAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteProgram
    extends AssetProcessorBase {
        private GlDeleteProgram() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_program;
            long programAsset_id_value;
            GlProgramAsset programAsset;
            assert (KapiSpec.GLES.functions.GLDELETEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (programAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value = AssetProcessorBase.asAssetID(arg_program = GLES.GlDeleteProgramDecorator.getArgumentProgram(functionCall))), programAsset_id_value, AssetProcessorBase.asAssetID(0L))) != null) {
                AssetProcessorBase.deleteGlProgramAsset(currentState, functionCall, programAsset);
            }
        }
    }

    private static final class GlDeleteProgramPipelines
    extends AssetProcessorBase {
        private GlDeleteProgramPipelines() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEPROGRAMPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteProgramPipelinesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_pipelines = GLES.GlDeleteProgramPipelinesDecorator.getArgumentPipelines(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_pipelines);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, programPipelineAsset_id_value -> {
                    GlProgramPipelineAsset programPipelineAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramPipelineAsset(currentState, functionCall, programPipelineAsset_id_value), programPipelineAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (programPipelineAsset != null) {
                        AssetProcessorBase.deleteGlProgramPipelineAsset(currentState, functionCall, programPipelineAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteQueries
    extends AssetProcessorBase {
        private GlDeleteQueries() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEQUERIES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteQueriesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlDeleteQueriesDecorator.getArgumentIds(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_ids);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, queryAsset_id_value -> {
                    GlQueryObjectAsset queryAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, currentState, functionCall, AssetProcessorBase.getGlQueryObjectAsset(currentState, functionCall, queryAsset_id_value), queryAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (queryAsset != null) {
                        AssetProcessorBase.deleteGlQueryObjectAsset(currentState, functionCall, queryAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteRenderbuffers
    extends AssetProcessorBase {
        private GlDeleteRenderbuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETERENDERBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteRenderbuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_renderbuffers = GLES.GlDeleteRenderbuffersDecorator.getArgumentRenderbuffers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_renderbuffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, renderbuffersAsset_id_value -> {
                    GlRenderbufferAsset renderbuffersAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlRenderbufferAsset(currentState, functionCall, renderbuffersAsset_id_value), renderbuffersAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (renderbuffersAsset != null) {
                        AssetProcessorBase.deleteGlRenderbufferAsset(currentState, functionCall, renderbuffersAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteSamplers
    extends AssetProcessorBase {
        private GlDeleteSamplers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETESAMPLERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_count = GLES.GlDeleteSamplersDecorator.getArgumentCount(functionCall);
                LongsArgAttachment arg_samplers = GLES.GlDeleteSamplersDecorator.getArgumentSamplers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_samplers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, samplerAsset_id_value -> {
                    GlSamplerAsset samplerAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (samplerAsset != null) {
                        AssetProcessorBase.deleteGlSamplerAsset(currentState, functionCall, samplerAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteShader
    extends AssetProcessorBase {
        private GlDeleteShader() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_shader;
            long shaderAsset_id_value;
            GlShaderAsset shaderAsset;
            assert (KapiSpec.GLES.functions.GLDELETESHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlShaderAsset(currentState, functionCall, shaderAsset_id_value = AssetProcessorBase.asAssetID(arg_shader = GLES.GlDeleteShaderDecorator.getArgumentShader(functionCall))), shaderAsset_id_value, AssetProcessorBase.asAssetID(0L))) != null) {
                AssetProcessorBase.deleteGlShaderAsset(currentState, functionCall, shaderAsset);
            }
        }
    }

    private static final class GlDeleteSync
    extends AssetProcessorBase {
        private GlDeleteSync() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Pointer arg_sync;
            long syncObjectAsset_id_value;
            GlSyncObjectAsset syncObjectAsset;
            assert (KapiSpec.GLES.functions.GLDELETESYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (syncObjectAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSyncObjectAsset(currentState, functionCall, syncObjectAsset_id_value = AssetProcessorBase.asAssetID(arg_sync = GLES.GlDeleteSyncDecorator.getArgumentSync(functionCall))), syncObjectAsset_id_value, AssetProcessorBase.asAssetID(0L))) != null) {
                AssetProcessorBase.deleteGlSyncObjectAsset(currentState, functionCall, syncObjectAsset);
            }
        }
    }

    private static final class GlDeleteTextures
    extends AssetProcessorBase {
        private GlDeleteTextures() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETETEXTURES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteTexturesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_textures = GLES.GlDeleteTexturesDecorator.getArgumentTextures(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_textures);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, textureAsset_id_value -> {
                    GlTextureAsset textureAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureAsset(currentState, functionCall, textureAsset_id_value, AssetProcessorBase.asAssetID(0L)), textureAsset_id_value);
                    if (textureAsset != null && textureAsset.getId() != AssetProcessorBase.asAssetID(0L)) {
                        AssetProcessorBase.deleteGlTextureAsset(currentState, functionCall, textureAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteTransformFeedbacks
    extends AssetProcessorBase {
        private GlDeleteTransformFeedbacks() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETETRANSFORMFEEDBACKS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteTransformFeedbacksDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlDeleteTransformFeedbacksDecorator.getArgumentIds(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_ids);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, transformFeedbackAsset_id_value -> {
                    GlTransformFeedbackAsset transformFeedbackAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTransformFeedbackAsset(currentState, functionCall, transformFeedbackAsset_id_value, AssetProcessorBase.asAssetID(0L)), transformFeedbackAsset_id_value);
                    if (transformFeedbackAsset != null && transformFeedbackAsset.getId() != AssetProcessorBase.asAssetID(0L)) {
                        AssetProcessorBase.deleteGlTransformFeedbackAsset(currentState, functionCall, transformFeedbackAsset);
                    }
                });
            }
        }
    }

    private static final class GlDeleteVertexArrays
    extends AssetProcessorBase {
        private GlDeleteVertexArrays() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDELETEVERTEXARRAYS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlDeleteVertexArraysDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_arrays = GLES.GlDeleteVertexArraysDecorator.getArgumentArrays(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_arrays);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, deletedAsset_id_value -> {
                    GlVertexArrayObjectAsset deletedAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, AssetProcessorBase.getGlVertexArrayObjectAsset(currentState, functionCall, deletedAsset_id_value, AssetProcessorBase.asAssetID(0L)), deletedAsset_id_value);
                    if (deletedAsset != null && deletedAsset.getId() != AssetProcessorBase.asAssetID(0L)) {
                        AssetProcessorBase.deleteGlVertexArrayObjectAsset(currentState, functionCall, deletedAsset);
                    }
                });
            }
        }
    }

    private static final class GlDetachShader
    extends AssetProcessorBase {
        private GlDetachShader() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDETACHSHADER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlDetachShaderDecorator.getArgumentProgram(functionCall);
                Long arg_shader = GLES.GlDetachShaderDecorator.getArgumentShader(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                GlProgramAsset programAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value);
                programAsset.setPreviousModificationFunction(functionCall);
                long shaderAsset_id_value = AssetProcessorBase.asAssetID(arg_shader);
                GlShaderAsset shaderAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlShaderAsset(currentState, functionCall, shaderAsset_id_value), shaderAsset_id_value);
                shaderAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlDetachShader(currentState, functionCall, programAsset, arg_program, arg_shader, shaderAsset);
            }
        }
    }

    private static final class GlDiscardFramebufferExt
    extends AssetProcessorBase {
        private GlDiscardFramebufferExt() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLDISCARDFRAMEBUFFEREXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlDiscardFramebufferEXTDecorator.getArgumentTarget(functionCall);
                Integer arg_numAttachments = GLES.GlDiscardFramebufferEXTDecorator.getArgumentNumAttachments(functionCall);
                LongsArgAttachment arg_attachments = GLES.GlDiscardFramebufferEXTDecorator.getArgumentAttachments(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlEgliMageTargetTexStorageExt
    extends AssetProcessorBase {
        private GlEgliMageTargetTexStorageExt() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXSTORAGEEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentTarget(functionCall);
                Pointer arg_image = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentImage(functionCall);
                Pointer arg_attrib_list = GLES.GlEGLImageTargetTexStorageEXTDecorator.getArgumentAttrib_list(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                textureAsset.setEglImage(arg_image);
            }
        }
    }

    private static final class GlEgliMageTargetTexture2Does
    extends AssetProcessorBase {
        private GlEgliMageTargetTexture2Does() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURE2DOES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEGLImageTargetTexture2DOESDecorator.getArgumentTarget(functionCall);
                Pointer arg_image = GLES.GlEGLImageTargetTexture2DOESDecorator.getArgumentImage(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                textureAsset.setEglImage(arg_image);
            }
        }
    }

    private static final class GlEgliMageTargetTextureStorageExt
    extends AssetProcessorBase {
        private GlEgliMageTargetTextureStorageExt() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLEGLIMAGETARGETTEXTURESTORAGEEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_texture = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentTexture(functionCall);
                Pointer arg_image = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentImage(functionCall);
                Pointer arg_attrib_list = GLES.GlEGLImageTargetTextureStorageEXTDecorator.getArgumentAttrib_list(functionCall);
                long textureAsset_id_value = AssetProcessorBase.asAssetID(arg_texture);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureAsset(currentState, functionCall, textureAsset_id_value, AssetProcessorBase.asAssetID(0L)), textureAsset_id_value);
                textureAsset.setPreviousModificationFunction(functionCall);
                textureAsset.setEglImage(arg_image);
            }
        }
    }

    private static final class GlEndQuery
    extends AssetProcessorBase {
        private GlEndQuery() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLENDQUERY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlEndQueryDecorator.getArgumentTarget(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.QUERY_TARGETS.specObject, arg_target);
                GlQueryObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.QUERY_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlQueryObjectAsset queryAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                queryAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlEndTransformFeedback
    extends AssetProcessorBase {
        private GlEndTransformFeedback() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLENDTRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
                targetAsset.setActive(KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
                targetAsset.setPaused(KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
            }
        }
    }

    private static final class GlFenceSync
    extends AssetProcessorBase {
        private GlFenceSync() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFENCESYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_condition = GLES.GlFenceSyncDecorator.getArgumentCondition(functionCall);
                Bitfield arg_flags = GLES.GlFenceSyncDecorator.getArgumentFlags(functionCall);
                Pointer returnValue_ = GLES.GlFenceSyncDecorator.getReturnValue(functionCall);
                long syncObjectAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, KapiSpec.GLES.constants.GL_SYNC_FENCE, Constants.CONSTANT_SET_6);
                GlSyncObjectAsset syncObjectAsset = AssetProcessorBase.createNewGlSyncObjectAsset(currentState, functionCall, syncObjectAsset_id_value, temp_validateConstantIsInSet_return_value_1);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_condition, Constants.CONSTANT_SET_5);
                assert (temp_validateConstantIsInSet_return_value_0 != null);
                syncObjectAsset.setCondition(temp_validateConstantIsInSet_return_value_0);
                syncObjectAsset.setFlags(arg_flags);
            }
        }
    }

    private static final class GlFramebufferParameteri
    extends AssetProcessorBase {
        private GlFramebufferParameteri() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFRAMEBUFFERPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferParameteriDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlFramebufferParameteriDecorator.getArgumentPname(functionCall);
                Integer arg_param = GLES.GlFramebufferParameteriDecorator.getArgumentParam(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_WIDTH)) {
                    long temp_longValue_return_value_3 = arg_param.longValue();
                    targetAsset.setDefaultWidth(temp_longValue_return_value_3);
                }
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_HEIGHT)) {
                    long temp_longValue_return_value_4 = arg_param.longValue();
                    targetAsset.setDefaultHeight(temp_longValue_return_value_4);
                }
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_LAYERS)) {
                    long temp_longValue_return_value_5 = arg_param.longValue();
                    targetAsset.setDefaultLayers(temp_longValue_return_value_5);
                }
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_SAMPLES)) {
                    long temp_longValue_return_value_6 = arg_param.longValue();
                    targetAsset.setDefaultSamples(temp_longValue_return_value_6);
                }
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS)) {
                    Integer temp_temp_arg_param_7 = arg_param;
                    int temp_temp_8 = temp_temp_arg_param_7 != null ? temp_temp_arg_param_7 : 0;
                    targetAsset.setDefaultFixedSampleLocations(temp_temp_8 != 0);
                }
            }
        }
    }

    private static final class GlFramebufferTextureMultisampleMultiviewOvr
    extends AssetProcessorBase {
        private GlFramebufferTextureMultisampleMultiviewOvr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attachment = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentAttachment(functionCall);
                Long arg_texture = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentTexture(functionCall);
                Integer arg_level = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentLevel(functionCall);
                Integer arg_samples = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentSamples(functionCall);
                Integer arg_baseViewIndex = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentBaseViewIndex(functionCall);
                Integer arg_numViews = GLES.GlFramebufferTextureMultisampleMultiviewOVRDecorator.getArgumentNumViews(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset framebufferAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                framebufferAsset.setPreviousModificationFunction(functionCall);
                long textureAsset_id_value = AssetProcessorBase.asAssetID(arg_texture);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureAsset(currentState, functionCall, textureAsset_id_value, AssetProcessorBase.asAssetID(0L)), textureAsset_id_value);
                ProvidedAssetProcessors.processProvidedActionForGlFramebufferAssetOnGlFramebufferTextureMultisampleMultiviewOvr(currentState, functionCall, framebufferAsset, arg_target, arg_attachment, arg_texture, arg_level, arg_samples, arg_baseViewIndex, arg_numViews, textureAsset);
            }
        }
    }

    private static final class GlFramebufferTextureMultiviewOvr
    extends AssetProcessorBase {
        private GlFramebufferTextureMultiviewOvr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLFRAMEBUFFERTEXTUREMULTIVIEWOVR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attachment = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentAttachment(functionCall);
                Long arg_texture = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentTexture(functionCall);
                Integer arg_level = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentLevel(functionCall);
                Integer arg_baseViewIndex = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentBaseViewIndex(functionCall);
                Integer arg_numViews = GLES.GlFramebufferTextureMultiviewOVRDecorator.getArgumentNumViews(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset framebufferAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                framebufferAsset.setPreviousModificationFunction(functionCall);
                long textureAsset_id_value = AssetProcessorBase.asAssetID(arg_texture);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureAsset(currentState, functionCall, textureAsset_id_value, AssetProcessorBase.asAssetID(0L)), textureAsset_id_value);
                ProvidedAssetProcessors.processProvidedActionForGlFramebufferAssetOnGlFramebufferTextureMultiviewOvr(currentState, functionCall, framebufferAsset, arg_target, arg_attachment, arg_texture, arg_level, arg_baseViewIndex, arg_numViews, textureAsset);
            }
        }
    }

    private static final class GlGenBuffers
    extends AssetProcessorBase {
        private GlGenBuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenBuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_buffers = GLES.GlGenBuffersDecorator.getArgumentBuffers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_buffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, newBufferAsset_id_value -> {
                    GlBufferAsset glBufferAsset = AssetProcessorBase.createNewGlBufferAsset(currentState, functionCall, newBufferAsset_id_value);
                });
            }
        }
    }

    private static final class GlGenFramebuffers
    extends AssetProcessorBase {
        private GlGenFramebuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENFRAMEBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenFramebuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_framebuffers = GLES.GlGenFramebuffersDecorator.getArgumentFramebuffers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_framebuffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, framebuffersAsset_id_value -> {
                    List<AbstractConstantOrAliasSpecExtended> temp_getDefaultPropertyValueForGlFramebufferAssetDrawBuffers_return_value_1 = AssetProcessorBase.getDefaultPropertyValueForGlFramebufferAssetDrawBuffers(currentState, functionCall, framebuffersAsset_id_value);
                    AbstractConstantOrAliasSpecExtended temp_getDefaultPropertyValueForGlFramebufferAssetReadBuffer_return_value_2 = AssetProcessorBase.getDefaultPropertyValueForGlFramebufferAssetReadBuffer(currentState, functionCall, framebuffersAsset_id_value);
                    GlFramebufferAsset glFramebufferAsset = AssetProcessorBase.createNewGlFramebufferAsset(currentState, functionCall, framebuffersAsset_id_value, AssetProcessorBase.asAssetID(0L), temp_getDefaultPropertyValueForGlFramebufferAssetDrawBuffers_return_value_1, temp_getDefaultPropertyValueForGlFramebufferAssetReadBuffer_return_value_2);
                });
            }
        }
    }

    private static final class GlGenProgramPipelines
    extends AssetProcessorBase {
        private GlGenProgramPipelines() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENPROGRAMPIPELINES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenProgramPipelinesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_pipelines = GLES.GlGenProgramPipelinesDecorator.getArgumentPipelines(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_pipelines);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, programPipelineAsset_id_value -> {
                    GlProgramPipelineAsset glProgramPipelineAsset = AssetProcessorBase.createNewGlProgramPipelineAsset(currentState, functionCall, programPipelineAsset_id_value);
                });
            }
        }
    }

    private static final class GlGenQueries
    extends AssetProcessorBase {
        private GlGenQueries() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENQUERIES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenQueriesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlGenQueriesDecorator.getArgumentIds(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_ids);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, queryAsset_id_value -> {
                    GlQueryObjectAsset glQueryObjectAsset = AssetProcessorBase.createNewGlQueryObjectAsset(currentState, functionCall, queryAsset_id_value);
                });
            }
        }
    }

    private static final class GlGenRenderbuffers
    extends AssetProcessorBase {
        private GlGenRenderbuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENRENDERBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenRenderbuffersDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_renderbuffers = GLES.GlGenRenderbuffersDecorator.getArgumentRenderbuffers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_renderbuffers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, renderbuffersAsset_id_value -> {
                    GlRenderbufferAsset glRenderbufferAsset = AssetProcessorBase.createNewGlRenderbufferAsset(currentState, functionCall, renderbuffersAsset_id_value);
                });
            }
        }
    }

    private static final class GlGenSamplers
    extends AssetProcessorBase {
        private GlGenSamplers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENSAMPLERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_count = GLES.GlGenSamplersDecorator.getArgumentCount(functionCall);
                LongsArgAttachment arg_samplers = GLES.GlGenSamplersDecorator.getArgumentSamplers(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_samplers);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, samplerAsset_id_value -> {
                    GlSamplerAsset glSamplerAsset = AssetProcessorBase.createNewGlSamplerAsset(currentState, functionCall, samplerAsset_id_value);
                });
            }
        }
    }

    private static final class GlGenTextures
    extends AssetProcessorBase {
        private GlGenTextures() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENTEXTURES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenTexturesDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_textures = GLES.GlGenTexturesDecorator.getArgumentTextures(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_textures);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, textureAsset_id_value -> {
                    GlTextureAsset glTextureAsset = AssetProcessorBase.createNewGlTextureAsset(currentState, functionCall, textureAsset_id_value, AssetProcessorBase.asAssetID(0L));
                });
            }
        }
    }

    private static final class GlGenTransformFeedbacks
    extends AssetProcessorBase {
        private GlGenTransformFeedbacks() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENTRANSFORMFEEDBACKS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenTransformFeedbacksDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_ids = GLES.GlGenTransformFeedbacksDecorator.getArgumentIds(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_ids);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, transformFeedbackAsset_id_value -> {
                    GlTransformFeedbackAsset glTransformFeedbackAsset = AssetProcessorBase.createNewGlTransformFeedbackAsset(currentState, functionCall, transformFeedbackAsset_id_value, AssetProcessorBase.asAssetID(0L));
                });
            }
        }
    }

    private static final class GlGenVertexArrays
    extends AssetProcessorBase {
        private GlGenVertexArrays() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENVERTEXARRAYS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_n = GLES.GlGenVertexArraysDecorator.getArgumentN(functionCall);
                LongsArgAttachment arg_arrays = GLES.GlGenVertexArraysDecorator.getArgumentArrays(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_arrays);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, createdAsset_id_value -> {
                    GlVertexArrayObjectAsset glVertexArrayObjectAsset = AssetProcessorBase.createNewGlVertexArrayObjectAsset(currentState, functionCall, createdAsset_id_value, AssetProcessorBase.asAssetID(0L));
                });
            }
        }
    }

    private static final class GlGenerateMipmap
    extends AssetProcessorBase {
        private GlGenerateMipmap() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGENERATEMIPMAP.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlGenerateMipmapDecorator.getArgumentTarget(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlGenerateMipmap(currentState, functionCall, textureAsset, arg_target);
            }
        }
    }

    private static final class GlGetQueryObjectuiv
    extends AssetProcessorBase {
        private GlGetQueryObjectuiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLGETQUERYOBJECTUIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_id = GLES.GlGetQueryObjectuivDecorator.getArgumentId(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlGetQueryObjectuivDecorator.getArgumentPname(functionCall);
                LongPtrArgAttachment arg_params = GLES.GlGetQueryObjectuivDecorator.getArgumentParams(functionCall);
                long queryAsset_id_value = AssetProcessorBase.asAssetID(arg_id);
                GlQueryObjectAsset queryAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.QUERY_TRAITS, currentState, functionCall, AssetProcessorBase.getGlQueryObjectAsset(currentState, functionCall, queryAsset_id_value), queryAsset_id_value);
                queryAsset.setPreviousModificationFunction(functionCall);
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_QUERY_RESULT)) {
                    queryAsset.setQueryResult(arg_params.getValue());
                }
                if (arg_pname.equals(KapiSpec.GLES.constants.GL_QUERY_RESULT_AVAILABLE)) {
                    queryAsset.setResultAvailable(arg_params.getValue() != 0L);
                }
            }
        }
    }

    private static final class GlInvalidateFramebuffer
    extends AssetProcessorBase {
        private GlInvalidateFramebuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLINVALIDATEFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlInvalidateFramebufferDecorator.getArgumentTarget(functionCall);
                Integer arg_numAttachments = GLES.GlInvalidateFramebufferDecorator.getArgumentNumAttachments(functionCall);
                LongsArgAttachment arg_attachments = GLES.GlInvalidateFramebufferDecorator.getArgumentAttachments(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlInvalidateSubFramebuffer
    extends AssetProcessorBase {
        private GlInvalidateSubFramebuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLINVALIDATESUBFRAMEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlInvalidateSubFramebufferDecorator.getArgumentTarget(functionCall);
                Integer arg_numAttachments = GLES.GlInvalidateSubFramebufferDecorator.getArgumentNumAttachments(functionCall);
                LongsArgAttachment arg_attachments = GLES.GlInvalidateSubFramebufferDecorator.getArgumentAttachments(functionCall);
                Integer arg_x = GLES.GlInvalidateSubFramebufferDecorator.getArgumentX(functionCall);
                Integer arg_y = GLES.GlInvalidateSubFramebufferDecorator.getArgumentY(functionCall);
                Integer arg_width = GLES.GlInvalidateSubFramebufferDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlInvalidateSubFramebufferDecorator.getArgumentHeight(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.FRAMEBUFFER_TARGETS.specObject, arg_target);
                GlFramebufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlFramebufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlLinkProgram
    extends AssetProcessorBase {
        private GlLinkProgram() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLLINKPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlLinkProgramDecorator.getArgumentProgram(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                GlProgramAsset programAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value);
                programAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlLinkProgram(currentState, functionCall, programAsset, arg_program);
            }
        }
    }

    private static final class GlPauseTransformFeedback
    extends AssetProcessorBase {
        private GlPauseTransformFeedback() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLPAUSETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
                targetAsset.setPaused(KapiSpec.GLES.constants.GL_TRUE.equals(KapiSpec.GLES.constants.GL_TRUE));
            }
        }
    }

    private static final class GlProgramParameteri
    extends AssetProcessorBase {
        private GlProgramParameteri() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLPROGRAMPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_program = GLES.GlProgramParameteriDecorator.getArgumentProgram(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlProgramParameteriDecorator.getArgumentPname(functionCall);
                Integer arg_value = GLES.GlProgramParameteriDecorator.getArgumentValue(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                GlProgramAsset programAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value);
                programAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlProgramParameteri(currentState, functionCall, programAsset, arg_program, arg_pname, arg_value);
            }
        }
    }

    private static final class GlRenderbufferStorage
    extends AssetProcessorBase {
        private GlRenderbufferStorage() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlRenderbufferStorageDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlRenderbufferStorageDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlRenderbufferStorageDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlRenderbufferStorageDecorator.getArgumentHeight(functionCall);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_RENDERBUFFER)) {
                    StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_RENDERBUFFER_BINDING);
                    GlRenderbufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                    long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                    GlRenderbufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                    targetAsset.setPreviousModificationFunction(functionCall);
                    targetAsset.setInternalFormat(arg_internalformat);
                    int temp_intValue_return_value_3 = arg_width;
                    targetAsset.setWidth(temp_intValue_return_value_3);
                    int temp_intValue_return_value_4 = arg_height;
                    targetAsset.setHeight(temp_intValue_return_value_4);
                    targetAsset.setSamples(0L);
                }
            }
        }
    }

    private static final class GlRenderbufferStorageMultisample
    extends AssetProcessorBase {
        private GlRenderbufferStorageMultisample() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLRENDERBUFFERSTORAGEMULTISAMPLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentTarget(functionCall);
                Integer arg_samples = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentSamples(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlRenderbufferStorageMultisampleDecorator.getArgumentHeight(functionCall);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_RENDERBUFFER)) {
                    StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_RENDERBUFFER_BINDING);
                    GlRenderbufferAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                    long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                    GlRenderbufferAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                    targetAsset.setPreviousModificationFunction(functionCall);
                    targetAsset.setInternalFormat(arg_internalformat);
                    int temp_intValue_return_value_3 = arg_width;
                    targetAsset.setWidth(temp_intValue_return_value_3);
                    int temp_intValue_return_value_4 = arg_height;
                    targetAsset.setHeight(temp_intValue_return_value_4);
                    long temp_longValue_return_value_5 = arg_samples.longValue();
                    targetAsset.setSamples(temp_longValue_return_value_5);
                }
            }
        }
    }

    private static final class GlResumeTransformFeedback
    extends AssetProcessorBase {
        private GlResumeTransformFeedback() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLRESUMETRANSFORMFEEDBACK.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_TRANSFORM_FEEDBACK_BINDING);
                GlTransformFeedbackAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlTransformFeedbackAsset targetAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                targetAsset.setPreviousModificationFunction(functionCall);
                targetAsset.setPaused(KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
            }
        }
    }

    private static final class GlSamplerParameterIiv
    extends AssetProcessorBase {
        private GlSamplerParameterIiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterIivDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterIivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_param = GLES.GlSamplerParameterIivDecorator.getArgumentParam(functionCall);
                long samplerAsset_id_value = AssetProcessorBase.asAssetID(arg_sampler);
                GlSamplerAsset samplerAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterIiv(currentState, functionCall, samplerAsset, arg_sampler, arg_pname, arg_param);
            }
        }
    }

    private static final class GlSamplerParameterIuiv
    extends AssetProcessorBase {
        private GlSamplerParameterIuiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIUIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterIuivDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterIuivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_param = GLES.GlSamplerParameterIuivDecorator.getArgumentParam(functionCall);
                long samplerAsset_id_value = AssetProcessorBase.asAssetID(arg_sampler);
                GlSamplerAsset samplerAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterIuiv(currentState, functionCall, samplerAsset, arg_sampler, arg_pname, arg_param);
            }
        }
    }

    private static final class GlSamplerParameterf
    extends AssetProcessorBase {
        private GlSamplerParameterf() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERF.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterfDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterfDecorator.getArgumentPname(functionCall);
                Float arg_param = GLES.GlSamplerParameterfDecorator.getArgumentParam(functionCall);
                long samplerAsset_id_value = AssetProcessorBase.asAssetID(arg_sampler);
                GlSamplerAsset samplerAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterf(currentState, functionCall, samplerAsset, arg_sampler, arg_pname, arg_param);
            }
        }
    }

    private static final class GlSamplerParameterfv
    extends AssetProcessorBase {
        private GlSamplerParameterfv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERFV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterfvDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterfvDecorator.getArgumentPname(functionCall);
                FloatsArgAttachment arg_param = GLES.GlSamplerParameterfvDecorator.getArgumentParam(functionCall);
                long samplerAsset_id_value = AssetProcessorBase.asAssetID(arg_sampler);
                GlSamplerAsset samplerAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameterfv(currentState, functionCall, samplerAsset, arg_sampler, arg_pname, arg_param);
            }
        }
    }

    private static final class GlSamplerParameteri
    extends AssetProcessorBase {
        private GlSamplerParameteri() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameteriDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameteriDecorator.getArgumentPname(functionCall);
                AbstractConstantOrAliasSpecExtended arg_param = GLES.GlSamplerParameteriDecorator.getArgumentParam(functionCall);
                long samplerAsset_id_value = AssetProcessorBase.asAssetID(arg_sampler);
                GlSamplerAsset samplerAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameteri(currentState, functionCall, samplerAsset, arg_sampler, arg_pname, arg_param);
            }
        }
    }

    private static final class GlSamplerParameteriv
    extends AssetProcessorBase {
        private GlSamplerParameteriv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSAMPLERPARAMETERIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_sampler = GLES.GlSamplerParameterivDecorator.getArgumentSampler(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlSamplerParameterivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_param = GLES.GlSamplerParameterivDecorator.getArgumentParam(functionCall);
                long samplerAsset_id_value = AssetProcessorBase.asAssetID(arg_sampler);
                GlSamplerAsset samplerAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SAMPLER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, samplerAsset_id_value), samplerAsset_id_value);
                samplerAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameteriv(currentState, functionCall, samplerAsset, arg_sampler, arg_pname, arg_param);
            }
        }
    }

    private static final class GlShaderBinary
    extends AssetProcessorBase {
        private GlShaderBinary() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLSHADERBINARY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Integer arg_count = GLES.GlShaderBinaryDecorator.getArgumentCount(functionCall);
                LongsArgAttachment arg_shaders = GLES.GlShaderBinaryDecorator.getArgumentShaders(functionCall);
                AbstractConstantOrAliasSpecExtended arg_binaryformat = GLES.GlShaderBinaryDecorator.getArgumentBinaryformat(functionCall);
                BufferArgAttachment arg_binary = GLES.GlShaderBinaryDecorator.getArgumentBinary(functionCall);
                Integer arg_length = GLES.GlShaderBinaryDecorator.getArgumentLength(functionCall);
                List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_shaders);
                AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, shaderAsset_id_value -> {
                    GlShaderAsset shaderAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SHADER_TRAITS, currentState, functionCall, AssetProcessorBase.getGlShaderAsset(currentState, functionCall, shaderAsset_id_value), shaderAsset_id_value);
                    shaderAsset.setPreviousModificationFunction(functionCall);
                    shaderAsset.setBinaryFormat(arg_binaryformat);
                });
            }
        }
    }

    private static final class GlTexImage2D
    extends AssetProcessorBase {
        private GlTexImage2D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXIMAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage2DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlTexImage2DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage2DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexImage2DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexImage2DDecorator.getArgumentHeight(functionCall);
                Integer arg_border = GLES.GlTexImage2DDecorator.getArgumentBorder(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage2DDecorator.getArgumentFormat(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage2DDecorator.getArgumentType(functionCall);
                TextureArgAttachment arg_pixels = GLES.GlTexImage2DDecorator.getArgumentPixels(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage2D(currentState, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_border, arg_format, arg_type, arg_pixels);
                long textureImageAsset_id_value = AssetProcessorBase.asAssetID(arg_level.intValue());
                GlTextureImageAsset textureImageAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureImageAsset(currentState, functionCall, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_3 = arg_width.longValue();
                textureImageAsset.setWidth(temp_longValue_return_value_3);
                long temp_longValue_return_value_4 = arg_height.longValue();
                textureImageAsset.setHeight(temp_longValue_return_value_4);
                textureImageAsset.setDepth(1L);
                textureImageAsset.setInternalFormat(arg_internalformat);
                textureImageAsset.setCompressed(false);
            }
        }
    }

    private static final class GlTexImage3D
    extends AssetProcessorBase {
        private GlTexImage3D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXIMAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage3DDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlTexImage3DDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage3DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexImage3DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexImage3DDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexImage3DDecorator.getArgumentDepth(functionCall);
                Integer arg_border = GLES.GlTexImage3DDecorator.getArgumentBorder(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage3DDecorator.getArgumentFormat(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage3DDecorator.getArgumentType(functionCall);
                TextureArgAttachment arg_pixels = GLES.GlTexImage3DDecorator.getArgumentPixels(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage3D(currentState, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_format, arg_type, arg_pixels);
                long textureImageAsset_id_value = AssetProcessorBase.asAssetID(arg_level.intValue());
                GlTextureImageAsset textureImageAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureImageAsset(currentState, functionCall, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_3 = arg_width.longValue();
                textureImageAsset.setWidth(temp_longValue_return_value_3);
                long temp_longValue_return_value_4 = arg_height.longValue();
                textureImageAsset.setHeight(temp_longValue_return_value_4);
                if (arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                    long temp_longValue_return_value_5 = arg_depth.longValue();
                    textureImageAsset.setDepth(temp_longValue_return_value_5);
                }
                if (!arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D)) {
                    textureImageAsset.setDepth(1L);
                }
                textureImageAsset.setInternalFormat(arg_internalformat);
                textureImageAsset.setCompressed(false);
            }
        }
    }

    private static final class GlTexImage3Does
    extends AssetProcessorBase {
        private GlTexImage3Does() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXIMAGE3DOES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexImage3DOESDecorator.getArgumentTarget(functionCall);
                Integer arg_level = GLES.GlTexImage3DOESDecorator.getArgumentLevel(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexImage3DOESDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexImage3DOESDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexImage3DOESDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexImage3DOESDecorator.getArgumentDepth(functionCall);
                Integer arg_border = GLES.GlTexImage3DOESDecorator.getArgumentBorder(functionCall);
                AbstractConstantOrAliasSpecExtended arg_format = GLES.GlTexImage3DOESDecorator.getArgumentFormat(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlTexImage3DOESDecorator.getArgumentType(functionCall);
                TextureArgAttachment arg_pixels = GLES.GlTexImage3DOESDecorator.getArgumentPixels(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexImage3Does(currentState, functionCall, textureAsset, arg_target, arg_level, arg_internalformat, arg_width, arg_height, arg_depth, arg_border, arg_format, arg_type, arg_pixels);
                long textureImageAsset_id_value = AssetProcessorBase.asAssetID(arg_level.intValue());
                GlTextureImageAsset textureImageAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_SURFACE_IMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlTextureImageAsset(currentState, functionCall, textureSurfaceAsset, textureImageAsset_id_value), textureImageAsset_id_value);
                textureImageAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_3 = arg_width.longValue();
                textureImageAsset.setWidth(temp_longValue_return_value_3);
                long temp_longValue_return_value_4 = arg_height.longValue();
                textureImageAsset.setHeight(temp_longValue_return_value_4);
                long temp_longValue_return_value_5 = arg_depth.longValue();
                textureImageAsset.setDepth(temp_longValue_return_value_5);
                textureImageAsset.setInternalFormat(arg_internalformat);
                textureImageAsset.setCompressed(false);
            }
        }
    }

    private static final class GlTexParameterIiv
    extends AssetProcessorBase {
        private GlTexParameterIiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERIIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterIivDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterIivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_params = GLES.GlTexParameterIivDecorator.getArgumentParams(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterIiv(currentState, functionCall, textureAsset, arg_target, arg_pname, arg_params);
            }
        }
    }

    private static final class GlTexParameterIuiv
    extends AssetProcessorBase {
        private GlTexParameterIuiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERIUIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterIuivDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterIuivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_params = GLES.GlTexParameterIuivDecorator.getArgumentParams(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterIuiv(currentState, functionCall, textureAsset, arg_target, arg_pname, arg_params);
            }
        }
    }

    private static final class GlTexParameterf
    extends AssetProcessorBase {
        private GlTexParameterf() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERF.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterfDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterfDecorator.getArgumentPname(functionCall);
                Float arg_param = GLES.GlTexParameterfDecorator.getArgumentParam(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterf(currentState, functionCall, textureAsset, arg_target, arg_pname, arg_param);
            }
        }
    }

    private static final class GlTexParameterfv
    extends AssetProcessorBase {
        private GlTexParameterfv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERFV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterfvDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterfvDecorator.getArgumentPname(functionCall);
                FloatsArgAttachment arg_params = GLES.GlTexParameterfvDecorator.getArgumentParams(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameterfv(currentState, functionCall, textureAsset, arg_target, arg_pname, arg_params);
            }
        }
    }

    private static final class GlTexParameteri
    extends AssetProcessorBase {
        private GlTexParameteri() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameteriDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameteriDecorator.getArgumentPname(functionCall);
                AbstractConstantOrAliasSpecExtended arg_param = GLES.GlTexParameteriDecorator.getArgumentParam(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameteri(currentState, functionCall, textureAsset, arg_target, arg_pname, arg_param);
            }
        }
    }

    private static final class GlTexParameteriv
    extends AssetProcessorBase {
        private GlTexParameteriv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXPARAMETERIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexParameterivDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended arg_pname = GLES.GlTexParameterivDecorator.getArgumentPname(functionCall);
                LongsArgAttachment arg_params = GLES.GlTexParameterivDecorator.getArgumentParams(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameteriv(currentState, functionCall, textureAsset, arg_target, arg_pname, arg_params);
            }
        }
    }

    private static final class GlTexStorage2D
    extends AssetProcessorBase {
        private GlTexStorage2D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage2DDecorator.getArgumentTarget(functionCall);
                Integer arg_levels = GLES.GlTexStorage2DDecorator.getArgumentLevels(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage2DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage2DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage2DDecorator.getArgumentHeight(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage2D(currentState, functionCall, textureAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height), textureSurfaceAsset_asset_value -> {
                    GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                    AssetProcessorBase.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage2D(currentState, functionCall, textureSurfaceAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height), textureImageAsset_asset_value -> {
                        GlTextureImageAsset textureImageAsset = textureImageAsset_asset_value;
                        textureImageAsset.setPreviousModificationFunction(functionCall);
                        ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage2D(currentState, functionCall, textureImageAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height);
                    });
                });
            }
        }
    }

    private static final class GlTexStorage2DmUltisample
    extends AssetProcessorBase {
        private GlTexStorage2DmUltisample() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE2DMULTISAMPLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage2DMultisampleDecorator.getArgumentTarget(functionCall);
                Integer arg_samples = GLES.GlTexStorage2DMultisampleDecorator.getArgumentSamples(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage2DMultisampleDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage2DMultisampleDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage2DMultisampleDecorator.getArgumentHeight(functionCall);
                AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations = GLES.GlTexStorage2DMultisampleDecorator.getArgumentFixedsamplelocations(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                GlTextureSurfaceAsset textureSurfaceAsset = ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage2DmUltisample(currentState, functionCall, textureAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_fixedsamplelocations);
                GlTextureImageAsset textureImageAsset = ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage2DmUltisample(currentState, functionCall, textureSurfaceAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_fixedsamplelocations);
                textureImageAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage2DmUltisample(currentState, functionCall, textureImageAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_fixedsamplelocations);
            }
        }
    }

    private static final class GlTexStorage3D
    extends AssetProcessorBase {
        private GlTexStorage3D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage3DDecorator.getArgumentTarget(functionCall);
                Integer arg_levels = GLES.GlTexStorage3DDecorator.getArgumentLevels(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage3DDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage3DDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage3DDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexStorage3DDecorator.getArgumentDepth(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage3D(currentState, functionCall, textureAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height, arg_depth), textureSurfaceAsset_asset_value -> {
                    GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                    AssetProcessorBase.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage3D(currentState, functionCall, textureSurfaceAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height, arg_depth), textureImageAsset_asset_value -> {
                        GlTextureImageAsset textureImageAsset = textureImageAsset_asset_value;
                        textureImageAsset.setPreviousModificationFunction(functionCall);
                        ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage3D(currentState, functionCall, textureImageAsset, arg_target, arg_levels, arg_internalformat, arg_width, arg_height, arg_depth);
                    });
                });
            }
        }
    }

    private static final class GlTexStorage3DmUltisample
    extends AssetProcessorBase {
        private GlTexStorage3DmUltisample() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLTEXSTORAGE3DMULTISAMPLE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                AbstractConstantOrAliasSpecExtended arg_target = GLES.GlTexStorage3DMultisampleDecorator.getArgumentTarget(functionCall);
                Integer arg_samples = GLES.GlTexStorage3DMultisampleDecorator.getArgumentSamples(functionCall);
                AbstractConstantOrAliasSpecExtended arg_internalformat = GLES.GlTexStorage3DMultisampleDecorator.getArgumentInternalformat(functionCall);
                Integer arg_width = GLES.GlTexStorage3DMultisampleDecorator.getArgumentWidth(functionCall);
                Integer arg_height = GLES.GlTexStorage3DMultisampleDecorator.getArgumentHeight(functionCall);
                Integer arg_depth = GLES.GlTexStorage3DMultisampleDecorator.getArgumentDepth(functionCall);
                AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations = GLES.GlTexStorage3DMultisampleDecorator.getArgumentFixedsamplelocations(functionCall);
                StateItem temp_mapTargetToStateValue_return_value_0 = AssetProcessorBase.mapTargetToStateValue(currentState, functionCall, KapiSpec.GLES.targetBindingMaps.TEXTURE_FACE_TARGET.specObject, arg_target);
                GlTextureAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapTargetToStateValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_mapTargetToStateValue_return_value_0);
                GlTextureAsset textureAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.TEXTURE_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                textureAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.forEachAssetItem(ProvidedAssetProcessors.provideGlTextureSurfaceAssetForGlTexStorage3DmUltisample(currentState, functionCall, textureAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_depth, arg_fixedsamplelocations), textureSurfaceAsset_asset_value -> {
                    GlTextureSurfaceAsset textureSurfaceAsset = textureSurfaceAsset_asset_value;
                    GlTextureImageAsset textureImageAsset = ProvidedAssetProcessors.provideGlTextureImageAssetForGlTexStorage3DmUltisample(currentState, functionCall, textureSurfaceAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_depth, arg_fixedsamplelocations);
                    textureImageAsset.setPreviousModificationFunction(functionCall);
                    ProvidedAssetProcessors.processProvidedActionForGlTextureImageAssetOnGlTexStorage3DmUltisample(currentState, functionCall, textureImageAsset, arg_target, arg_samples, arg_internalformat, arg_width, arg_height, arg_depth, arg_fixedsamplelocations);
                });
            }
        }
    }

    private static final class GlUniform1F
    extends AssetProcessorBase {
        private GlUniform1F() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Float arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM1F.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform1F(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform1F(currentState, functionCall, arg_location = GLES.GlUniform1fDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform1fDecorator.getArgumentV0(functionCall)), arg_location, arg_v0)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform1F(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0);
            }
        }
    }

    private static final class GlUniform1Fv
    extends AssetProcessorBase {
        private GlUniform1Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM1FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform1Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform1Fv(currentState, functionCall, arg_location = GLES.GlUniform1fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform1fvDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform1fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform1Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform1I
    extends AssetProcessorBase {
        private GlUniform1I() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Integer arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM1I.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform1I(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform1I(currentState, functionCall, arg_location = GLES.GlUniform1iDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform1iDecorator.getArgumentV0(functionCall)), arg_location, arg_v0)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform1I(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0);
            }
        }
    }

    private static final class GlUniform1Iv
    extends AssetProcessorBase {
        private GlUniform1Iv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM1IV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform1Iv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform1Iv(currentState, functionCall, arg_location = GLES.GlUniform1ivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform1ivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform1ivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform1Iv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform1Ui
    extends AssetProcessorBase {
        private GlUniform1Ui() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM1UI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform1Ui(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform1Ui(currentState, functionCall, arg_location = GLES.GlUniform1uiDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform1uiDecorator.getArgumentV0(functionCall)), arg_location, arg_v0)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform1Ui(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0);
            }
        }
    }

    private static final class GlUniform1Uiv
    extends AssetProcessorBase {
        private GlUniform1Uiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM1UIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform1Uiv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform1Uiv(currentState, functionCall, arg_location = GLES.GlUniform1uivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform1uivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform1uivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform1Uiv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform2F
    extends AssetProcessorBase {
        private GlUniform2F() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Float arg_v1;
            Float arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM2F.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform2F(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform2F(currentState, functionCall, arg_location = GLES.GlUniform2fDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform2fDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform2fDecorator.getArgumentV1(functionCall)), arg_location, arg_v0, arg_v1)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform2F(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1);
            }
        }
    }

    private static final class GlUniform2Fv
    extends AssetProcessorBase {
        private GlUniform2Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM2FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform2Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform2Fv(currentState, functionCall, arg_location = GLES.GlUniform2fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform2fvDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform2fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform2Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform2I
    extends AssetProcessorBase {
        private GlUniform2I() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Integer arg_v1;
            Integer arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM2I.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform2I(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform2I(currentState, functionCall, arg_location = GLES.GlUniform2iDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform2iDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform2iDecorator.getArgumentV1(functionCall)), arg_location, arg_v0, arg_v1)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform2I(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1);
            }
        }
    }

    private static final class GlUniform2Iv
    extends AssetProcessorBase {
        private GlUniform2Iv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM2IV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform2Iv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform2Iv(currentState, functionCall, arg_location = GLES.GlUniform2ivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform2ivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform2ivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform2Iv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform2Ui
    extends AssetProcessorBase {
        private GlUniform2Ui() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_v1;
            Long arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM2UI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform2Ui(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform2Ui(currentState, functionCall, arg_location = GLES.GlUniform2uiDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform2uiDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform2uiDecorator.getArgumentV1(functionCall)), arg_location, arg_v0, arg_v1)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform2Ui(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1);
            }
        }
    }

    private static final class GlUniform2Uiv
    extends AssetProcessorBase {
        private GlUniform2Uiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM2UIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform2Uiv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform2Uiv(currentState, functionCall, arg_location = GLES.GlUniform2uivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform2uivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform2uivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform2Uiv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform3F
    extends AssetProcessorBase {
        private GlUniform3F() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Float arg_v2;
            Float arg_v1;
            Float arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM3F.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform3F(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform3F(currentState, functionCall, arg_location = GLES.GlUniform3fDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform3fDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform3fDecorator.getArgumentV1(functionCall), arg_v2 = GLES.GlUniform3fDecorator.getArgumentV2(functionCall)), arg_location, arg_v0, arg_v1, arg_v2)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform3F(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2);
            }
        }
    }

    private static final class GlUniform3Fv
    extends AssetProcessorBase {
        private GlUniform3Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM3FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform3Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform3Fv(currentState, functionCall, arg_location = GLES.GlUniform3fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform3fvDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform3fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform3Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform3I
    extends AssetProcessorBase {
        private GlUniform3I() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Integer arg_v2;
            Integer arg_v1;
            Integer arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM3I.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform3I(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform3I(currentState, functionCall, arg_location = GLES.GlUniform3iDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform3iDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform3iDecorator.getArgumentV1(functionCall), arg_v2 = GLES.GlUniform3iDecorator.getArgumentV2(functionCall)), arg_location, arg_v0, arg_v1, arg_v2)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform3I(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2);
            }
        }
    }

    private static final class GlUniform3Iv
    extends AssetProcessorBase {
        private GlUniform3Iv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM3IV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform3Iv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform3Iv(currentState, functionCall, arg_location = GLES.GlUniform3ivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform3ivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform3ivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform3Iv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform3Ui
    extends AssetProcessorBase {
        private GlUniform3Ui() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_v2;
            Long arg_v1;
            Long arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM3UI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform3Ui(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform3Ui(currentState, functionCall, arg_location = GLES.GlUniform3uiDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform3uiDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform3uiDecorator.getArgumentV1(functionCall), arg_v2 = GLES.GlUniform3uiDecorator.getArgumentV2(functionCall)), arg_location, arg_v0, arg_v1, arg_v2)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform3Ui(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2);
            }
        }
    }

    private static final class GlUniform3Uiv
    extends AssetProcessorBase {
        private GlUniform3Uiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM3UIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform3Uiv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform3Uiv(currentState, functionCall, arg_location = GLES.GlUniform3uivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform3uivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform3uivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform3Uiv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform4F
    extends AssetProcessorBase {
        private GlUniform4F() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Float arg_v3;
            Float arg_v2;
            Float arg_v1;
            Float arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM4F.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform4F(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform4F(currentState, functionCall, arg_location = GLES.GlUniform4fDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform4fDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform4fDecorator.getArgumentV1(functionCall), arg_v2 = GLES.GlUniform4fDecorator.getArgumentV2(functionCall), arg_v3 = GLES.GlUniform4fDecorator.getArgumentV3(functionCall)), arg_location, arg_v0, arg_v1, arg_v2, arg_v3)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform4F(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2, arg_v3);
            }
        }
    }

    private static final class GlUniform4Fv
    extends AssetProcessorBase {
        private GlUniform4Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM4FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform4Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform4Fv(currentState, functionCall, arg_location = GLES.GlUniform4fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform4fvDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform4fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform4Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform4I
    extends AssetProcessorBase {
        private GlUniform4I() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Integer arg_v3;
            Integer arg_v2;
            Integer arg_v1;
            Integer arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM4I.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform4I(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform4I(currentState, functionCall, arg_location = GLES.GlUniform4iDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform4iDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform4iDecorator.getArgumentV1(functionCall), arg_v2 = GLES.GlUniform4iDecorator.getArgumentV2(functionCall), arg_v3 = GLES.GlUniform4iDecorator.getArgumentV3(functionCall)), arg_location, arg_v0, arg_v1, arg_v2, arg_v3)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform4I(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2, arg_v3);
            }
        }
    }

    private static final class GlUniform4Iv
    extends AssetProcessorBase {
        private GlUniform4Iv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM4IV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform4Iv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform4Iv(currentState, functionCall, arg_location = GLES.GlUniform4ivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform4ivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform4ivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform4Iv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniform4Ui
    extends AssetProcessorBase {
        private GlUniform4Ui() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_v3;
            Long arg_v2;
            Long arg_v1;
            Long arg_v0;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM4UI.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform4Ui(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform4Ui(currentState, functionCall, arg_location = GLES.GlUniform4uiDecorator.getArgumentLocation(functionCall), arg_v0 = GLES.GlUniform4uiDecorator.getArgumentV0(functionCall), arg_v1 = GLES.GlUniform4uiDecorator.getArgumentV1(functionCall), arg_v2 = GLES.GlUniform4uiDecorator.getArgumentV2(functionCall), arg_v3 = GLES.GlUniform4uiDecorator.getArgumentV3(functionCall)), arg_location, arg_v0, arg_v1, arg_v2, arg_v3)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform4Ui(currentState, functionCall, shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2, arg_v3);
            }
        }
    }

    private static final class GlUniform4Uiv
    extends AssetProcessorBase {
        private GlUniform4Uiv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            LongsArgAttachment arg_value;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORM4UIV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniform4Uiv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniform4Uiv(currentState, functionCall, arg_location = GLES.GlUniform4uivDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniform4uivDecorator.getArgumentCount(functionCall), arg_value = GLES.GlUniform4uivDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniform4Uiv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix2Fv
    extends AssetProcessorBase {
        private GlUniformMatrix2Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX2FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix2Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix2Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix2fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix2fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix2fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix2fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix2Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix2X3Fv
    extends AssetProcessorBase {
        private GlUniformMatrix2X3Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX2X3FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix2X3Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix2X3Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix2x3fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix2x3fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix2x3fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix2x3fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix2X3Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix2X4Fv
    extends AssetProcessorBase {
        private GlUniformMatrix2X4Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX2X4FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix2X4Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix2X4Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix2x4fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix2x4fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix2x4fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix2x4fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix2X4Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix3Fv
    extends AssetProcessorBase {
        private GlUniformMatrix3Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX3FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix3Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix3Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix3fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix3fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix3fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix3fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix3Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix3X2Fv
    extends AssetProcessorBase {
        private GlUniformMatrix3X2Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX3X2FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix3X2Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix3X2Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix3x2fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix3x2fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix3x2fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix3x2fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix3X2Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix3X4Fv
    extends AssetProcessorBase {
        private GlUniformMatrix3X4Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX3X4FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix3X4Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix3X4Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix3x4fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix3x4fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix3x4fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix3x4fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix3X4Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix4Fv
    extends AssetProcessorBase {
        private GlUniformMatrix4Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX4FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix4Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix4Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix4fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix4fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix4fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix4fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix4Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix4X2Fv
    extends AssetProcessorBase {
        private GlUniformMatrix4X2Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX4X2FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix4X2Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix4X2Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix4x2fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix4x2fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix4x2fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix4x2fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix4X2Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUniformMatrix4X3Fv
    extends AssetProcessorBase {
        private GlUniformMatrix4X3Fv() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            FloatsArgAttachment arg_value;
            AbstractConstantOrAliasSpecExtended arg_transpose;
            Integer arg_count;
            Integer arg_location;
            GlProgramAsset currentProgramAsset;
            ShaderUniform shaderUniformAsset;
            assert (KapiSpec.GLES.functions.GLUNIFORMMATRIX4X3FV.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (shaderUniformAsset = ProvidedAssetProcessors.provideShaderUniformForGlUniformMatrix4X3Fv(currentState, functionCall, currentProgramAsset = ProvidedAssetProcessors.provideGlProgramAssetForGlUniformMatrix4X3Fv(currentState, functionCall, arg_location = GLES.GlUniformMatrix4x3fvDecorator.getArgumentLocation(functionCall), arg_count = GLES.GlUniformMatrix4x3fvDecorator.getArgumentCount(functionCall), arg_transpose = GLES.GlUniformMatrix4x3fvDecorator.getArgumentTranspose(functionCall), arg_value = GLES.GlUniformMatrix4x3fvDecorator.getArgumentValue(functionCall)), arg_location, arg_count, arg_transpose, arg_value)) != null) {
                shaderUniformAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForShaderUniformOnGlUniformMatrix4X3Fv(currentState, functionCall, shaderUniformAsset, arg_location, arg_count, arg_transpose, arg_value);
            }
        }
    }

    private static final class GlUseProgram
    extends AssetProcessorBase {
        private GlUseProgram() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            Long arg_program;
            long programAsset_id_value;
            GlProgramAsset programAsset;
            assert (KapiSpec.GLES.functions.GLUSEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError() && (programAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value = AssetProcessorBase.asAssetID(arg_program = GLES.GlUseProgramDecorator.getArgumentProgram(functionCall))), programAsset_id_value, AssetProcessorBase.asAssetID(0L))) != null) {
                programAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class GlUseProgramStages
    extends AssetProcessorBase {
        private GlUseProgramStages() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLUSEPROGRAMSTAGES.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_pipeline = GLES.GlUseProgramStagesDecorator.getArgumentPipeline(functionCall);
                Bitfield arg_stages = GLES.GlUseProgramStagesDecorator.getArgumentStages(functionCall);
                Long arg_program = GLES.GlUseProgramStagesDecorator.getArgumentProgram(functionCall);
                long programPipelineAsset_id_value = AssetProcessorBase.asAssetID(arg_pipeline);
                GlProgramPipelineAsset programPipelineAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramPipelineAsset(currentState, functionCall, programPipelineAsset_id_value), programPipelineAsset_id_value);
                programPipelineAsset.setPreviousModificationFunction(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                GlProgramAsset programAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.GLES.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getGlProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value, AssetProcessorBase.asAssetID(0L));
                ProvidedAssetProcessors.processProvidedActionForGlProgramPipelineAssetOnGlUseProgramStages(currentState, functionCall, programPipelineAsset, arg_pipeline, arg_stages, arg_program, programAsset);
            }
        }
    }

    private static final class GlVertexAttribBinding
    extends AssetProcessorBase {
        private GlVertexAttribBinding() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBBINDING.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_attribindex = GLES.GlVertexAttribBindingDecorator.getArgumentAttribindex(functionCall);
                Long arg_bindingindex = GLES.GlVertexAttribBindingDecorator.getArgumentBindingindex(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                long vertexAttributeAsset_id_value = AssetProcessorBase.asAssetID(arg_attribindex);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(currentState, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = vertexAttributeAsset_id_value != AssetProcessorBase.asAssetID(-1L) ? AssetProcessorBase.getOrCreateNewGlVertexAttributeAsset(currentState, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, currentState, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.setPreviousModificationFunction(functionCall);
                long vertexBindingAsset_id_value = AssetProcessorBase.asAssetID(arg_bindingindex);
                GlVertexBufferBindingAsset vertexBindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlVertexBufferBindingAsset(currentState, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                vertexAttributeAsset.setVboBinding(vertexBindingAsset);
            }
        }
    }

    private static final class GlVertexAttribDivisor
    extends AssetProcessorBase {
        private GlVertexAttribDivisor() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBDIVISOR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_index = GLES.GlVertexAttribDivisorDecorator.getArgumentIndex(functionCall);
                Long arg_divisor = GLES.GlVertexAttribDivisorDecorator.getArgumentDivisor(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                long vertexAttributeAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(currentState, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = vertexAttributeAsset_id_value != AssetProcessorBase.asAssetID(-1L) ? AssetProcessorBase.getOrCreateNewGlVertexAttributeAsset(currentState, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, currentState, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.setPreviousModificationFunction(functionCall);
                long vertexBindingAsset_id_value = AssetProcessorBase.asAssetID(arg_index);
                GlVertexBufferBindingAsset vertexBindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlVertexBufferBindingAsset(currentState, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                vertexBindingAsset.setPreviousModificationFunction(functionCall);
                vertexAttributeAsset.setVboBinding(vertexBindingAsset);
                long temp_longValue_return_value_5 = arg_divisor;
                vertexBindingAsset.setDivisor(temp_longValue_return_value_5);
            }
        }
    }

    private static final class GlVertexAttribFormat
    extends AssetProcessorBase {
        private GlVertexAttribFormat() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBFORMAT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_attribindex = GLES.GlVertexAttribFormatDecorator.getArgumentAttribindex(functionCall);
                Integer arg_size = GLES.GlVertexAttribFormatDecorator.getArgumentSize(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlVertexAttribFormatDecorator.getArgumentType(functionCall);
                AbstractConstantOrAliasSpecExtended arg_normalized = GLES.GlVertexAttribFormatDecorator.getArgumentNormalized(functionCall);
                Long arg_relativeoffset = GLES.GlVertexAttribFormatDecorator.getArgumentRelativeoffset(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                long vertexAttributeAsset_id_value = AssetProcessorBase.asAssetID(arg_attribindex);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(currentState, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = vertexAttributeAsset_id_value != AssetProcessorBase.asAssetID(-1L) ? AssetProcessorBase.getOrCreateNewGlVertexAttributeAsset(currentState, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, currentState, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_5 = arg_size.longValue();
                vertexAttributeAsset.setArraySize(temp_longValue_return_value_5);
                vertexAttributeAsset.setArrayType(arg_type);
                vertexAttributeAsset.setArrayNormalized(arg_normalized.equals(KapiSpec.GLES.constants.GL_TRUE));
                long temp_longValue_return_value_6 = arg_relativeoffset;
                vertexAttributeAsset.setVboRelativeOffset(temp_longValue_return_value_6);
                vertexAttributeAsset.setArrayInteger(KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
            }
        }
    }

    private static final class GlVertexAttribIfOrmat
    extends AssetProcessorBase {
        private GlVertexAttribIfOrmat() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXATTRIBIFORMAT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_attribindex = GLES.GlVertexAttribIFormatDecorator.getArgumentAttribindex(functionCall);
                Integer arg_size = GLES.GlVertexAttribIFormatDecorator.getArgumentSize(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = GLES.GlVertexAttribIFormatDecorator.getArgumentType(functionCall);
                Long arg_relativeoffset = GLES.GlVertexAttribIFormatDecorator.getArgumentRelativeoffset(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                long vertexAttributeAsset_id_value = AssetProcessorBase.asAssetID(arg_attribindex);
                GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(currentState, functionCall, vertexAttributeAsset_id_value);
                assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3 != null);
                GlVertexAttributeAsset temp_temp_4 = vertexAttributeAsset_id_value != AssetProcessorBase.asAssetID(-1L) ? AssetProcessorBase.getOrCreateNewGlVertexAttributeAsset(currentState, functionCall, vertexArrayAsset, vertexAttributeAsset_id_value, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_3) : null;
                GlVertexAttributeAsset vertexAttributeAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_TRAITS, currentState, functionCall, temp_temp_4, vertexAttributeAsset_id_value);
                vertexAttributeAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_5 = arg_size.longValue();
                vertexAttributeAsset.setArraySize(temp_longValue_return_value_5);
                vertexAttributeAsset.setArrayType(arg_type);
                long temp_longValue_return_value_6 = arg_relativeoffset;
                vertexAttributeAsset.setVboRelativeOffset(temp_longValue_return_value_6);
                vertexAttributeAsset.setArrayInteger(KapiSpec.GLES.constants.GL_TRUE.equals(KapiSpec.GLES.constants.GL_TRUE));
                vertexAttributeAsset.setArrayNormalized(KapiSpec.GLES.constants.GL_FALSE.equals(KapiSpec.GLES.constants.GL_TRUE));
            }
        }
    }

    private static final class GlVertexBindingDivisor
    extends AssetProcessorBase {
        private GlVertexBindingDivisor() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLVERTEXBINDINGDIVISOR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Long arg_bindingindex = GLES.GlVertexBindingDivisorDecorator.getArgumentBindingindex(functionCall);
                Long arg_divisor = GLES.GlVertexBindingDivisorDecorator.getArgumentDivisor(functionCall);
                StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
                GlVertexArrayObjectAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                GlVertexArrayObjectAsset vertexArrayAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                long vertexBindingAsset_id_value = AssetProcessorBase.asAssetID(arg_bindingindex);
                GlVertexBufferBindingAsset vertexBindingAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.VERTEX_BUFFER_BINDING_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewGlVertexBufferBindingAsset(currentState, functionCall, vertexArrayAsset, vertexBindingAsset_id_value), vertexBindingAsset_id_value);
                vertexBindingAsset.setPreviousModificationFunction(functionCall);
                long temp_longValue_return_value_3 = arg_divisor;
                vertexBindingAsset.setDivisor(temp_longValue_return_value_3);
            }
        }
    }

    private static final class GlWaitSync
    extends AssetProcessorBase {
        private GlWaitSync() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.GLES.functions.GLWAITSYNC.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_sync = GLES.GlWaitSyncDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended arg_flags = GLES.GlWaitSyncDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended arg_timeout = GLES.GlWaitSyncDecorator.getArgumentTimeout(functionCall);
                long syncObjectAsset_id_value = AssetProcessorBase.asAssetID(arg_sync);
                GlSyncObjectAsset syncObjectAsset = AssetProcessorBase.requireAsset(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS, currentState, functionCall, AssetProcessorBase.getGlSyncObjectAsset(currentState, functionCall, syncObjectAsset_id_value), syncObjectAsset_id_value);
                syncObjectAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }
}

