/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors.gen;

import com.arm.mgd.core.asset.EglConfigAsset;
import com.arm.mgd.core.asset.EglContextAsset;
import com.arm.mgd.core.asset.EglDisplayAsset;
import com.arm.mgd.core.asset.EglImageAsset;
import com.arm.mgd.core.asset.EglPbufferSurfaceAsset;
import com.arm.mgd.core.asset.EglPixmapSurfaceAsset;
import com.arm.mgd.core.asset.EglSurfaceAsset;
import com.arm.mgd.core.asset.EglSyncAsset;
import com.arm.mgd.core.asset.EglWindowSurfaceAsset;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.processors.ProvidedAssetProcessors;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.EGL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public final class EglAssetProcessor {
    private static final Map<String, AssetProcessorBase> ASSET_PROCESSORS = new HashMap<String, AssetProcessorBase>(){
        {
            this.put("eglBindTexImage", new EglBindTexImage());
            this.put("eglChooseConfig", new EglChooseConfig());
            this.put("eglCopyBuffers", new EglCopyBuffers());
            this.put("eglCreateContext", new EglCreateContext());
            this.put("eglCreateImageKHR", new EglCreateImageKhr());
            this.put("eglCreatePbufferFromClientBuffer", new EglCreatePbufferFromClientBuffer());
            this.put("eglCreatePbufferSurface", new EglCreatePbufferSurface());
            this.put("eglCreatePixmapSurface", new EglCreatePixmapSurface());
            this.put("eglCreatePlatformWindowSurfaceEXT", new EglCreatePlatformWindowSurfaceExt());
            this.put("eglCreateSync64KHR", new EglCreateSync64Khr());
            this.put("eglCreateSyncKHR", new EglCreateSyncKhr());
            this.put("eglCreateWindowSurface", new EglCreateWindowSurface());
            this.put("eglDestroyContext", new EglDestroyContext());
            this.put("eglDestroyImageKHR", new EglDestroyImageKhr());
            this.put("eglDestroySurface", new EglDestroySurface());
            this.put("eglDestroySyncKHR", new EglDestroySyncKhr());
            this.put("eglGetConfigAttrib", new EglGetConfigAttrib());
            this.put("eglGetConfigs", new EglGetConfigs());
            this.put("eglGetDisplay", new EglGetDisplay());
            this.put("eglGetSyncAttribKHR", new EglGetSyncAttribKhr());
            this.put("eglInitialize", new EglInitialize());
            this.put("eglLockSurfaceKHR", new EglLockSurfaceKhr());
            this.put("eglMakeCurrent", new EglMakeCurrent());
            this.put("eglQueryContext", new EglQueryContext());
            this.put("eglQuerySurface", new EglQuerySurface());
            this.put("eglQuerySurface64KHR", new EglQuerySurface64Khr());
            this.put("eglReleaseTexImage", new EglReleaseTexImage());
            this.put("eglSurfaceAttrib", new EglSurfaceAttrib());
            this.put("eglSwapBuffers", new EglSwapBuffers());
            this.put("eglTerminate", new EglTerminate());
            this.put("eglUnlockSurfaceKHR", new EglUnlockSurfaceKhr());
        }
    };

    public static final AssetProcessorBase getAssetProcessor(String functionName) {
        return ASSET_PROCESSORS.get(functionName);
    }

    private static class Constants {
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_GREEN_SIZE, KapiSpec.EGL.constants.EGL_NATIVE_VISUAL_ID, KapiSpec.EGL.constants.EGL_NATIVE_VISUAL_TYPE, KapiSpec.EGL.constants.EGL_DEPTH_SIZE, KapiSpec.EGL.constants.EGL_CONFIG_CAVEAT, KapiSpec.EGL.constants.EGL_ALPHA_SIZE, KapiSpec.EGL.constants.EGL_LEVEL, KapiSpec.EGL.constants.EGL_MIN_SWAP_INTERVAL, KapiSpec.EGL.constants.EGL_SURFACE_TYPE, KapiSpec.EGL.constants.EGL_TRANSPARENT_GREEN_VALUE, KapiSpec.EGL.constants.EGL_NONE, KapiSpec.EGL.constants.EGL_RECORDABLE_ANDROID, KapiSpec.EGL.constants.EGL_LUMINANCE_SIZE, KapiSpec.EGL.constants.EGL_FRAMEBUFFER_TARGET_ANDROID, KapiSpec.EGL.constants.EGL_MATCH_NATIVE_PIXMAP, KapiSpec.EGL.constants.EGL_MAX_SWAP_INTERVAL, KapiSpec.EGL.constants.EGL_RED_SIZE, KapiSpec.EGL.constants.EGL_BUFFER_SIZE, KapiSpec.EGL.constants.EGL_TRANSPARENT_BLUE_VALUE, KapiSpec.EGL.constants.EGL_BLUE_SIZE, KapiSpec.EGL.constants.EGL_BIND_TO_TEXTURE_RGBA, KapiSpec.EGL.constants.EGL_SAMPLES, KapiSpec.EGL.constants.EGL_ALPHA_MASK_SIZE, KapiSpec.EGL.constants.EGL_TRANSPARENT_RED_VALUE, KapiSpec.EGL.constants.EGL_TRANSPARENT_TYPE, KapiSpec.EGL.constants.EGL_NATIVE_RENDERABLE, KapiSpec.EGL.constants.EGL_MATCH_FORMAT_KHR, KapiSpec.EGL.constants.EGL_BIND_TO_TEXTURE_RGB, KapiSpec.EGL.constants.EGL_CONFORMANT, KapiSpec.EGL.constants.EGL_MAX_PBUFFER_PIXELS, KapiSpec.EGL.constants.EGL_MAX_PBUFFER_WIDTH, KapiSpec.EGL.constants.EGL_SAMPLE_BUFFERS, KapiSpec.EGL.constants.EGL_RENDERABLE_TYPE, KapiSpec.EGL.constants.EGL_MAX_PBUFFER_HEIGHT, KapiSpec.EGL.constants.EGL_CONFIG_ID, KapiSpec.EGL.constants.EGL_COLOR_BUFFER_TYPE, KapiSpec.EGL.constants.EGL_STENCIL_SIZE));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_NONE, KapiSpec.EGL.constants.EGL_CONTEXT_MINOR_VERSION_KHR, KapiSpec.EGL.constants.EGL_CONTEXT_OPENGL_RESET_NOTIFICATION_STRATEGY_KHR, KapiSpec.EGL.constants.EGL_CONTEXT_CLIENT_TYPE, KapiSpec.EGL.constants.EGL_CONTEXT_CLIENT_VERSION, KapiSpec.EGL.constants.EGL_CONTEXT_OPENGL_PROFILE_MASK_KHR, KapiSpec.EGL.constants.EGL_CONFIG_ID, KapiSpec.EGL.constants.EGL_RENDER_BUFFER, KapiSpec.EGL.constants.EGL_CONTEXT_PRIORITY_LEVEL_IMG, KapiSpec.EGL.constants.EGL_CONTEXT_FLAGS_KHR));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_2 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_IMAGE_CROP_LEFT_ANDROID, KapiSpec.EGL.constants.EGL_IMAGE_CROP_TOP_ANDROID, KapiSpec.EGL.constants.EGL_DRM_BUFFER_FORMAT_MESA, KapiSpec.EGL.constants.EGL_HEIGHT, KapiSpec.EGL.constants.EGL_WIDTH, KapiSpec.EGL.constants.EGL_IMAGE_CROP_RIGHT_ANDROID, KapiSpec.EGL.constants.EGL_IMAGE_PRESERVED_KHR, KapiSpec.EGL.constants.EGL_WAYLAND_PLANE_WL, KapiSpec.EGL.constants.EGL_GL_TEXTURE_ZOFFSET_KHR, KapiSpec.EGL.constants.EGL_DRM_BUFFER_STRIDE_MESA, KapiSpec.EGL.constants.EGL_GL_TEXTURE_LEVEL_KHR, KapiSpec.EGL.constants.EGL_IMAGE_CROP_BOTTOM_ANDROID));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_3 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_GL_RENDERBUFFER_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_2D_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_KHR, KapiSpec.EGL.constants.EGL_NATIVE_BUFFER_ANDROID, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_3D_KHR));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_4 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_FRONT_BUFFER_AUTO_REFRESH_ANDROID, KapiSpec.EGL.constants.EGL_MIPMAP_TEXTURE, KapiSpec.EGL.constants.EGL_RENDER_BUFFER, KapiSpec.EGL.constants.EGL_TEXTURE_FORMAT, KapiSpec.EGL.constants.EGL_LARGEST_PBUFFER, KapiSpec.EGL.constants.EGL_PIXEL_ASPECT_RATIO, KapiSpec.EGL.constants.EGL_HORIZONTAL_RESOLUTION, KapiSpec.EGL.constants.EGL_VG_ALPHA_FORMAT, KapiSpec.EGL.constants.EGL_NONE, KapiSpec.EGL.constants.EGL_SWAP_BEHAVIOR, KapiSpec.EGL.constants.EGL_MIPMAP_LEVEL, KapiSpec.EGL.constants.EGL_TEXTURE_TARGET, KapiSpec.EGL.constants.EGL_HEIGHT, KapiSpec.EGL.constants.EGL_WIDTH, KapiSpec.EGL.constants.EGL_VERTICAL_RESOLUTION, KapiSpec.EGL.constants.EGL_MULTISAMPLE_RESOLVE, KapiSpec.EGL.constants.ALIAS_EGL_GL_COLORSPACE_KHR, KapiSpec.EGL.constants.EGL_VG_COLORSPACE));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_5 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_SYNC_CONDITION_KHR, KapiSpec.EGL.constants.EGL_SYNC_STATUS_KHR, KapiSpec.EGL.constants.EGL_SYNC_TYPE_KHR, KapiSpec.EGL.constants.EGL_SYNC_NATIVE_FENCE_FD_ANDROID));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_6 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_SYNC_NATIVE_FENCE_ANDROID, KapiSpec.EGL.constants.EGL_SYNC_REUSABLE_KHR, KapiSpec.EGL.constants.EGL_SYNC_CL_EVENT_KHR, KapiSpec.EGL.constants.EGL_SYNC_FENCE_KHR));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_7 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_UNSIGNALED_KHR, KapiSpec.EGL.constants.EGL_SIGNALED_KHR));

        private Constants() {
        }
    }

    private static final class EglBindTexImage
    extends AssetProcessorBase {
        private EglBindTexImage() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLBINDTEXIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglBindTexImageDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglBindTexImageDecorator.getArgumentSurface(functionCall);
                Integer arg_buffer = EGL.EglBindTexImageDecorator.getArgumentBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglBindTexImageDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglPbufferSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglPbufferSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                    StateItem temp_getStateItemValue_return_value_0 = AssetProcessorBase.getStateItemValue(currentState, functionCall, KapiSpec.EGL.states.EGL_CURRENT_CONTEXT);
                    EglContextAsset temp_mapStateValueToAssetObject_return_value_1 = AssetProcessorBase.mapStateValueToAssetObject(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, currentState, functionCall, temp_getStateItemValue_return_value_0);
                    long temp_asAssetID_return_value_2 = AssetProcessorBase.asAssetID(temp_getStateItemValue_return_value_0);
                    EglContextAsset currentContextAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, currentState, functionCall, temp_mapStateValueToAssetObject_return_value_1, temp_asAssetID_return_value_2);
                    surfaceAsset.setSourceContext(currentContextAsset);
                    surfaceAsset.setBoundTexture(arg_buffer);
                }
            }
        }
    }

    private static final class EglChooseConfig
    extends AssetProcessorBase {
        private EglChooseConfig() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCHOOSECONFIG.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglChooseConfigDecorator.getArgumentDpy(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglChooseConfigDecorator.getArgumentAttrib_list(functionCall);
                LongsArgAttachment arg_configs = EGL.EglChooseConfigDecorator.getArgumentConfigs(functionCall);
                Integer arg_config_size = EGL.EglChooseConfigDecorator.getArgumentConfig_size(functionCall);
                LongPtrArgAttachment arg_num_config = EGL.EglChooseConfigDecorator.getArgumentNum_config(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglChooseConfigDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    List<Long> temp_asAssetIDs_return_value_2 = AssetProcessorBase.asAssetIDs(arg_configs);
                    AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_2, configsAsset_id_value -> {
                        EglConfigAsset configsAsset = AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configsAsset_id_value, dpyAsset);
                        Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                        temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                            AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_0);
                            configsAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                        });
                    });
                }
            }
        }
    }

    private static final class EglCopyBuffers
    extends AssetProcessorBase {
        private EglCopyBuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCOPYBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglCopyBuffersDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglCopyBuffersDecorator.getArgumentSurface(functionCall);
                Pointer arg_target = EGL.EglCopyBuffersDecorator.getArgumentTarget(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglCopyBuffersDecorator.getReturnValue(functionCall);
                long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                EglSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                surfaceAsset.setPreviousModificationFunction(functionCall);
            }
        }
    }

    private static final class EglCreateContext
    extends AssetProcessorBase {
        private EglCreateContext() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATECONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_2;
                Pointer arg_dpy = EGL.EglCreateContextDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreateContextDecorator.getArgumentConfig(functionCall);
                Pointer arg_share_context = EGL.EglCreateContextDecorator.getArgumentShare_context(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateContextDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateContextDecorator.getReturnValue(functionCall);
                long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_2 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long configAsset_id_value = AssetProcessorBase.asAssetID(arg_config);
                    EglConfigAsset configAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configAsset_id_value, dpyAsset), configAsset_id_value);
                    long share_contextAsset_id_value = AssetProcessorBase.asAssetID(arg_share_context);
                    EglContextAsset share_contextAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getEglContextAsset(currentState, functionCall, share_contextAsset_id_value), share_contextAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    EglContextAsset returnedAsset = AssetProcessorBase.createNewEglContextAsset(currentState, functionCall, returnedAsset_id_value, configAsset, dpyAsset, share_contextAsset);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_1);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreateImageKhr
    extends AssetProcessorBase {
        private EglCreateImageKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEIMAGEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_3;
                Pointer arg_dpy = EGL.EglCreateImageKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_ctx = EGL.EglCreateImageKHRDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended arg_target = EGL.EglCreateImageKHRDecorator.getArgumentTarget(functionCall);
                Pointer arg_buffer = EGL.EglCreateImageKHRDecorator.getArgumentBuffer(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateImageKHRDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateImageKHRDecorator.getReturnValue(functionCall);
                long l = temp_temp_3 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_3 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long ctxAsset_id_value = AssetProcessorBase.asAssetID(arg_ctx);
                    EglContextAsset ctxAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getEglContextAsset(currentState, functionCall, ctxAsset_id_value), ctxAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_2 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_target, Constants.CONSTANT_SET_3);
                    EglImageAsset returnedAsset = AssetProcessorBase.createNewEglImageAsset(currentState, functionCall, returnedAsset_id_value, arg_buffer, dpyAsset, ctxAsset, temp_validateConstantIsInSet_return_value_2);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_2);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreatePbufferFromClientBuffer
    extends AssetProcessorBase {
        private EglCreatePbufferFromClientBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPBUFFERFROMCLIENTBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_2;
                Pointer arg_dpy = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended arg_buftype = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentBuftype(functionCall);
                Pointer arg_buffer = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentBuffer(functionCall);
                Pointer arg_config = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentConfig(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePbufferFromClientBufferDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePbufferFromClientBufferDecorator.getReturnValue(functionCall);
                long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_2 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long configAsset_id_value = AssetProcessorBase.asAssetID(arg_config);
                    EglConfigAsset configAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configAsset_id_value, dpyAsset), configAsset_id_value);
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    EglPbufferSurfaceAsset returnedAsset = AssetProcessorBase.createNewEglPbufferSurfaceAsset(currentState, functionCall, returnedAsset_id_value, configAsset, dpyAsset);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_4);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreatePbufferSurface
    extends AssetProcessorBase {
        private EglCreatePbufferSurface() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPBUFFERSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_2;
                Pointer arg_dpy = EGL.EglCreatePbufferSurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreatePbufferSurfaceDecorator.getArgumentConfig(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePbufferSurfaceDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePbufferSurfaceDecorator.getReturnValue(functionCall);
                long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_2 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long configAsset_id_value = AssetProcessorBase.asAssetID(arg_config);
                    EglConfigAsset configAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configAsset_id_value, dpyAsset), configAsset_id_value);
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    EglPbufferSurfaceAsset returnedAsset = AssetProcessorBase.createNewEglPbufferSurfaceAsset(currentState, functionCall, returnedAsset_id_value, configAsset, dpyAsset);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_4);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreatePixmapSurface
    extends AssetProcessorBase {
        private EglCreatePixmapSurface() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPIXMAPSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_2;
                Pointer arg_dpy = EGL.EglCreatePixmapSurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreatePixmapSurfaceDecorator.getArgumentConfig(functionCall);
                Pointer arg_pixmap = EGL.EglCreatePixmapSurfaceDecorator.getArgumentPixmap(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePixmapSurfaceDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePixmapSurfaceDecorator.getReturnValue(functionCall);
                long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_2 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long configAsset_id_value = AssetProcessorBase.asAssetID(arg_config);
                    EglConfigAsset configAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configAsset_id_value, dpyAsset), configAsset_id_value);
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    EglPixmapSurfaceAsset returnedAsset = AssetProcessorBase.createNewEglPixmapSurfaceAsset(currentState, functionCall, returnedAsset_id_value, configAsset, dpyAsset, arg_pixmap);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_4);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreatePlatformWindowSurfaceExt
    extends AssetProcessorBase {
        private EglCreatePlatformWindowSurfaceExt() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEPLATFORMWINDOWSURFACEEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_2;
                Pointer arg_dpy = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentConfig(functionCall);
                Pointer arg_native_window = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentNative_window(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreatePlatformWindowSurfaceEXTDecorator.getReturnValue(functionCall);
                long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_2 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long configAsset_id_value = AssetProcessorBase.asAssetID(arg_config);
                    EglConfigAsset configAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configAsset_id_value, dpyAsset), configAsset_id_value);
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    EglWindowSurfaceAsset returnedAsset = AssetProcessorBase.createNewEglWindowSurfaceAsset(currentState, functionCall, returnedAsset_id_value, configAsset, dpyAsset, arg_native_window);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_4);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreateSync64Khr
    extends AssetProcessorBase {
        private EglCreateSync64Khr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATESYNC64KHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_3;
                Pointer arg_dpy = EGL.EglCreateSync64KHRDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = EGL.EglCreateSync64KHRDecorator.getArgumentType(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateSync64KHRDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateSync64KHRDecorator.getReturnValue(functionCall);
                long l = temp_temp_3 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_3 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_2 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_type, Constants.CONSTANT_SET_6);
                    EglSyncAsset returnedAsset = AssetProcessorBase.createNewEglSyncAsset(currentState, functionCall, returnedAsset_id_value, dpyAsset, temp_validateConstantIsInSet_return_value_2);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_5);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreateSyncKhr
    extends AssetProcessorBase {
        private EglCreateSyncKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATESYNCKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_3;
                Pointer arg_dpy = EGL.EglCreateSyncKHRDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended arg_type = EGL.EglCreateSyncKHRDecorator.getArgumentType(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateSyncKHRDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateSyncKHRDecorator.getReturnValue(functionCall);
                long l = temp_temp_3 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_3 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_2 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_type, Constants.CONSTANT_SET_6);
                    EglSyncAsset returnedAsset = AssetProcessorBase.createNewEglSyncAsset(currentState, functionCall, returnedAsset_id_value, dpyAsset, temp_validateConstantIsInSet_return_value_2);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_5);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglCreateWindowSurface
    extends AssetProcessorBase {
        private EglCreateWindowSurface() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLCREATEWINDOWSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_2;
                Pointer arg_dpy = EGL.EglCreateWindowSurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglCreateWindowSurfaceDecorator.getArgumentConfig(functionCall);
                Pointer arg_win = EGL.EglCreateWindowSurfaceDecorator.getArgumentWin(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglCreateWindowSurfaceDecorator.getArgumentAttrib_list(functionCall);
                Pointer returnValue_ = EGL.EglCreateWindowSurfaceDecorator.getReturnValue(functionCall);
                long l = temp_temp_2 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_2 != 0L) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long configAsset_id_value = AssetProcessorBase.asAssetID(arg_config);
                    EglConfigAsset configAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configAsset_id_value, dpyAsset), configAsset_id_value);
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    EglWindowSurfaceAsset returnedAsset = AssetProcessorBase.createNewEglWindowSurfaceAsset(currentState, functionCall, returnedAsset_id_value, configAsset, dpyAsset, arg_win);
                    Map<AbstractConstantOrAliasSpecExtended, Long> temp_convertEglAttributesToMap_return_value_0 = AssetProcessorBase.convertEglAttributesToMap(arg_attrib_list);
                    temp_convertEglAttributesToMap_return_value_0.forEach((mapEntryKey, mapEntryValue) -> {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_1 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, mapEntryKey, Constants.CONSTANT_SET_4);
                        returnedAsset.setAttribute(temp_validateConstantIsInSet_return_value_1, (Long)mapEntryValue);
                    });
                }
            }
        }
    }

    private static final class EglDestroyContext
    extends AssetProcessorBase {
        private EglDestroyContext() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYCONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglDestroyContextDecorator.getArgumentDpy(functionCall);
                Pointer arg_ctx = EGL.EglDestroyContextDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroyContextDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long ctxAsset_id_value = AssetProcessorBase.asAssetID(arg_ctx);
                    EglContextAsset ctxAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getEglContextAsset(currentState, functionCall, ctxAsset_id_value), ctxAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (ctxAsset != null) {
                        AssetProcessorBase.deleteEglContextAsset(currentState, functionCall, ctxAsset);
                    }
                }
            }
        }
    }

    private static final class EglDestroyImageKhr
    extends AssetProcessorBase {
        private EglDestroyImageKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYIMAGEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglDestroyImageKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_image = EGL.EglDestroyImageKHRDecorator.getArgumentImage(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroyImageKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long imageAsset_id_value = AssetProcessorBase.asAssetID(arg_image);
                    EglImageAsset imageAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglImageAsset(currentState, functionCall, imageAsset_id_value), imageAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (imageAsset != null) {
                        AssetProcessorBase.deleteEglImageAsset(currentState, functionCall, imageAsset);
                    }
                }
            }
        }
    }

    private static final class EglDestroySurface
    extends AssetProcessorBase {
        private EglDestroySurface() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglDestroySurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglDestroySurfaceDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroySurfaceDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglSurfaceAsset surfaceAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (surfaceAsset != null) {
                        AssetProcessorBase.deleteEglSurfaceAsset(currentState, functionCall, surfaceAsset);
                    }
                }
            }
        }
    }

    private static final class EglDestroySyncKhr
    extends AssetProcessorBase {
        private EglDestroySyncKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLDESTROYSYNCKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglDestroySyncKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_sync = EGL.EglDestroySyncKHRDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglDestroySyncKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long syncAsset_id_value = AssetProcessorBase.asAssetID(arg_sync);
                    EglSyncAsset syncAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSyncAsset(currentState, functionCall, syncAsset_id_value), syncAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (syncAsset != null) {
                        AssetProcessorBase.deleteEglSyncAsset(currentState, functionCall, syncAsset);
                    }
                }
            }
        }
    }

    private static final class EglGetConfigAttrib
    extends AssetProcessorBase {
        private EglGetConfigAttrib() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETCONFIGATTRIB.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglGetConfigAttribDecorator.getArgumentDpy(functionCall);
                Pointer arg_config = EGL.EglGetConfigAttribDecorator.getArgumentConfig(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglGetConfigAttribDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglGetConfigAttribDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetConfigAttribDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long configAsset_id_value = AssetProcessorBase.asAssetID(arg_config);
                    EglConfigAsset configAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS, currentState, functionCall, AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configAsset_id_value, dpyAsset), configAsset_id_value);
                    configAsset.setPreviousModificationFunction(functionCall);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_attribute, Constants.CONSTANT_SET_0);
                    assert (temp_validateConstantIsInSet_return_value_0 != null);
                    configAsset.setAttribute(temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                }
            }
        }
    }

    private static final class EglGetConfigs
    extends AssetProcessorBase {
        private EglGetConfigs() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETCONFIGS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglGetConfigsDecorator.getArgumentDpy(functionCall);
                LongsArgAttachment arg_configs = EGL.EglGetConfigsDecorator.getArgumentConfigs(functionCall);
                Integer arg_config_size = EGL.EglGetConfigsDecorator.getArgumentConfig_size(functionCall);
                LongPtrArgAttachment arg_num_config = EGL.EglGetConfigsDecorator.getArgumentNum_config(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetConfigsDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    List<Long> temp_asAssetIDs_return_value_0 = AssetProcessorBase.asAssetIDs(arg_configs);
                    AssetProcessorBase.forEachAssetItemID(temp_asAssetIDs_return_value_0, configsAsset_id_value -> {
                        EglConfigAsset eglConfigAsset = AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, configsAsset_id_value, dpyAsset);
                    });
                }
            }
        }
    }

    private static final class EglGetDisplay
    extends AssetProcessorBase {
        private EglGetDisplay() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETDISPLAY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long temp_temp_0;
                Pointer arg_display_id = EGL.EglGetDisplayDecorator.getArgumentDisplay_id(functionCall);
                Pointer returnValue_ = EGL.EglGetDisplayDecorator.getReturnValue(functionCall);
                long l = temp_temp_0 = returnValue_ != null ? returnValue_.address() : 0L;
                if (temp_temp_0 != 0L) {
                    long returnedAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    EglDisplayAsset eglDisplayAsset = AssetProcessorBase.createNewEglDisplayAsset(currentState, functionCall, returnedAsset_id_value, arg_display_id);
                }
            }
        }
    }

    private static final class EglGetSyncAttribKhr
    extends AssetProcessorBase {
        private EglGetSyncAttribKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLGETSYNCATTRIBKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglGetSyncAttribKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_sync = EGL.EglGetSyncAttribKHRDecorator.getArgumentSync(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglGetSyncAttribKHRDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglGetSyncAttribKHRDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglGetSyncAttribKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long syncAsset_id_value = AssetProcessorBase.asAssetID(arg_sync);
                    EglSyncAsset syncAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSyncAsset(currentState, functionCall, syncAsset_id_value), syncAsset_id_value);
                    syncAsset.setPreviousModificationFunction(functionCall);
                    if (arg_attribute.equals(KapiSpec.EGL.constants.EGL_SYNC_STATUS_KHR)) {
                        AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, KapiSpec.EGL.getConstantSpecByValue(arg_value.getValue()), Constants.CONSTANT_SET_7);
                        assert (temp_validateConstantIsInSet_return_value_0 != null);
                        syncAsset.setStatus(temp_validateConstantIsInSet_return_value_0);
                    }
                }
            }
        }
    }

    private static final class EglInitialize
    extends AssetProcessorBase {
        private EglInitialize() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLINITIALIZE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglInitializeDecorator.getArgumentDpy(functionCall);
                LongPtrArgAttachment arg_major = EGL.EglInitializeDecorator.getArgumentMajor(functionCall);
                LongPtrArgAttachment arg_minor = EGL.EglInitializeDecorator.getArgumentMinor(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglInitializeDecorator.getReturnValue(functionCall);
                long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                dpyAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.retainAsset(currentState, functionCall, dpyAsset);
            }
        }
    }

    private static final class EglLockSurfaceKhr
    extends AssetProcessorBase {
        private EglLockSurfaceKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglLockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglLockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                LongsArgAttachment arg_attrib_list = EGL.EglLockSurfaceKHRDecorator.getArgumentAttrib_list(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglLockSurfaceKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                    surfaceAsset.setLocked(true);
                }
            }
        }
    }

    private static final class EglMakeCurrent
    extends AssetProcessorBase {
        private EglMakeCurrent() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLMAKECURRENT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglMakeCurrentDecorator.getArgumentDpy(functionCall);
                Pointer arg_draw = EGL.EglMakeCurrentDecorator.getArgumentDraw(functionCall);
                Pointer arg_read = EGL.EglMakeCurrentDecorator.getArgumentRead(functionCall);
                Pointer arg_ctx = EGL.EglMakeCurrentDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglMakeCurrentDecorator.getReturnValue(functionCall);
                long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                EglDisplayAsset dpyAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (dpyAsset != null) {
                    long readAsset_id_value;
                    EglSurfaceAsset readAsset;
                    long drawAsset_id_value;
                    EglSurfaceAsset drawAsset;
                    long ctxAsset_id_value = AssetProcessorBase.asAssetID(arg_ctx);
                    EglContextAsset ctxAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getEglContextAsset(currentState, functionCall, ctxAsset_id_value), ctxAsset_id_value, AssetProcessorBase.asAssetID(0L));
                    if (ctxAsset != null) {
                        ctxAsset.setPreviousModificationFunction(functionCall);
                    }
                    if ((drawAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, drawAsset_id_value = AssetProcessorBase.asAssetID(arg_draw)), drawAsset_id_value, AssetProcessorBase.asAssetID(0L))) != null) {
                        drawAsset.setPreviousModificationFunction(functionCall);
                    }
                    if ((readAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, readAsset_id_value = AssetProcessorBase.asAssetID(arg_read)), readAsset_id_value, AssetProcessorBase.asAssetID(0L))) != null) {
                        readAsset.setPreviousModificationFunction(functionCall);
                    }
                }
            }
        }
    }

    private static final class EglQueryContext
    extends AssetProcessorBase {
        private EglQueryContext() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLQUERYCONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglQueryContextDecorator.getArgumentDpy(functionCall);
                Pointer arg_ctx = EGL.EglQueryContextDecorator.getArgumentCtx(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQueryContextDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglQueryContextDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQueryContextDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long ctxAsset_id_value = AssetProcessorBase.asAssetID(arg_ctx);
                    EglContextAsset ctxAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getEglContextAsset(currentState, functionCall, ctxAsset_id_value), ctxAsset_id_value);
                    ctxAsset.setPreviousModificationFunction(functionCall);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_attribute, Constants.CONSTANT_SET_1);
                    assert (temp_validateConstantIsInSet_return_value_0 != null);
                    ctxAsset.setAttribute(temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                }
            }
        }
    }

    private static final class EglQuerySurface
    extends AssetProcessorBase {
        private EglQuerySurface() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLQUERYSURFACE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglQuerySurfaceDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglQuerySurfaceDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurfaceDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglQuerySurfaceDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurfaceDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_attribute, Constants.CONSTANT_SET_4);
                    assert (temp_validateConstantIsInSet_return_value_0 != null);
                    surfaceAsset.setAttribute(temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                }
            }
        }
    }

    private static final class EglQuerySurface64Khr
    extends AssetProcessorBase {
        private EglQuerySurface64Khr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLQUERYSURFACE64KHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglQuerySurface64KHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglQuerySurface64KHRDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglQuerySurface64KHRDecorator.getArgumentAttribute(functionCall);
                LongPtrArgAttachment arg_value = EGL.EglQuerySurface64KHRDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglQuerySurface64KHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                    AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSet_return_value_0 = AssetProcessorBase.validateConstantIsInSet(currentState, functionCall, arg_attribute, Constants.CONSTANT_SET_4);
                    assert (temp_validateConstantIsInSet_return_value_0 != null);
                    surfaceAsset.setAttribute(temp_validateConstantIsInSet_return_value_0, arg_value.getValue());
                }
            }
        }
    }

    private static final class EglReleaseTexImage
    extends AssetProcessorBase {
        private EglReleaseTexImage() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLRELEASETEXIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglReleaseTexImageDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglReleaseTexImageDecorator.getArgumentSurface(functionCall);
                Integer arg_buffer = EGL.EglReleaseTexImageDecorator.getArgumentBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglReleaseTexImageDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglPbufferSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglPbufferSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                    surfaceAsset.setSourceContext(null);
                    surfaceAsset.setBoundTexture(0);
                }
            }
        }
    }

    private static final class EglSurfaceAttrib
    extends AssetProcessorBase {
        private EglSurfaceAttrib() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLSURFACEATTRIB.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglSurfaceAttribDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglSurfaceAttribDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended arg_attribute = EGL.EglSurfaceAttribDecorator.getArgumentAttribute(functionCall);
                Integer arg_value = EGL.EglSurfaceAttribDecorator.getArgumentValue(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSurfaceAttribDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                    ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSurfaceAttrib(currentState, functionCall, surfaceAsset, arg_dpy, arg_surface, arg_attribute, arg_value, returnValue_);
                }
            }
        }
    }

    private static final class EglSwapBuffers
    extends AssetProcessorBase {
        private EglSwapBuffers() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLSWAPBUFFERS.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglSwapBuffersDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglSwapBuffersDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglSwapBuffersDecorator.getReturnValue(functionCall);
                long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                EglSurfaceAsset surfaceAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (surfaceAsset != null) {
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                }
                ProvidedAssetProcessors.processProvidedActionForEglSurfaceAssetOnEglSwapBuffers(currentState, functionCall, surfaceAsset, arg_dpy, arg_surface, returnValue_);
            }
        }
    }

    private static final class EglTerminate
    extends AssetProcessorBase {
        private EglTerminate() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLTERMINATE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                long dpyAsset_id_value;
                EglDisplayAsset dpyAsset;
                Pointer arg_dpy = EGL.EglTerminateDecorator.getArgumentDpy(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglTerminateDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE) && (dpyAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy)), dpyAsset_id_value, AssetProcessorBase.asAssetID(0L))) != null) {
                    AssetProcessorBase.deleteEglDisplayAsset(currentState, functionCall, dpyAsset);
                }
            }
        }
    }

    private static final class EglUnlockSurfaceKhr
    extends AssetProcessorBase {
        private EglUnlockSurfaceKhr() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.EGL.functions.EGLUNLOCKSURFACEKHR.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_dpy = EGL.EglUnlockSurfaceKHRDecorator.getArgumentDpy(functionCall);
                Pointer arg_surface = EGL.EglUnlockSurfaceKHRDecorator.getArgumentSurface(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = EGL.EglUnlockSurfaceKHRDecorator.getReturnValue(functionCall);
                if (returnValue_.equals(KapiSpec.EGL.constants.EGL_TRUE)) {
                    long dpyAsset_id_value = AssetProcessorBase.asAssetID(arg_dpy);
                    EglDisplayAsset dpyAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS, currentState, functionCall, AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, dpyAsset_id_value), dpyAsset_id_value);
                    long surfaceAsset_id_value = AssetProcessorBase.asAssetID(arg_surface);
                    EglSurfaceAsset surfaceAsset = AssetProcessorBase.requireAsset(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS, currentState, functionCall, AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, surfaceAsset_id_value), surfaceAsset_id_value);
                    surfaceAsset.setPreviousModificationFunction(functionCall);
                    surfaceAsset.setLocked(false);
                }
            }
        }
    }
}

