/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors.gen;

import com.arm.mgd.core.asset.ClBufferMemoryAsset;
import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ClImageMemoryAsset;
import com.arm.mgd.core.asset.ClKernelAsset;
import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.ClProgramAsset;
import com.arm.mgd.core.asset.ClSubBufferMemoryAsset;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.processors.ProvidedAssetProcessors;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public final class ClAssetProcessor {
    private static final Map<String, AssetProcessorBase> ASSET_PROCESSORS = new HashMap<String, AssetProcessorBase>(){
        {
            this.put("clCreateBuffer", new ClCreateBuffer());
            this.put("clCreateContext", new ClCreateContext());
            this.put("clCreateContextFromType", new ClCreateContextFromType());
            this.put("clCreateImage", new ClCreateImage());
            this.put("clCreateImage2D", new ClCreateImage2D());
            this.put("clCreateImage3D", new ClCreateImage3D());
            this.put("clCreateProgramWithBinary", new ClCreateProgramWithBinary());
            this.put("clCreateProgramWithSource", new ClCreateProgramWithSource());
            this.put("clCreateSubBuffer", new ClCreateSubBuffer());
            this.put("clEnqueueCopyBuffer", new ClEnqueueCopyBuffer());
            this.put("clEnqueueWriteBuffer", new ClEnqueueWriteBuffer());
            this.put("clReleaseContext", new ClReleaseContext());
            this.put("clReleaseKernel", new ClReleaseKernel());
            this.put("clReleaseMemObject", new ClReleaseMemObject());
            this.put("clReleaseProgram", new ClReleaseProgram());
            this.put("clRetainContext", new ClRetainContext());
            this.put("clRetainKernel", new ClRetainKernel());
            this.put("clRetainMemObject", new ClRetainMemObject());
            this.put("clRetainProgram", new ClRetainProgram());
        }
    };

    public static final AssetProcessorBase getAssetProcessor(String functionName) {
        return ASSET_PROCESSORS.get(functionName);
    }

    private static final class ClCreateBuffer
    extends AssetProcessorBase {
        private ClCreateBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateBufferDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateBufferDecorator.getArgumentFlags(functionCall);
                Long arg_size = CL.ClCreateBufferDecorator.getArgumentSize(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateBufferDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateBufferDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateBufferDecorator.getReturnValue(functionCall);
                long contextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset contextAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, contextAsset_id_value), contextAsset_id_value);
                long clMemoryAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                ClBufferMemoryAsset clMemoryAsset = AssetProcessorBase.createNewClBufferMemoryAsset(currentState, functionCall, clMemoryAsset_id_value, contextAsset, arg_flags);
                clMemoryAsset.setSize(arg_size);
            }
        }
    }

    private static final class ClCreateContext
    extends AssetProcessorBase {
        private ClCreateContext() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATECONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_properties = CL.ClCreateContextDecorator.getArgumentProperties(functionCall);
                Long arg_num_devices = CL.ClCreateContextDecorator.getArgumentNum_devices(functionCall);
                LongsArgAttachment arg_devices = CL.ClCreateContextDecorator.getArgumentDevices(functionCall);
                Pointer arg_pfn_notify = CL.ClCreateContextDecorator.getArgumentPfn_notify(functionCall);
                Pointer arg_user_data = CL.ClCreateContextDecorator.getArgumentUser_data(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateContextDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateContextDecorator.getReturnValue(functionCall);
                if (!returnValue_.equals(Pointer.NULL)) {
                    long contextAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    ClContextAsset clContextAsset = AssetProcessorBase.createNewClContextAsset(currentState, functionCall, contextAsset_id_value);
                }
            }
        }
    }

    private static final class ClCreateContextFromType
    extends AssetProcessorBase {
        private ClCreateContextFromType() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATECONTEXTFROMTYPE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_properties = CL.ClCreateContextFromTypeDecorator.getArgumentProperties(functionCall);
                Bitfield arg_device_type = CL.ClCreateContextFromTypeDecorator.getArgumentDevice_type(functionCall);
                Pointer arg_pfn_notify = CL.ClCreateContextFromTypeDecorator.getArgumentPfn_notify(functionCall);
                Pointer arg_user_data = CL.ClCreateContextFromTypeDecorator.getArgumentUser_data(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateContextFromTypeDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateContextFromTypeDecorator.getReturnValue(functionCall);
                if (!returnValue_.equals(Pointer.NULL)) {
                    long contextAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                    ClContextAsset clContextAsset = AssetProcessorBase.createNewClContextAsset(currentState, functionCall, contextAsset_id_value);
                }
            }
        }
    }

    private static final class ClCreateImage
    extends AssetProcessorBase {
        private ClCreateImage() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEIMAGE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateImageDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateImageDecorator.getArgumentFlags(functionCall);
                CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImageDecorator.getArgumentImage_format(functionCall);
                CL.Structs.ClImageDescStruct arg_image_desc = CL.ClCreateImageDecorator.getArgumentImage_desc(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateImageDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImageDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateImageDecorator.getReturnValue(functionCall);
                long imageContextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset imageContextAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                long imageAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                assert (arg_image_format.getImage_channel_data_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_image_format.getImage_channel_data_type(), Constants.CONSTANT_SET_0);
                assert (arg_image_format.getImage_channel_order() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_1 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_image_format.getImage_channel_order(), Constants.CONSTANT_SET_1);
                assert (arg_image_desc.getImage_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_image_desc.getImage_type(), Constants.CONSTANT_SET_2);
                ClImageMemoryAsset imageAsset = AssetProcessorBase.createNewClImageMemoryAsset(currentState, functionCall, imageAsset_id_value, imageContextAsset, arg_flags, temp_validateConstantIsInSetLogError_return_value_0, temp_validateConstantIsInSetLogError_return_value_1, temp_validateConstantIsInSetLogError_return_value_2);
                imageAsset.setWidth(arg_image_desc.getImage_width());
                imageAsset.setHeight(arg_image_desc.getImage_height());
                imageAsset.setDepth(arg_image_desc.getImage_depth());
            }
        }
    }

    private static final class ClCreateImage2D
    extends AssetProcessorBase {
        private ClCreateImage2D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEIMAGE2D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateImage2DDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateImage2DDecorator.getArgumentFlags(functionCall);
                CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImage2DDecorator.getArgumentImage_format(functionCall);
                Long arg_image_width = CL.ClCreateImage2DDecorator.getArgumentImage_width(functionCall);
                Long arg_image_height = CL.ClCreateImage2DDecorator.getArgumentImage_height(functionCall);
                Long arg_image_row_pitch = CL.ClCreateImage2DDecorator.getArgumentImage_row_pitch(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateImage2DDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImage2DDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateImage2DDecorator.getReturnValue(functionCall);
                long imageContextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset imageContextAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                long imageAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                assert (arg_image_format.getImage_channel_data_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_image_format.getImage_channel_data_type(), Constants.CONSTANT_SET_0);
                assert (arg_image_format.getImage_channel_order() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_1 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_image_format.getImage_channel_order(), Constants.CONSTANT_SET_1);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D, Constants.CONSTANT_SET_2);
                ClImageMemoryAsset imageAsset = AssetProcessorBase.createNewClImageMemoryAsset(currentState, functionCall, imageAsset_id_value, imageContextAsset, arg_flags, temp_validateConstantIsInSetLogError_return_value_0, temp_validateConstantIsInSetLogError_return_value_1, temp_validateConstantIsInSetLogError_return_value_2);
                imageAsset.setWidth(arg_image_width);
                imageAsset.setHeight(arg_image_height);
                imageAsset.setDepth(null);
            }
        }
    }

    private static final class ClCreateImage3D
    extends AssetProcessorBase {
        private ClCreateImage3D() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEIMAGE3D.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateImage3DDecorator.getArgumentContext(functionCall);
                Bitfield arg_flags = CL.ClCreateImage3DDecorator.getArgumentFlags(functionCall);
                CL.Structs.ClImageFormatStruct arg_image_format = CL.ClCreateImage3DDecorator.getArgumentImage_format(functionCall);
                Long arg_image_width = CL.ClCreateImage3DDecorator.getArgumentImage_width(functionCall);
                Long arg_image_height = CL.ClCreateImage3DDecorator.getArgumentImage_height(functionCall);
                Long arg_image_depth = CL.ClCreateImage3DDecorator.getArgumentImage_depth(functionCall);
                Long arg_image_row_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_row_pitch(functionCall);
                Long arg_image_slice_pitch = CL.ClCreateImage3DDecorator.getArgumentImage_slice_pitch(functionCall);
                BufferArgAttachment arg_host_ptr = CL.ClCreateImage3DDecorator.getArgumentHost_ptr(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateImage3DDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateImage3DDecorator.getReturnValue(functionCall);
                long imageContextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset imageContextAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, imageContextAsset_id_value), imageContextAsset_id_value);
                long imageAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                assert (arg_image_format.getImage_channel_data_type() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_0 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_image_format.getImage_channel_data_type(), Constants.CONSTANT_SET_0);
                assert (arg_image_format.getImage_channel_order() != null);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_1 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, arg_image_format.getImage_channel_order(), Constants.CONSTANT_SET_1);
                AbstractConstantOrAliasSpecExtended temp_validateConstantIsInSetLogError_return_value_2 = AssetProcessorBase.validateConstantIsInSetLogError(currentState, functionCall, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE3D, Constants.CONSTANT_SET_2);
                ClImageMemoryAsset imageAsset = AssetProcessorBase.createNewClImageMemoryAsset(currentState, functionCall, imageAsset_id_value, imageContextAsset, arg_flags, temp_validateConstantIsInSetLogError_return_value_0, temp_validateConstantIsInSetLogError_return_value_1, temp_validateConstantIsInSetLogError_return_value_2);
                imageAsset.setWidth(arg_image_width);
                imageAsset.setHeight(arg_image_height);
                imageAsset.setDepth(arg_image_depth);
            }
        }
    }

    private static final class ClCreateProgramWithBinary
    extends AssetProcessorBase {
        private ClCreateProgramWithBinary() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEPROGRAMWITHBINARY.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateProgramWithBinaryDecorator.getArgumentContext(functionCall);
                Long arg_num_devices = CL.ClCreateProgramWithBinaryDecorator.getArgumentNum_devices(functionCall);
                LongsArgAttachment arg_device_list = CL.ClCreateProgramWithBinaryDecorator.getArgumentDevice_list(functionCall);
                LongsArgAttachment arg_lengths = CL.ClCreateProgramWithBinaryDecorator.getArgumentLengths(functionCall);
                Pointer arg_binaries = CL.ClCreateProgramWithBinaryDecorator.getArgumentBinaries(functionCall);
                LongsArgAttachment arg_binary_status = CL.ClCreateProgramWithBinaryDecorator.getArgumentBinary_status(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateProgramWithBinaryDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateProgramWithBinaryDecorator.getReturnValue(functionCall);
                long contextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset contextAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, contextAsset_id_value), contextAsset_id_value);
                long clProgramAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                ClProgramAsset clProgramAsset = AssetProcessorBase.createNewClProgramAsset(currentState, functionCall, clProgramAsset_id_value, contextAsset);
            }
        }
    }

    private static final class ClCreateProgramWithSource
    extends AssetProcessorBase {
        private ClCreateProgramWithSource() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATEPROGRAMWITHSOURCE.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClCreateProgramWithSourceDecorator.getArgumentContext(functionCall);
                Long arg_count = CL.ClCreateProgramWithSourceDecorator.getArgumentCount(functionCall);
                StringsArgAttachment arg_strings = CL.ClCreateProgramWithSourceDecorator.getArgumentStrings(functionCall);
                LongsArgAttachment arg_lengths = CL.ClCreateProgramWithSourceDecorator.getArgumentLengths(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateProgramWithSourceDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateProgramWithSourceDecorator.getReturnValue(functionCall);
                long contextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset contextAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, contextAsset_id_value), contextAsset_id_value);
                long clProgramAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                ClProgramAsset clProgramAsset = AssetProcessorBase.createNewClProgramAsset(currentState, functionCall, clProgramAsset_id_value, contextAsset);
            }
        }
    }

    private static final class ClCreateSubBuffer
    extends AssetProcessorBase {
        private ClCreateSubBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLCREATESUBBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_buffer = CL.ClCreateSubBufferDecorator.getArgumentBuffer(functionCall);
                Bitfield arg_flags = CL.ClCreateSubBufferDecorator.getArgumentFlags(functionCall);
                AbstractConstantOrAliasSpecExtended arg_buffer_create_type = CL.ClCreateSubBufferDecorator.getArgumentBuffer_create_type(functionCall);
                CL.Structs.ClBufferRegionStruct arg_buffer_create_info = CL.ClCreateSubBufferDecorator.getArgumentBuffer_create_info(functionCall);
                LongPtrArgAttachment arg_errcode_ret = CL.ClCreateSubBufferDecorator.getArgumentErrcode_ret(functionCall);
                Pointer returnValue_ = CL.ClCreateSubBufferDecorator.getReturnValue(functionCall);
                long parentMemAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                ClMemoryAsset parentMemAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getClMemoryAsset(currentState, functionCall, parentMemAsset_id_value), parentMemAsset_id_value);
                long clMemoryAsset_id_value = AssetProcessorBase.asAssetID(returnValue_);
                ClContextAsset temp_getContextAsset_return_value_0 = parentMemAsset.getContextAsset();
                ClSubBufferMemoryAsset clSubBufferMemoryAsset = AssetProcessorBase.createNewClSubBufferMemoryAsset(currentState, functionCall, clMemoryAsset_id_value, temp_getContextAsset_return_value_0, arg_flags, arg_buffer_create_info, parentMemAsset);
            }
        }
    }

    private static final class ClEnqueueCopyBuffer
    extends AssetProcessorBase {
        private ClEnqueueCopyBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLENQUEUECOPYBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_command_queue = CL.ClEnqueueCopyBufferDecorator.getArgumentCommand_queue(functionCall);
                Pointer arg_src_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_buffer(functionCall);
                Pointer arg_dst_buffer = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_buffer(functionCall);
                Long arg_src_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentSrc_offset(functionCall);
                Long arg_dst_offset = CL.ClEnqueueCopyBufferDecorator.getArgumentDst_offset(functionCall);
                Long arg_size = CL.ClEnqueueCopyBufferDecorator.getArgumentSize(functionCall);
                Long arg_num_events_in_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                LongsArgAttachment arg_event_wait_list = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent_wait_list(functionCall);
                LongPtrArgAttachment arg_event = CL.ClEnqueueCopyBufferDecorator.getArgumentEvent(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueCopyBufferDecorator.getReturnValue(functionCall);
                long sourceBuffer_id_value = AssetProcessorBase.asAssetID(arg_src_buffer);
                ClMemoryAsset sourceBuffer = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getClMemoryAsset(currentState, functionCall, sourceBuffer_id_value), sourceBuffer_id_value);
                long destinationBuffer_id_value = AssetProcessorBase.asAssetID(arg_dst_buffer);
                ClMemoryAsset destinationBuffer = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getClMemoryAsset(currentState, functionCall, destinationBuffer_id_value), destinationBuffer_id_value);
                destinationBuffer.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueCopyBuffer(currentState, functionCall, destinationBuffer, arg_command_queue, arg_src_buffer, arg_dst_buffer, arg_src_offset, arg_dst_offset, arg_size, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_, sourceBuffer);
            }
        }
    }

    private static final class ClEnqueueWriteBuffer
    extends AssetProcessorBase {
        private ClEnqueueWriteBuffer() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLENQUEUEWRITEBUFFER.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_command_queue = CL.ClEnqueueWriteBufferDecorator.getArgumentCommand_queue(functionCall);
                Pointer arg_buffer = CL.ClEnqueueWriteBufferDecorator.getArgumentBuffer(functionCall);
                AbstractConstantOrAliasSpecExtended arg_blocking_write = CL.ClEnqueueWriteBufferDecorator.getArgumentBlocking_write(functionCall);
                Long arg_offset = CL.ClEnqueueWriteBufferDecorator.getArgumentOffset(functionCall);
                Long arg_size = CL.ClEnqueueWriteBufferDecorator.getArgumentSize(functionCall);
                BufferArgAttachment arg_ptr = CL.ClEnqueueWriteBufferDecorator.getArgumentPtr(functionCall);
                Long arg_num_events_in_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentNum_events_in_wait_list(functionCall);
                LongsArgAttachment arg_event_wait_list = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent_wait_list(functionCall);
                LongPtrArgAttachment arg_event = CL.ClEnqueueWriteBufferDecorator.getArgumentEvent(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClEnqueueWriteBufferDecorator.getReturnValue(functionCall);
                long bufferAsset_id_value = AssetProcessorBase.asAssetID(arg_buffer);
                ClMemoryAsset bufferAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getClMemoryAsset(currentState, functionCall, bufferAsset_id_value), bufferAsset_id_value);
                bufferAsset.setPreviousModificationFunction(functionCall);
                ProvidedAssetProcessors.processProvidedActionForClMemoryAssetOnClEnqueueWriteBuffer(currentState, functionCall, bufferAsset, arg_command_queue, arg_buffer, arg_blocking_write, arg_offset, arg_size, arg_ptr, arg_num_events_in_wait_list, arg_event_wait_list, arg_event, returnValue_);
            }
        }
    }

    private static final class ClReleaseContext
    extends AssetProcessorBase {
        private ClReleaseContext() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASECONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClReleaseContextDecorator.getArgumentContext(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseContextDecorator.getReturnValue(functionCall);
                long contextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset contextAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, contextAsset_id_value), contextAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (contextAsset != null) {
                    AssetProcessorBase.deleteClContextAsset(currentState, functionCall, contextAsset);
                }
            }
        }
    }

    private static final class ClReleaseKernel
    extends AssetProcessorBase {
        private ClReleaseKernel() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASEKERNEL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_kernel = CL.ClReleaseKernelDecorator.getArgumentKernel(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseKernelDecorator.getReturnValue(functionCall);
                long kernelAsset_id_value = AssetProcessorBase.asAssetID(arg_kernel);
                ClKernelAsset kernelAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.CL.assetTables.KERNEL_TRAITS, currentState, functionCall, AssetProcessorBase.getClKernelAsset(currentState, functionCall, kernelAsset_id_value), kernelAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (kernelAsset != null) {
                    AssetProcessorBase.deleteClKernelAsset(currentState, functionCall, kernelAsset);
                }
            }
        }
    }

    private static final class ClReleaseMemObject
    extends AssetProcessorBase {
        private ClReleaseMemObject() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASEMEMOBJECT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_memobj = CL.ClReleaseMemObjectDecorator.getArgumentMemobj(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseMemObjectDecorator.getReturnValue(functionCall);
                long memoryAsset_id_value = AssetProcessorBase.asAssetID(arg_memobj);
                ClMemoryAsset memoryAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getClMemoryAsset(currentState, functionCall, memoryAsset_id_value), memoryAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (memoryAsset != null) {
                    AssetProcessorBase.deleteClMemoryAsset(currentState, functionCall, memoryAsset);
                }
            }
        }
    }

    private static final class ClReleaseProgram
    extends AssetProcessorBase {
        private ClReleaseProgram() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRELEASEPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_program = CL.ClReleaseProgramDecorator.getArgumentProgram(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClReleaseProgramDecorator.getReturnValue(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                ClProgramAsset programAsset = AssetProcessorBase.warnIfMissingAsset(KapiSpec.CL.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getClProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value, AssetProcessorBase.asAssetID(0L));
                if (programAsset != null) {
                    AssetProcessorBase.deleteClProgramAsset(currentState, functionCall, programAsset);
                }
            }
        }
    }

    private static final class ClRetainContext
    extends AssetProcessorBase {
        private ClRetainContext() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINCONTEXT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_context = CL.ClRetainContextDecorator.getArgumentContext(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainContextDecorator.getReturnValue(functionCall);
                long contextAsset_id_value = AssetProcessorBase.asAssetID(arg_context);
                ClContextAsset contextAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.CONTEXT_TRAITS, currentState, functionCall, AssetProcessorBase.getClContextAsset(currentState, functionCall, contextAsset_id_value), contextAsset_id_value);
                contextAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.retainAsset(currentState, functionCall, contextAsset);
            }
        }
    }

    private static final class ClRetainKernel
    extends AssetProcessorBase {
        private ClRetainKernel() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINKERNEL.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_kernel = CL.ClRetainKernelDecorator.getArgumentKernel(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainKernelDecorator.getReturnValue(functionCall);
                long kernelAsset_id_value = AssetProcessorBase.asAssetID(arg_kernel);
                ClKernelAsset kernelAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.KERNEL_TRAITS, currentState, functionCall, AssetProcessorBase.getClKernelAsset(currentState, functionCall, kernelAsset_id_value), kernelAsset_id_value);
                kernelAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.retainAsset(currentState, functionCall, kernelAsset);
            }
        }
    }

    private static final class ClRetainMemObject
    extends AssetProcessorBase {
        private ClRetainMemObject() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINMEMOBJECT.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_memobj = CL.ClRetainMemObjectDecorator.getArgumentMemobj(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainMemObjectDecorator.getReturnValue(functionCall);
                long memoryAsset_id_value = AssetProcessorBase.asAssetID(arg_memobj);
                ClMemoryAsset memoryAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.MEMORY_TRAITS, currentState, functionCall, AssetProcessorBase.getClMemoryAsset(currentState, functionCall, memoryAsset_id_value), memoryAsset_id_value);
                memoryAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.retainAsset(currentState, functionCall, memoryAsset);
            }
        }
    }

    private static final class ClRetainProgram
    extends AssetProcessorBase {
        private ClRetainProgram() {
        }

        @Override
        public void execute(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws Exception {
            assert (KapiSpec.CL.functions.CLRETAINPROGRAM.equals(functionCall.getFunctionSpec()));
            if (!functionCall.hasError()) {
                Pointer arg_program = CL.ClRetainProgramDecorator.getArgumentProgram(functionCall);
                AbstractConstantOrAliasSpecExtended returnValue_ = CL.ClRetainProgramDecorator.getReturnValue(functionCall);
                long programAsset_id_value = AssetProcessorBase.asAssetID(arg_program);
                ClProgramAsset programAsset = AssetProcessorBase.requireAsset(KapiSpec.CL.assetTables.PROGRAM_TRAITS, currentState, functionCall, AssetProcessorBase.getClProgramAsset(currentState, functionCall, programAsset_id_value), programAsset_id_value);
                programAsset.setPreviousModificationFunction(functionCall);
                AssetProcessorBase.retainAsset(currentState, functionCall, programAsset);
            }
        }
    }

    private static class Constants {
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_0 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.CL.constants.CL_SNORM_INT8, KapiSpec.CL.constants.CL_SIGNED_INT32, KapiSpec.CL.constants.CL_UNORM_INT16, KapiSpec.CL.constants.CL_UNORM_SHORT_565, KapiSpec.CL.constants.CL_UNORM_SHORT_555, KapiSpec.CL.constants.CL_UNSIGNED_INT32, KapiSpec.CL.constants.CL_FLOAT, KapiSpec.CL.constants.CL_SIGNED_INT16, KapiSpec.CL.constants.CL_UNORM_INT_101010, KapiSpec.CL.constants.CL_HALF_FLOAT, KapiSpec.CL.constants.CL_SIGNED_INT8, KapiSpec.CL.constants.CL_UNORM_INT8, KapiSpec.CL.constants.CL_SNORM_INT16, KapiSpec.CL.constants.CL_UNSIGNED_INT8, KapiSpec.CL.constants.CL_UNSIGNED_INT16));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_1 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.CL.constants.CL_RG, KapiSpec.CL.constants.CL_RGBA, KapiSpec.CL.constants.CL_RA, KapiSpec.CL.constants.CL_BGRA, KapiSpec.CL.constants.CL_RX, KapiSpec.CL.constants.CL_LUMINANCE, KapiSpec.CL.constants.CL_RGBX, KapiSpec.CL.constants.CL_ARGB, KapiSpec.CL.constants.CL_RGB, KapiSpec.CL.constants.CL_INTENSITY, KapiSpec.CL.constants.CL_R, KapiSpec.CL.constants.CL_A, KapiSpec.CL.constants.CL_RGX));
        public static final Set<AbstractConstantOrAliasSpecExtended> CONSTANT_SET_2 = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_ARRAY, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE1D_BUFFER, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE2D_ARRAY, KapiSpec.CL.constants.CL_MEM_OBJECT_IMAGE3D));

        private Constants() {
        }
    }
}

