/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors;

import com.arm.mgd.core.asset.objects.IVkAttachmentDescription;
import com.arm.mgd.core.asset.objects.IVkAttachmentReference;
import com.arm.mgd.core.asset.objects.IVkSubpassDependency;
import com.arm.mgd.core.asset.objects.IVkSubpassDescription;
import com.arm.mgd.core.target.data.ArgumentContainerAttachment;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class ValueTransformHelper {
    public static <T, R> @NonNull List<R> map(@NonNull List<T> list, @NonNull Function<T, R> mapper) {
        return list.stream().map(mapper).collect(Collectors.toList());
    }

    public static @NonNull IVkAttachmentDescription toIvKAttachmentDescription( @NonNull VULKAN.Structs.VkAttachmentDescription value) {
        return new IVkAttachmentDescription(){};
    }

    public static @NonNull IVkAttachmentDescription toIvKAttachmentDescription( @NonNull VULKAN.Structs.VkAttachmentDescription2 value) {
        return new IVkAttachmentDescription(){};
    }

    public static @NonNull IVkAttachmentReference toIVkAttachmentReference(final  @NonNull VULKAN.Structs.VkAttachmentReference reference) {
        return new IVkAttachmentReference(){

            @Override
            public @NonNull Long getAttachment() {
                return reference.getAttachment();
            }

            @Override
            public @NonNull ArgumentContainerAttachment getContainer() {
                return reference.getContainer();
            }
        };
    }

    public static @NonNull IVkAttachmentReference toIVkAttachmentReference(final  @NonNull VULKAN.Structs.VkAttachmentReference2 reference) {
        return new IVkAttachmentReference(){

            @Override
            public @NonNull Long getAttachment() {
                return reference.getAttachment();
            }

            @Override
            public @NonNull ArgumentContainerAttachment getContainer() {
                return reference.getContainer();
            }
        };
    }

    public static @NonNull IVkSubpassDependency toIvKSubpassDependency( @NonNull VULKAN.Structs.VkSubpassDependency value) {
        return new IVkSubpassDependency(){};
    }

    public static @NonNull IVkSubpassDependency toIvKSubpassDependency( @NonNull VULKAN.Structs.VkSubpassDependency2 value) {
        return new IVkSubpassDependency(){};
    }

    public static @NonNull IVkSubpassDescription toIvKSubpassDescription(final  @NonNull VULKAN.Structs.VkSubpassDescription value) {
        return new IVkSubpassDescription(){

            @Override
            public ArgumentContainerAttachment getContainer() {
                return value.getContainer();
            }

            @Override
            public @NonNull List<@NonNull IVkAttachmentReference> getPColorAttachments() {
                return ValueTransformHelper.map(value.getPColorAttachments(), ValueTransformHelper::toIVkAttachmentReference);
            }

            @Override
            public @NonNull IVkAttachmentReference getPDepthStencilAttachment() {
                return ValueTransformHelper.toIVkAttachmentReference(value.getPDepthStencilAttachment());
            }

            @Override
            public @NonNull List<@NonNull IVkAttachmentReference> getPResolveAttachments() {
                return ValueTransformHelper.map(value.getPResolveAttachments(), ValueTransformHelper::toIVkAttachmentReference);
            }
        };
    }

    public static @NonNull IVkSubpassDescription toIvKSubpassDescription(final  @NonNull VULKAN.Structs.VkSubpassDescription2 value) {
        return new IVkSubpassDescription(){

            @Override
            public ArgumentContainerAttachment getContainer() {
                return value.getContainer();
            }

            @Override
            public @NonNull List<@NonNull IVkAttachmentReference> getPColorAttachments() {
                return ValueTransformHelper.map(value.getPColorAttachments(), ValueTransformHelper::toIVkAttachmentReference);
            }

            @Override
            public @NonNull IVkAttachmentReference getPDepthStencilAttachment() {
                return ValueTransformHelper.toIVkAttachmentReference(value.getPDepthStencilAttachment());
            }

            @Override
            public @NonNull List<@NonNull IVkAttachmentReference> getPResolveAttachments() {
                return ValueTransformHelper.map(value.getPResolveAttachments(), ValueTransformHelper::toIVkAttachmentReference);
            }
        };
    }
}

