/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors;

import com.arm.mgd.core.target.data.ArrayArgumentAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ShaderUniformValueProcessorHelper {
    public static @NonNull Number @NonNull [] mapMatrixNumberArgsAttachment(@NonNull FloatsArgAttachment attachment, boolean transpose, int arrayIndex, @NonNull AbstractConstantOrAliasSpecExtended type) {
        int elementSize = Math.max(1, type.getNumberOfRowsAsInt() * type.getNumberOfColumnsAsInt());
        int offset = arrayIndex * elementSize;
        if (!transpose) {
            @NonNull Number @NonNull [] subArray = new Number[elementSize];
            int i = 0;
            while (i < elementSize) {
                subArray[i] = attachment.get(i + offset);
                ++i;
            }
            return subArray;
        }
        return ShaderUniformValueProcessorHelper.transposeMatrixSlice(attachment.asList(), offset, type);
    }

    public static <T extends Number> @NonNull Number @NonNull [] mapNumberArgsAttachment(@NonNull ArrayArgumentAttachment<T> attachment, int arrayIndex, @NonNull AbstractConstantOrAliasSpecExtended type, @NonNull Number @NonNull [] currentValue) {
        int elementSize = Math.max(1, type.getNumberOfRowsAsInt() * type.getNumberOfColumnsAsInt());
        int offset = arrayIndex * elementSize;
        int count = Math.min(elementSize, attachment.size() - offset);
        assert (count > 0);
        @NonNull Number @NonNull [] result = (Number[])currentValue.clone();
        int index = 0;
        while (index < count) {
            result[index] = (Number)attachment.get(index + offset);
            ++index;
        }
        return result;
    }

    private static @NonNull Number @NonNull [] transposeMatrixSlice(@NonNull List<@NonNull ? extends Number> input, int offset, @NonNull AbstractConstantOrAliasSpecExtended type) {
        int columns = type.getNumberOfRowsAsInt();
        int rows = type.getNumberOfColumnsAsInt();
        int length = rows * columns;
        assert (length > 0);
        assert (offset >= 0);
        assert (input.size() >= offset + length);
        @NonNull Number @NonNull [] result = new Number[length];
        int c = 0;
        while (c < columns) {
            int r = 0;
            while (r < rows) {
                int src = offset + (c * rows + r);
                int dst = r * columns + c;
                result[dst] = input.get(src);
                ++r;
            }
            ++c;
        }
        return result;
    }
}

