/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors;

import com.arm.mgd.core.asset.AssetProcessor;
import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.asset.EglSurfaceAsset;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.GlProgramPipelineAsset;
import com.arm.mgd.core.asset.GlSamplerAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.GlUniformBindingPointAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkDescriptorPoolAsset;
import com.arm.mgd.core.asset.VkDescriptorSetAsset;
import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.asset.VkExtent3DFromSwapchain;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.VkSwapchainKHRAsset;
import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.processors.ShaderUniformValueProcessorHelper;
import com.arm.mgd.core.asset.programvariable.GlProgramVariableOffset;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.lang.handle.HandleAttachment;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.ArrayArgumentAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.ClMemoryRegionAttachment;
import com.arm.mgd.core.target.data.EmulatedClMemoryRegionAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.SoftwareCounterAttachment;
import com.arm.mgd.core.target.data.StringsArgAttachment;
import com.arm.mgd.core.target.data.TextureArgAttachment;
import com.arm.mgd.core.target.data.VulkanImageMemoryRequirementsAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.TextureAssetUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProvidedAssetProcessors {
    public static void processProvidedActionForGlProgramAssetOnGlAttachShader(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset programAsset, Long arg_program, Long arg_shader, @NonNull GlShaderAsset shaderAsset) throws ApiUsageException {
        programAsset.attachShader(functionCall, shaderAsset);
    }

    public static void processProvidedActionForGlProgramAssetOnGlDetachShader(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset programAsset, Long arg_program, Long arg_shader, @NonNull GlShaderAsset shaderAsset) {
        programAsset.detachShaderById(functionCall, shaderAsset.getId());
        if (shaderAsset.shouldBeDeleted()) {
            shaderAsset.setDeleted(true);
            currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC).remove(shaderAsset.getId());
        }
    }

    public static void processProvidedActionForGlProgramAssetOnGlLinkProgram(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlProgramAsset programAsset, Long arg_program) {
        programAsset.clearUniformsAndAttributes(functionCall);
        programAsset.link();
        @NonNull List<SoftwareCounterAttachment> attachments = functionCall.findFreeAttachments(SoftwareCounterAttachment.class);
        if (!attachments.isEmpty()) {
            int x = 0;
            int y = 0;
            int z = 0;
            for (SoftwareCounterAttachment attachment : attachments) {
                switch (attachment.counterType) {
                    case COMPUTE_LOCAL_WORKGROUP_X: {
                        x = (int)attachment.counterValue;
                        break;
                    }
                    case COMPUTE_LOCAL_WORKGROUP_Y: {
                        y = (int)attachment.counterValue;
                        break;
                    }
                    case COMPUTE_LOCAL_WORKGROUP_Z: {
                        z = (int)attachment.counterValue;
                        break;
                    }
                }
            }
            if (x > 0 && y > 0 && z > 0) {
                programAsset.setComputeLocalWorkGroupSize(new ComputeWorkgroupSize(x, y, z));
            }
        }
    }

    public static void processProvidedActionForGlTextureAssetOnGlGenerateMipmap(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target) {
        long baseLevel = textureAsset.getBaseLevel();
        for (GlTextureSurfaceAsset surfaceAsset : textureAsset.getSurfaces()) {
            if (surfaceAsset.isCubeMapCrossImageSurface()) continue;
            int numLevels = surfaceAsset.getNumMipMapLevels();
            GlTextureImageAsset baseImage = surfaceAsset.getOrCreateTextureLevel(functionCall, baseLevel, false);
            int width = (int)Math.max(1L, baseImage.getWidth());
            int height = (int)Math.max(1L, baseImage.getHeight());
            int depth = (int)Math.max(1L, baseImage.hasDepthComponent() ? baseImage.getDepth() : 1L);
            int i = 1;
            while (i < numLevels) {
                GlTextureImageAsset levelImage = surfaceAsset.getOrCreateTextureLevel(functionCall, baseLevel + (long)i, false);
                levelImage.setStorageProperties(baseImage.getInternalFormat(), 0, width, height, depth);
                width = Math.max(1, width / 2);
                height = Math.max(1, height / 2);
                depth = Math.max(1, depth / 2);
                ++i;
            }
        }
    }

    public static void processProvidedActionForGlTextureImageAssetOnGlTexStorage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureImageAsset textureImageAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_levels, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height) {
        AssetProcessor.checkInternalFormat(currentState, functionCall, arg_internalformat);
        textureImageAsset.getParentAsset().getParentAsset().setImmutableFormat(true);
        textureImageAsset.setStorageProperties(arg_internalformat, arg_levels, arg_width, arg_height, null);
    }

    public static void processProvidedActionForGlTextureImageAssetOnGlTexStorage2DmUltisample(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureImageAsset textureImageAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_samples, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations) {
        AssetProcessor.checkInternalFormat(currentState, functionCall, arg_internalformat);
        textureImageAsset.getParentAsset().getParentAsset().setImmutableFormat(true);
        textureImageAsset.setStorageProperties(arg_internalformat, 1, arg_width, arg_height, null);
    }

    public static void processProvidedActionForGlTextureImageAssetOnGlTexStorage3D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureImageAsset textureImageAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_levels, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth) {
        AssetProcessor.checkInternalFormat(currentState, functionCall, arg_internalformat);
        textureImageAsset.getParentAsset().getParentAsset().setImmutableFormat(true);
        textureImageAsset.setStorageProperties(arg_internalformat, arg_levels, arg_width, arg_height, arg_depth);
    }

    public static void processProvidedActionForGlTextureImageAssetOnGlTexStorage3DmUltisample(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureImageAsset textureImageAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_samples, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth, @NonNull AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations) {
        AssetProcessor.checkInternalFormat(currentState, functionCall, arg_internalformat);
        textureImageAsset.getParentAsset().getParentAsset().setImmutableFormat(true);
        textureImageAsset.setStorageProperties(arg_internalformat, 1, arg_width, arg_height, arg_depth);
    }

    public static void processProvidedActionForGlUniformBindingPointAssetOnGlBindBufferBase(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlUniformBindingPointAsset ubpAsset, AbstractConstantOrAliasSpecExtended arg_target, Long arg_index, Long arg_buffer, @Nullable GlBufferAsset bufferAsset) {
        AssetProcessor.processUniformBufferBlockDataForAllBoundToBindingPoint(currentState, functionCall, ubpAsset);
    }

    public static void processProvidedActionForGlUniformBindingPointAssetOnGlBindBufferRange(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlUniformBindingPointAsset ubpAsset, AbstractConstantOrAliasSpecExtended arg_target, Long arg_index, Long arg_buffer, Long arg_offset, Long arg_size, @Nullable GlBufferAsset bufferAsset) {
        AssetProcessor.processUniformBufferBlockDataForAllBoundToBindingPoint(currentState, functionCall, ubpAsset);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform1F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Float arg_v0) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform1Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform1I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform1Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform1Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Long arg_v0) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform1Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform2F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Float arg_v0, @NonNull Float arg_v1) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform2I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0, @NonNull Integer arg_v1) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform2Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform2Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Long arg_v0, @NonNull Long arg_v1) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform2Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform3F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Float arg_v0, @NonNull Float arg_v1, @NonNull Float arg_v2) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform3I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0, @NonNull Integer arg_v1, @NonNull Integer arg_v2) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform3Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform3Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Long arg_v0, @NonNull Long arg_v1, @NonNull Long arg_v2) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform3Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform4F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Float arg_v0, @NonNull Float arg_v1, @NonNull Float arg_v2, @NonNull Float arg_v3) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2, arg_v3);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform4I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0, @NonNull Integer arg_v1, @NonNull Integer arg_v2, @NonNull Integer arg_v3) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2, arg_v3);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform4Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform4Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Long arg_v0, @NonNull Long arg_v1, @NonNull Long arg_v2, @NonNull Long arg_v3) {
        ProvidedAssetProcessors.setShaderUniformValue(shaderUniformAsset, arg_location, arg_v0, arg_v1, arg_v2, arg_v3);
    }

    public static void processProvidedActionForShaderUniformOnGlUniform4Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix2X3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix2X4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix3X2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix3X4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix4X2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static void processProvidedActionForShaderUniformOnGlUniformMatrix4X3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ShaderUniform shaderUniformAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        ProvidedAssetProcessors.setShaderUniformValues(shaderUniformAsset, arg_location, arg_count, KapiSpec.GLES.constants.GL_TRUE.equals(arg_transpose), arg_value);
    }

    public static @NonNull List<@NonNull GlTextureImageAsset> provideGlTextureImageAssetForGlTexStorage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset textureSurfaceAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_levels, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height) {
        return ProvidedAssetProcessors.getAllTextureImagesForGlTexStorage(functionCall, textureSurfaceAsset, arg_levels);
    }

    public static @NonNull GlTextureImageAsset provideGlTextureImageAssetForGlTexStorage2DmUltisample(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset textureSurfaceAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_samples, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations) {
        return textureSurfaceAsset.getOrCreateTextureLevel(functionCall, textureSurfaceAsset.getBaseMipMapLevel(), true);
    }

    public static @NonNull List<@NonNull GlTextureImageAsset> provideGlTextureImageAssetForGlTexStorage3D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset textureSurfaceAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_levels, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth) {
        return ProvidedAssetProcessors.getAllTextureImagesForGlTexStorage(functionCall, textureSurfaceAsset, arg_levels);
    }

    public static @NonNull GlTextureImageAsset provideGlTextureImageAssetForGlTexStorage3DmUltisample(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset textureSurfaceAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_samples, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth, @NonNull AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations) {
        return textureSurfaceAsset.getOrCreateTextureLevel(functionCall, textureSurfaceAsset.getBaseMipMapLevel(), true);
    }

    public static @NonNull GlTextureSurfaceAsset provideGlTextureSurfaceAssetForGlCompressedTexImage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_level, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_border, @NonNull Integer arg_imageSize, @NonNull TextureArgAttachment arg_data) throws AbortActionException {
        GlTextureSurfaceAsset surfaceAsset = textureAsset.getOrCreateTextureSurface(functionCall, arg_target, null);
        if (surfaceAsset == null) {
            throw new AbortActionException("Unexpected target type for texture");
        }
        return surfaceAsset;
    }

    public static @NonNull GlTextureSurfaceAsset provideGlTextureSurfaceAssetForGlCompressedTexImage3D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_level, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth, @NonNull Integer arg_border, @NonNull Integer arg_imageSize, @NonNull TextureArgAttachment arg_data) throws AbortActionException {
        GlTextureSurfaceAsset surfaceAsset = textureAsset.getOrCreateTextureSurface(functionCall, arg_target, arg_depth);
        if (surfaceAsset == null) {
            throw new AbortActionException("Unexpected target type for texture");
        }
        return surfaceAsset;
    }

    public static @NonNull GlTextureSurfaceAsset provideGlTextureSurfaceAssetForGlTexImage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_level, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_border, @NonNull AbstractConstantOrAliasSpecExtended arg_format, @NonNull AbstractConstantOrAliasSpecExtended arg_type, @NonNull TextureArgAttachment arg_pixels) throws AbortActionException {
        GlTextureSurfaceAsset surfaceAsset = textureAsset.getOrCreateTextureSurface(functionCall, arg_target, null);
        if (surfaceAsset == null) {
            throw new AbortActionException("Unexpected target type for texture");
        }
        return surfaceAsset;
    }

    public static @NonNull GlTextureSurfaceAsset provideGlTextureSurfaceAssetForGlTexImage3D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_level, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth, @NonNull Integer arg_border, @NonNull AbstractConstantOrAliasSpecExtended arg_format, @NonNull AbstractConstantOrAliasSpecExtended arg_type, @NonNull TextureArgAttachment arg_pixels) throws AbortActionException {
        GlTextureSurfaceAsset surfaceAsset = textureAsset.getOrCreateTextureSurface(functionCall, arg_target, arg_depth);
        if (surfaceAsset == null) {
            throw new AbortActionException("Unexpected target type for texture");
        }
        return surfaceAsset;
    }

    public static @NonNull GlTextureSurfaceAsset provideGlTextureSurfaceAssetForGlTexImage3Does(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_level, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth, @NonNull Integer arg_border, @NonNull AbstractConstantOrAliasSpecExtended arg_format, @NonNull AbstractConstantOrAliasSpecExtended arg_type, @NonNull TextureArgAttachment arg_pixels) throws AbortActionException {
        GlTextureSurfaceAsset surfaceAsset = textureAsset.getOrCreateTextureSurface(functionCall, arg_target, arg_depth);
        if (surfaceAsset == null) {
            throw new AbortActionException("Unexpected target type for texture");
        }
        return surfaceAsset;
    }

    public static @NonNull List<@NonNull GlTextureSurfaceAsset> provideGlTextureSurfaceAssetForGlTexStorage2D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_levels, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height) throws AbortActionException {
        HashSet<@NonNull AbstractConstantOrAliasSpecExtended> validSurfaceTargets = arg_target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP) ? TextureAssetUtils.CUBE_MAP_FACE_TARGETS : new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(arg_target));
        ArrayList<@NonNull GlTextureSurfaceAsset> result = new ArrayList<GlTextureSurfaceAsset>();
        for (AbstractConstantOrAliasSpecExtended surfaceTarget : validSurfaceTargets) {
            GlTextureSurfaceAsset surfaceAsset = textureAsset.getOrCreateTextureSurface(functionCall, surfaceTarget, null);
            if (surfaceAsset == null) {
                throw new AbortActionException("Unexpected target type for texture");
            }
            result.add(surfaceAsset);
        }
        return result;
    }

    public static @NonNull GlTextureSurfaceAsset provideGlTextureSurfaceAssetForGlTexStorage2DmUltisample(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_samples, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations) throws AbortActionException {
        GlTextureSurfaceAsset result = textureAsset.getOrCreateTextureSurface(functionCall, arg_target, null);
        if (result == null) {
            throw new AbortActionException("Unexpected target type for texture");
        }
        return result;
    }

    public static @NonNull List<@NonNull GlTextureSurfaceAsset> provideGlTextureSurfaceAssetForGlTexStorage3D(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_levels, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth) throws AbortActionException {
        return ProvidedAssetProcessors.getAllSurfacesForTexStorage3D(functionCall, textureAsset, arg_target, arg_depth);
    }

    public static @NonNull List<@NonNull GlTextureSurfaceAsset> provideGlTextureSurfaceAssetForGlTexStorage3DmUltisample(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_target, @NonNull Integer arg_samples, @NonNull AbstractConstantOrAliasSpecExtended arg_internalformat, @NonNull Integer arg_width, @NonNull Integer arg_height, @NonNull Integer arg_depth, @NonNull AbstractConstantOrAliasSpecExtended arg_fixedsamplelocations) throws AbortActionException {
        return ProvidedAssetProcessors.getAllSurfacesForTexStorage3D(functionCall, textureAsset, arg_target, arg_depth);
    }

    public static @NonNull GlTextureUnitAsset provideGlTextureUnitAssetForGlActiveTexture(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended arg_texture) {
        return AssetProcessorBase.getOrCreateNewGlTextureUnitAsset(currentState, functionCall, GlTextureUnitAsset.convertTextureUnitEnumToTextureUnitId(arg_texture));
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform1F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Float arg_v0) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform1Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform1I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform1Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform1Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Long arg_v0) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform1Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform2F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Float arg_v0, @NonNull Float arg_v1) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform2I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0, @NonNull Integer arg_v1) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform2Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform2Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Long arg_v0, @NonNull Long arg_v1) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform2Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform3F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Float arg_v0, @NonNull Float arg_v1, @NonNull Float arg_v2) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform3I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0, @NonNull Integer arg_v1, @NonNull Integer arg_v2) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform3Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform3Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Long arg_v0, @NonNull Long arg_v1, @NonNull Long arg_v2) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform3Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform4F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Float arg_v0, @NonNull Float arg_v1, @NonNull Float arg_v2, @NonNull Float arg_v3) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform4I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_v0, @NonNull Integer arg_v1, @NonNull Integer arg_v2, @NonNull Integer arg_v3) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform4Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform4Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Long arg_v0, @NonNull Long arg_v1, @NonNull Long arg_v2, @NonNull Long arg_v3) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniform4Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull LongsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix2X3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix2X4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix3X2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix3X4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix4X2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    public static @Nullable ShaderUniform provideShaderUniformForGlUniformMatrix4X3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, @NonNull Integer arg_location, @NonNull Integer arg_count, @NonNull AbstractConstantOrAliasSpecExtended arg_transpose, @NonNull FloatsArgAttachment arg_value) {
        return ProvidedAssetProcessors.mapLocationToShaderUniform(currentState, functionCall, currentProgramAsset, arg_location);
    }

    private static @NonNull List<@NonNull GlTextureSurfaceAsset> getAllSurfacesForTexStorage3D(@NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, @NonNull AbstractConstantOrAliasSpecExtended target, @NonNull Integer depth) throws AssertionError, AbortActionException {
        ArrayList<@NonNull GlTextureSurfaceAsset> result = new ArrayList<GlTextureSurfaceAsset>();
        if (TextureAssetUtils.isTargetUsingDepthAsArrayIndex(target)) {
            int surfaceCount = depth;
            if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY)) {
                surfaceCount *= 6;
            }
            int surfaceId = 0;
            while (surfaceId < surfaceCount) {
                GlTextureSurfaceAsset surface = textureAsset.getOrCreateTextureSurface(functionCall, target, surfaceId);
                if (surface == null) {
                    throw new AssertionError((Object)"surface asset not provided");
                }
                result.add(surface);
                ++surfaceId;
            }
        } else {
            GlTextureSurfaceAsset surface = textureAsset.getOrCreateTextureSurface(functionCall, target, depth);
            if (surface == null) {
                throw new AbortActionException("Unexpected target type for texture");
            }
            result.add(surface);
        }
        return result;
    }

    private static @NonNull List<@NonNull GlTextureImageAsset> getAllTextureImagesForGlTexStorage(@NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset textureSurfaceAsset, @NonNull Integer arg_levels) {
        ArrayList<@NonNull GlTextureImageAsset> result = new ArrayList<GlTextureImageAsset>();
        int i = 0;
        while (i < arg_levels) {
            GlTextureImageAsset imageAsset = textureSurfaceAsset.getOrCreateTextureLevel(functionCall, i, true);
            result.add(imageAsset);
            ++i;
        }
        return result;
    }

    private static @Nullable ShaderUniform mapLocationToShaderUniform(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset currentProgramAsset, int location) {
        GlProgramVariableOffset uniformVariableOffset = currentProgramAsset.getUniformsContainer().getByLocation(location);
        return uniformVariableOffset != null ? (ShaderUniform)uniformVariableOffset.getVariable() : null;
    }

    private static void setShaderUniformValue(@NonNull ShaderUniform shaderUniformAsset, int location, Number ... value) {
        int arrayIndex = shaderUniformAsset.mapLocationToIndex(location, 0);
        if (arrayIndex >= 0) {
            shaderUniformAsset.setValue(arrayIndex, value);
        }
    }

    private static <T extends Number> void setShaderUniformValues(@NonNull ShaderUniform shaderUniformAsset, int location, int count, @NonNull ArrayArgumentAttachment<T> arg_value) {
        if (arg_value.isEmpty() || arg_value.isNull()) {
            return;
        }
        assert (!shaderUniformAsset.getResourceDescriptor().resolveIsRowMajor()) : "setShaderUniformValues for non-matrix operations called on row-major matrix. Data will be inserted as if column major.";
        int i = 0;
        while (i < count) {
            int arrayIndex = shaderUniformAsset.mapLocationToIndex(location, i);
            if (arrayIndex >= 0) {
                @NonNull Number @NonNull [] value = ShaderUniformValueProcessorHelper.mapNumberArgsAttachment(arg_value, i, shaderUniformAsset.getType(), (Number[])NullUtils.neverNull((Object[])shaderUniformAsset.getValue(arrayIndex)));
                shaderUniformAsset.setValue(arrayIndex, value);
            }
            ++i;
        }
    }

    private static <T extends Number> void setShaderUniformValues(@NonNull ShaderUniform shaderUniformAsset, int location, int count, boolean transpose, @NonNull FloatsArgAttachment arg_value) {
        if (arg_value.isEmpty() || arg_value.isNull()) {
            return;
        }
        int i = 0;
        while (i < count) {
            int arrayIndex = shaderUniformAsset.mapLocationToIndex(location, i);
            if (arrayIndex >= 0) {
                @NonNull Number @NonNull [] value = ShaderUniformValueProcessorHelper.mapMatrixNumberArgsAttachment(arg_value, transpose, i, shaderUniformAsset.getType());
                shaderUniformAsset.setValue(arrayIndex, value);
            }
            ++i;
        }
    }

    public static void processProvidedActionForVkCommandBufferAssetOnVkResetCommandBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkCommandBufferAsset commandBufferAsset, Pointer arg_commandBuffer, Bitfield arg_flags, AbstractConstantOrAliasSpecExtended returnValue_) {
        commandBufferAsset.reset();
    }

    public static void processProvidedActionForVkCommandBufferAssetOnVkBeginCommandBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkCommandBufferAsset commandBufferAsset, Pointer arg_commandBuffer, VULKAN.Structs.VkCommandBufferBeginInfo arg_pBeginInfo, AbstractConstantOrAliasSpecExtended returnValue_) throws AbortActionException {
        commandBufferAsset.begin(currentState, functionCall);
    }

    public static void processProvidedActionForVkCommandBufferAssetOnVkEndCommandBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkCommandBufferAsset commandBufferAsset, Pointer arg_commandBuffer, AbstractConstantOrAliasSpecExtended returnValue_) throws AbortActionException {
        commandBufferAsset.end();
    }

    public static void processProvidedActionForClMemoryAssetOnClEnqueueWriteBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, ClMemoryAsset bufferAsset, Pointer arg_command_queue, Pointer arg_buffer, AbstractConstantOrAliasSpecExtended arg_blocking_write, Long arg_offset, Long arg_size, BufferArgAttachment arg_ptr, Long arg_num_events_in_wait_list, LongsArgAttachment arg_event_wait_list, LongPtrArgAttachment arg_event, AbstractConstantOrAliasSpecExtended returnValue_) {
        if (arg_ptr != null) {
            ClMemoryRegionAttachment att = new ClMemoryRegionAttachment(arg_offset, arg_ptr);
            bufferAsset.addDataAttachment(att);
        }
    }

    public static void processProvidedActionForClMemoryAssetOnClEnqueueCopyBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, ClMemoryAsset destinationBuffer, Pointer arg_command_queue, Pointer arg_src_buffer, Pointer arg_dst_buffer, Long arg_src_offset, Long arg_dst_offset, Long arg_size, Long arg_num_events_in_wait_list, LongsArgAttachment arg_event_wait_list, LongPtrArgAttachment arg_event, AbstractConstantOrAliasSpecExtended returnValue_, ClMemoryAsset sourceBuffer) {
        if (sourceBuffer != null) {
            EmulatedClMemoryRegionAttachment att = new EmulatedClMemoryRegionAttachment(arg_dst_offset, arg_src_offset, arg_size.intValue(), sourceBuffer);
            destinationBuffer.addDataAttachment(att);
        }
    }

    public static void processProvidedActionForVkSwapchainKhraSsetOnVkGetSwapchainImagesKhr(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkSwapchainKHRAsset swapchainAsset, Pointer arg_device, Handle arg_swapchain, LongPtrArgAttachment arg_pSwapchainImageCount, HandleArrayAttachment arg_pSwapchainImages, AbstractConstantOrAliasSpecExtended returnValue_) {
        if (!arg_pSwapchainImages.isNull()) {
            @NonNull ArrayList<VkImageAsset> images = new ArrayList<VkImageAsset>();
            for (Handle image : arg_pSwapchainImages) {
                 @NonNull VULKAN.Structs.VkExtent2D extent = swapchainAsset.getImageExtent();
                @NonNull Long extentWidth = extent.getWidth();
                @NonNull Long extentHeight = extent.getHeight();
                @NonNull VkExtent3DFromSwapchain extentFake = new VkExtent3DFromSwapchain(extentWidth, extentHeight);
                VkImageAsset imageAsset = new VkImageAsset(currentState.asSnapshotAssetParent(), functionCall, image.getHandleValue(), swapchainAsset.getImageArrayLayers(), extentFake, new Bitfield(), swapchainAsset.getImageFormat(), KapiSpec.VULKAN.constants.VK_IMAGE_TYPE_2D, KapiSpec.VULKAN.constants.VK_IMAGE_LAYOUT_UNDEFINED, 1L, swapchainAsset.getQueueFamilyIndices(), Bitfield.valueOf(KapiSpec.VULKAN.constants.VK_SAMPLE_COUNT_1_BIT), swapchainAsset.getImageSharingMode(), KapiSpec.VULKAN.constants.VK_IMAGE_TILING_OPTIMAL, swapchainAsset.getImageUsage());
                AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC);
                assetTableBySpec.addAsset(imageAsset);
                images.add(imageAsset);
            }
            swapchainAsset.setImages(images);
        }
    }

    public static void processProvidedActionForVkDescriptorPoolAssetOnVkResetDescriptorPool(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkDescriptorPoolAsset descriptorPoolAsset, Pointer arg_device, Handle arg_descriptorPool, Bitfield arg_flags, AbstractConstantOrAliasSpecExtended returnValue_) {
        for (VkDescriptorSetAsset descriptorSetAsset : descriptorPoolAsset.getDescriptorSets()) {
            AssetProcessorBase.deleteVkDescriptorSetAsset(currentState, functionCall, (VkDescriptorSetAsset)NullUtils.neverNull((Object)descriptorSetAsset));
        }
    }

    public static void processProvidedActionForVkBufferAssetOnVkBindBufferMemory(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkBufferAsset buffer, @NonNull Pointer device, @NonNull Handle bufferHandle, @NonNull Handle memoryHandle, @NonNull Long memoryOffset, @NonNull AbstractConstantOrAliasSpecExtended returnValue, @NonNull VkDeviceMemoryAsset memoryAsset) {
        memoryAsset.bindMemoryAsset(currentState, functionCall, buffer, memoryOffset);
    }

    public static void processProvidedActionForVkBufferAssetOnVkDestroyBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkBufferAsset bufferAsset, @NonNull Pointer arg_device, @NonNull Handle arg_buffer,  @NonNull VULKAN.Structs.VkAllocationCallbacks arg_pAllocator) {
        @Nullable VkDeviceMemoryAsset memory = bufferAsset.getBackingMemory();
        if (memory != null) {
            memory.unbindMemoryAsset(bufferAsset);
        }
    }

    public static void processProvidedActionForVkImageAssetOnVkCreateImage(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkImageAsset imageAsset, Pointer arg_device, VULKAN.Structs.VkImageCreateInfo arg_pCreateInfo, VULKAN.Structs.VkAllocationCallbacks arg_pAllocator, HandleAttachment arg_pImage, AbstractConstantOrAliasSpecExtended returnValue_) {
        @NonNull List<VulkanImageMemoryRequirementsAttachment> attachments = functionCall.findFreeAttachments(VulkanImageMemoryRequirementsAttachment.class);
        for (VulkanImageMemoryRequirementsAttachment att : attachments) {
            imageAsset.setAlignment(att.getAlignment());
            imageAsset.setSize(att.getSize());
            imageAsset.setMemoryTypeBits(att.getMemoryTypeBits());
        }
    }

    public static void processProvidedActionForVkImageAssetOnVkBindImageMemory(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkImageAsset imageAsset, @NonNull Pointer arg_device, @NonNull Handle arg_image, @NonNull Handle arg_memory, @NonNull Long arg_memoryOffset, @NonNull AbstractConstantOrAliasSpecExtended returnValue_, @NonNull VkDeviceMemoryAsset memoryAsset) {
        memoryAsset.bindMemoryAsset(currentState, functionCall, imageAsset, arg_memoryOffset);
    }

    public static void processProvidedActionForVkImageAssetOnVkDestroyImage(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkImageAsset imageAsset, @NonNull Pointer arg_device, @NonNull Handle arg_image,  @NonNull VULKAN.Structs.VkAllocationCallbacks arg_pAllocator) {
        @Nullable VkDeviceMemoryAsset memory = imageAsset.getBackingMemory();
        if (memory != null) {
            memory.unbindMemoryAsset(imageAsset);
        }
    }

    public static void processProvidedActionForGlTextureAssetOnGlTexParameterIiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlTextureAsset textureAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_pname, LongsArgAttachment arg_params) {
        ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameter(textureAsset, arg_pname, arg_params.asList());
    }

    public static void processProvidedActionForGlTextureAssetOnGlTexParameterIuiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlTextureAsset textureAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_pname, LongsArgAttachment arg_params) {
        ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameter(textureAsset, arg_pname, arg_params.asList());
    }

    public static void processProvidedActionForGlTextureAssetOnGlTexParameteri(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlTextureAsset textureAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_pname, AbstractConstantOrAliasSpecExtended arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameter(textureAsset, arg_pname, NullUtils.asList((Object[])new AbstractConstantOrAliasSpecExtended[]{arg_param}));
    }

    public static void processProvidedActionForGlTextureAssetOnGlTexParameteriv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlTextureAsset textureAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_pname, LongsArgAttachment arg_params) {
        ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameter(textureAsset, arg_pname, arg_params.asList());
    }

    public static void processProvidedActionForGlTextureAssetOnGlTexParameterf(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlTextureAsset textureAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_pname, Float arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameter(textureAsset, arg_pname, NullUtils.asList((Object[])new Float[]{arg_param}));
    }

    public static void processProvidedActionForGlTextureAssetOnGlTexParameterfv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlTextureAsset textureAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_pname, FloatsArgAttachment arg_params) {
        ProvidedAssetProcessors.processProvidedActionForGlTextureAssetOnGlTexParameter(textureAsset, arg_pname, arg_params.asList());
    }

    private static void processProvidedActionForGlTextureAssetOnGlTexParameter(GlTextureAsset textureAsset, AbstractConstantOrAliasSpecExtended arg_pname, @NonNull List<?> arg_params) {
        if (arg_pname.equals(KapiSpec.GLES.constants.GL_DEPTH_STENCIL_TEXTURE_MODE)) {
            textureAsset.setDepthStencilTextureMode(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_BASE_LEVEL)) {
            textureAsset.setBaseLevel(ProvidedAssetProcessors.coerceListToLong(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_BORDER_COLOR)) {
            textureAsset.setBorderColor(ProvidedAssetProcessors.coerceListToFloatArray(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_COMPARE_MODE)) {
            textureAsset.setCompareMode(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_COMPARE_FUNC)) {
            textureAsset.setCompareFunc(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MAG_FILTER)) {
            textureAsset.setMagFilter(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MAX_LEVEL)) {
            textureAsset.setMaxLevel(ProvidedAssetProcessors.coerceListToLong(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MAX_LOD)) {
            textureAsset.setMaxLod(ProvidedAssetProcessors.coerceListToFloat(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MIN_FILTER)) {
            textureAsset.setMinFilter(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MIN_LOD)) {
            textureAsset.setMinLod(ProvidedAssetProcessors.coerceListToFloat(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_SWIZZLE_R)) {
            textureAsset.setSwizzleR(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_SWIZZLE_G)) {
            textureAsset.setSwizzleG(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_SWIZZLE_B)) {
            textureAsset.setSwizzleB(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_SWIZZLE_A)) {
            textureAsset.setSwizzleA(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_WRAP_S)) {
            textureAsset.setWrapS(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_WRAP_T)) {
            textureAsset.setWrapT(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_WRAP_R)) {
            textureAsset.setWrapR(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        }
    }

    public static void processProvidedActionForGlSamplerAssetOnGlSamplerParameterIiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlSamplerAsset samplerAsset, Long arg_sampler, AbstractConstantOrAliasSpecExtended arg_pname, LongsArgAttachment arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameter(samplerAsset, arg_pname, arg_param.asList());
    }

    public static void processProvidedActionForGlSamplerAssetOnGlSamplerParameterIuiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlSamplerAsset samplerAsset, Long arg_sampler, AbstractConstantOrAliasSpecExtended arg_pname, LongsArgAttachment arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameter(samplerAsset, arg_pname, arg_param.asList());
    }

    public static void processProvidedActionForGlSamplerAssetOnGlSamplerParameteri(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlSamplerAsset samplerAsset, Long arg_sampler, AbstractConstantOrAliasSpecExtended arg_pname, AbstractConstantOrAliasSpecExtended arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameter(samplerAsset, arg_pname, NullUtils.asList((Object[])new AbstractConstantOrAliasSpecExtended[]{arg_param}));
    }

    public static void processProvidedActionForGlSamplerAssetOnGlSamplerParameteriv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlSamplerAsset samplerAsset, Long arg_sampler, AbstractConstantOrAliasSpecExtended arg_pname, LongsArgAttachment arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameter(samplerAsset, arg_pname, arg_param.asList());
    }

    public static void processProvidedActionForGlSamplerAssetOnGlSamplerParameterf(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlSamplerAsset samplerAsset, Long arg_sampler, AbstractConstantOrAliasSpecExtended arg_pname, Float arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameter(samplerAsset, arg_pname, NullUtils.asList((Object[])new Float[]{arg_param}));
    }

    public static void processProvidedActionForGlSamplerAssetOnGlSamplerParameterfv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlSamplerAsset samplerAsset, Long arg_sampler, AbstractConstantOrAliasSpecExtended arg_pname, FloatsArgAttachment arg_param) {
        ProvidedAssetProcessors.processProvidedActionForGlSamplerAssetOnGlSamplerParameter(samplerAsset, arg_pname, arg_param.asList());
    }

    private static void processProvidedActionForGlSamplerAssetOnGlSamplerParameter(GlSamplerAsset samplerAsset, AbstractConstantOrAliasSpecExtended arg_pname, @NonNull List<?> arg_params) {
        if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_BORDER_COLOR)) {
            samplerAsset.setBorderColor(ProvidedAssetProcessors.coerceListToFloatArray(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MIN_FILTER)) {
            samplerAsset.setMinFilter(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MAG_FILTER)) {
            samplerAsset.setMagFilter(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_WRAP_S)) {
            samplerAsset.setWrapS(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_WRAP_T)) {
            samplerAsset.setWrapT(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_WRAP_R)) {
            samplerAsset.setWrapR(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MIN_LOD)) {
            samplerAsset.setMinLod(ProvidedAssetProcessors.coerceListToFloat(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_MAX_LOD)) {
            samplerAsset.setMaxLod(ProvidedAssetProcessors.coerceListToFloat(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_COMPARE_MODE)) {
            samplerAsset.setCompareMode(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        } else if (arg_pname.equals(KapiSpec.GLES.constants.GL_TEXTURE_COMPARE_FUNC)) {
            samplerAsset.setCompareFunc(ProvidedAssetProcessors.coerceListToAbstractConstantOrAliasSpecExtended(arg_params));
        }
    }

    private static @NonNull AbstractConstantOrAliasSpecExtended coerceListToAbstractConstantOrAliasSpecExtended(@NonNull List<?> arg_params) {
        if (arg_params.size() > 0) {
            Object param = arg_params.get(0);
            if (param instanceof AbstractConstantOrAliasSpecExtended) {
                return (AbstractConstantOrAliasSpecExtended)param;
            }
            if (param instanceof Long) {
                return KapiSpec.GLES.getConstantSpecByValue((Long)param);
            }
            if (param instanceof Float) {
                return KapiSpec.GLES.getConstantSpecByValue(NullUtils.longValueOf((long)((Float)param).longValue()));
            }
        }
        return KapiSpec.GLES.getConstantSpecByValue(NullUtils.longValueOf((long)0L));
    }

    private static long coerceListToLong(@NonNull List<?> arg_params) {
        if (arg_params.size() > 0) {
            Object param = arg_params.get(0);
            if (param instanceof AbstractConstantOrAliasSpecExtended) {
                return ((AbstractConstantOrAliasSpecExtended)param).getResolvedValue();
            }
            if (param instanceof Long) {
                return (Long)param;
            }
            if (param instanceof Float) {
                return ((Float)param).longValue();
            }
        }
        return 0L;
    }

    private static float coerceListToFloat(@NonNull List<?> arg_params) {
        if (arg_params.size() > 0) {
            Object param = arg_params.get(0);
            if (param instanceof AbstractConstantOrAliasSpecExtended) {
                return ((AbstractConstantOrAliasSpecExtended)param).getResolvedValue().floatValue();
            }
            if (param instanceof Long) {
                return ((Long)param).floatValue();
            }
            if (param instanceof Float) {
                return ((Float)param).floatValue();
            }
        }
        return 0.0f;
    }

    private static float @Nullable [] coerceListToFloatArray(@NonNull List<?> arg_params) {
        if (arg_params.size() > 0) {
            float[] values = new float[arg_params.size()];
            int i = 0;
            while (i < arg_params.size()) {
                Object param = arg_params.get(i);
                if (param instanceof AbstractConstantOrAliasSpecExtended) {
                    values[i] = ((AbstractConstantOrAliasSpecExtended)param).getResolvedValue().floatValue();
                } else if (param instanceof Long) {
                    values[i] = ((Long)param).floatValue();
                } else if (param instanceof Float) {
                    values[i] = ((Float)param).floatValue();
                }
                ++i;
            }
            return values;
        }
        return null;
    }

    public static void processProvidedActionForGlProgramAssetOnGlProgramParameteri(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset program, @NonNull Long arg_program, @NonNull AbstractConstantOrAliasSpecExtended arg_pname, @NonNull Integer arg_value) {
        if (arg_pname.equals(KapiSpec.GLES.constants.GL_PROGRAM_SEPARABLE)) {
            program.setSeparable(KapiSpec.GLES.constants.GL_TRUE.getResolvedValue().intValue() == arg_value.intValue());
        }
    }

    public static void processProvidedActionForGlProgramPipelineAssetOnGlUseProgramStages(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlProgramPipelineAsset programPipelineAsset, Long arg_pipeline, Bitfield arg_stages, Long arg_program, GlProgramAsset programAsset) {
        if (arg_stages.contains(KapiSpec.GLES.constants.GL_VERTEX_SHADER_BIT)) {
            programPipelineAsset.setVertexShader(programAsset);
        }
        if (arg_stages.contains(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER_BIT)) {
            programPipelineAsset.setTessControlShader(programAsset);
        }
        if (arg_stages.contains(KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER_BIT)) {
            programPipelineAsset.setTessEvaluationShader(programAsset);
        }
        if (arg_stages.contains(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER_BIT)) {
            programPipelineAsset.setFragmentShader(programAsset);
        }
        if (arg_stages.contains(KapiSpec.GLES.constants.GL_COMPUTE_SHADER_BIT)) {
            programPipelineAsset.setComputeShader(programAsset);
        }
    }

    private static @NonNull GlProgramAsset requireCurrentActiveProgram(@NonNull TraceStateSnapshot currentState) throws AbortActionException {
        GlProgramAsset asset = GlProgramHelper.getCurrentActiveProgram(currentState);
        if (asset != null) {
            return asset;
        }
        throw new AbortActionException("No current active program or program pipeline");
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform1F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Float arg_v0) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform1Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform1I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_v0) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform1Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform1Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Long arg_v0) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform1Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform2F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Float arg_v0, Float arg_v1) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform2I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_v0, Integer arg_v1) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform2Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform2Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Long arg_v0, Long arg_v1) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform2Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform3F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Float arg_v0, Float arg_v1, Float arg_v2) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform3I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_v0, Integer arg_v1, Integer arg_v2) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform3Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform3Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Long arg_v0, Long arg_v1, Long arg_v2) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform3Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform4F(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Float arg_v0, Float arg_v1, Float arg_v2, Float arg_v3) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform4I(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_v0, Integer arg_v1, Integer arg_v2, Integer arg_v3) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform4Iv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform4Ui(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Long arg_v0, Long arg_v1, Long arg_v2, Long arg_v3) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniform4Uiv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, LongsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix2X3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix2X4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix3X2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix3X4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix4Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix4X2Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static @NonNull GlProgramAsset provideGlProgramAssetForGlUniformMatrix4X3Fv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, Integer arg_location, Integer arg_count, AbstractConstantOrAliasSpecExtended arg_transpose, FloatsArgAttachment arg_value) throws AbortActionException {
        return ProvidedAssetProcessors.requireCurrentActiveProgram(currentState);
    }

    public static void processProvidedActionForGlProgramAssetOnGlCreateShaderProgramv(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlProgramAsset programAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_type, Integer arg_count, @NonNull StringsArgAttachment arg_strings, Long returnValue_) throws ApiUsageException {
        GlShaderAsset shader = new GlShaderAsset(currentState.asSnapshotAssetParent(), functionCall, 1L, arg_type);
        shader.setSource(functionCall, arg_strings);
        shader.setCompiled(true);
        programAsset.attachShader(functionCall, shader);
        programAsset.setSeparable(true);
        programAsset.link();
        programAsset.detachShaderById(functionCall, shader.getId());
        shader.setDeleted(true);
    }

    public static void processProvidedActionForGlProgramAssetOnGlCreateShaderProgramvExt(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlProgramAsset programAsset, @NonNull AbstractConstantOrAliasSpecExtended arg_type, Integer arg_count, @NonNull StringsArgAttachment arg_strings, Long returnValue_) throws ApiUsageException {
        ProvidedAssetProcessors.processProvidedActionForGlProgramAssetOnGlCreateShaderProgramv(currentState, functionCall, programAsset, arg_type, arg_count, arg_strings, returnValue_);
    }

    public static void processProvidedActionForEglSurfaceAssetOnEglSurfaceAttrib(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, EglSurfaceAsset surfaceAsset, Pointer arg_dpy, Pointer arg_surface, AbstractConstantOrAliasSpecExtended arg_attribute, Integer arg_value, AbstractConstantOrAliasSpecExtended returnValue_) {
        assert (surfaceAsset != null);
        @NonNull Long attributeValue = NullUtils.longValueOf((long)arg_value.longValue());
        if (KapiSpec.EGL.constants.EGL_RENDER_BUFFER.equals(NullUtils.neverNull((Object)arg_attribute))) {
            @Nullable Long currentAttributeValue = surfaceAsset.getAttribute((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)arg_attribute));
            if (!attributeValue.equals(currentAttributeValue)) {
                surfaceAsset.setPendingAttribute((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)arg_attribute), attributeValue);
            }
            return;
        }
        surfaceAsset.setAttribute((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)arg_attribute), attributeValue);
    }

    public static void processProvidedActionForEglSurfaceAssetOnEglSwapBuffers(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, EglSurfaceAsset surfaceAsset, Pointer arg_dpy, Pointer arg_surface, AbstractConstantOrAliasSpecExtended returnValue_) {
        if (surfaceAsset == null) {
            return;
        }
        @Nullable Long eglRenderBufferAttributeValue = surfaceAsset.getPendingAttribute(KapiSpec.EGL.constants.EGL_RENDER_BUFFER);
        if (eglRenderBufferAttributeValue != null) {
            surfaceAsset.setAttribute(KapiSpec.EGL.constants.EGL_RENDER_BUFFER, (Long)NullUtils.neverNull((Object)eglRenderBufferAttributeValue));
        }
        surfaceAsset.setPendingAttributesCollection(NullUtils.emptyMap());
    }

    public static void processProvidedActionForGlFramebufferAssetOnGlFramebufferTextureMultisampleMultiviewOvr(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlFramebufferAsset framebufferAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_attachment, Long arg_texture, Integer arg_level, Integer arg_samples, Integer arg_baseViewIndex, Integer arg_numViews, GlTextureAsset textureAsset) {
        GlFramebufferAttachmentAsset[] oldAssets;
        GlFramebufferAttachmentAsset[] glFramebufferAttachmentAssetArray = oldAssets = framebufferAsset.clearAttachment((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)arg_attachment));
        int n = oldAssets.length;
        int n2 = 0;
        while (n2 < n) {
            IAssetItem attachmentAsset;
            GlFramebufferAttachmentAsset oldAsset = glFramebufferAttachmentAssetArray[n2];
            if (oldAsset != null && (attachmentAsset = oldAsset.getAsset()) != null) {
                attachmentAsset.setNote(functionCall, "");
            }
            ++n2;
        }
        framebufferAsset.attachAsset(new GlFramebufferTextureMultiviewAttachmentAsset(functionCall, framebufferAsset, arg_attachment.getResolvedValue(), (GlTextureAsset)NullUtils.neverNull((Object)textureAsset), arg_level.longValue(), arg_baseViewIndex.longValue(), arg_numViews, arg_samples));
        textureAsset.addBoundTo(framebufferAsset.getId(), arg_attachment, functionCall);
    }

    public static void processProvidedActionForGlFramebufferAssetOnGlFramebufferTextureMultiviewOvr(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlFramebufferAsset framebufferAsset, AbstractConstantOrAliasSpecExtended arg_target, AbstractConstantOrAliasSpecExtended arg_attachment, Long arg_texture, Integer arg_level, Integer arg_baseViewIndex, Integer arg_numViews, GlTextureAsset textureAsset) {
        ProvidedAssetProcessors.processProvidedActionForGlFramebufferAssetOnGlFramebufferTextureMultisampleMultiviewOvr(currentState, functionCall, framebufferAsset, arg_target, arg_attachment, arg_texture, arg_level, 0, arg_baseViewIndex, arg_numViews, textureAsset);
    }
}

