/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.processors;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.ClBufferMemoryAsset;
import com.arm.mgd.core.asset.ClContextAsset;
import com.arm.mgd.core.asset.ClImageMemoryAsset;
import com.arm.mgd.core.asset.ClKernelAsset;
import com.arm.mgd.core.asset.ClMemoryAsset;
import com.arm.mgd.core.asset.ClProgramAsset;
import com.arm.mgd.core.asset.ClSubBufferMemoryAsset;
import com.arm.mgd.core.asset.EglAttribAssetProcessor;
import com.arm.mgd.core.asset.EglConfigAsset;
import com.arm.mgd.core.asset.EglContextAsset;
import com.arm.mgd.core.asset.EglDisplayAsset;
import com.arm.mgd.core.asset.EglImageAsset;
import com.arm.mgd.core.asset.EglPbufferSurfaceAsset;
import com.arm.mgd.core.asset.EglPixmapSurfaceAsset;
import com.arm.mgd.core.asset.EglSurfaceAsset;
import com.arm.mgd.core.asset.EglSyncAsset;
import com.arm.mgd.core.asset.EglWindowSurfaceAsset;
import com.arm.mgd.core.asset.GlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentBinding;
import com.arm.mgd.core.asset.GlFramebufferRenderbufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferTextureAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferZeroAttachmentAsset;
import com.arm.mgd.core.asset.GlImageUnitAsset;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramPipelineAsset;
import com.arm.mgd.core.asset.GlQueryObjectAsset;
import com.arm.mgd.core.asset.GlRenderbufferAsset;
import com.arm.mgd.core.asset.GlSamplerAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.core.asset.GlSyncObjectAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.GlTransformFeedbackAsset;
import com.arm.mgd.core.asset.GlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.core.asset.GlUniformBindingPointAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.core.asset.GlVertexBufferBindingAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.VkBufferViewAsset;
import com.arm.mgd.core.asset.VkCommand;
import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkComputePipelineAsset;
import com.arm.mgd.core.asset.VkDescriptorPoolAsset;
import com.arm.mgd.core.asset.VkDescriptorSetAsset;
import com.arm.mgd.core.asset.VkDescriptorSetLayoutAsset;
import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.asset.VkFramebufferAsset;
import com.arm.mgd.core.asset.VkGraphicsPipelineAsset;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.VkImageViewAsset;
import com.arm.mgd.core.asset.VkPipelineAsset;
import com.arm.mgd.core.asset.VkPipelineLayoutAsset;
import com.arm.mgd.core.asset.VkRenderPassAsset;
import com.arm.mgd.core.asset.VkShaderModuleAsset;
import com.arm.mgd.core.asset.VkShaderStage;
import com.arm.mgd.core.asset.VkSwapchainKHRAsset;
import com.arm.mgd.core.asset.objects.IRetainableAssetItem;
import com.arm.mgd.core.asset.objects.IVkAttachmentDescription;
import com.arm.mgd.core.asset.objects.IVkSubpassDependency;
import com.arm.mgd.core.asset.objects.IVkSubpassDescription;
import com.arm.mgd.core.asset.objects.OneShotPropertyFailureException;
import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.MissingAssetException;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.CL;
import com.arm.mgd.core.kapi.spec.GLES;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.lang.handle.HandleAttachment;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.state.GLESApiVersion;
import com.arm.mgd.core.state.GraphicsContext;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.AbstractContainerWrapperType;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.ClMemoryRegionAttachment;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongPtrArgAttachment;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.TargetBindingGroupSpec;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AssetProcessorBase {
    public static long asAssetID(long l) {
        return l;
    }

    public static long asAssetID(@NonNull StateItem stateItem) {
        if (stateItem.getStateSpec().equals(KapiSpec.GLES.states.GL_ACTIVE_TEXTURE)) {
            return ((AbstractConstantOrAliasSpecExtended)stateItem.getValue()[0].value).getResolvedValue() - KapiSpec.GLES.constants.GL_TEXTURE0.getResolvedValue();
        }
        return stateItem.getValue()[0].getValueAsLong();
    }

    public static @NonNull ClBufferMemoryAsset createNewClBufferMemoryAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull ClContextAsset context, @NonNull Bitfield flags) {
        ClBufferMemoryAsset buffer = new ClBufferMemoryAsset(currentState.asSnapshotAssetParent(), functionCall, id, context, flags);
        if (flags.contains(KapiSpec.CL.constants.CL_MEM_COPY_HOST_PTR)) {
            BufferArgAttachment ptr = CL.ClCreateBufferDecorator.getArgumentHost_ptr(functionCall);
            ClMemoryRegionAttachment att = new ClMemoryRegionAttachment(0L, ptr);
            buffer.addDataAttachment(att);
        }
        currentState.addAsset(buffer);
        return buffer;
    }

    public static ClImageMemoryAsset createNewClImageMemoryAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long temp_asAssetID_return_value_1, @NonNull ClContextAsset imageContextAsset, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended type, @NonNull AbstractConstantOrAliasSpecExtended channelOrder, @NonNull AbstractConstantOrAliasSpecExtended channelDataType) {
        BufferArgAttachment data;
        ClImageMemoryAsset imageAsset = new ClImageMemoryAsset(currentState.asSnapshotAssetParent(), functionCall, temp_asAssetID_return_value_1, imageContextAsset, flags, type, channelOrder, channelDataType);
        @NonNull IFunctionOrAliasSpecExtended spec = functionCall.getFunctionSpec();
        if (spec.equals(KapiSpec.CL.functions.CLCREATEIMAGE)) {
            data = CL.ClCreateImageDecorator.getArgumentHost_ptr(functionCall);
        } else if (spec.equals(KapiSpec.CL.functions.CLCREATEIMAGE2D)) {
            data = CL.ClCreateImage2DDecorator.getArgumentHost_ptr(functionCall);
        } else if (spec.equals(KapiSpec.CL.functions.CLCREATEIMAGE3D)) {
            data = CL.ClCreateImage3DDecorator.getArgumentHost_ptr(functionCall);
        } else {
            assert (false) : "Unrecognised CL image constructor: " + spec.getName();
            data = null;
        }
        if (flags.contains(KapiSpec.CL.constants.CL_MEM_COPY_HOST_PTR) && data != null) {
            imageAsset.addDataAttachment(new ClMemoryRegionAttachment(0L, data));
        }
        currentState.addAsset(imageAsset);
        return imageAsset;
    }

    public static void deleteGlVertexArrayObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset asset) {
        assert (asset.getId() != 0L);
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS.SPEC).remove(asset.getId());
    }

    public static @Nullable ClContextAsset getClContextAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.CONTEXT_TRAITS.SPEC);
        return (ClContextAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable ClKernelAsset getClKernelAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC);
        return (ClKernelAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable ClProgramAsset getClProgramAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC);
        return (ClProgramAsset)assetTableBySpec.get((Long)id);
    }

    public static @NonNull List<@NonNull AbstractConstantOrAliasSpecExtended> getDefaultPropertyValueForGlFramebufferAssetDrawBuffers(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        return GlFramebufferAsset.getDefaultDrawBuffers(id);
    }

    public static @NonNull AbstractConstantOrAliasSpecExtended getDefaultPropertyValueForGlFramebufferAssetReadBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        return GlFramebufferAsset.getDefaultReadBuffer(id);
    }

    public static @NonNull GlVertexAttributeNonArrayValueAsset getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        return AssetProcessorBase.getOrCreateNewGlVertexAttributeNonArrayValueAsset(currentState, functionCall, id, AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue(currentState, functionCall, id));
    }

    public static Number[] getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        return GlVertexAttributeNonArrayValueAsset.DEFAULT_VERTEX;
    }

    public static @Nullable EglContextAsset getEglContextAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS.SPEC);
        EglContextAsset result = (EglContextAsset)assetTableBySpec.get((Long)id);
        return result;
    }

    public static @NonNull EglDisplayAsset getEglDisplayAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        return AssetProcessorBase.getOrCreateNewEglDisplayAsset(currentState, functionCall, id, Pointer.NULL);
    }

    protected static long asAssetID(@NonNull LongPtrArgAttachment argAttachment) {
        return argAttachment.getValue();
    }

    public static @Nullable EglImageAsset getEglImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS.SPEC);
        return (EglImageAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable EglPbufferSurfaceAsset getEglPbufferSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        EglSurfaceAsset surfaceAsset = AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, id);
        return surfaceAsset instanceof EglPbufferSurfaceAsset ? (EglPbufferSurfaceAsset)surfaceAsset : null;
    }

    public static @Nullable EglPixmapSurfaceAsset getEglPixmapSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        EglSurfaceAsset surfaceAsset = AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, id);
        return surfaceAsset instanceof EglPixmapSurfaceAsset ? (EglPixmapSurfaceAsset)surfaceAsset : null;
    }

    public static @Nullable EglSurfaceAsset getEglSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS.SPEC);
        EglSurfaceAsset result = (EglSurfaceAsset)assetTableBySpec.get((Long)id);
        return result;
    }

    public static @Nullable EglSyncAsset getEglSyncAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS.SPEC);
        return (EglSyncAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable EglWindowSurfaceAsset getEglWindowSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        EglSurfaceAsset surfaceAsset = AssetProcessorBase.getEglSurfaceAsset(currentState, functionCall, id);
        return surfaceAsset instanceof EglWindowSurfaceAsset ? (EglWindowSurfaceAsset)surfaceAsset : null;
    }

    public static @Nullable GlBufferAsset getGlBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC);
        return (GlBufferAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable GlFramebufferAsset getGlFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC);
        GlFramebufferAsset asset = (GlFramebufferAsset)assetTableBySpec.get((Long)id);
        if (asset == null && id == defaultObjectId) {
            asset = GlFramebufferAsset.createFramebufferZero(currentState.asSnapshotAssetParent(), functionCall);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @Nullable GlFramebufferRenderbufferAttachmentAsset getGlFramebufferRenderbufferAttachmentAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset, long id) {
        AbstractConstantOrAliasSpecExtended attachment = KapiSpec.GLES.constantGroups.FRAMEBUFFERATTACHMENT.getConstantSpecByValue(NullUtils.longValueOf((long)id));
        GlFramebufferAttachmentBinding binding = parentAsset.getAttachmentBinding(attachment);
        GlFramebufferAttachmentAsset asset = binding != null ? binding.getAsset() : null;
        return asset instanceof GlFramebufferRenderbufferAttachmentAsset ? (GlFramebufferRenderbufferAttachmentAsset)asset : null;
    }

    public static @Nullable GlFramebufferTextureAttachmentAsset getGlFramebufferTextureAttachmentAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset, long id) {
        AbstractConstantOrAliasSpecExtended attachment = KapiSpec.GLES.constantGroups.FRAMEBUFFERATTACHMENT.getConstantSpecByValue(NullUtils.longValueOf((long)id));
        GlFramebufferAttachmentBinding binding = parentAsset.getAttachmentBinding(attachment);
        GlFramebufferAttachmentAsset asset = binding != null ? binding.getAsset() : null;
        return asset instanceof GlFramebufferTextureAttachmentAsset ? (GlFramebufferTextureAttachmentAsset)asset : null;
    }

    public static @Nullable GlFramebufferZeroAttachmentAsset getGlFramebufferZeroAttachmentAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset, long id) {
        AbstractConstantOrAliasSpecExtended attachment = KapiSpec.GLES.constantGroups.FRAMEBUFFERATTACHMENT.getConstantSpecByValue(NullUtils.longValueOf((long)id));
        GlFramebufferAttachmentBinding binding = parentAsset.getAttachmentBinding(attachment);
        GlFramebufferAttachmentAsset asset = binding != null ? binding.getAsset() : null;
        return asset instanceof GlFramebufferZeroAttachmentAsset ? (GlFramebufferZeroAttachmentAsset)asset : null;
    }

    public static @Nullable GlProgramAsset getGlProgramAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC);
        return (GlProgramAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable GlQueryObjectAsset getGlQueryObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.QUERY_TRAITS.SPEC);
        return (GlQueryObjectAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable GlRenderbufferAsset getGlRenderbufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS.SPEC);
        return (GlRenderbufferAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable GlSamplerAsset getGlSamplerAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SAMPLER_TRAITS.SPEC);
        return (GlSamplerAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable GlShaderAsset getGlShaderAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC);
        return (GlShaderAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable GlSyncObjectAsset getGlSyncObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS.SPEC);
        return (GlSyncObjectAsset)assetTableBySpec.get((Long)id);
    }

    public static @Nullable GlTextureAsset getGlTextureAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC);
        GlTextureAsset asset = (GlTextureAsset)assetTableBySpec.get((Long)id);
        if (asset == null && id == defaultObjectId) {
            asset = new GlTextureAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlTextureImageAsset getGlTextureImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset textureSurfaceAsset, long level) {
        return textureSurfaceAsset.getOrCreateTextureLevel(functionCall, level, false);
    }

    public static @Nullable GlTextureSurfaceAsset getGlTextureSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset textureAsset, long id) {
        return textureAsset.getOrCreateTextureSurfaceById(functionCall, id);
    }

    public static @Nullable GlVertexArrayObjectAsset getGlVertexArrayObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS.SPEC);
        GlVertexArrayObjectAsset result = (GlVertexArrayObjectAsset)assetTableBySpec.get((Long)id);
        if (result == null && id == defaultObjectId) {
            result = new GlVertexArrayObjectAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(result);
        }
        return result;
    }

    public static @NonNull EglConfigAsset getOrCreateNewEglConfigAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, EglDisplayAsset parentDisplay) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLCONFIG_TRAITS.SPEC);
        EglConfigAsset asset = (EglConfigAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new EglConfigAsset(currentState.asSnapshotAssetParent(), functionCall, id, parentDisplay);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlAtomicCounterBufferBindingPointAsset getOrCreateNewGlAtomicCounterBufferBindingPointAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.ATOMIC_COUNTER_BUFFER_BINDINGPOINT_TRAITS.SPEC);
        GlAtomicCounterBufferBindingPointAsset asset = (GlAtomicCounterBufferBindingPointAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new GlAtomicCounterBufferBindingPointAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlImageUnitAsset getOrCreateNewGlImageUnitAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.IMAGE_UNIT_TRAITS.SPEC);
        GlImageUnitAsset asset = (GlImageUnitAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new GlImageUnitAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlShaderStorageBufferBindingPointAsset getOrCreateNewGlShaderStorageBufferBindingPointAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_STORAGE_BUFFER_BINDINGPOINT_TRAITS.SPEC);
        GlShaderStorageBufferBindingPointAsset asset = (GlShaderStorageBufferBindingPointAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new GlShaderStorageBufferBindingPointAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlTextureUnitAsset getOrCreateNewGlTextureUnitAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC);
        GlTextureUnitAsset asset = (GlTextureUnitAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new GlTextureUnitAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlTransformFeedbackBufferBindingPointAsset getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_BUFFER_BINDINGPOINT_TRAITS.SPEC);
        GlTransformFeedbackBufferBindingPointAsset asset = (GlTransformFeedbackBufferBindingPointAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new GlTransformFeedbackBufferBindingPointAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlUniformBindingPointAsset getOrCreateNewGlUniformBindingPointAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.UNIFORM_BINDING_POINT_TRAITS.SPEC);
        GlUniformBindingPointAsset asset = (GlUniformBindingPointAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new GlUniformBindingPointAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlVertexAttributeAsset getOrCreateNewGlVertexAttributeAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset, long id, @NonNull GlVertexAttributeNonArrayValueAsset nonArrayAssetValue) {
        return parentAsset.getVertexAttributeAssetById(id);
    }

    public static @NonNull GlVertexAttributeNonArrayValueAsset getOrCreateNewGlVertexAttributeNonArrayValueAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, Number[] nonArrayValueAssetValue) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_TRAITS.SPEC);
        GlVertexAttributeNonArrayValueAsset asset = (GlVertexAttributeNonArrayValueAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new GlVertexAttributeNonArrayValueAsset(currentState.asSnapshotAssetParent(), functionCall, id, nonArrayValueAssetValue);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @NonNull GlVertexBufferBindingAsset getOrCreateNewGlVertexBufferBindingAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset, long id) {
        return parentAsset.getOrCreateNewGlVertexBufferBindingAsset(id);
    }

    public static @Nullable ShaderUniform getShaderUniform(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset parentAsset, long id) {
        return (ShaderUniform)parentAsset.getUniformsContainer().getByIndex(id);
    }

    public static void handleOneShotPropertyFailure(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull OneShotPropertyFailureException oneShotException) {
        String[] stringArray = oneShotException.getMessages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            TraceAnalysisLogger.warning(currentState, functionCall, message);
            ++n2;
        }
    }

    public static boolean mapGlBoolean(@NonNull AbstractConstantOrAliasSpecExtended bool) {
        assert (KapiSpec.GLES.constantGroups.BOOLEAN.contains(bool));
        return bool.getResolvedValue() != 0L;
    }

    public static void retainAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull IRetainableAssetItem asset) {
        asset.getReferenceCounter().increment();
    }

    protected static long asAssetID(@NonNull Long l) {
        return l;
    }

    protected static long asAssetID(@NonNull Pointer pointer) {
        return pointer.address();
    }

    public static @NonNull List<@NonNull Long> asAssetIDs(@Nullable LongsArgAttachment longs) {
        return longs != null ? longs.asList() : NullUtils.EMPTY_LIST;
    }

    protected static Map<AbstractConstantOrAliasSpecExtended, Long> convertEglAttributesToMap(@NonNull LongsArgAttachment attributesAttachment) {
        return EglAttribAssetProcessor.convertEglAttributesToMap(attributesAttachment);
    }

    protected static @NonNull ClContextAsset createNewClContextAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        ClContextAsset item = new ClContextAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(item);
        return item;
    }

    protected static @NonNull ClProgramAsset createNewClProgramAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull ClContextAsset contextAsset) {
        ClProgramAsset newAsset = new ClProgramAsset(currentState.asSnapshotAssetParent(), functionCall, id, contextAsset);
        currentState.addAsset(newAsset);
        return newAsset;
    }

    protected static @NonNull ClSubBufferMemoryAsset createNewClSubBufferMemoryAsset(@NonNull TraceStateSnapshot currentState, FunctionCall createdByFunction, long id, @NonNull ClContextAsset contextAsset, @NonNull Bitfield flags,  @NonNull CL.Structs.ClBufferRegionStruct bufferRegion, @NonNull ClMemoryAsset parentBufferAsset) {
        ClSubBufferMemoryAsset newSubBuffer = new ClSubBufferMemoryAsset(currentState.asSnapshotAssetParent(), createdByFunction, id, contextAsset, flags, bufferRegion, parentBufferAsset);
        currentState.addAsset(newSubBuffer);
        parentBufferAsset.addSubBuffer(newSubBuffer, createdByFunction, currentState);
        return newSubBuffer;
    }

    protected static @NonNull EglContextAsset createNewEglContextAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentDisplay, EglContextAsset sharedContext) {
        EglContextAsset item = new EglContextAsset(currentState.asSnapshotAssetParent(), functionCall, id, config, parentDisplay, sharedContext);
        currentState.addAsset(item);
        GLESApiVersion apiVersion = GraphicsContext.getApiVersion(functionCall);
        assert (apiVersion != null);
        currentState.createContext(Pointer.valueOf(item.getId()), sharedContext != null ? Pointer.valueOf(sharedContext.getId()) : null, apiVersion, functionCall);
        return item;
    }

    protected static @NonNull EglDisplayAsset createNewEglDisplayAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull Pointer nativeDisplayId) {
        return AssetProcessorBase.getOrCreateNewEglDisplayAsset(currentState, functionCall, id, nativeDisplayId);
    }

    protected static @NonNull EglImageAsset createNewEglImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull Pointer clientObjectID, @NonNull EglDisplayAsset parentDisplay, @Nullable EglContextAsset sourceContext, @NonNull AbstractConstantOrAliasSpecExtended target) {
        EglImageAsset item = new EglImageAsset(currentState.asSnapshotAssetParent(), functionCall, id, parentDisplay, clientObjectID, sourceContext, target);
        currentState.addAsset(item);
        return item;
    }

    protected static @NonNull EglPbufferSurfaceAsset createNewEglPbufferSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentDisplay) {
        EglPbufferSurfaceAsset item = new EglPbufferSurfaceAsset(currentState.asSnapshotAssetParent(), functionCall, id, config, parentDisplay);
        currentState.addAsset(item);
        return item;
    }

    protected static @NonNull EglPixmapSurfaceAsset createNewEglPixmapSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentDisplay, @NonNull Pointer pixmap) {
        EglPixmapSurfaceAsset item = new EglPixmapSurfaceAsset(currentState.asSnapshotAssetParent(), functionCall, id, config, parentDisplay, pixmap);
        currentState.addAsset(item);
        return item;
    }

    protected static @NonNull EglSyncAsset createNewEglSyncAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull EglDisplayAsset parentDisplay, @NonNull AbstractConstantOrAliasSpecExtended type) {
        EglSyncAsset item = new EglSyncAsset(currentState.asSnapshotAssetParent(), functionCall, id, parentDisplay, type);
        currentState.addAsset(item);
        return item;
    }

    protected static @NonNull EglWindowSurfaceAsset createNewEglWindowSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentDisplay, @NonNull Pointer window) {
        EglWindowSurfaceAsset item = new EglWindowSurfaceAsset(currentState.asSnapshotAssetParent(), functionCall, id, config, parentDisplay, window);
        currentState.addAsset(item);
        return item;
    }

    protected static @NonNull GlBufferAsset createNewGlBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        GlBufferAsset newBufferAsset = new GlBufferAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(newBufferAsset);
        return newBufferAsset;
    }

    protected static @NonNull GlFramebufferAsset createNewGlFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId, @NonNull List<AbstractConstantOrAliasSpecExtended> drawBuffers, @NonNull AbstractConstantOrAliasSpecExtended readBuffer) {
        if (id == defaultObjectId) {
            return (GlFramebufferAsset)NullUtils.neverNull((Object)AssetProcessorBase.getGlFramebufferAsset(currentState, functionCall, id, defaultObjectId));
        }
        GlFramebufferAsset newFramebuffer = new GlFramebufferAsset(currentState.asSnapshotAssetParent(), functionCall, id, drawBuffers, readBuffer);
        currentState.addAsset(newFramebuffer);
        return newFramebuffer;
    }

    protected static @NonNull GlProgramAsset createNewGlProgramAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        GlProgramAsset item = new GlProgramAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(item);
        return item;
    }

    protected static GlQueryObjectAsset createNewGlQueryObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        GlQueryObjectAsset newAsset = new GlQueryObjectAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(newAsset);
        return newAsset;
    }

    protected static @Nullable ClMemoryAsset getClMemoryAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.MEMORY_TRAITS.SPEC);
        return (ClMemoryAsset)assetTableBySpec.get((Long)id);
    }

    protected static @NonNull GlRenderbufferAsset createNewGlRenderbufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        GlRenderbufferAsset newRenderbuffer = new GlRenderbufferAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(newRenderbuffer);
        return newRenderbuffer;
    }

    protected static @NonNull GlSamplerAsset createNewGlSamplerAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        GlSamplerAsset newAsset = new GlSamplerAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(newAsset);
        return newAsset;
    }

    protected static @NonNull GlShaderAsset createNewGlShaderAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull AbstractConstantOrAliasSpecExtended type) throws ApiUsageException {
        if (!KapiSpec.GLES.constantGroups.SHADERTYPE.contains(type)) {
            throw new ApiUsageException("Shader type is not recognized.");
        }
        GlShaderAsset newAsset = new GlShaderAsset(currentState.asSnapshotAssetParent(), functionCall, id, type);
        currentState.addAsset(newAsset);
        return newAsset;
    }

    protected static GlSyncObjectAsset createNewGlSyncObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull AbstractConstantOrAliasSpecExtended type) {
        GlSyncObjectAsset newAsset = new GlSyncObjectAsset(currentState.asSnapshotAssetParent(), functionCall, id, type);
        currentState.addAsset(newAsset);
        return newAsset;
    }

    protected static @NonNull GlTextureAsset createNewGlTextureAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId) {
        if (id == defaultObjectId) {
            return (GlTextureAsset)NullUtils.neverNull((Object)AssetProcessorBase.getGlTextureAsset(currentState, functionCall, id, defaultObjectId));
        }
        GlTextureAsset newTexture = new GlTextureAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(newTexture);
        return newTexture;
    }

    protected static @NonNull GlVertexArrayObjectAsset createNewGlVertexArrayObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId) {
        if (id == defaultObjectId) {
            return (GlVertexArrayObjectAsset)NullUtils.neverNull((Object)AssetProcessorBase.getGlVertexArrayObjectAsset(currentState, functionCall, id, defaultObjectId));
        }
        GlVertexArrayObjectAsset item = new GlVertexArrayObjectAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(item);
        return item;
    }

    protected static void deleteClContextAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ClContextAsset contextAsset) {
        long newRefCount = contextAsset.getReferenceCounter().decrement();
        if (newRefCount == 0L) {
            currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.CONTEXT_TRAITS.SPEC).remove(contextAsset.getId());
        }
    }

    protected static void deleteClKernelAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ClKernelAsset kernelAsset) {
        long newRefCount = kernelAsset.getReferenceCounter().decrement();
        if (newRefCount == 0L) {
            currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC).remove(kernelAsset.getId());
        }
    }

    protected static void deleteClMemoryAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ClMemoryAsset memoryAsset) {
        long newRefCount = memoryAsset.getReferenceCounter().decrement();
        if (newRefCount == 0L) {
            currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.MEMORY_TRAITS.SPEC).remove(memoryAsset.getId());
            if (memoryAsset instanceof ClSubBufferMemoryAsset) {
                ClMemoryAsset parent = ((ClSubBufferMemoryAsset)memoryAsset).getParentBufferAsset();
                parent.removeSubBuffer((ClSubBufferMemoryAsset)memoryAsset);
            }
        }
    }

    protected static void deleteClProgramAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull ClProgramAsset programAsset) {
        long newRefCount = programAsset.getReferenceCounter().decrement();
        if (newRefCount == 0L) {
            currentState.getAssetTableBySpec(KapiSpec.CL.assetTables.PROGRAM_TRAITS.SPEC).remove(programAsset.getId());
        }
    }

    protected static void deleteEglContextAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull EglContextAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLCONTEXT_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteEglDisplayAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset asset) {
        if (asset.getReferenceCounter().decrement() <= 0L) {
            currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS.SPEC).remove(asset.getId());
        }
    }

    protected static void deleteEglImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull EglImageAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteEglSurfaceAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull EglSurfaceAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteEglSyncAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull EglSyncAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLSYNC_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlBufferAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset asset) {
        assert (asset.getId() != 0L);
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.FRAMEBUFFER_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlProgramAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset asset) {
        GlProgramAsset program = (GlProgramAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC).get(asset.getId());
        if (program != null) {
            program.delete();
            for (IAssetItem shaderAsset : currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC)) {
                GlShaderAsset shader = (GlShaderAsset)shaderAsset;
                if (!shader.shouldBeDeleted()) continue;
                shader.setDeleted(true);
                currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC).remove(shader.getId());
            }
        }
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlQueryObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlQueryObjectAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.QUERY_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlRenderbufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlRenderbufferAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.RENDERBUFFER_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlSamplerAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlSamplerAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SAMPLER_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlShaderAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlShaderAsset asset) {
        Long shaderId = GLES.GlDeleteShaderDecorator.getArgumentShader(functionCall);
        GlShaderAsset shader = (GlShaderAsset)currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC).get(shaderId);
        if (shader != null) {
            shader.setFlaggedForDeletion(true);
            if (shader.shouldBeDeleted()) {
                shader.setDeleted(true);
                currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC).remove(shader.getId());
            }
        }
    }

    protected static void deleteGlSyncObjectAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlSyncObjectAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.SYNC_OBJECT_TRAITS.SPEC).remove(asset.getId());
    }

    protected static void deleteGlTextureAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset asset) {
        assert (asset.getId() != 0L);
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC).remove(asset.getId());
    }

    protected static <T extends IAssetItem> void forEachAssetItem(@NonNull List<@NonNull T> assets, @NonNull IForEachAssetItemFunction<T> function) throws AbortActionException {
        for (IAssetItem asset : assets) {
            function.call(asset);
        }
    }

    protected static void forEachAssetItemID(@NonNull List<@NonNull Long> ids, @NonNull IForEachAssetItemIDFunction function) throws AbortActionException {
        for (Long id : ids) {
            function.call(id);
        }
    }

    protected static <T extends IAssetItem> T getStateItemAssetValue(@NonNull Class<T> clazz, @NonNull TraceStateSnapshot currentState, @NonNull StateSpec stateSpec) {
        IAssetItem asset = currentState.getStateItemBySpec(stateSpec).getValueAsAsset();
        assert (asset == null || clazz.isAssignableFrom(asset.getClass()));
        return (T)asset;
    }

    protected static @NonNull StateItem getStateItemValue(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull StateSpec specName) {
        return currentState.getStateItemBySpec(specName);
    }

    protected static void logMissingAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull String missingAssetClassName) {
        TraceAnalysisLogger.error(currentState, functionCall, (String)NullUtils.neverNull((Object)String.format("Could not locate %s object.", missingAssetClassName)), "This may be because tracing was started after the process began or because \"Send Output Buffers\" is turned off.");
    }

    protected static void logMissingAssetParent(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull String assetClassName, @NonNull String missingParentClassName) {
        TraceAnalysisLogger.error(currentState, functionCall, (String)NullUtils.neverNull((Object)String.format("Could not locate %s object. Was tracing started after the process began?", missingParentClassName)));
    }

    protected static <T extends IAssetItem> @Nullable T mapStateValueToAssetObject(@NonNull KapiSpec.AssetTraits<T, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull StateItem stateItem) {
        IAssetItem assetObject = stateItem.getValueAsAsset();
        if (assetObject == null) {
            return null;
        }
        assert (traits.ASSET_CLASS.isAssignableFrom(assetObject.getClass()));
        return (T)assetObject;
    }

    protected static @NonNull StateItem mapTargetToStateValue(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull TargetBindingGroupSpec specObject, @NonNull AbstractConstantOrAliasSpecExtended target) {
        for (TargetBindingSpec targetBindingSpec : specObject.getTargetBinding()) {
            if (!targetBindingSpec.getTarget().equals(target)) continue;
            return AssetProcessorBase.getStateItemValue(currentState, functionCall, (StateSpec)NullUtils.neverNull((Object)targetBindingSpec.getState()));
        }
        throw new AssertionError((Object)("Missing target item for target binding spec " + specObject.getName() + " : " + target.getName()));
    }

    protected static void processPossibleReplayOverrideAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset programAsset) {
        Frame parentFrame = functionCall.getParentFrame();
        if (parentFrame != null && parentFrame.isReplayed()) {
            for (AbstractFrameOverride abstractFrameOverride : parentFrame.getFrameOverrides()) {
                ProgramOverride programOverride;
                if (!(abstractFrameOverride instanceof ProgramOverride) || (programOverride = (ProgramOverride)abstractFrameOverride).getProgramMappingId() == null || !programOverride.getProgramMappingId().equals(programAsset.getId())) continue;
                programAsset.setNote(functionCall, "Program is an override of " + programOverride.getProgram().getId());
                break;
            }
        }
    }

    protected static void processPossibleReplayOverrideAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlShaderAsset shaderAsset) {
        Frame parentFrame = functionCall.getParentFrame();
        if (parentFrame != null && parentFrame.isReplayed()) {
            for (AbstractFrameOverride abstractFrameOverride : parentFrame.getFrameOverrides()) {
                if (!(abstractFrameOverride instanceof ProgramOverride)) continue;
                ProgramOverride programOverride = (ProgramOverride)abstractFrameOverride;
                if (programOverride.getVertexMappingId() != null && programOverride.getVertexMappingId().equals(shaderAsset.getId())) {
                    GlShaderAsset linkedShader = programOverride.getProgram().getLinkedShader(KapiSpec.GLES.constants.GL_VERTEX_SHADER);
                    if (linkedShader == null) break;
                    shaderAsset.setNote(functionCall, "Shader is an override of " + linkedShader.getId());
                    break;
                }
                if (programOverride.getFragmentMappingId() == null || !programOverride.getFragmentMappingId().equals(shaderAsset.getId())) continue;
                GlShaderAsset linkedShader = programOverride.getProgram().getLinkedShader(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER);
                if (linkedShader == null) break;
                shaderAsset.setNote(functionCall, "Shader is an override of " + linkedShader.getId());
                break;
            }
        }
    }

    public static <T> @NonNull T requireAsset(@NonNull KapiSpec.AssetTraits<? super T, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable T asset, long id) throws MissingAssetException {
        if (asset != null) {
            return asset;
        }
        throw new MissingAssetException(traits, functionCall, id);
    }

    protected static @NonNull GlBufferAsset requireAsset(@NonNull KapiSpec.AssetTraits<GlBufferAsset, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable GlBufferAsset asset, long id) throws AbortActionException {
        if (asset != null) {
            return asset;
        }
        if (id != 0L && functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDBUFFER)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Binding buffers without first calling glGenBuffers to generate IDs is deprecated in OpenGL ES 3.0.");
            return AssetProcessorBase.createNewGlBufferAsset(currentState, functionCall, id);
        }
        throw new MissingAssetException(traits, functionCall, id);
    }

    protected static @NonNull GlFramebufferAsset requireAsset(@NonNull KapiSpec.AssetTraits<GlFramebufferAsset, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable GlFramebufferAsset asset, long id) throws AbortActionException {
        if (asset != null) {
            return asset;
        }
        assert (id != 0L);
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDFRAMEBUFFER)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Binding framebuffers without first calling glGenFramebuffers to generate IDs is deprecated in OpenGL ES 3.0.");
            List<AbstractConstantOrAliasSpecExtended> drawBuffers = AssetProcessorBase.getDefaultPropertyValueForGlFramebufferAssetDrawBuffers(currentState, functionCall, id);
            AbstractConstantOrAliasSpecExtended readBuffer = AssetProcessorBase.getDefaultPropertyValueForGlFramebufferAssetReadBuffer(currentState, functionCall, id);
            return AssetProcessorBase.createNewGlFramebufferAsset(currentState, functionCall, id, 0L, drawBuffers, readBuffer);
        }
        throw new MissingAssetException(traits, functionCall, id);
    }

    protected static @NonNull GlRenderbufferAsset requireAsset(@NonNull KapiSpec.AssetTraits<GlRenderbufferAsset, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable GlRenderbufferAsset asset, long id) throws AbortActionException {
        if (asset != null) {
            return asset;
        }
        if (id != 0L && functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDRENDERBUFFER)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Binding renderbuffers without first calling glGenFramebuffers to generate IDs is deprecated in OpenGL ES 3.0.");
            return AssetProcessorBase.createNewGlRenderbufferAsset(currentState, functionCall, id);
        }
        throw new MissingAssetException(traits, functionCall, id);
    }

    protected static @NonNull GlTransformFeedbackAsset requireAsset(@NonNull KapiSpec.AssetTraits<GlTransformFeedbackAsset, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable GlTransformFeedbackAsset asset, long id) throws AbortActionException {
        if (asset != null) {
            return asset;
        }
        assert (id != 0L);
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDTRANSFORMFEEDBACK)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Binding transform feedbacks without first calling glGenTranformFeedbacks to generate IDs is deprecated in OpenGL ES 3.0.");
            return AssetProcessorBase.createNewGlTransformFeedbackAsset(currentState, functionCall, id, 0L);
        }
        throw new MissingAssetException(traits, functionCall, id);
    }

    protected static @NonNull GlProgramPipelineAsset requireAsset(@NonNull KapiSpec.AssetTraits<GlProgramPipelineAsset, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable GlProgramPipelineAsset asset, long id) throws AbortActionException {
        if (asset != null) {
            return asset;
        }
        if (id != 0L && functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDPROGRAMPIPELINE)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Binding program pipelines without first calling glGenProgramPipelines to generate IDs is deprecated in OpenGL ES 3.0.");
            return AssetProcessorBase.createNewGlProgramPipelineAsset(currentState, functionCall, id);
        }
        throw new MissingAssetException(traits, functionCall, id);
    }

    protected static @NonNull GlTextureAsset requireAsset(@NonNull KapiSpec.AssetTraits<GlTextureAsset, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable GlTextureAsset asset, long id) throws AbortActionException {
        if (asset != null) {
            return asset;
        }
        assert (id != 0L);
        if (functionCall.getFunctionSpec().equals(KapiSpec.GLES.functions.GLBINDTEXTURE)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Binding textures without first calling glGenTextures to generate IDs is deprecated in OpenGL ES 3.0.");
            return AssetProcessorBase.createNewGlTextureAsset(currentState, functionCall, id, 0L);
        }
        throw new MissingAssetException(traits, functionCall, id);
    }

    protected static @NonNull AbstractConstantOrAliasSpecExtended validateConstantIsInSet(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended constantToValidate, @NonNull Set<AbstractConstantOrAliasSpecExtended> validConstants) {
        if (!validConstants.contains(constantToValidate)) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Unexpected constant value " + constantToValidate.getName());
        }
        return constantToValidate;
    }

    protected static @NonNull AbstractConstantOrAliasSpecExtended validateConstantIsInSetLogError(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended constantToValidate, @NonNull Set<AbstractConstantOrAliasSpecExtended> validConstants) {
        if (!validConstants.contains(constantToValidate)) {
            TraceAnalysisLogger.error(currentState, functionCall, "Unexpected constant value " + constantToValidate.getName());
        }
        return constantToValidate;
    }

    protected static <T> @Nullable T warnIfMissingAsset(@NonNull KapiSpec.AssetTraits<? super T, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable T asset, long id) {
        return AssetProcessorBase.warnIfMissingAsset(traits, currentState, functionCall, asset, id, null);
    }

    protected static <T> @Nullable T warnIfMissingAsset(@NonNull KapiSpec.AssetTraits<? super T, ?, ?> traits, @NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable T asset, long id, @Nullable Long invalidId) {
        if (asset == null && (invalidId == null || id != invalidId)) {
            TraceAnalysisLogger.warning(currentState, functionCall, (String)NullUtils.neverNull((Object)String.format("No asset object found of type %s", traits.SPEC.getSingularName())));
        }
        return asset;
    }

    private static @NonNull EglDisplayAsset getOrCreateNewEglDisplayAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull Pointer nativeDisplay) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLDISPLAY_TRAITS.SPEC);
        EglDisplayAsset result = (EglDisplayAsset)assetTableBySpec.get((Long)id);
        if (result == null) {
            result = new EglDisplayAsset(currentState.asSnapshotAssetParent(), functionCall, id, nativeDisplay);
            currentState.addAsset(result);
        }
        return result;
    }

    public static long asAssetID(@NonNull Handle handle) {
        return handle.getHandleValue();
    }

    public static long asAssetID(@NonNull HandleAttachment handlePointer) {
        return handlePointer.getValue().getHandleValue();
    }

    public static @NonNull List<@NonNull Long> asAssetIDs(@Nullable HandleArrayAttachment handles) {
        return handles != null ? handles.asLongsList() : NullUtils.emptyList();
    }

    public static @Nullable VkCommandBufferAsset getVkCommandBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC);
        return (VkCommandBufferAsset)assetTableBySpec.get((Long)id);
    }

    public static @NonNull VkCommandBufferAsset createNewVkCommandBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull Handle commandPool, @NonNull Pointer device, @NonNull AbstractConstantOrAliasSpecExtended level) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC);
        VkCommandBufferAsset asset = (VkCommandBufferAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Command buffer " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkCommandBufferAsset(currentState.asSnapshotAssetParent(), functionCall, id, commandPool, device, level);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static void deleteVkCommandBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkCommandBufferAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static void recordVkCommand(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall) throws AbortActionException {
        assert (KapiSpec.VULKAN.equals(functionCall.getFunctionSpec().getKapiSpec()));
        assert (functionCall.getFunctionSpec().isVulkanCommand());
        VkCommand command = VkCommand.createFromFunctionCall(functionCall);
        Handle commandBufferHandle = command.getCommandBufferHandle();
        if (!commandBufferHandle.isEmptyHandle()) {
            @NonNull VkCommandBufferAsset vkCommandBufferAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, currentState, functionCall, AssetProcessorBase.getVkCommandBufferAsset(currentState, functionCall, AssetProcessorBase.asAssetID(commandBufferHandle)), AssetProcessorBase.asAssetID(commandBufferHandle));
            vkCommandBufferAsset.record(currentState, command);
        }
    }

    public static @NonNull Handle getDefaultPropertyValueForVkCommandBufferAssetCommandPool(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long allocatedCommandBuffer_id_value) throws AbortActionException {
        return VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPAllocateInfo(functionCall).getCommandPool();
    }

    public static Pointer getDefaultPropertyValueForVkCommandBufferAssetDevice(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long allocatedCommandBuffer_id_value) {
        return (Pointer)NullUtils.neverNull((Object)VULKAN.VkAllocateCommandBuffersDecorator.getArgumentDevice(functionCall));
    }

    public static AbstractConstantOrAliasSpecExtended getDefaultPropertyValueForVkCommandBufferAssetLevel(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long allocatedCommandBuffer_id_value) throws AbortActionException {
        return VULKAN.VkAllocateCommandBuffersDecorator.getArgumentPAllocateInfo(functionCall).getLevel();
    }

    public static VkRenderPassAsset createNewVkRenderPassAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull List<IVkAttachmentDescription> attachments, @NonNull List<IVkSubpassDependency> dependencies, @NonNull Bitfield flags, @NonNull List<IVkSubpassDescription> subpasses) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS.SPEC);
        VkRenderPassAsset asset = (VkRenderPassAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Render pass " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkRenderPassAsset(currentState.asSnapshotAssetParent(), functionCall, id, attachments, dependencies, flags, subpasses);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkRenderPassAsset getVkRenderPassAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS.SPEC);
        return (VkRenderPassAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkRenderPassAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkRenderPassAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkFramebufferAsset createNewVkFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull List<VkImageViewAsset> attachments, @NonNull Bitfield flags, long height, long layers, @NonNull VkRenderPassAsset renderPass, long width) throws AbortActionException {
        List nonNullAttachments;
        assert (attachments.isEmpty());
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC);
        VkFramebufferAsset asset = (VkFramebufferAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            nonNullAttachments = NullUtils.neverNullList(attachments);
             @NonNull VULKAN.Structs.VkFramebufferCreateInfo createInfo = VULKAN.VkCreateFramebufferDecorator.getArgumentPCreateInfo(functionCall);
            for (Long imageViewAssetId : AssetProcessorBase.asAssetIDs(createInfo.getPAttachments())) {
                VkImageViewAsset imageView = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS, currentState, functionCall, AssetProcessorBase.getVkImageViewAsset(currentState, functionCall, imageViewAssetId), (long)imageViewAssetId);
                nonNullAttachments.add(imageView);
            }
        } else {
            throw new AbortActionException("Framebuffer " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkFramebufferAsset(currentState.asSnapshotAssetParent(), functionCall, id, nonNullAttachments, flags, height, layers, renderPass, width);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkFramebufferAsset getVkFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC);
        return (VkFramebufferAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkFramebufferAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkImageViewAsset createNewVkImageViewAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id,  @NonNull VULKAN.Structs.VkComponentMapping components, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended format, @NonNull VkImageAsset image,  @NonNull VULKAN.Structs.VkImageSubresourceRange subresourceRange, @NonNull AbstractConstantOrAliasSpecExtended viewType) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC);
        VkImageViewAsset asset = (VkImageViewAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Image view " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkImageViewAsset(currentState.asSnapshotAssetParent(), functionCall, id, components, flags, format, image, subresourceRange, viewType);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkImageViewAsset getVkImageViewAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC);
        return (VkImageViewAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkImageViewAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkImageViewAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public abstract void execute(@NonNull TraceStateSnapshot var1, @NonNull FunctionCall var2) throws Exception;

    public static @NonNull VkImageAsset createNewVkImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long arrayLayers,  @NonNull VULKAN.Structs.VkExtent3D extent, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended format, @NonNull AbstractConstantOrAliasSpecExtended imageType, @NonNull AbstractConstantOrAliasSpecExtended initialLayout, long mipLevels, @NonNull LongsArgAttachment queueFamilyIndices, @NonNull Bitfield samples, @NonNull AbstractConstantOrAliasSpecExtended sharingMode, @NonNull AbstractConstantOrAliasSpecExtended tiling, @NonNull Bitfield usage) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC);
        VkImageAsset asset = (VkImageAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Image " + asset.toString() + " has already been created.");
        }
        asset = new VkImageAsset(currentState.asSnapshotAssetParent(), functionCall, id, arrayLayers, extent, flags, format, imageType, initialLayout, mipLevels, queueFamilyIndices, samples, sharingMode, tiling, usage);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkImageAsset getVkImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC);
        return (VkImageAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkImageAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static @Nullable VkSwapchainKHRAsset getVkSwapchainKHRAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functioncCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS.SPEC);
        return (VkSwapchainKHRAsset)assetTableBySpec.get((Long)id);
    }

    public static VkSwapchainKHRAsset createNewVkSwapchainKHRAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull AbstractConstantOrAliasSpecExtended clipped, @NonNull Bitfield compositeAlpha, long imageArrayLayers, @NonNull AbstractConstantOrAliasSpecExtended imageColorSpace,  @NonNull VULKAN.Structs.VkExtent2D imageExtent, @NonNull AbstractConstantOrAliasSpecExtended imageFormat, @NonNull AbstractConstantOrAliasSpecExtended imageSharingMode, @NonNull Bitfield imageUsage, @NonNull Bitfield preTransform, @NonNull AbstractConstantOrAliasSpecExtended presentMode, @NonNull LongsArgAttachment queueFamilyIndices, @NonNull Handle surface) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS.SPEC);
        VkSwapchainKHRAsset asset = (VkSwapchainKHRAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            asset = new VkSwapchainKHRAsset(currentState.asSnapshotAssetParent(), functionCall, id, clipped, compositeAlpha, imageArrayLayers, imageColorSpace, imageExtent, imageFormat, imageSharingMode, imageUsage, preTransform, presentMode, queueFamilyIndices, surface);
            VULKAN.Structs.VkSwapchainCreateInfoKHR createInfo = VULKAN.VkCreateSwapchainKHRDecorator.getArgumentPCreateInfo(functionCall);
            Handle oldSwapchainHandle = createInfo.getOldSwapchain();
            if (!oldSwapchainHandle.isEmptyHandle()) {
                @NonNull VkSwapchainKHRAsset oldSwapchain = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS, currentState, functionCall, AssetProcessorBase.getVkSwapchainKHRAsset(currentState, functionCall, AssetProcessorBase.asAssetID(oldSwapchainHandle)), AssetProcessorBase.asAssetID(oldSwapchainHandle));
                asset.setOldSwapchain(oldSwapchain);
            }
        } else {
            throw new AbortActionException("Swapchain " + asset.toString() + " has already been created.");
        }
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static void deleteVkSwapchainKHRAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkSwapchainKHRAsset swapchainAsset) {
        AssetTable swapchainAssetTable = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS.SPEC);
        AssetTable imageAssetTable = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC);
        for (VkImageAsset imageAsset : swapchainAsset.getImages()) {
            imageAssetTable.remove(imageAsset.getId());
        }
        swapchainAssetTable.remove(swapchainAsset.getId());
    }

    public static VkShaderModuleAsset createNewVkShaderModuleAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS.SPEC);
        VkShaderModuleAsset asset = (VkShaderModuleAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Shader module " + asset.toString() + " has already been created.");
        }
        asset = new VkShaderModuleAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkShaderModuleAsset getVkShaderModuleAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS.SPEC);
        return (VkShaderModuleAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkShaderModuleAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkShaderModuleAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkPipelineLayoutAsset createNewVkPipelineLayoutAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull Bitfield flags, @NonNull List< @NonNull VULKAN.Structs.VkPushConstantRange> pushConstants, @NonNull List<@NonNull VkDescriptorSetLayoutAsset> setLayouts) throws AbortActionException {
        List setLayoutAssets;
        assert (setLayouts.isEmpty());
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS.SPEC);
        VkPipelineLayoutAsset asset = (VkPipelineLayoutAsset)assetTableBySpec.get((Long)id);
        if (asset == null) {
            VULKAN.Structs.VkPipelineLayoutCreateInfo createInfo = VULKAN.VkCreatePipelineLayoutDecorator.getArgumentPCreateInfo(functionCall);
            setLayoutAssets = NullUtils.neverNullList(setLayouts);
            for (Long setLayoutAssetId : AssetProcessorBase.asAssetIDs(createInfo.getPSetLayouts())) {
                VkDescriptorSetLayoutAsset descriptorSetLayoutAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDescriptorSetLayoutAsset(currentState, functionCall, AssetProcessorBase.asAssetID(setLayoutAssetId)), AssetProcessorBase.asAssetID(setLayoutAssetId));
                setLayoutAssets.add(descriptorSetLayoutAsset);
            }
        } else {
            throw new AbortActionException("Pipeline layout " + asset.toString() + " has already been created.");
        }
        asset = new VkPipelineLayoutAsset(currentState.asSnapshotAssetParent(), functionCall, id, flags, pushConstants, setLayoutAssets);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkPipelineLayoutAsset getVkPipelineLayoutAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS.SPEC);
        return (VkPipelineLayoutAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkPipelineLayoutAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkPipelineLayoutAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkBufferAsset createNewVkBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull Bitfield flags, @NonNull LongsArgAttachment queueFamilyIndices, @NonNull AbstractConstantOrAliasSpecExtended sharingMode, long size, @NonNull Bitfield usage) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC);
        VkBufferAsset asset = (VkBufferAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Buffer " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkBufferAsset(currentState.asSnapshotAssetParent(), functionCall, id, flags, queueFamilyIndices, sharingMode, size, usage);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkBufferAsset getVkBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC);
        return (VkBufferAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkBufferAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkDeviceMemoryAsset createNewVkDeviceMemoryAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long allocationSize, long memoryTypeIndex) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC);
        VkDeviceMemoryAsset asset = (VkDeviceMemoryAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Device Memory " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkDeviceMemoryAsset(currentState.asSnapshotAssetParent(), functionCall, id, allocationSize, memoryTypeIndex);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkDeviceMemoryAsset getVkDeviceMemoryAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC);
        return (VkDeviceMemoryAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkDeviceMemoryAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkDeviceMemoryAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkBufferViewAsset createNewVkBufferViewAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull VkBufferAsset buffer, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended format, long offset, long range) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC);
        VkBufferViewAsset asset = (VkBufferViewAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            throw new AbortActionException("Buffer view " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        AssetTable parentAssetTable = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC);
        asset = new VkBufferViewAsset(currentState.asSnapshotAssetParent(), functionCall, id, buffer, flags, format, offset, range);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkBufferViewAsset getVkBufferViewAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC);
        return (VkBufferViewAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkBufferViewAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkBufferViewAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkGraphicsPipelineAsset createNewVkGraphicsPipelineAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long handle) throws AbortActionException {
        List<VULKAN.Structs.VkGraphicsPipelineCreateInfo> createInfos;
        int index;
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS.SPEC);
        VkGraphicsPipelineAsset asset = (VkGraphicsPipelineAsset)assetTableBySpec.get((Long)handle);
        if (asset == null) {
            asset = new VkGraphicsPipelineAsset(currentState.asSnapshotAssetParent(), functionCall, handle);
            HandleArrayAttachment pipelinesHandles = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPPipelines(functionCall);
            index = AssetProcessorBase.getIndexOfVkHandle(pipelinesHandles, handle);
            createInfos = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPCreateInfos(functionCall);
            assert (createInfos.size() == pipelinesHandles.size());
        } else {
            throw new AbortActionException("Graphics pipeline " + asset.toString() + " has already been created.");
        }
        VULKAN.Structs.VkGraphicsPipelineCreateInfo createInfo = createInfos.get(index);
        Bitfield flags = createInfo.getFlags();
        List< @NonNull VULKAN.Structs.VkPipelineShaderStageCreateInfo> stageCreateInfos = createInfo.getPStages();
        Handle layoutHandle = createInfo.getLayout();
        Handle basePipelineHandle = createInfo.getBasePipelineHandle();
        Long basePipelineIndex = createInfo.getBasePipelineIndex();
        AssetProcessorBase.processVkPipelineAssetProperties(currentState, functionCall, asset, flags, stageCreateInfos, layoutHandle, basePipelineIndex, basePipelineHandle);
        AssetProcessorBase.processVkGraphicsPipelineAssetProperties(currentState, functionCall, asset, createInfo);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static VkComputePipelineAsset createNewVkComputePipelineAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long handle) throws AbortActionException {
        List<VULKAN.Structs.VkComputePipelineCreateInfo> createInfos;
        int index;
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS.SPEC);
        VkComputePipelineAsset asset = (VkComputePipelineAsset)assetTableBySpec.get((Long)handle);
        if (asset == null) {
            asset = new VkComputePipelineAsset(currentState.asSnapshotAssetParent(), functionCall, handle);
            HandleArrayAttachment pipelineHandles = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPPipelines(functionCall);
            index = AssetProcessorBase.getIndexOfVkHandle(pipelineHandles, handle);
            createInfos = VULKAN.VkCreateComputePipelinesDecorator.getArgumentPCreateInfos(functionCall);
            assert (createInfos.size() == pipelineHandles.size());
        } else {
            throw new AbortActionException("Compute pipeline " + asset.toString() + " has already been created.");
        }
        VULKAN.Structs.VkComputePipelineCreateInfo createInfo = createInfos.get(index);
        Bitfield flags = createInfo.getFlags();
        VULKAN.Structs.VkPipelineShaderStageCreateInfo stageCreateInfo = createInfo.getStage();
        Handle layoutHandle = createInfo.getLayout();
        Handle basePipelineHandle = createInfo.getBasePipelineHandle();
        Long basePipelineIndex = createInfo.getBasePipelineIndex();
        AssetProcessorBase.processVkPipelineAssetProperties(currentState, functionCall, asset, flags, NullUtils.asList((Object[])new VULKAN.Structs.VkPipelineShaderStageCreateInfo[]{stageCreateInfo}), layoutHandle, basePipelineIndex, basePipelineHandle);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    private static int getIndexOfVkHandle(@NonNull HandleArrayAttachment arrayAttachment, long assetHandle) {
        List ids = arrayAttachment.asList().stream().map(handle -> handle.getHandleValue()).collect(Collectors.toList());
        int index = ids.indexOf(assetHandle);
        assert (index != -1);
        return index;
    }

    private static void processVkPipelineAssetProperties(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkPipelineAsset pipelineAsset, @NonNull Bitfield flags, @NonNull List< @NonNull VULKAN.Structs.VkPipelineShaderStageCreateInfo> stageCreateInfos, @NonNull Handle layoutHandle, long basePipelineIndex, @NonNull Handle basePipelineHandle) throws AbortActionException {
        pipelineAsset.setFlags(flags.getAsLong());
        ArrayList<@NonNull VkShaderStage> stages = new ArrayList<VkShaderStage>();
        ArrayList<VkShaderModuleAsset> modules = new ArrayList<VkShaderModuleAsset>();
        for (VULKAN.Structs.VkPipelineShaderStageCreateInfo stageCreateInfo : stageCreateInfos) {
            @Nullable Bitfield shaderStageCreateFlags = Bitfield.valueOf(stageCreateInfo.getStage());
            @Nullable Handle shaderModuleHandle = stageCreateInfo.getModule();
            @NonNull String name = stageCreateInfo.getPName().getConcatenatedString();
            @NonNull VkShaderModuleAsset moduleAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.SHADERMODULE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkShaderModuleAsset(currentState, functionCall, AssetProcessorBase.asAssetID(shaderModuleHandle)), AssetProcessorBase.asAssetID(shaderModuleHandle));
            modules.add(moduleAsset);
            VkShaderStage stage = new VkShaderStage(shaderStageCreateFlags, moduleAsset, name);
            stages.add(stage);
        }
        pipelineAsset.addShaderStages(stages);
        VkPipelineLayoutAsset layoutAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS, currentState, functionCall, AssetProcessorBase.getVkPipelineLayoutAsset(currentState, functionCall, AssetProcessorBase.asAssetID(layoutHandle)), AssetProcessorBase.asAssetID(layoutHandle));
        pipelineAsset.setLayout(layoutAsset);
        if (flags.contains(KapiSpec.VULKAN.constants.VK_PIPELINE_CREATE_DERIVATIVE_BIT)) {
            AssetProcessorBase.setVkBasePipeline(currentState, functionCall, pipelineAsset, basePipelineIndex, basePipelineHandle);
        }
    }

    private static <T extends AbstractContainerWrapperType> void checkVkCreateInfoValidity(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull T createInfo) {
        if (createInfo.getContainer().isNull()) {
            TraceAnalysisLogger.error(currentState, functionCall, String.valueOf(createInfo.getContainer().getArgumentName()) + " must be a valid " + createInfo.getContainer().getArgumentSpec().getName() + " structure.");
        }
    }

    private static void processVkGraphicsPipelineAssetProperties(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkGraphicsPipelineAsset pipelineAsset,  @NonNull VULKAN.Structs.VkGraphicsPipelineCreateInfo createInfo) throws AbortActionException {
        VULKAN.Structs.VkPipelineVertexInputStateCreateInfo vertexInputState = createInfo.getPVertexInputState();
        AssetProcessorBase.checkVkCreateInfoValidity(currentState, functionCall, vertexInputState);
        pipelineAsset.setVertexInputState(vertexInputState);
        VULKAN.Structs.VkPipelineInputAssemblyStateCreateInfo inputAssemblyState = createInfo.getPInputAssemblyState();
        AssetProcessorBase.checkVkCreateInfoValidity(currentState, functionCall, inputAssemblyState);
        pipelineAsset.setInputAssemblyState(inputAssemblyState);
        VULKAN.Structs.VkPipelineTessellationStateCreateInfo tessellationState = createInfo.getPTessellationState();
        pipelineAsset.setTessellationState(tessellationState);
        VULKAN.Structs.VkPipelineViewportStateCreateInfo viewportState = createInfo.getPViewportState();
        pipelineAsset.setViewportState(viewportState);
        VULKAN.Structs.VkPipelineRasterizationStateCreateInfo rasterizationState = createInfo.getPRasterizationState();
        AssetProcessorBase.checkVkCreateInfoValidity(currentState, functionCall, rasterizationState);
        pipelineAsset.setRasterizationState(rasterizationState);
        VULKAN.Structs.VkPipelineMultisampleStateCreateInfo multisampleState = createInfo.getPMultisampleState();
        pipelineAsset.setMultisampleState(multisampleState);
        VULKAN.Structs.VkPipelineDepthStencilStateCreateInfo depthStencilState = createInfo.getPDepthStencilState();
        pipelineAsset.setDepthStencilState(depthStencilState);
        VULKAN.Structs.VkPipelineColorBlendStateCreateInfo colorBlendState = createInfo.getPColorBlendState();
        pipelineAsset.setColorBlendState(colorBlendState);
        VULKAN.Structs.VkPipelineDynamicStateCreateInfo dynamicState = createInfo.getPDynamicState();
        pipelineAsset.setDynamicState(dynamicState);
        Handle renderPassHandle = createInfo.getRenderPass();
        VkRenderPassAsset renderPass = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, currentState, functionCall, AssetProcessorBase.getVkRenderPassAsset(currentState, functionCall, AssetProcessorBase.asAssetID(renderPassHandle)), AssetProcessorBase.asAssetID(renderPassHandle));
        pipelineAsset.setRenderpass(renderPass);
        Long subpass = createInfo.getSubpass();
        pipelineAsset.setSubpass(subpass);
    }

    private static void setVkBasePipeline(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkPipelineAsset pipelineAsset, long basePipelineIndex, @NonNull Handle basePipelineHandle) throws AbortActionException {
        if (basePipelineIndex != -1L && !basePipelineHandle.isEmptyHandle()) {
            TraceAnalysisLogger.error(currentState, functionCall, "Only one of basePipelineIndex or basePipelineHandle can be used to identify the base pipeline.");
            return;
        }
        if (basePipelineIndex != -1L) {
            AssetProcessorBase.setVkBasePipelineByIndex(currentState, functionCall, pipelineAsset, basePipelineIndex);
        } else if (!basePipelineHandle.isEmptyHandle()) {
            AssetProcessorBase.setVkBasePipelineByHandle(currentState, functionCall, pipelineAsset, basePipelineHandle);
        } else {
            TraceAnalysisLogger.error(currentState, functionCall, "basePipelineIndex and basePipelineHandle have no valid values.");
        }
    }

    private static void setVkBasePipelineByIndex(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkPipelineAsset pipelineAsset, long basePipelineIndex) throws AbortActionException {
        try {
            HandleArrayAttachment arrayAttachment = VULKAN.VkCreateGraphicsPipelinesDecorator.getArgumentPPipelines(functionCall);
            List<@NonNull Handle> pipelineHandles = arrayAttachment.asList();
            Handle basePipelineHandleFromIndex = pipelineHandles.get((int)basePipelineIndex);
            VkPipelineAsset basePipelineAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkPipelineAsset(currentState, functionCall, AssetProcessorBase.asAssetID(basePipelineHandleFromIndex)), AssetProcessorBase.asAssetID(basePipelineHandleFromIndex));
            pipelineAsset.setBasePipelineHandle(basePipelineAsset);
        }
        catch (IndexOutOfBoundsException e) {
            TraceAnalysisLogger.error(currentState, functionCall, "basePipelineIndex must be a valid index to a base pipeline appearing earlier in the array.");
        }
    }

    private static void setVkBasePipelineByHandle(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkPipelineAsset pipelineAsset, @NonNull Handle basePipelineHandle) throws AbortActionException {
        try {
            VkPipelineAsset basePipelineAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS, currentState, functionCall, AssetProcessorBase.getVkPipelineAsset(currentState, functionCall, AssetProcessorBase.asAssetID(basePipelineHandle)), AssetProcessorBase.asAssetID(basePipelineHandle));
            pipelineAsset.setBasePipelineHandle(basePipelineAsset);
        }
        catch (AbortActionException e) {
            TraceAnalysisLogger.error(currentState, functionCall, "basePipelineHandle must be a valid handle.");
        }
    }

    public static @Nullable VkPipelineAsset getVkPipelineAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS.SPEC);
        return (VkPipelineAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkPipelineAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, VkPipelineAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.PIPELINE_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkDescriptorSetLayoutAsset createNewVkDescriptorSetLayoutAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull List< @NonNull VULKAN.Structs.VkDescriptorSetLayoutBinding> bindings) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS.SPEC);
        VkDescriptorSetLayoutAsset asset = (VkDescriptorSetLayoutAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            String assetName = KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS.SPEC.getSingularName();
            throw new AbortActionException(String.valueOf(assetName) + " asset " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkDescriptorSetLayoutAsset(currentState.asSnapshotAssetParent(), functionCall, id, bindings);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkDescriptorSetLayoutAsset getVkDescriptorSetLayoutAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS.SPEC);
        return (VkDescriptorSetLayoutAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkDescriptorSetLayoutAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkDescriptorSetLayoutAsset asset) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkDescriptorSetAsset createNewVkDescriptorSetAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, @NonNull VkDescriptorPoolAsset descriptorPool, @Nullable VkDescriptorSetLayoutAsset layoutAsset) throws AbortActionException {
        assert (layoutAsset == null);
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS.SPEC);
        VkDescriptorSetAsset descriptorSetAsset = (VkDescriptorSetAsset)assetTableBySpec.get((Long)id);
        if (descriptorSetAsset == null) {
            VULKAN.Structs.VkDescriptorSetAllocateInfo allocateInfo;
            HandleArrayAttachment setLayouts;
            HandleArrayAttachment descriptorSetsArrayAttachment = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPDescriptorSets(functionCall);
            int index = AssetProcessorBase.getIndexOfVkHandle(descriptorSetsArrayAttachment, id);
            if (index >= (setLayouts = (allocateInfo = VULKAN.VkAllocateDescriptorSetsDecorator.getArgumentPAllocateInfo(functionCall)).getPSetLayouts()).size()) {
                throw new AbortActionException("Failed getting descriptor set layout " + index + ".");
            }
            Handle setLayoutHandle = setLayouts.get(index);
            layoutAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.DESCRIPTORSETLAYOUT_TRAITS, currentState, functionCall, AssetProcessorBase.getVkDescriptorSetLayoutAsset(currentState, functionCall, AssetProcessorBase.asAssetID(setLayoutHandle)), AssetProcessorBase.asAssetID(setLayoutHandle));
            descriptorSetAsset = new VkDescriptorSetAsset(currentState.asSnapshotAssetParent(), functionCall, id, descriptorPool, layoutAsset);
            for (VULKAN.Structs.VkDescriptorSetLayoutBinding binding : layoutAsset.getBindingsCollection()) {
                descriptorSetAsset.allocateDescriptors((VULKAN.Structs.VkDescriptorSetLayoutBinding)NullUtils.neverNull((Object)binding));
            }
        } else {
            String assetName = KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS.SPEC.getSingularName();
            throw new AbortActionException(String.valueOf(assetName) + " asset " + Long.toHexString(descriptorSetAsset.getId()) + " has already been created.");
        }
        descriptorPool.getDescriptorSets().add(descriptorSetAsset);
        assetTableBySpec.addAsset(descriptorSetAsset);
        return descriptorSetAsset;
    }

    public static @Nullable VkDescriptorSetAsset getVkDescriptorSetAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS.SPEC);
        return (VkDescriptorSetAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkDescriptorSetAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkDescriptorSetAsset asset) {
        asset.getDescriptorPool().getDescriptorSets().remove(asset);
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS.SPEC);
        assetTableBySpec.remove(asset.getId());
    }

    public static VkDescriptorPoolAsset createNewVkDescriptorPoolAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) throws AbortActionException {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS.SPEC);
        VkDescriptorPoolAsset asset = (VkDescriptorPoolAsset)assetTableBySpec.get((Long)id);
        if (asset != null) {
            String assetName = KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS.SPEC.getSingularName();
            throw new AbortActionException(String.valueOf(assetName) + " asset " + Long.toHexString(asset.getId()) + " has already been created.");
        }
        asset = new VkDescriptorPoolAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        assetTableBySpec.addAsset(asset);
        return asset;
    }

    public static @Nullable VkDescriptorPoolAsset getVkDescriptorPoolAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS.SPEC);
        return (VkDescriptorPoolAsset)assetTableBySpec.get((Long)id);
    }

    public static void deleteVkDescriptorPoolAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull VkDescriptorPoolAsset descriptorPoolAsset) {
        AssetTable descriptorSetAssets = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORSET_TRAITS.SPEC);
        for (VkDescriptorSetAsset descriptorSetAsset : descriptorPoolAsset.getDescriptorSetsCollection()) {
            descriptorSetAssets.remove(descriptorSetAsset.getId());
        }
        descriptorPoolAsset.getDescriptorSets().clear();
        AssetTable descriptorPoolAssets = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS.SPEC);
        descriptorPoolAssets.remove(descriptorPoolAsset.getId());
    }

    public static void deleteGlTransformFeedbackAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlTransformFeedbackAsset transformFeedbackAsset) {
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS.SPEC).remove(transformFeedbackAsset.getId());
    }

    public static @NonNull GlTransformFeedbackAsset createNewGlTransformFeedbackAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId) {
        if (id == defaultObjectId) {
            return (GlTransformFeedbackAsset)NullUtils.neverNull((Object)AssetProcessorBase.getGlTransformFeedbackAsset(currentState, functionCall, id, defaultObjectId));
        }
        GlTransformFeedbackAsset newAsset = new GlTransformFeedbackAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(newAsset);
        return newAsset;
    }

    public static @Nullable GlTransformFeedbackAsset getGlTransformFeedbackAsset(TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id, long defaultObjectId) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.TRANSFORM_FEEDBACK_OBJECT_TRAITS.SPEC);
        GlTransformFeedbackAsset asset = (GlTransformFeedbackAsset)assetTableBySpec.get((Long)id);
        if (asset == null && id == defaultObjectId) {
            asset = new GlTransformFeedbackAsset(currentState.asSnapshotAssetParent(), functionCall, id);
            assetTableBySpec.addAsset(asset);
        }
        return asset;
    }

    public static @Nullable GlProgramPipelineAsset getGlProgramPipelineAsset(TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS.SPEC);
        return (GlProgramPipelineAsset)assetTableBySpec.get((Long)id);
    }

    public static @NonNull GlProgramPipelineAsset createNewGlProgramPipelineAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        GlProgramPipelineAsset newBufferAsset = new GlProgramPipelineAsset(currentState.asSnapshotAssetParent(), functionCall, id);
        currentState.addAsset(newBufferAsset);
        return newBufferAsset;
    }

    public static void deleteGlProgramPipelineAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, GlProgramPipelineAsset asset) {
        currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_PIPELINE_TRAITS.SPEC).remove(asset.getId());
    }

    public static @Nullable GlFramebufferTextureMultiviewAttachmentAsset getGlFramebufferTextureMultiviewAttachmentAsset(TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset, long id) {
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.GLES.assetTables.FRAMEBUFFER_ATTACHMENT_TRAITS.SPEC);
        return (GlFramebufferTextureMultiviewAttachmentAsset)assetTableBySpec.get((Long)id);
    }

    @FunctionalInterface
    protected static interface IForEachAssetItemFunction<T extends IAssetItem> {
        public void call(@NonNull T var1) throws AbortActionException;
    }

    @FunctionalInterface
    protected static interface IForEachAssetItemIDFunction {
        public void call(long var1) throws AbortActionException;
    }
}

