/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.EglConfigAsset;
import com.arm.mgd.core.asset.EglContextAsset;
import com.arm.mgd.core.asset.EglDisplayAsset;
import com.arm.mgd.core.asset.EglImageAsset;
import com.arm.mgd.core.asset.EglPbufferSurfaceAsset;
import com.arm.mgd.core.asset.EglPixmapSurfaceAsset;
import com.arm.mgd.core.asset.EglSyncAsset;
import com.arm.mgd.core.asset.EglWindowSurfaceAsset;
import com.arm.mgd.core.asset.GlAtomicCounterBufferBindingPointAsset;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlFramebufferRenderbufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferTextureAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferZeroAttachmentAsset;
import com.arm.mgd.core.asset.GlImageUnitAsset;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramPipelineAsset;
import com.arm.mgd.core.asset.GlQueryObjectAsset;
import com.arm.mgd.core.asset.GlRenderbufferAsset;
import com.arm.mgd.core.asset.GlSamplerAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlShaderStorageBufferBindingPointAsset;
import com.arm.mgd.core.asset.GlSyncObjectAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.GlTransformFeedbackAsset;
import com.arm.mgd.core.asset.GlTransformFeedbackBufferBindingPointAsset;
import com.arm.mgd.core.asset.GlUniformBindingPointAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.core.asset.GlVertexBufferBindingAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.objects.OneShotPropertyFailureException;
import com.arm.mgd.core.asset.objects.gen.AllAssetClasses;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MidstreamAssetFactory {
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_IMAGE_UNIT_ASSET_ACCESS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_READ_WRITE, KapiSpec.GLES.constants.GL_READ_ONLY, KapiSpec.GLES.constants.GL_WRITE_ONLY));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_IMAGE_UNIT_ASSET_FORMAT = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_RGBA32I, KapiSpec.GLES.constants.GL_RGBA8I, KapiSpec.GLES.constants.GL_R32F, KapiSpec.GLES.constants.GL_RGBA8UI, KapiSpec.GLES.constants.GL_R32I, KapiSpec.GLES.constants.GL_RGBA8, KapiSpec.GLES.constants.GL_R32UI, KapiSpec.GLES.constants.GL_RGBA32UI, KapiSpec.GLES.constants.GL_RGBA16F, KapiSpec.GLES.constants.GL_RGBA8_SNORM, KapiSpec.GLES.constants.GL_RGBA16I, KapiSpec.GLES.constants.GL_RGBA16UI, KapiSpec.GLES.constants.GL_RGBA32F));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_QUERY_OBJECT_ASSET_QUERY_TARGET = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED, KapiSpec.GLES.constants.GL_TIME_ELAPSED_EXT, KapiSpec.GLES.constants.GL_ANY_SAMPLES_PASSED_CONSERVATIVE, KapiSpec.GLES.constants.GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, KapiSpec.GLES.constants.GL_TIMESTAMP_EXT, KapiSpec.GLES.constants.GL_PRIMITIVES_GENERATED));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SHADER_ASSET_TYPE = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER, KapiSpec.GLES.constants.GL_COMPUTE_SHADER, KapiSpec.GLES.constants.GL_GEOMETRY_SHADER, KapiSpec.GLES.constants.GL_FRAGMENT_SHADER, KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER, KapiSpec.GLES.constants.GL_VERTEX_SHADER));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_CONDITION = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_GPU_COMMANDS_COMPLETE));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_FLAGS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_ZERO));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_STATUS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_UNSIGNALED, KapiSpec.GLES.constants.GL_SIGNALED));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_GL_SYNC_OBJECT_ASSET_TYPE = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.GLES.constants.GL_SYNC_FENCE));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_EGL_IMAGE_ASSET_TARGET = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_GL_RENDERBUFFER_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Y_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_2D_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_Z_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_KHR, KapiSpec.EGL.constants.EGL_NATIVE_BUFFER_ANDROID, KapiSpec.EGL.constants.EGL_GL_TEXTURE_CUBE_MAP_POSITIVE_X_KHR, KapiSpec.EGL.constants.EGL_GL_TEXTURE_3D_KHR));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_EGL_SYNC_ASSET_STATUS = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_UNSIGNALED_KHR, KapiSpec.EGL.constants.EGL_SIGNALED_KHR));
    private static final @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> CONSTANT_SET_EGL_SYNC_ASSET_TYPE = new HashSet<AbstractConstantOrAliasSpecExtended>(Arrays.asList(KapiSpec.EGL.constants.EGL_SYNC_NATIVE_FENCE_ANDROID, KapiSpec.EGL.constants.EGL_SYNC_REUSABLE_KHR, KapiSpec.EGL.constants.EGL_SYNC_CL_EVENT_KHR, KapiSpec.EGL.constants.EGL_SYNC_FENCE_KHR));

    public static <TYPE extends IAssetItem, PARENT extends IAssetItem> @NonNull TYPE findExisting(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FindExistingAssetHelper helper, @NonNull KapiSpec.AssetTraits<TYPE, ?, ?> traits, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @Nullable PARENT parentAsset) {
        long id = assetAttachment.getId();
        AllAssetClasses classEnum = traits.ENUM;
        assert (classEnum != null);
        switch (classEnum) {
            case GL_ATOMIC_COUNTER_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlAtomicCounterBufferBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_BUFFER_ASSET: {
                return (TYPE)helper.findGlBufferAsset(callbacks, functionCall, id);
            }
            case GL_FRAMEBUFFER_ASSET: {
                return (TYPE)helper.findGlFramebufferAsset(callbacks, functionCall, id);
            }
            case GL_IMAGE_UNIT_ASSET: {
                return (TYPE)helper.findGlImageUnitAsset(callbacks, functionCall, id);
            }
            case GL_PROGRAM_ASSET: {
                return (TYPE)helper.findGlProgramAsset(callbacks, functionCall, id);
            }
            case GL_PROGRAM_PIPELINE_ASSET: {
                return (TYPE)helper.findGlProgramPipelineAsset(callbacks, functionCall, id);
            }
            case GL_QUERY_OBJECT_ASSET: {
                return (TYPE)helper.findGlQueryObjectAsset(callbacks, functionCall, id);
            }
            case GL_RENDERBUFFER_ASSET: {
                return (TYPE)helper.findGlRenderbufferAsset(callbacks, functionCall, id);
            }
            case GL_SAMPLER_ASSET: {
                return (TYPE)helper.findGlSamplerAsset(callbacks, functionCall, id);
            }
            case GL_SHADER_ASSET: {
                return (TYPE)helper.findGlShaderAsset(callbacks, functionCall, id);
            }
            case GL_SHADER_STORAGE_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlShaderStorageBufferBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_SYNC_OBJECT_ASSET: {
                return (TYPE)helper.findGlSyncObjectAsset(callbacks, functionCall, id);
            }
            case GL_TEXTURE_ASSET: {
                return (TYPE)helper.findGlTextureAsset(callbacks, functionCall, id);
            }
            case GL_TEXTURE_UNIT_ASSET: {
                return (TYPE)helper.findGlTextureUnitAsset(callbacks, functionCall, id);
            }
            case GL_TRANSFORM_FEEDBACK_ASSET: {
                return (TYPE)helper.findGlTransformFeedbackAsset(callbacks, functionCall, id);
            }
            case GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlTransformFeedbackBufferBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_UNIFORM_BINDING_POINT_ASSET: {
                return (TYPE)helper.findGlUniformBindingPointAsset(callbacks, functionCall, id);
            }
            case GL_VERTEX_ARRAY_OBJECT_ASSET: {
                return (TYPE)helper.findGlVertexArrayObjectAsset(callbacks, functionCall, id);
            }
            case GL_VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_ASSET: {
                return (TYPE)helper.findGlVertexAttributeNonArrayValueAsset(callbacks, functionCall, id);
            }
            case GL_TEXTURE_IMAGE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlTextureImageAsset(callbacks, functionCall, id, (GlTextureSurfaceAsset)parentAsset);
                }
                return null;
            }
            case GL_TEXTURE_SURFACE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlTextureSurfaceAsset(callbacks, functionCall, id, (GlTextureAsset)parentAsset);
                }
                return null;
            }
            case GL_VERTEX_ATTRIBUTE_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlVertexAttributeAsset(callbacks, functionCall, id, (GlVertexArrayObjectAsset)parentAsset);
                }
                return null;
            }
            case GL_VERTEX_BUFFER_BINDING_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlVertexBufferBindingAsset(callbacks, functionCall, id, (GlVertexArrayObjectAsset)parentAsset);
                }
                return null;
            }
            case SHADER_UNIFORM: {
                if (parentAsset != null) {
                    return (TYPE)helper.findShaderUniform(callbacks, functionCall, id, (GlProgramAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_RENDERBUFFER_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferRenderbufferAttachmentAsset(callbacks, functionCall, id, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_TEXTURE_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferTextureAttachmentAsset(callbacks, functionCall, id, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_TEXTURE_MULTIVIEW_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferTextureMultiviewAttachmentAsset(callbacks, functionCall, id, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case GL_FRAMEBUFFER_ZERO_ATTACHMENT_ASSET: {
                if (parentAsset != null) {
                    return (TYPE)helper.findGlFramebufferZeroAttachmentAsset(callbacks, functionCall, id, (GlFramebufferAsset)parentAsset);
                }
                return null;
            }
            case EGL_CONFIG_ASSET: {
                return (TYPE)helper.findEglConfigAsset(callbacks, functionCall, id);
            }
            case EGL_CONTEXT_ASSET: {
                return (TYPE)helper.findEglContextAsset(callbacks, functionCall, id);
            }
            case EGL_DISPLAY_ASSET: {
                return (TYPE)helper.findEglDisplayAsset(callbacks, functionCall, id);
            }
            case EGL_IMAGE_ASSET: {
                return (TYPE)helper.findEglImageAsset(callbacks, functionCall, id);
            }
            case EGL_SYNC_ASSET: {
                return (TYPE)helper.findEglSyncAsset(callbacks, functionCall, id);
            }
            case EGL_PBUFFER_SURFACE_ASSET: {
                return (TYPE)helper.findEglPbufferSurfaceAsset(callbacks, functionCall, id);
            }
            case EGL_PIXMAP_SURFACE_ASSET: {
                return (TYPE)helper.findEglPixmapSurfaceAsset(callbacks, functionCall, id);
            }
            case EGL_WINDOW_SURFACE_ASSET: {
                return (TYPE)helper.findEglWindowSurfaceAsset(callbacks, functionCall, id);
            }
        }
        throw new AssertionError((Object)("Unexpected asset class for midstream trace processing in findExisting: " + (Object)((Object)classEnum)));
    }

    private static @NonNull GlAtomicCounterBufferBindingPointAsset createGlAtomicCounterBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlAtomicCounterBufferBindingPointAsset newAssetObject = GlAtomicCounterBufferBindingPointAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlAtomicCounterBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlAtomicCounterBufferBindingPointAsset assetToUpdate) {
        GlBufferAsset buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        try {
            assetToUpdate.setBuffer(buffer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "buffer", t);
        }
        long length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        try {
            assetToUpdate.setLength(length);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "length", t);
        }
        long offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        try {
            assetToUpdate.setOffset(offset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "offset", t);
        }
        return true;
    }

    private static @NonNull GlBufferAsset createGlBufferAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlBufferAsset newAssetObject = GlBufferAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlBufferAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlBufferAsset assetToUpdate) {
        long accessFlags = builder.resolveLongProperty(assetAttachment, "accessFlags", 0L);
        try {
            assetToUpdate.setAccessFlags(accessFlags);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "accessFlags", t);
        }
        byte[] data = builder.resolveByteDataProperty(assetAttachment, "data", true);
        try {
            assetToUpdate.setData(data);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "data", t);
        }
        AbstractConstantOrAliasSpecExtended firstBinding = builder.resolveProperty(assetAttachment, "firstBinding", AbstractConstantOrAliasSpecExtended.class, true, null);
        try {
            assetToUpdate.setFirstBinding(firstBinding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "firstBinding", t);
        }
        AbstractConstantOrAliasSpecExtended lastBoundTarget = builder.resolveProperty(assetAttachment, "lastBoundTarget", AbstractConstantOrAliasSpecExtended.class, true, null);
        try {
            assetToUpdate.setLastBoundTarget(lastBoundTarget);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "lastBoundTarget", t);
        }
        long mapLength = builder.resolveLongProperty(assetAttachment, "mapLength", 0L);
        try {
            assetToUpdate.setMapLength(mapLength);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "mapLength", t);
        }
        long mapOffset = builder.resolveLongProperty(assetAttachment, "mapOffset", 0L);
        try {
            assetToUpdate.setMapOffset(mapOffset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "mapOffset", t);
        }
        Pointer mapPointer = builder.resolveProperty(assetAttachment, "mapPointer", Pointer.class, false, Pointer.valueOf(0L));
        try {
            assetToUpdate.setMapPointer(mapPointer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "mapPointer", t);
        }
        boolean mapped = builder.resolveBooleanProperty(assetAttachment, "mapped", false);
        try {
            assetToUpdate.setMapped(mapped);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "mapped", t);
        }
        long size = builder.resolveLongProperty(assetAttachment, "size", 0L);
        try {
            assetToUpdate.setSize(size);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "size", t);
        }
        AbstractConstantOrAliasSpecExtended usage = builder.resolveProperty(assetAttachment, "usage", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_STATIC_DRAW);
        try {
            assetToUpdate.setUsage(usage);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "usage", t);
        }
        return true;
    }

    private static @NonNull GlFramebufferAsset createGlFramebufferAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        List<AbstractConstantOrAliasSpecExtended> drawBuffers = builder.resolveListProperty(assetAttachment, "drawBuffers", AbstractConstantOrAliasSpecExtended.class, false, AssetProcessorBase.getDefaultPropertyValueForGlFramebufferAssetDrawBuffers(currentState, functionCall, id));
        AbstractConstantOrAliasSpecExtended readBuffer = builder.resolveProperty(assetAttachment, "readBuffer", AbstractConstantOrAliasSpecExtended.class, false, null);
        GlFramebufferAsset newAssetObject = GlFramebufferAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, drawBuffers, readBuffer);
        return newAssetObject;
    }

    private static boolean updateGlFramebufferAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlFramebufferAsset assetToUpdate) {
        boolean defaultFixedSampleLocations = builder.resolveBooleanProperty(assetAttachment, "defaultFixedSampleLocations", false);
        try {
            assetToUpdate.setDefaultFixedSampleLocations(defaultFixedSampleLocations);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "defaultFixedSampleLocations", t);
        }
        long defaultHeight = builder.resolveLongProperty(assetAttachment, "defaultHeight", 0L);
        try {
            assetToUpdate.setDefaultHeight(defaultHeight);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "defaultHeight", t);
        }
        long defaultLayers = builder.resolveLongProperty(assetAttachment, "defaultLayers", 0L);
        try {
            assetToUpdate.setDefaultLayers(defaultLayers);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "defaultLayers", t);
        }
        long defaultSamples = builder.resolveLongProperty(assetAttachment, "defaultSamples", 0L);
        try {
            assetToUpdate.setDefaultSamples(defaultSamples);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "defaultSamples", t);
        }
        long defaultWidth = builder.resolveLongProperty(assetAttachment, "defaultWidth", 0L);
        try {
            assetToUpdate.setDefaultWidth(defaultWidth);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "defaultWidth", t);
        }
        return true;
    }

    private static @NonNull GlImageUnitAsset createGlImageUnitAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlImageUnitAsset newAssetObject = GlImageUnitAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlImageUnitAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlImageUnitAsset assetToUpdate) {
        AbstractConstantOrAliasSpecExtended access = builder.resolveConstantProperty(assetAttachment, "access", CONSTANT_SET_GL_IMAGE_UNIT_ASSET_ACCESS, false, KapiSpec.GLES.constants.GL_READ_ONLY);
        try {
            assetToUpdate.setAccess(access);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "access", t);
        }
        AbstractConstantOrAliasSpecExtended format = builder.resolveConstantProperty(assetAttachment, "format", CONSTANT_SET_GL_IMAGE_UNIT_ASSET_FORMAT, false, KapiSpec.GLES.constants.GL_R32UI);
        try {
            assetToUpdate.setFormat(format);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "format", t);
        }
        long layer = builder.resolveLongProperty(assetAttachment, "layer", 0L);
        try {
            assetToUpdate.setLayer(layer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "layer", t);
        }
        boolean layered = builder.resolveBooleanProperty(assetAttachment, "layered", false);
        try {
            assetToUpdate.setLayered(layered);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "layered", t);
        }
        long level = builder.resolveLongProperty(assetAttachment, "level", 0L);
        try {
            assetToUpdate.setLevel(level);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "level", t);
        }
        GlTextureAsset texture = builder.resolveAssetProperty(assetAttachment, "texture", GlTextureAsset.class, true, null);
        try {
            assetToUpdate.setTexture(texture);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "texture", t);
        }
        return true;
    }

    private static @NonNull GlProgramAsset createGlProgramAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlProgramAsset newAssetObject = GlProgramAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlProgramAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlProgramAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset> attachedShaders = builder.resolveMapProperty(assetAttachment, "attachedShaders", AbstractConstantOrAliasSpecExtended.class, GlShaderAsset.class);
        try {
            assetToUpdate.setAttachedShadersCollection(attachedShaders);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attachedShaders", t);
        }
        boolean deleted = builder.resolveBooleanProperty(assetAttachment, "deleted", false);
        try {
            assetToUpdate.setDeleted(deleted);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "deleted", t);
        }
        boolean linked = builder.resolveBooleanProperty(assetAttachment, "linked", false);
        try {
            assetToUpdate.setLinked(linked);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "linked", t);
        }
        Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset> linkedShaders = builder.resolveMapProperty(assetAttachment, "linkedShaders", AbstractConstantOrAliasSpecExtended.class, GlShaderAsset.class);
        try {
            assetToUpdate.setLinkedShadersCollection(linkedShaders);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "linkedShaders", t);
        }
        String programInfoLog = builder.resolveProperty(assetAttachment, "programInfoLog", String.class, false, "");
        try {
            assetToUpdate.setProgramInfoLog(programInfoLog);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "programInfoLog", t);
        }
        boolean separable = builder.resolveBooleanProperty(assetAttachment, "separable", false);
        try {
            assetToUpdate.setSeparable(separable);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "separable", t);
        }
        boolean validated = builder.resolveBooleanProperty(assetAttachment, "validated", false);
        try {
            assetToUpdate.setValidated(validated);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "validated", t);
        }
        return true;
    }

    private static @NonNull GlProgramPipelineAsset createGlProgramPipelineAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlProgramPipelineAsset newAssetObject = GlProgramPipelineAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlProgramPipelineAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlProgramPipelineAsset assetToUpdate) {
        GlProgramAsset activeProgram = builder.resolveAssetProperty(assetAttachment, "activeProgram", GlProgramAsset.class, true, null);
        try {
            assetToUpdate.setActiveProgram(activeProgram);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "activeProgram", t);
        }
        GlProgramAsset computeShader = builder.resolveAssetProperty(assetAttachment, "computeShader", GlProgramAsset.class, true, null);
        try {
            assetToUpdate.setComputeShader(computeShader);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "computeShader", t);
        }
        GlProgramAsset fragmentShader = builder.resolveAssetProperty(assetAttachment, "fragmentShader", GlProgramAsset.class, true, null);
        try {
            assetToUpdate.setFragmentShader(fragmentShader);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "fragmentShader", t);
        }
        GlProgramAsset geometryShader = builder.resolveAssetProperty(assetAttachment, "geometryShader", GlProgramAsset.class, true, null);
        try {
            assetToUpdate.setGeometryShader(geometryShader);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "geometryShader", t);
        }
        GlProgramAsset tessControlShader = builder.resolveAssetProperty(assetAttachment, "tessControlShader", GlProgramAsset.class, true, null);
        try {
            assetToUpdate.setTessControlShader(tessControlShader);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "tessControlShader", t);
        }
        GlProgramAsset tessEvaluationShader = builder.resolveAssetProperty(assetAttachment, "tessEvaluationShader", GlProgramAsset.class, true, null);
        try {
            assetToUpdate.setTessEvaluationShader(tessEvaluationShader);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "tessEvaluationShader", t);
        }
        GlProgramAsset vertexShader = builder.resolveAssetProperty(assetAttachment, "vertexShader", GlProgramAsset.class, true, null);
        try {
            assetToUpdate.setVertexShader(vertexShader);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "vertexShader", t);
        }
        return true;
    }

    private static @NonNull GlQueryObjectAsset createGlQueryObjectAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlQueryObjectAsset newAssetObject = GlQueryObjectAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlQueryObjectAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlQueryObjectAsset assetToUpdate) {
        long queryResult = builder.resolveLongProperty(assetAttachment, "queryResult", 0L);
        try {
            assetToUpdate.setQueryResult(queryResult);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "queryResult", t);
        }
        AbstractConstantOrAliasSpecExtended queryTarget = builder.resolveConstantProperty(assetAttachment, "queryTarget", CONSTANT_SET_GL_QUERY_OBJECT_ASSET_QUERY_TARGET, true, null);
        try {
            assetToUpdate.setQueryTarget(queryTarget);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "queryTarget", t);
        }
        boolean resultAvailable = builder.resolveBooleanProperty(assetAttachment, "resultAvailable", false);
        try {
            assetToUpdate.setResultAvailable(resultAvailable);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "resultAvailable", t);
        }
        return true;
    }

    private static @NonNull GlRenderbufferAsset createGlRenderbufferAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlRenderbufferAsset newAssetObject = GlRenderbufferAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlRenderbufferAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlRenderbufferAsset assetToUpdate) {
        long alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        try {
            assetToUpdate.setAlphaSize(alphaSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "alphaSize", t);
        }
        long blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        try {
            assetToUpdate.setBlueSize(blueSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "blueSize", t);
        }
        long depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        try {
            assetToUpdate.setDepthSize(depthSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthSize", t);
        }
        long greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        try {
            assetToUpdate.setGreenSize(greenSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "greenSize", t);
        }
        int height = builder.resolveIntProperty(assetAttachment, "height", 0);
        try {
            assetToUpdate.setHeight(height);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "height", t);
        }
        AbstractConstantOrAliasSpecExtended internalFormat = builder.resolveProperty(assetAttachment, "internalFormat", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_RGBA4);
        try {
            assetToUpdate.setInternalFormat(internalFormat);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "internalFormat", t);
        }
        long redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        try {
            assetToUpdate.setRedSize(redSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "redSize", t);
        }
        long samples = builder.resolveLongProperty(assetAttachment, "samples", 0L);
        try {
            assetToUpdate.setSamples(samples);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "samples", t);
        }
        long stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        try {
            assetToUpdate.setStencilSize(stencilSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "stencilSize", t);
        }
        int width = builder.resolveIntProperty(assetAttachment, "width", 0);
        try {
            assetToUpdate.setWidth(width);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "width", t);
        }
        return true;
    }

    private static @NonNull GlSamplerAsset createGlSamplerAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlSamplerAsset newAssetObject = GlSamplerAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlSamplerAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlSamplerAsset assetToUpdate) {
        float[] borderColor = builder.resolveFloatArrayProperty(assetAttachment, "borderColor", false);
        try {
            assetToUpdate.setBorderColor(borderColor);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "borderColor", t);
        }
        AbstractConstantOrAliasSpecExtended compareFunc = builder.resolveProperty(assetAttachment, "compareFunc", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LEQUAL);
        try {
            assetToUpdate.setCompareFunc(compareFunc);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "compareFunc", t);
        }
        AbstractConstantOrAliasSpecExtended compareMode = builder.resolveProperty(assetAttachment, "compareMode", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        try {
            assetToUpdate.setCompareMode(compareMode);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "compareMode", t);
        }
        AbstractConstantOrAliasSpecExtended magFilter = builder.resolveProperty(assetAttachment, "magFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        try {
            assetToUpdate.setMagFilter(magFilter);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "magFilter", t);
        }
        float maxLod = builder.resolveFloatProperty(assetAttachment, "maxLod", 1000.0f);
        try {
            assetToUpdate.setMaxLod(maxLod);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "maxLod", t);
        }
        AbstractConstantOrAliasSpecExtended minFilter = builder.resolveProperty(assetAttachment, "minFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NEAREST_MIPMAP_LINEAR);
        try {
            assetToUpdate.setMinFilter(minFilter);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "minFilter", t);
        }
        float minLod = builder.resolveFloatProperty(assetAttachment, "minLod", -1000.0f);
        try {
            assetToUpdate.setMinLod(minLod);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "minLod", t);
        }
        AbstractConstantOrAliasSpecExtended wrapR = builder.resolveProperty(assetAttachment, "wrapR", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        try {
            assetToUpdate.setWrapR(wrapR);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "wrapR", t);
        }
        AbstractConstantOrAliasSpecExtended wrapS = builder.resolveProperty(assetAttachment, "wrapS", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        try {
            assetToUpdate.setWrapS(wrapS);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "wrapS", t);
        }
        AbstractConstantOrAliasSpecExtended wrapT = builder.resolveProperty(assetAttachment, "wrapT", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        try {
            assetToUpdate.setWrapT(wrapT);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "wrapT", t);
        }
        return true;
    }

    private static @NonNull GlShaderAsset createGlShaderAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        AbstractConstantOrAliasSpecExtended type = builder.resolveConstantProperty(assetAttachment, "type", CONSTANT_SET_GL_SHADER_ASSET_TYPE, false, null);
        GlShaderAsset newAssetObject = GlShaderAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, type);
        return newAssetObject;
    }

    private static boolean updateGlShaderAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlShaderAsset assetToUpdate) {
        AbstractConstantOrAliasSpecExtended binaryFormat = builder.resolveProperty(assetAttachment, "binaryFormat", AbstractConstantOrAliasSpecExtended.class, true, null);
        try {
            assetToUpdate.setBinaryFormat(binaryFormat);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "binaryFormat", t);
        }
        boolean compiled = builder.resolveBooleanProperty(assetAttachment, "compiled", false);
        try {
            assetToUpdate.setCompiled(compiled);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "compiled", t);
        }
        boolean deleted = builder.resolveBooleanProperty(assetAttachment, "deleted", false);
        try {
            assetToUpdate.setDeleted(deleted);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "deleted", t);
        }
        boolean flaggedForDeletion = builder.resolveBooleanProperty(assetAttachment, "flaggedForDeletion", false);
        try {
            assetToUpdate.setFlaggedForDeletion(flaggedForDeletion);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "flaggedForDeletion", t);
        }
        String shaderInfoLog = builder.resolveProperty(assetAttachment, "shaderInfoLog", String.class, false, "");
        try {
            assetToUpdate.setShaderInfoLog(shaderInfoLog);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "shaderInfoLog", t);
        }
        String shaderSource = builder.resolveProperty(assetAttachment, "shaderSource", String.class, false, "");
        try {
            assetToUpdate.setShaderSource(shaderSource);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "shaderSource", t);
        }
        return true;
    }

    private static @NonNull GlShaderStorageBufferBindingPointAsset createGlShaderStorageBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlShaderStorageBufferBindingPointAsset newAssetObject = GlShaderStorageBufferBindingPointAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlShaderStorageBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlShaderStorageBufferBindingPointAsset assetToUpdate) {
        GlBufferAsset buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        try {
            assetToUpdate.setBuffer(buffer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "buffer", t);
        }
        long length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        try {
            assetToUpdate.setLength(length);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "length", t);
        }
        long offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        try {
            assetToUpdate.setOffset(offset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "offset", t);
        }
        return true;
    }

    private static @NonNull GlSyncObjectAsset createGlSyncObjectAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        AbstractConstantOrAliasSpecExtended type = builder.resolveConstantProperty(assetAttachment, "type", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_TYPE, false, null);
        GlSyncObjectAsset newAssetObject = GlSyncObjectAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, type);
        return newAssetObject;
    }

    private static boolean updateGlSyncObjectAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlSyncObjectAsset assetToUpdate) {
        AbstractConstantOrAliasSpecExtended condition = builder.resolveConstantProperty(assetAttachment, "condition", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_CONDITION, false, KapiSpec.GLES.constants.GL_SYNC_GPU_COMMANDS_COMPLETE);
        try {
            assetToUpdate.setCondition(condition);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "condition", t);
        }
        Bitfield flags = builder.resolveBitfieldProperty(assetAttachment, "flags", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_FLAGS, false, null);
        try {
            assetToUpdate.setFlags(flags);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "flags", t);
        }
        AbstractConstantOrAliasSpecExtended status = builder.resolveConstantProperty(assetAttachment, "status", CONSTANT_SET_GL_SYNC_OBJECT_ASSET_STATUS, false, KapiSpec.GLES.constants.GL_UNSIGNALED);
        try {
            assetToUpdate.setStatus(status);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "status", t);
        }
        return true;
    }

    private static @NonNull GlTextureAsset createGlTextureAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTextureAsset newAssetObject = GlTextureAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlTextureAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlTextureAsset assetToUpdate) {
        long baseLevel = builder.resolveLongProperty(assetAttachment, "baseLevel", 0L);
        try {
            assetToUpdate.setBaseLevel(baseLevel);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "baseLevel", t);
        }
        float[] borderColor = builder.resolveFloatArrayProperty(assetAttachment, "borderColor", false);
        try {
            assetToUpdate.setBorderColor(borderColor);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "borderColor", t);
        }
        AbstractConstantOrAliasSpecExtended compareFunc = builder.resolveProperty(assetAttachment, "compareFunc", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LEQUAL);
        try {
            assetToUpdate.setCompareFunc(compareFunc);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "compareFunc", t);
        }
        AbstractConstantOrAliasSpecExtended compareMode = builder.resolveProperty(assetAttachment, "compareMode", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        try {
            assetToUpdate.setCompareMode(compareMode);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "compareMode", t);
        }
        AbstractConstantOrAliasSpecExtended depthStencilTextureMode = builder.resolveProperty(assetAttachment, "depthStencilTextureMode", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_DEPTH_COMPONENT);
        try {
            assetToUpdate.setDepthStencilTextureMode(depthStencilTextureMode);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthStencilTextureMode", t);
        }
        Pointer eglImage = builder.resolveProperty(assetAttachment, "eglImage", Pointer.class, true, null);
        try {
            assetToUpdate.setEglImage(eglImage);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "eglImage", t);
        }
        boolean immutableFormat = builder.resolveBooleanProperty(assetAttachment, "immutableFormat", false);
        try {
            assetToUpdate.setImmutableFormat(immutableFormat);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "immutableFormat", t);
        }
        long immutableLevels = builder.resolveLongProperty(assetAttachment, "immutableLevels", 0L);
        try {
            assetToUpdate.setImmutableLevels(immutableLevels);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "immutableLevels", t);
        }
        AbstractConstantOrAliasSpecExtended magFilter = builder.resolveProperty(assetAttachment, "magFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        try {
            assetToUpdate.setMagFilter(magFilter);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "magFilter", t);
        }
        long maxLevel = builder.resolveLongProperty(assetAttachment, "maxLevel", 1000L);
        try {
            assetToUpdate.setMaxLevel(maxLevel);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "maxLevel", t);
        }
        float maxLod = builder.resolveFloatProperty(assetAttachment, "maxLod", 1000.0f);
        try {
            assetToUpdate.setMaxLod(maxLod);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "maxLod", t);
        }
        AbstractConstantOrAliasSpecExtended minFilter = builder.resolveProperty(assetAttachment, "minFilter", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NEAREST_MIPMAP_LINEAR);
        try {
            assetToUpdate.setMinFilter(minFilter);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "minFilter", t);
        }
        float minLod = builder.resolveFloatProperty(assetAttachment, "minLod", -1000.0f);
        try {
            assetToUpdate.setMinLod(minLod);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "minLod", t);
        }
        AbstractConstantOrAliasSpecExtended swizzleA = builder.resolveProperty(assetAttachment, "swizzleA", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_ALPHA);
        try {
            assetToUpdate.setSwizzleA(swizzleA);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "swizzleA", t);
        }
        AbstractConstantOrAliasSpecExtended swizzleB = builder.resolveProperty(assetAttachment, "swizzleB", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_BLUE);
        try {
            assetToUpdate.setSwizzleB(swizzleB);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "swizzleB", t);
        }
        AbstractConstantOrAliasSpecExtended swizzleG = builder.resolveProperty(assetAttachment, "swizzleG", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_GREEN);
        try {
            assetToUpdate.setSwizzleG(swizzleG);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "swizzleG", t);
        }
        AbstractConstantOrAliasSpecExtended swizzleR = builder.resolveProperty(assetAttachment, "swizzleR", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_RED);
        try {
            assetToUpdate.setSwizzleR(swizzleR);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "swizzleR", t);
        }
        AbstractConstantOrAliasSpecExtended textureTarget = builder.resolveProperty(assetAttachment, "textureTarget", AbstractConstantOrAliasSpecExtended.class, true, null);
        try {
            assetToUpdate.setTextureTarget(textureTarget);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "textureTarget", t);
        }
        AbstractConstantOrAliasSpecExtended wrapR = builder.resolveProperty(assetAttachment, "wrapR", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        try {
            assetToUpdate.setWrapR(wrapR);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "wrapR", t);
        }
        AbstractConstantOrAliasSpecExtended wrapS = builder.resolveProperty(assetAttachment, "wrapS", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        try {
            assetToUpdate.setWrapS(wrapS);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "wrapS", t);
        }
        AbstractConstantOrAliasSpecExtended wrapT = builder.resolveProperty(assetAttachment, "wrapT", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_REPEAT);
        try {
            assetToUpdate.setWrapT(wrapT);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "wrapT", t);
        }
        return true;
    }

    private static @NonNull GlTextureUnitAsset createGlTextureUnitAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTextureUnitAsset newAssetObject = GlTextureUnitAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlTextureUnitAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlTextureUnitAsset assetToUpdate) {
        GlSamplerAsset sampler = builder.resolveAssetProperty(assetAttachment, "sampler", GlSamplerAsset.class, true, null);
        try {
            assetToUpdate.setSampler(sampler);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "sampler", t);
        }
        Map<AbstractConstantOrAliasSpecExtended, GlTextureAsset> textureTargets = builder.resolveMapProperty(assetAttachment, "textureTargets", AbstractConstantOrAliasSpecExtended.class, GlTextureAsset.class);
        try {
            assetToUpdate.setTextureTargetsCollection(textureTargets);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "textureTargets", t);
        }
        return true;
    }

    private static @NonNull GlTransformFeedbackAsset createGlTransformFeedbackAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTransformFeedbackAsset newAssetObject = GlTransformFeedbackAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlTransformFeedbackAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlTransformFeedbackAsset assetToUpdate) {
        boolean active = builder.resolveBooleanProperty(assetAttachment, "active", false);
        try {
            assetToUpdate.setActive(active);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "active", t);
        }
        boolean paused = builder.resolveBooleanProperty(assetAttachment, "paused", false);
        try {
            assetToUpdate.setPaused(paused);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "paused", t);
        }
        return true;
    }

    private static @NonNull GlTransformFeedbackBufferBindingPointAsset createGlTransformFeedbackBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTransformFeedbackBufferBindingPointAsset newAssetObject = GlTransformFeedbackBufferBindingPointAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlTransformFeedbackBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlTransformFeedbackBufferBindingPointAsset assetToUpdate) {
        GlBufferAsset buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        try {
            assetToUpdate.setBuffer(buffer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "buffer", t);
        }
        long length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        try {
            assetToUpdate.setLength(length);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "length", t);
        }
        long offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        try {
            assetToUpdate.setOffset(offset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "offset", t);
        }
        return true;
    }

    private static @NonNull GlUniformBindingPointAsset createGlUniformBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlUniformBindingPointAsset newAssetObject = GlUniformBindingPointAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlUniformBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlUniformBindingPointAsset assetToUpdate) {
        GlBufferAsset buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        try {
            assetToUpdate.setBuffer(buffer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "buffer", t);
        }
        long length = builder.resolveLongProperty(assetAttachment, "length", 0L);
        try {
            assetToUpdate.setLength(length);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "length", t);
        }
        long offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        try {
            assetToUpdate.setOffset(offset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "offset", t);
        }
        return true;
    }

    private static @NonNull GlVertexArrayObjectAsset createGlVertexArrayObjectAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlVertexArrayObjectAsset newAssetObject = GlVertexArrayObjectAsset.createForMidstreamTrace(builder, assetAttachment, functionCall);
        return newAssetObject;
    }

    private static boolean updateGlVertexArrayObjectAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlVertexArrayObjectAsset assetToUpdate) {
        GlBufferAsset elementArrayBufferBinding = builder.resolveAssetProperty(assetAttachment, "elementArrayBufferBinding", GlBufferAsset.class, true, null);
        try {
            assetToUpdate.setElementArrayBufferBinding(elementArrayBufferBinding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "elementArrayBufferBinding", t);
        }
        return true;
    }

    private static @NonNull GlVertexAttributeNonArrayValueAsset createGlVertexAttributeNonArrayValueAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        Number[] value = builder.resolveArrayProperty(assetAttachment, "value", Number.class, false);
        GlVertexAttributeNonArrayValueAsset newAssetObject = GlVertexAttributeNonArrayValueAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, value);
        return newAssetObject;
    }

    private static boolean updateGlVertexAttributeNonArrayValueAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlVertexAttributeNonArrayValueAsset assetToUpdate) {
        return true;
    }

    private static @NonNull GlTextureImageAsset createGlTextureImageAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureSurfaceAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTextureImageAsset newAssetObject = GlTextureImageAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset);
        return newAssetObject;
    }

    private static boolean updateGlTextureImageAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlTextureImageAsset assetToUpdate) {
        GlTextureSurfaceAsset parentAsset = assetToUpdate.getParentAsset();
        long alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        try {
            assetToUpdate.setAlphaSize(alphaSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "alphaSize", t);
        }
        AbstractConstantOrAliasSpecExtended alphaType = builder.resolveProperty(assetAttachment, "alphaType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        try {
            assetToUpdate.setAlphaType(alphaType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "alphaType", t);
        }
        long blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        try {
            assetToUpdate.setBlueSize(blueSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "blueSize", t);
        }
        AbstractConstantOrAliasSpecExtended blueType = builder.resolveProperty(assetAttachment, "blueType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        try {
            assetToUpdate.setBlueType(blueType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "blueType", t);
        }
        GlBufferAsset bufferDataStoreBinding = builder.resolveAssetProperty(assetAttachment, "bufferDataStoreBinding", GlBufferAsset.class, true, null);
        try {
            assetToUpdate.setBufferDataStoreBinding(bufferDataStoreBinding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "bufferDataStoreBinding", t);
        }
        long bufferOffset = builder.resolveLongProperty(assetAttachment, "bufferOffset", 0L);
        try {
            assetToUpdate.setBufferOffset(bufferOffset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "bufferOffset", t);
        }
        long bufferSize = builder.resolveLongProperty(assetAttachment, "bufferSize", 0L);
        try {
            assetToUpdate.setBufferSize(bufferSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "bufferSize", t);
        }
        boolean compressed = builder.resolveBooleanProperty(assetAttachment, "compressed", false);
        try {
            assetToUpdate.setCompressed(compressed);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "compressed", t);
        }
        long depth = builder.resolveLongProperty(assetAttachment, "depth", 0L);
        try {
            assetToUpdate.setDepth(depth);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depth", t);
        }
        long depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        try {
            assetToUpdate.setDepthSize(depthSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthSize", t);
        }
        AbstractConstantOrAliasSpecExtended depthType = builder.resolveProperty(assetAttachment, "depthType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        try {
            assetToUpdate.setDepthType(depthType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthType", t);
        }
        boolean fixedSampleLocations = builder.resolveBooleanProperty(assetAttachment, "fixedSampleLocations", true);
        try {
            assetToUpdate.setFixedSampleLocations(fixedSampleLocations);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "fixedSampleLocations", t);
        }
        long greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        try {
            assetToUpdate.setGreenSize(greenSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "greenSize", t);
        }
        AbstractConstantOrAliasSpecExtended greenType = builder.resolveProperty(assetAttachment, "greenType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        try {
            assetToUpdate.setGreenType(greenType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "greenType", t);
        }
        long height = builder.resolveLongProperty(assetAttachment, "height", 0L);
        try {
            assetToUpdate.setHeight(height);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "height", t);
        }
        AbstractConstantOrAliasSpecExtended internalFormat = builder.resolveProperty(assetAttachment, "internalFormat", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_RGBA);
        try {
            assetToUpdate.setInternalFormat(internalFormat);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "internalFormat", t);
        }
        long redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        try {
            assetToUpdate.setRedSize(redSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "redSize", t);
        }
        AbstractConstantOrAliasSpecExtended redType = builder.resolveProperty(assetAttachment, "redType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_NONE);
        try {
            assetToUpdate.setRedType(redType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "redType", t);
        }
        long samples = builder.resolveLongProperty(assetAttachment, "samples", 0L);
        try {
            assetToUpdate.setSamples(samples);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "samples", t);
        }
        long sharedSize = builder.resolveLongProperty(assetAttachment, "sharedSize", 0L);
        try {
            assetToUpdate.setSharedSize(sharedSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "sharedSize", t);
        }
        long stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        try {
            assetToUpdate.setStencilSize(stencilSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "stencilSize", t);
        }
        long width = builder.resolveLongProperty(assetAttachment, "width", 0L);
        try {
            assetToUpdate.setWidth(width);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "width", t);
        }
        return true;
    }

    private static @NonNull GlTextureSurfaceAsset createGlTextureSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlTextureAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTextureSurfaceAsset newAssetObject = GlTextureSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset);
        return newAssetObject;
    }

    private static boolean updateGlTextureSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlTextureSurfaceAsset assetToUpdate) {
        GlTextureAsset parentAsset = assetToUpdate.getParentAsset();
        return true;
    }

    private static @NonNull GlVertexAttributeAsset createGlVertexAttributeAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlVertexAttributeAsset newAssetObject = GlVertexAttributeAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset);
        return newAssetObject;
    }

    private static boolean updateGlVertexAttributeAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlVertexAttributeAsset assetToUpdate) {
        GlVertexArrayObjectAsset parentAsset = assetToUpdate.getParentAsset();
        boolean arrayEnabled = builder.resolveBooleanProperty(assetAttachment, "arrayEnabled", false);
        try {
            assetToUpdate.setArrayEnabled(arrayEnabled);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "arrayEnabled", t);
        }
        boolean arrayInteger = builder.resolveBooleanProperty(assetAttachment, "arrayInteger", false);
        try {
            assetToUpdate.setArrayInteger(arrayInteger);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "arrayInteger", t);
        }
        boolean arrayNormalized = builder.resolveBooleanProperty(assetAttachment, "arrayNormalized", false);
        try {
            assetToUpdate.setArrayNormalized(arrayNormalized);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "arrayNormalized", t);
        }
        Pointer arrayPointer = builder.resolveProperty(assetAttachment, "arrayPointer", Pointer.class, false, Pointer.valueOf(0L));
        try {
            assetToUpdate.setArrayPointer(arrayPointer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "arrayPointer", t);
        }
        long arraySize = builder.resolveLongProperty(assetAttachment, "arraySize", 4L);
        try {
            assetToUpdate.setArraySize(arraySize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "arraySize", t);
        }
        long arrayStride = builder.resolveLongProperty(assetAttachment, "arrayStride", 0L);
        try {
            assetToUpdate.setArrayStride(arrayStride);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "arrayStride", t);
        }
        AbstractConstantOrAliasSpecExtended arrayType = builder.resolveProperty(assetAttachment, "arrayType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        try {
            assetToUpdate.setArrayType(arrayType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "arrayType", t);
        }
        GlVertexBufferBindingAsset vboBinding = builder.resolveAssetProperty(assetAttachment, "vboBinding", GlVertexBufferBindingAsset.class, parentAsset, true, null);
        try {
            assetToUpdate.setVboBinding(vboBinding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "vboBinding", t);
        }
        long vboRelativeOffset = builder.resolveLongProperty(assetAttachment, "vboRelativeOffset", 0L);
        try {
            assetToUpdate.setVboRelativeOffset(vboRelativeOffset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "vboRelativeOffset", t);
        }
        return true;
    }

    private static @NonNull GlVertexBufferBindingAsset createGlVertexBufferBindingAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlVertexArrayObjectAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlVertexBufferBindingAsset newAssetObject = GlVertexBufferBindingAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset);
        return newAssetObject;
    }

    private static boolean updateGlVertexBufferBindingAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlVertexBufferBindingAsset assetToUpdate) {
        GlVertexArrayObjectAsset parentAsset = assetToUpdate.getParentAsset();
        GlBufferAsset buffer = builder.resolveAssetProperty(assetAttachment, "buffer", GlBufferAsset.class, true, null);
        try {
            assetToUpdate.setBuffer(buffer);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "buffer", t);
        }
        long divisor = builder.resolveLongProperty(assetAttachment, "divisor", 0L);
        try {
            assetToUpdate.setDivisor(divisor);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "divisor", t);
        }
        long offset = builder.resolveLongProperty(assetAttachment, "offset", 0L);
        try {
            assetToUpdate.setOffset(offset);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "offset", t);
        }
        long stride = builder.resolveLongProperty(assetAttachment, "stride", 0L);
        try {
            assetToUpdate.setStride(stride);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "stride", t);
        }
        return true;
    }

    private static @NonNull ShaderUniform createShaderUniform(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlProgramAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        ShaderUniform newAssetObject = ShaderUniform.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset);
        return newAssetObject;
    }

    private static boolean updateShaderUniform(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull ShaderUniform assetToUpdate) {
        GlProgramAsset parentAsset = assetToUpdate.getParentAsset();
        Number[] value = builder.resolveArrayProperty(assetAttachment, "value", Number.class, false);
        try {
            assetToUpdate.setValue(value);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "value", t);
        }
        return true;
    }

    private static @NonNull GlFramebufferRenderbufferAttachmentAsset createGlFramebufferRenderbufferAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlRenderbufferAsset renderbuffer = builder.resolveAssetProperty(assetAttachment, "renderbuffer", GlRenderbufferAsset.class, false, null);
        GlFramebufferRenderbufferAttachmentAsset newAssetObject = GlFramebufferRenderbufferAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, renderbuffer);
        return newAssetObject;
    }

    private static boolean updateGlFramebufferRenderbufferAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlFramebufferRenderbufferAttachmentAsset assetToUpdate) {
        GlFramebufferAsset parentAsset = assetToUpdate.getParentAsset();
        long alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        try {
            assetToUpdate.setAlphaSize(alphaSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "alphaSize", t);
        }
        long blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        try {
            assetToUpdate.setBlueSize(blueSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "blueSize", t);
        }
        AbstractConstantOrAliasSpecExtended colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        try {
            assetToUpdate.setColorEncoding(colorEncoding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "colorEncoding", t);
        }
        AbstractConstantOrAliasSpecExtended componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        try {
            assetToUpdate.setComponentType(componentType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "componentType", t);
        }
        long depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        try {
            assetToUpdate.setDepthSize(depthSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthSize", t);
        }
        long greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        try {
            assetToUpdate.setGreenSize(greenSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "greenSize", t);
        }
        long redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        try {
            assetToUpdate.setRedSize(redSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "redSize", t);
        }
        long stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        try {
            assetToUpdate.setStencilSize(stencilSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "stencilSize", t);
        }
        return true;
    }

    private static @NonNull GlFramebufferTextureAttachmentAsset createGlFramebufferTextureAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTextureAsset texture = builder.resolveAssetProperty(assetAttachment, "texture", GlTextureAsset.class, false, null);
        AbstractConstantOrAliasSpecExtended textureCubeMapFace = builder.resolveProperty(assetAttachment, "textureCubeMapFace", AbstractConstantOrAliasSpecExtended.class, true, KapiSpec.GLES.constants.GL_NONE);
        Integer textureLayer = builder.resolveProperty(assetAttachment, "textureLayer", Integer.class, true, 0);
        long textureLevel = builder.resolveLongProperty(assetAttachment, "textureLevel", 0L);
        GlFramebufferTextureAttachmentAsset newAssetObject = GlFramebufferTextureAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, texture, textureCubeMapFace, textureLayer, textureLevel);
        return newAssetObject;
    }

    private static boolean updateGlFramebufferTextureAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlFramebufferTextureAttachmentAsset assetToUpdate) {
        GlFramebufferAsset parentAsset = assetToUpdate.getParentAsset();
        long alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        try {
            assetToUpdate.setAlphaSize(alphaSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "alphaSize", t);
        }
        long blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        try {
            assetToUpdate.setBlueSize(blueSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "blueSize", t);
        }
        AbstractConstantOrAliasSpecExtended colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        try {
            assetToUpdate.setColorEncoding(colorEncoding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "colorEncoding", t);
        }
        AbstractConstantOrAliasSpecExtended componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        try {
            assetToUpdate.setComponentType(componentType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "componentType", t);
        }
        long depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        try {
            assetToUpdate.setDepthSize(depthSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthSize", t);
        }
        long greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        try {
            assetToUpdate.setGreenSize(greenSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "greenSize", t);
        }
        long redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        try {
            assetToUpdate.setRedSize(redSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "redSize", t);
        }
        long stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        try {
            assetToUpdate.setStencilSize(stencilSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "stencilSize", t);
        }
        return true;
    }

    private static @NonNull GlFramebufferTextureMultiviewAttachmentAsset createGlFramebufferTextureMultiviewAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlTextureAsset arrayTexture = builder.resolveAssetProperty(assetAttachment, "arrayTexture", GlTextureAsset.class, false, null);
        long arrayTextureLevel = builder.resolveLongProperty(assetAttachment, "arrayTextureLevel", 0L);
        long baseViewIndex = builder.resolveLongProperty(assetAttachment, "baseViewIndex", 0L);
        int numViews = builder.resolveIntProperty(assetAttachment, "numViews", 0);
        int samples = builder.resolveIntProperty(assetAttachment, "samples", 0);
        GlFramebufferTextureMultiviewAttachmentAsset newAssetObject = GlFramebufferTextureMultiviewAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset, arrayTexture, arrayTextureLevel, baseViewIndex, numViews, samples);
        return newAssetObject;
    }

    private static boolean updateGlFramebufferTextureMultiviewAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlFramebufferTextureMultiviewAttachmentAsset assetToUpdate) {
        GlFramebufferAsset parentAsset = assetToUpdate.getParentAsset();
        long alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        try {
            assetToUpdate.setAlphaSize(alphaSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "alphaSize", t);
        }
        long blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        try {
            assetToUpdate.setBlueSize(blueSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "blueSize", t);
        }
        AbstractConstantOrAliasSpecExtended colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        try {
            assetToUpdate.setColorEncoding(colorEncoding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "colorEncoding", t);
        }
        AbstractConstantOrAliasSpecExtended componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        try {
            assetToUpdate.setComponentType(componentType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "componentType", t);
        }
        long depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        try {
            assetToUpdate.setDepthSize(depthSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthSize", t);
        }
        long greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        try {
            assetToUpdate.setGreenSize(greenSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "greenSize", t);
        }
        long redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        try {
            assetToUpdate.setRedSize(redSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "redSize", t);
        }
        long stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        try {
            assetToUpdate.setStencilSize(stencilSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "stencilSize", t);
        }
        return true;
    }

    private static @NonNull GlFramebufferZeroAttachmentAsset createGlFramebufferZeroAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        GlFramebufferZeroAttachmentAsset newAssetObject = GlFramebufferZeroAttachmentAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentAsset);
        return newAssetObject;
    }

    private static boolean updateGlFramebufferZeroAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull GlFramebufferZeroAttachmentAsset assetToUpdate) {
        GlFramebufferAsset parentAsset = assetToUpdate.getParentAsset();
        long alphaSize = builder.resolveLongProperty(assetAttachment, "alphaSize", 0L);
        try {
            assetToUpdate.setAlphaSize(alphaSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "alphaSize", t);
        }
        long blueSize = builder.resolveLongProperty(assetAttachment, "blueSize", 0L);
        try {
            assetToUpdate.setBlueSize(blueSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "blueSize", t);
        }
        AbstractConstantOrAliasSpecExtended colorEncoding = builder.resolveProperty(assetAttachment, "colorEncoding", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_LINEAR);
        try {
            assetToUpdate.setColorEncoding(colorEncoding);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "colorEncoding", t);
        }
        AbstractConstantOrAliasSpecExtended componentType = builder.resolveProperty(assetAttachment, "componentType", AbstractConstantOrAliasSpecExtended.class, false, KapiSpec.GLES.constants.GL_FLOAT);
        try {
            assetToUpdate.setComponentType(componentType);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "componentType", t);
        }
        long depthSize = builder.resolveLongProperty(assetAttachment, "depthSize", 0L);
        try {
            assetToUpdate.setDepthSize(depthSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "depthSize", t);
        }
        long greenSize = builder.resolveLongProperty(assetAttachment, "greenSize", 0L);
        try {
            assetToUpdate.setGreenSize(greenSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "greenSize", t);
        }
        long redSize = builder.resolveLongProperty(assetAttachment, "redSize", 0L);
        try {
            assetToUpdate.setRedSize(redSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "redSize", t);
        }
        long stencilSize = builder.resolveLongProperty(assetAttachment, "stencilSize", 0L);
        try {
            assetToUpdate.setStencilSize(stencilSize);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "stencilSize", t);
        }
        return true;
    }

    private static @NonNull EglConfigAsset createEglConfigAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        EglDisplayAsset parentDisplay = parentAsset;
        EglConfigAsset newAssetObject = EglConfigAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentDisplay);
        return newAssetObject;
    }

    private static boolean updateEglConfigAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglConfigAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, Long> attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setAttributesCollection(attributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attributes", t);
        }
        return true;
    }

    private static @NonNull EglContextAsset createEglContextAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, false, null);
        EglDisplayAsset parentDisplay = parentAsset;
        EglContextAsset sharedContext = builder.resolveAssetProperty(assetAttachment, "sharedContext", EglContextAsset.class, true, null);
        EglContextAsset newAssetObject = EglContextAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, config, parentDisplay, sharedContext);
        return newAssetObject;
    }

    private static boolean updateEglContextAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglContextAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, Long> attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setAttributesCollection(attributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attributes", t);
        }
        return true;
    }

    private static @NonNull EglDisplayAsset createEglDisplayAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        Pointer nativeDisplayID = builder.resolveProperty(assetAttachment, "nativeDisplayID", Pointer.class, false, Pointer.NULL);
        EglDisplayAsset newAssetObject = EglDisplayAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, nativeDisplayID);
        return newAssetObject;
    }

    private static boolean updateEglDisplayAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglDisplayAsset assetToUpdate) {
        return true;
    }

    private static @NonNull EglImageAsset createEglImageAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        Pointer clientObjectID = builder.resolveProperty(assetAttachment, "clientObjectID", Pointer.class, false, null);
        EglDisplayAsset parentDisplay = parentAsset;
        EglContextAsset sourceContext = builder.resolveAssetProperty(assetAttachment, "sourceContext", EglContextAsset.class, true, null);
        AbstractConstantOrAliasSpecExtended target = builder.resolveConstantProperty(assetAttachment, "target", CONSTANT_SET_EGL_IMAGE_ASSET_TARGET, false, null);
        EglImageAsset newAssetObject = EglImageAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, clientObjectID, parentDisplay, sourceContext, target);
        return newAssetObject;
    }

    private static boolean updateEglImageAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglImageAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, Long> attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setAttributesCollection(attributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attributes", t);
        }
        return true;
    }

    private static @NonNull EglSyncAsset createEglSyncAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        EglDisplayAsset parentDisplay = parentAsset;
        AbstractConstantOrAliasSpecExtended type = builder.resolveConstantProperty(assetAttachment, "type", CONSTANT_SET_EGL_SYNC_ASSET_TYPE, false, null);
        EglSyncAsset newAssetObject = EglSyncAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, parentDisplay, type);
        return newAssetObject;
    }

    private static boolean updateEglSyncAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglSyncAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, Long> attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setAttributesCollection(attributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attributes", t);
        }
        AbstractConstantOrAliasSpecExtended status = builder.resolveConstantProperty(assetAttachment, "status", CONSTANT_SET_EGL_SYNC_ASSET_STATUS, false, KapiSpec.EGL.constants.EGL_UNSIGNALED_KHR);
        try {
            assetToUpdate.setStatus(status);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "status", t);
        }
        return true;
    }

    private static @NonNull EglPbufferSurfaceAsset createEglPbufferSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, false, null);
        EglDisplayAsset parentDisplay = parentAsset;
        EglPbufferSurfaceAsset newAssetObject = EglPbufferSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, config, parentDisplay);
        return newAssetObject;
    }

    private static boolean updateEglPbufferSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglPbufferSurfaceAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, Long> attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setAttributesCollection(attributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attributes", t);
        }
        Boolean locked = builder.resolveProperty(assetAttachment, "locked", Boolean.class, true, null);
        try {
            assetToUpdate.setLocked(locked);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "locked", t);
        }
        Map<AbstractConstantOrAliasSpecExtended, Long> pendingAttributes = builder.resolveMapProperty(assetAttachment, "pendingAttributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setPendingAttributesCollection(pendingAttributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "pendingAttributes", t);
        }
        Integer boundTexture = builder.resolveProperty(assetAttachment, "boundTexture", Integer.class, true, null);
        try {
            assetToUpdate.setBoundTexture(boundTexture);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "boundTexture", t);
        }
        EglContextAsset sourceContext = builder.resolveAssetProperty(assetAttachment, "sourceContext", EglContextAsset.class, true, null);
        try {
            assetToUpdate.setSourceContext(sourceContext);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "sourceContext", t);
        }
        return true;
    }

    private static @NonNull EglPixmapSurfaceAsset createEglPixmapSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, false, null);
        EglDisplayAsset parentDisplay = parentAsset;
        Pointer nativePixmap = builder.resolveProperty(assetAttachment, "nativePixmap", Pointer.class, false, null);
        EglPixmapSurfaceAsset newAssetObject = EglPixmapSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, config, parentDisplay, nativePixmap);
        return newAssetObject;
    }

    private static boolean updateEglPixmapSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglPixmapSurfaceAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, Long> attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setAttributesCollection(attributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attributes", t);
        }
        Boolean locked = builder.resolveProperty(assetAttachment, "locked", Boolean.class, true, null);
        try {
            assetToUpdate.setLocked(locked);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "locked", t);
        }
        Map<AbstractConstantOrAliasSpecExtended, Long> pendingAttributes = builder.resolveMapProperty(assetAttachment, "pendingAttributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setPendingAttributesCollection(pendingAttributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "pendingAttributes", t);
        }
        return true;
    }

    private static @NonNull EglWindowSurfaceAsset createEglWindowSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull EglDisplayAsset parentAsset) {
        TraceStateSnapshot currentState = builder.getSnapshotAssetParent().getTraceStateSnapshot();
        long id = assetAttachment.getId();
        EglConfigAsset config = builder.resolveAssetProperty(assetAttachment, "config", EglConfigAsset.class, false, null);
        EglDisplayAsset parentDisplay = parentAsset;
        Pointer nativeWindow = builder.resolveProperty(assetAttachment, "nativeWindow", Pointer.class, false, null);
        EglWindowSurfaceAsset newAssetObject = EglWindowSurfaceAsset.createForMidstreamTrace(builder, assetAttachment, functionCall, config, parentDisplay, nativeWindow);
        return newAssetObject;
    }

    private static boolean updateEglWindowSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull EglWindowSurfaceAsset assetToUpdate) {
        Map<AbstractConstantOrAliasSpecExtended, Long> attributes = builder.resolveMapProperty(assetAttachment, "attributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setAttributesCollection(attributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "attributes", t);
        }
        Boolean locked = builder.resolveProperty(assetAttachment, "locked", Boolean.class, true, null);
        try {
            assetToUpdate.setLocked(locked);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "locked", t);
        }
        Map<AbstractConstantOrAliasSpecExtended, Long> pendingAttributes = builder.resolveMapProperty(assetAttachment, "pendingAttributes", AbstractConstantOrAliasSpecExtended.class, Long.class);
        try {
            assetToUpdate.setPendingAttributesCollection(pendingAttributes);
        }
        catch (Throwable t) {
            MidstreamAssetFactory.processThrown(builder, assetToUpdate, "pendingAttributes", t);
        }
        return true;
    }

    public static <TYPE extends IAssetItem, PARENT extends IAssetItem> @NonNull TYPE create(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull KapiSpec.AssetTraits<TYPE, ?, ?> traits, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @Nullable PARENT parentAsset) {
        AllAssetClasses classEnum = traits.ENUM;
        assert (classEnum != null);
        switch (classEnum) {
            case GL_ATOMIC_COUNTER_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlAtomicCounterBufferBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_BUFFER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlBufferAsset(builder, assetAttachment, functionCall);
            }
            case GL_FRAMEBUFFER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferAsset(builder, assetAttachment, functionCall);
            }
            case GL_IMAGE_UNIT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlImageUnitAsset(builder, assetAttachment, functionCall);
            }
            case GL_PROGRAM_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlProgramAsset(builder, assetAttachment, functionCall);
            }
            case GL_PROGRAM_PIPELINE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlProgramPipelineAsset(builder, assetAttachment, functionCall);
            }
            case GL_QUERY_OBJECT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlQueryObjectAsset(builder, assetAttachment, functionCall);
            }
            case GL_RENDERBUFFER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlRenderbufferAsset(builder, assetAttachment, functionCall);
            }
            case GL_SAMPLER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlSamplerAsset(builder, assetAttachment, functionCall);
            }
            case GL_SHADER_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlShaderAsset(builder, assetAttachment, functionCall);
            }
            case GL_SHADER_STORAGE_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlShaderStorageBufferBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_SYNC_OBJECT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlSyncObjectAsset(builder, assetAttachment, functionCall);
            }
            case GL_TEXTURE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureAsset(builder, assetAttachment, functionCall);
            }
            case GL_TEXTURE_UNIT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureUnitAsset(builder, assetAttachment, functionCall);
            }
            case GL_TRANSFORM_FEEDBACK_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTransformFeedbackAsset(builder, assetAttachment, functionCall);
            }
            case GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTransformFeedbackBufferBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_UNIFORM_BINDING_POINT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlUniformBindingPointAsset(builder, assetAttachment, functionCall);
            }
            case GL_VERTEX_ARRAY_OBJECT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexArrayObjectAsset(builder, assetAttachment, functionCall);
            }
            case GL_VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexAttributeNonArrayValueAsset(builder, assetAttachment, functionCall);
            }
            case GL_TEXTURE_IMAGE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureImageAsset(builder, assetAttachment, functionCall, (GlTextureSurfaceAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_TEXTURE_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlTextureSurfaceAsset(builder, assetAttachment, functionCall, (GlTextureAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_VERTEX_ATTRIBUTE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexAttributeAsset(builder, assetAttachment, functionCall, (GlVertexArrayObjectAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_VERTEX_BUFFER_BINDING_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlVertexBufferBindingAsset(builder, assetAttachment, functionCall, (GlVertexArrayObjectAsset)NullUtils.neverNull(parentAsset));
            }
            case SHADER_UNIFORM: {
                return (TYPE)MidstreamAssetFactory.createShaderUniform(builder, assetAttachment, functionCall, (GlProgramAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_RENDERBUFFER_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferRenderbufferAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_TEXTURE_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferTextureAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_TEXTURE_MULTIVIEW_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferTextureMultiviewAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case GL_FRAMEBUFFER_ZERO_ATTACHMENT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createGlFramebufferZeroAttachmentAsset(builder, assetAttachment, functionCall, (GlFramebufferAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_CONFIG_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglConfigAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_CONTEXT_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglContextAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_DISPLAY_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglDisplayAsset(builder, assetAttachment, functionCall);
            }
            case EGL_IMAGE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglImageAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_SYNC_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglSyncAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_PBUFFER_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglPbufferSurfaceAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_PIXMAP_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglPixmapSurfaceAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
            case EGL_WINDOW_SURFACE_ASSET: {
                return (TYPE)MidstreamAssetFactory.createEglWindowSurfaceAsset(builder, assetAttachment, functionCall, (EglDisplayAsset)NullUtils.neverNull(parentAsset));
            }
        }
        throw new AssertionError((Object)("Unexpected asset class for midstream trace processing in create: " + (Object)((Object)classEnum)));
    }

    public static <TYPE extends IAssetItem> boolean update(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull KapiSpec.AssetTraits<TYPE, ?, ?> traits, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall updateFunction, @NonNull TYPE assetToUpdate) {
        AllAssetClasses classEnum = traits.ENUM;
        assert (classEnum != null);
        switch (classEnum) {
            case GL_ATOMIC_COUNTER_BUFFER_BINDING_POINT_ASSET: {
                return MidstreamAssetFactory.updateGlAtomicCounterBufferBindingPointAsset(builder, assetAttachment, updateFunction, (GlAtomicCounterBufferBindingPointAsset)assetToUpdate);
            }
            case GL_BUFFER_ASSET: {
                return MidstreamAssetFactory.updateGlBufferAsset(builder, assetAttachment, updateFunction, (GlBufferAsset)assetToUpdate);
            }
            case GL_FRAMEBUFFER_ASSET: {
                return MidstreamAssetFactory.updateGlFramebufferAsset(builder, assetAttachment, updateFunction, (GlFramebufferAsset)assetToUpdate);
            }
            case GL_IMAGE_UNIT_ASSET: {
                return MidstreamAssetFactory.updateGlImageUnitAsset(builder, assetAttachment, updateFunction, (GlImageUnitAsset)assetToUpdate);
            }
            case GL_PROGRAM_ASSET: {
                return MidstreamAssetFactory.updateGlProgramAsset(builder, assetAttachment, updateFunction, (GlProgramAsset)assetToUpdate);
            }
            case GL_PROGRAM_PIPELINE_ASSET: {
                return MidstreamAssetFactory.updateGlProgramPipelineAsset(builder, assetAttachment, updateFunction, (GlProgramPipelineAsset)assetToUpdate);
            }
            case GL_QUERY_OBJECT_ASSET: {
                return MidstreamAssetFactory.updateGlQueryObjectAsset(builder, assetAttachment, updateFunction, (GlQueryObjectAsset)assetToUpdate);
            }
            case GL_RENDERBUFFER_ASSET: {
                return MidstreamAssetFactory.updateGlRenderbufferAsset(builder, assetAttachment, updateFunction, (GlRenderbufferAsset)assetToUpdate);
            }
            case GL_SAMPLER_ASSET: {
                return MidstreamAssetFactory.updateGlSamplerAsset(builder, assetAttachment, updateFunction, (GlSamplerAsset)assetToUpdate);
            }
            case GL_SHADER_ASSET: {
                return MidstreamAssetFactory.updateGlShaderAsset(builder, assetAttachment, updateFunction, (GlShaderAsset)assetToUpdate);
            }
            case GL_SHADER_STORAGE_BUFFER_BINDING_POINT_ASSET: {
                return MidstreamAssetFactory.updateGlShaderStorageBufferBindingPointAsset(builder, assetAttachment, updateFunction, (GlShaderStorageBufferBindingPointAsset)assetToUpdate);
            }
            case GL_SYNC_OBJECT_ASSET: {
                return MidstreamAssetFactory.updateGlSyncObjectAsset(builder, assetAttachment, updateFunction, (GlSyncObjectAsset)assetToUpdate);
            }
            case GL_TEXTURE_ASSET: {
                return MidstreamAssetFactory.updateGlTextureAsset(builder, assetAttachment, updateFunction, (GlTextureAsset)assetToUpdate);
            }
            case GL_TEXTURE_UNIT_ASSET: {
                return MidstreamAssetFactory.updateGlTextureUnitAsset(builder, assetAttachment, updateFunction, (GlTextureUnitAsset)assetToUpdate);
            }
            case GL_TRANSFORM_FEEDBACK_ASSET: {
                return MidstreamAssetFactory.updateGlTransformFeedbackAsset(builder, assetAttachment, updateFunction, (GlTransformFeedbackAsset)assetToUpdate);
            }
            case GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_POINT_ASSET: {
                return MidstreamAssetFactory.updateGlTransformFeedbackBufferBindingPointAsset(builder, assetAttachment, updateFunction, (GlTransformFeedbackBufferBindingPointAsset)assetToUpdate);
            }
            case GL_UNIFORM_BINDING_POINT_ASSET: {
                return MidstreamAssetFactory.updateGlUniformBindingPointAsset(builder, assetAttachment, updateFunction, (GlUniformBindingPointAsset)assetToUpdate);
            }
            case GL_VERTEX_ARRAY_OBJECT_ASSET: {
                return MidstreamAssetFactory.updateGlVertexArrayObjectAsset(builder, assetAttachment, updateFunction, (GlVertexArrayObjectAsset)assetToUpdate);
            }
            case GL_VERTEX_ATTRIBUTE_NON_ARRAY_VALUE_ASSET: {
                return MidstreamAssetFactory.updateGlVertexAttributeNonArrayValueAsset(builder, assetAttachment, updateFunction, (GlVertexAttributeNonArrayValueAsset)assetToUpdate);
            }
            case GL_TEXTURE_IMAGE_ASSET: {
                return MidstreamAssetFactory.updateGlTextureImageAsset(builder, assetAttachment, updateFunction, (GlTextureImageAsset)assetToUpdate);
            }
            case GL_TEXTURE_SURFACE_ASSET: {
                return MidstreamAssetFactory.updateGlTextureSurfaceAsset(builder, assetAttachment, updateFunction, (GlTextureSurfaceAsset)assetToUpdate);
            }
            case GL_VERTEX_ATTRIBUTE_ASSET: {
                return MidstreamAssetFactory.updateGlVertexAttributeAsset(builder, assetAttachment, updateFunction, (GlVertexAttributeAsset)assetToUpdate);
            }
            case GL_VERTEX_BUFFER_BINDING_ASSET: {
                return MidstreamAssetFactory.updateGlVertexBufferBindingAsset(builder, assetAttachment, updateFunction, (GlVertexBufferBindingAsset)assetToUpdate);
            }
            case SHADER_UNIFORM: {
                return MidstreamAssetFactory.updateShaderUniform(builder, assetAttachment, updateFunction, (ShaderUniform)assetToUpdate);
            }
            case GL_FRAMEBUFFER_RENDERBUFFER_ATTACHMENT_ASSET: {
                return MidstreamAssetFactory.updateGlFramebufferRenderbufferAttachmentAsset(builder, assetAttachment, updateFunction, (GlFramebufferRenderbufferAttachmentAsset)assetToUpdate);
            }
            case GL_FRAMEBUFFER_TEXTURE_ATTACHMENT_ASSET: {
                return MidstreamAssetFactory.updateGlFramebufferTextureAttachmentAsset(builder, assetAttachment, updateFunction, (GlFramebufferTextureAttachmentAsset)assetToUpdate);
            }
            case GL_FRAMEBUFFER_TEXTURE_MULTIVIEW_ATTACHMENT_ASSET: {
                return MidstreamAssetFactory.updateGlFramebufferTextureMultiviewAttachmentAsset(builder, assetAttachment, updateFunction, (GlFramebufferTextureMultiviewAttachmentAsset)assetToUpdate);
            }
            case GL_FRAMEBUFFER_ZERO_ATTACHMENT_ASSET: {
                return MidstreamAssetFactory.updateGlFramebufferZeroAttachmentAsset(builder, assetAttachment, updateFunction, (GlFramebufferZeroAttachmentAsset)assetToUpdate);
            }
            case EGL_CONFIG_ASSET: {
                return MidstreamAssetFactory.updateEglConfigAsset(builder, assetAttachment, updateFunction, (EglConfigAsset)assetToUpdate);
            }
            case EGL_CONTEXT_ASSET: {
                return MidstreamAssetFactory.updateEglContextAsset(builder, assetAttachment, updateFunction, (EglContextAsset)assetToUpdate);
            }
            case EGL_DISPLAY_ASSET: {
                return MidstreamAssetFactory.updateEglDisplayAsset(builder, assetAttachment, updateFunction, (EglDisplayAsset)assetToUpdate);
            }
            case EGL_IMAGE_ASSET: {
                return MidstreamAssetFactory.updateEglImageAsset(builder, assetAttachment, updateFunction, (EglImageAsset)assetToUpdate);
            }
            case EGL_SYNC_ASSET: {
                return MidstreamAssetFactory.updateEglSyncAsset(builder, assetAttachment, updateFunction, (EglSyncAsset)assetToUpdate);
            }
            case EGL_PBUFFER_SURFACE_ASSET: {
                return MidstreamAssetFactory.updateEglPbufferSurfaceAsset(builder, assetAttachment, updateFunction, (EglPbufferSurfaceAsset)assetToUpdate);
            }
            case EGL_PIXMAP_SURFACE_ASSET: {
                return MidstreamAssetFactory.updateEglPixmapSurfaceAsset(builder, assetAttachment, updateFunction, (EglPixmapSurfaceAsset)assetToUpdate);
            }
            case EGL_WINDOW_SURFACE_ASSET: {
                return MidstreamAssetFactory.updateEglWindowSurfaceAsset(builder, assetAttachment, updateFunction, (EglWindowSurfaceAsset)assetToUpdate);
            }
        }
        throw new AssertionError((Object)("Unexpected asset class for midstream trace processing in update: " + (Object)((Object)classEnum)));
    }

    private static void processThrown(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull IAssetItem assetToUpdate, @NonNull String propertyName, @NonNull Throwable t) {
        if (!(t instanceof OneShotPropertyFailureException)) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        CoreLogging.info(builder.getModel(), "Unexpected OneShotPropertyFailureException for " + assetToUpdate.getLabelText() + " for " + propertyName);
    }

    public static abstract class FindExistingAssetHelper {
        public @Nullable GlAtomicCounterBufferBindingPointAsset findGlAtomicCounterBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewGlAtomicCounterBufferBindingPointAsset(currentState, functionCall, id);
        }

        public @Nullable GlBufferAsset findGlBufferAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlBufferAsset(currentState, functionCall, id);
        }

        public @Nullable GlFramebufferAsset findGlFramebufferAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlFramebufferAsset(currentState, functionCall, id, AssetProcessorBase.asAssetID(0L));
        }

        public @Nullable GlImageUnitAsset findGlImageUnitAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewGlImageUnitAsset(currentState, functionCall, id);
        }

        public @Nullable GlProgramAsset findGlProgramAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlProgramAsset(currentState, functionCall, id);
        }

        public @Nullable GlProgramPipelineAsset findGlProgramPipelineAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlProgramPipelineAsset(currentState, functionCall, id);
        }

        public @Nullable GlQueryObjectAsset findGlQueryObjectAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlQueryObjectAsset(currentState, functionCall, id);
        }

        public @Nullable GlRenderbufferAsset findGlRenderbufferAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlRenderbufferAsset(currentState, functionCall, id);
        }

        public @Nullable GlSamplerAsset findGlSamplerAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlSamplerAsset(currentState, functionCall, id);
        }

        public @Nullable GlShaderAsset findGlShaderAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlShaderAsset(currentState, functionCall, id);
        }

        public @Nullable GlShaderStorageBufferBindingPointAsset findGlShaderStorageBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewGlShaderStorageBufferBindingPointAsset(currentState, functionCall, id);
        }

        public @Nullable GlSyncObjectAsset findGlSyncObjectAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlSyncObjectAsset(currentState, functionCall, id);
        }

        public @Nullable GlTextureAsset findGlTextureAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlTextureAsset(currentState, functionCall, id, AssetProcessorBase.asAssetID(0L));
        }

        public @Nullable GlTextureUnitAsset findGlTextureUnitAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewGlTextureUnitAsset(currentState, functionCall, id);
        }

        public @Nullable GlTransformFeedbackAsset findGlTransformFeedbackAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlTransformFeedbackAsset(currentState, functionCall, id, AssetProcessorBase.asAssetID(0L));
        }

        public @Nullable GlTransformFeedbackBufferBindingPointAsset findGlTransformFeedbackBufferBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewGlTransformFeedbackBufferBindingPointAsset(currentState, functionCall, id);
        }

        public @Nullable GlUniformBindingPointAsset findGlUniformBindingPointAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewGlUniformBindingPointAsset(currentState, functionCall, id);
        }

        public @Nullable GlVertexArrayObjectAsset findGlVertexArrayObjectAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlVertexArrayObjectAsset(currentState, functionCall, id, AssetProcessorBase.asAssetID(0L));
        }

        public @Nullable GlVertexAttributeNonArrayValueAsset findGlVertexAttributeNonArrayValueAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            Number[] temp_getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue_return_value_0 = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue(currentState, functionCall, id);
            return AssetProcessorBase.getOrCreateNewGlVertexAttributeNonArrayValueAsset(currentState, functionCall, id, temp_getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue_return_value_0);
        }

        public @Nullable GlTextureImageAsset findGlTextureImageAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlTextureSurfaceAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlTextureImageAsset(currentState, functionCall, parentAsset, id);
        }

        public @Nullable GlTextureSurfaceAsset findGlTextureSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlTextureAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlTextureSurfaceAsset(currentState, functionCall, parentAsset, id);
        }

        public @Nullable GlVertexAttributeAsset findGlVertexAttributeAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlVertexArrayObjectAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            GlVertexAttributeNonArrayValueAsset temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_0 = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource(currentState, functionCall, id);
            assert (temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_0 != null);
            return AssetProcessorBase.getOrCreateNewGlVertexAttributeAsset(currentState, functionCall, parentAsset, id, temp_getDefaultPropertyValueForGlVertexAttributeAssetNonArrayDataSource_return_value_0);
        }

        public @Nullable GlVertexBufferBindingAsset findGlVertexBufferBindingAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlVertexArrayObjectAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewGlVertexBufferBindingAsset(currentState, functionCall, parentAsset, id);
        }

        public @Nullable ShaderUniform findShaderUniform(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlProgramAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getShaderUniform(currentState, functionCall, parentAsset, id);
        }

        public @Nullable GlFramebufferRenderbufferAttachmentAsset findGlFramebufferRenderbufferAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlFramebufferAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlFramebufferRenderbufferAttachmentAsset(currentState, functionCall, parentAsset, id);
        }

        public @Nullable GlFramebufferTextureAttachmentAsset findGlFramebufferTextureAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlFramebufferAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlFramebufferTextureAttachmentAsset(currentState, functionCall, parentAsset, id);
        }

        public @Nullable GlFramebufferTextureMultiviewAttachmentAsset findGlFramebufferTextureMultiviewAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlFramebufferAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlFramebufferTextureMultiviewAttachmentAsset(currentState, functionCall, parentAsset, id);
        }

        public @Nullable GlFramebufferZeroAttachmentAsset findGlFramebufferZeroAttachmentAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id, @NonNull GlFramebufferAsset parentAsset) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getGlFramebufferZeroAttachmentAsset(currentState, functionCall, parentAsset, id);
        }

        public @Nullable EglConfigAsset findEglConfigAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getOrCreateNewEglConfigAsset(currentState, functionCall, id, null);
        }

        public @Nullable EglContextAsset findEglContextAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getEglContextAsset(currentState, functionCall, id);
        }

        public @Nullable EglDisplayAsset findEglDisplayAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getEglDisplayAsset(currentState, functionCall, id);
        }

        public @Nullable EglImageAsset findEglImageAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getEglImageAsset(currentState, functionCall, id);
        }

        public @Nullable EglSyncAsset findEglSyncAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getEglSyncAsset(currentState, functionCall, id);
        }

        public @Nullable EglPbufferSurfaceAsset findEglPbufferSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getEglPbufferSurfaceAsset(currentState, functionCall, id);
        }

        public @Nullable EglPixmapSurfaceAsset findEglPixmapSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getEglPixmapSurfaceAsset(currentState, functionCall, id);
        }

        public @Nullable EglWindowSurfaceAsset findEglWindowSurfaceAsset(@NonNull TraceStateSnapshotAssetBuilder.ISnapshotCallbacks callbacks, @NonNull FunctionCall functionCall, long id) {
            TraceStateSnapshot currentState = callbacks.getSnapshotAssetParent().getTraceStateSnapshot();
            return AssetProcessorBase.getEglWindowSurfaceAsset(currentState, functionCall, id);
        }
    }
}

