/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.VkSwapchainKHRAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkSwapchainKHRAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = -4086894940994238779L;
    private final @NonNull AbstractConstantOrAliasSpecExtended clipped;
    private final @NonNull Bitfield compositeAlpha;
    private final long imageArrayLayers;
    private final @NonNull AbstractConstantOrAliasSpecExtended imageColorSpace;
    private final  @NonNull VULKAN.Structs.VkExtent2D imageExtent;
    private final @NonNull AbstractConstantOrAliasSpecExtended imageFormat;
    private final @NonNull AbstractConstantOrAliasSpecExtended imageSharingMode;
    private final @NonNull Bitfield imageUsage;
    private @NonNull List<VkImageAsset> images;
    private VkSwapchainKHRAsset oldSwapchain;
    private final @NonNull Bitfield preTransform;
    private final @NonNull AbstractConstantOrAliasSpecExtended presentMode;
    private final @NonNull LongsArgAttachment queueFamilyIndices;
    private final @NonNull Handle surface;

    public AbstractVkSwapchainKHRAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, @NonNull AbstractConstantOrAliasSpecExtended clipped, @NonNull Bitfield compositeAlpha, long imageArrayLayers, @NonNull AbstractConstantOrAliasSpecExtended imageColorSpace,  @NonNull VULKAN.Structs.VkExtent2D imageExtent, @NonNull AbstractConstantOrAliasSpecExtended imageFormat, @NonNull AbstractConstantOrAliasSpecExtended imageSharingMode, @NonNull Bitfield imageUsage, @NonNull Bitfield preTransform, @NonNull AbstractConstantOrAliasSpecExtended presentMode, @NonNull LongsArgAttachment queueFamilyIndices, @NonNull Handle surface) {
        super(KapiSpec.VULKAN.assetTables.SWAPCHAIN_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
        this.clipped = clipped;
        this.compositeAlpha = compositeAlpha;
        this.imageArrayLayers = imageArrayLayers;
        this.imageColorSpace = imageColorSpace;
        this.imageExtent = imageExtent;
        this.imageFormat = imageFormat;
        this.imageSharingMode = imageSharingMode;
        this.imageUsage = imageUsage;
        this.preTransform = preTransform;
        this.presentMode = presentMode;
        this.queueFamilyIndices = queueFamilyIndices;
        this.surface = surface;
        this.images = new ArrayList<VkImageAsset>();
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getClipped() {
        return this.clipped;
    }

    public @NonNull Bitfield getCompositeAlpha() {
        return this.compositeAlpha;
    }

    public long getImageArrayLayers() {
        return this.imageArrayLayers;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getImageColorSpace() {
        return this.imageColorSpace;
    }

    public  @NonNull VULKAN.Structs.VkExtent2D getImageExtent() {
        return this.imageExtent;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getImageFormat() {
        return this.imageFormat;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getImageSharingMode() {
        return this.imageSharingMode;
    }

    public @NonNull Bitfield getImageUsage() {
        return this.imageUsage;
    }

    public @NonNull List<VkImageAsset> getImages() {
        return this.images;
    }

    public List<VkImageAsset> setImages(@NonNull List<VkImageAsset> images) {
        List<VkImageAsset> previousValueToReturn = this.images;
        this.images = images;
        return previousValueToReturn;
    }

    public VkSwapchainKHRAsset getOldSwapchain() {
        return this.oldSwapchain;
    }

    public VkSwapchainKHRAsset setOldSwapchain(VkSwapchainKHRAsset oldSwapchain) {
        VkSwapchainKHRAsset previousValueToReturn = this.oldSwapchain;
        this.oldSwapchain = oldSwapchain;
        return previousValueToReturn;
    }

    public @NonNull Bitfield getPreTransform() {
        return this.preTransform;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getPresentMode() {
        return this.presentMode;
    }

    public @NonNull LongsArgAttachment getQueueFamilyIndices() {
        return this.queueFamilyIndices;
    }

    public @NonNull Handle getSurface() {
        return this.surface;
    }

    public @NonNull List<VkImageAsset> getImagesCollection() {
        return Collections.unmodifiableList(this.images);
    }

    public void setImagesCollection(@NonNull List<VkImageAsset> images) {
        this.images.clear();
        this.images.addAll(images);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("clipped", VkAssetPropertyFormatter.getAssetViewProperty(this.getClipped()));
        properties.put("compositeAlpha", VkAssetPropertyFormatter.getAssetViewProperty(this.getCompositeAlpha()));
        properties.put("imageArrayLayers", ValueAssetProperty.create(String.valueOf(this.getImageArrayLayers())));
        properties.put("imageColorSpace", VkAssetPropertyFormatter.getAssetViewProperty(this.getImageColorSpace()));
        properties.put("imageExtent", VkAssetPropertyFormatter.getAssetViewProperty(this.getImageExtent()));
        properties.put("imageFormat", VkAssetPropertyFormatter.getAssetViewProperty(this.getImageFormat()));
        properties.put("imageSharingMode", VkAssetPropertyFormatter.getAssetViewProperty(this.getImageSharingMode()));
        properties.put("imageUsage", VkAssetPropertyFormatter.getAssetViewProperty(this.getImageUsage()));
        ArrayList<IAssetProperty> imageslist = new ArrayList<IAssetProperty>();
        for (VkImageAsset property : this.getImages()) {
            imageslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("images", new ListAssetProperty(imageslist));
        properties.put("oldSwapchain", VkAssetPropertyFormatter.getAssetViewProperty(this.getOldSwapchain()));
        properties.put("preTransform", VkAssetPropertyFormatter.getAssetViewProperty(this.getPreTransform()));
        properties.put("presentMode", VkAssetPropertyFormatter.getAssetViewProperty(this.getPresentMode()));
        properties.put("queueFamilyIndices", VkAssetPropertyFormatter.getAssetViewProperty(this.getQueueFamilyIndices()));
        properties.put("surface", VkAssetPropertyFormatter.getAssetViewProperty(this.getSurface()));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

