/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.objects.IVkAttachmentDescription;
import com.arm.mgd.core.asset.objects.IVkSubpassDependency;
import com.arm.mgd.core.asset.objects.IVkSubpassDescription;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkRenderPassAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = -694341007704032810L;
    private final @NonNull List<IVkAttachmentDescription> attachments;
    private final @NonNull List<IVkSubpassDependency> dependencies;
    private final @NonNull Bitfield flags;
    private final @NonNull List<IVkSubpassDescription> subpasses;

    public AbstractVkRenderPassAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, @NonNull List<IVkAttachmentDescription> attachments, @NonNull List<IVkSubpassDependency> dependencies, @NonNull Bitfield flags, @NonNull List<IVkSubpassDescription> subpasses) {
        super(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
        this.attachments = attachments;
        this.dependencies = dependencies;
        this.flags = flags;
        this.subpasses = subpasses;
    }

    public @NonNull List<IVkAttachmentDescription> getAttachments() {
        return this.attachments;
    }

    public @NonNull List<IVkSubpassDependency> getDependencies() {
        return this.dependencies;
    }

    public @NonNull Bitfield getFlags() {
        return this.flags;
    }

    public @NonNull List<IVkSubpassDescription> getSubpasses() {
        return this.subpasses;
    }

    public @NonNull List<IVkAttachmentDescription> getAttachmentsCollection() {
        return Collections.unmodifiableList(this.attachments);
    }

    public @NonNull List<IVkSubpassDependency> getDependenciesCollection() {
        return Collections.unmodifiableList(this.dependencies);
    }

    public @NonNull List<IVkSubpassDescription> getSubpassesCollection() {
        return Collections.unmodifiableList(this.subpasses);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        ArrayList<IAssetProperty> attachmentslist = new ArrayList<IAssetProperty>();
        for (IVkAttachmentDescription property : this.getAttachments()) {
            attachmentslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("attachments", new ListAssetProperty(attachmentslist));
        ArrayList<IAssetProperty> dependencieslist = new ArrayList<IAssetProperty>();
        for (IVkSubpassDependency property : this.getDependencies()) {
            dependencieslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("dependencies", new ListAssetProperty(dependencieslist));
        properties.put("flags", VkAssetPropertyFormatter.getAssetViewProperty(this.getFlags()));
        ArrayList<IAssetProperty> subpasseslist = new ArrayList<IAssetProperty>();
        for (IVkSubpassDescription property : this.getSubpasses()) {
            subpasseslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("subpasses", new ListAssetProperty(subpasseslist));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

