/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.VkDescriptorSetLayoutAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkPipelineLayoutAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = 4262529515405378066L;
    private final @NonNull Bitfield flags;
    private final @NonNull List<VULKAN.Structs.VkPushConstantRange> pushConstants;
    private final List<VkDescriptorSetLayoutAsset> setLayouts;

    public AbstractVkPipelineLayoutAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, @NonNull Bitfield flags, @NonNull List<VULKAN.Structs.VkPushConstantRange> pushConstants, List<VkDescriptorSetLayoutAsset> setLayouts) {
        super(KapiSpec.VULKAN.assetTables.PIPELINELAYOUT_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
        this.flags = flags;
        this.pushConstants = pushConstants;
        this.setLayouts = setLayouts;
    }

    public @NonNull Bitfield getFlags() {
        return this.flags;
    }

    public @NonNull List<VULKAN.Structs.VkPushConstantRange> getPushConstants() {
        return this.pushConstants;
    }

    public List<VkDescriptorSetLayoutAsset> getSetLayouts() {
        return this.setLayouts;
    }

    public @NonNull List<VULKAN.Structs.VkPushConstantRange> getPushConstantsCollection() {
        return Collections.unmodifiableList(this.pushConstants);
    }

    public @NonNull List<VkDescriptorSetLayoutAsset> getSetLayoutsCollection() {
        return Collections.unmodifiableList(this.setLayouts);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("flags", VkAssetPropertyFormatter.getAssetViewProperty(this.getFlags()));
        ArrayList<IAssetProperty> pushConstantslist = new ArrayList<IAssetProperty>();
        for (VULKAN.Structs.VkPushConstantRange property : this.getPushConstants()) {
            pushConstantslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("pushConstants", new ListAssetProperty(pushConstantslist));
        ArrayList<IAssetProperty> setLayoutslist = new ArrayList<IAssetProperty>();
        for (VkDescriptorSetLayoutAsset property : this.getSetLayouts()) {
            setLayoutslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("setLayouts", new ListAssetProperty(setLayoutslist));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

