/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.VkImageViewAsset;
import com.arm.mgd.core.asset.VkRenderPassAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkFramebufferAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = -6173106172603491766L;
    private final List<VkImageViewAsset> attachments;
    private final @NonNull Bitfield flags;
    private final long height;
    private final long layers;
    private final @NonNull VkRenderPassAsset renderPass;
    private final long width;

    public AbstractVkFramebufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, List<VkImageViewAsset> attachments, @NonNull Bitfield flags, long height, long layers, @NonNull VkRenderPassAsset renderPass, long width) {
        super(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
        this.attachments = attachments;
        this.flags = flags;
        this.height = height;
        this.layers = layers;
        this.renderPass = renderPass;
        this.width = width;
    }

    public List<VkImageViewAsset> getAttachments() {
        return this.attachments;
    }

    public @NonNull Bitfield getFlags() {
        return this.flags;
    }

    public long getHeight() {
        return this.height;
    }

    public long getLayers() {
        return this.layers;
    }

    public @NonNull VkRenderPassAsset getRenderPass() {
        return this.renderPass;
    }

    public long getWidth() {
        return this.width;
    }

    public @NonNull List<VkImageViewAsset> getAttachmentsCollection() {
        return Collections.unmodifiableList(this.attachments);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        ArrayList<IAssetProperty> attachmentslist = new ArrayList<IAssetProperty>();
        for (VkImageViewAsset property : this.getAttachments()) {
            attachmentslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("attachments", new ListAssetProperty(attachmentslist));
        properties.put("flags", VkAssetPropertyFormatter.getAssetViewProperty(this.getFlags()));
        properties.put("height", ValueAssetProperty.create(String.valueOf(this.getHeight())));
        properties.put("layers", ValueAssetProperty.create(String.valueOf(this.getLayers())));
        properties.put("renderPass", VkAssetPropertyFormatter.getAssetViewProperty(this.getRenderPass()));
        properties.put("width", ValueAssetProperty.create(String.valueOf(this.getWidth())));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

